<?php
require_once('synophoto_mobile_csDBCacher.php');
/*!
 * database operation
 */
class csSYNOPhotoDB {
	/*! cache life time (seconds)*/
	public $CACHE_LIFETIME = 300;
	/*! db connection handler */
	public $_dbh;
	/*! db cacher handler */
	private $_dbCacher;
	/*! db cacher handler for mediaserver DB*/
	private $_dbCacherMedia;
	/*! db escape string for like */
	public $escapeStr = '';
	/*! db true condition string */
	public $condition_true = 'true';
	public $db_type = '';
	public static $current_admin = '';
	/*! reference to a self instance */
	private static $instance = null;
	/*! convert type condition to query video_convert table */
	private static $video_convert_type_condition;
	/*!
	 * Constructor
	 */
	function __construct()
	{
		if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
			$user = substr(urldecode($matches[0]), 2);
			$user_photo_db = "/var/services/homes/{$user}/photo/.SYNOPPSDB";
			$user_media_db = "/var/services/homes/{$user}/photo/.SYNOPPSDB";
			if(!file_exists($user_photo_db) || !file_exists($user_media_db)){
				die('error_database_not_exist');
			}
			try{
				$this->_dbh = new PDO("sqlite:{$user_photo_db}");
				$this->_dbh->exec('PRAGMA case_sensitive_like=1');
				$this->_dbh->exec('PRAGMA foreign_keys=ON');
				$this->escapeStr = " ESCAPE '\'";
				$this->condition_true = '1';
				self::$current_admin = $user;
			} catch (PDOException $e) {
				die($e->getMessage());
			}
		} else {
			try{
				$this->_dbh = new PDO('pgsql:dbname=photo', 'admin', '',
					array(PDO::ATTR_PERSISTENT => true, PDO::ATTR_EMULATE_PREPARES => true));
				self::$current_admin = 'root';

			} catch (PDOException $e) {
				die($e->getMessage());
			}
		}

		$this->_dbCacher = new DBCacher($this->_dbh, false, self::$current_admin);
		$this->_dbCacherMedia = new DBCacher($this->_dbh, true, self::$current_admin);

		$GLOBALS['dbconn_photo'] = $this->_dbh;

		$this->SetSessionCache(false);
		$this->SetSessionSystemConfigsFromFile();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'] = array();

		$this->db_type = $this->_dbh->getAttribute(constant("PDO::ATTR_DRIVER_NAME"));

		$condition = $this->GetConvertedVideoDBCondition();
		if (!empty($condition)) {
			$this->video_convert_type_condition = "AND path in (SELECT video_path FROM video_convert WHERE {$condition})";
		}
	}
	/*!
	 * close db connection
	 */
	function __destruct()
	{
		$this->_dbh = null;
	}
	/*!
	 * Get a exist instance
	 */
	static function GetDBInstance()
	{
		$admin_name = preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches) ? substr(urldecode($matches[0]), 2) : 'root';
		if (null === self::$instance || $admin_name != self::$current_admin) {
			self::$instance = null;
			self::$instance = new self;
			self::$current_admin = $admin_name;
		}
		return self::$instance;
	}
	/*!
	 * convert db bool colum to bool value
	 *
	 * \param $param db colum value
	 * \return bool value
	 */
	private function ConvertAsBool($param) {
		return ($param === true || $param === 't');
	}
	/*!
	 * escape string for like/ilike sql op
	 * \param $param string to escape
	 * \return escaped string
	 */
	static function EscapeLikeParam($param)
	{
		$param = str_replace('\\', '\\\\', $param);
		$param = str_replace('_', '\\_', $param);
		$param = str_replace('%', '\\%', $param);
		return $param;
	}
	/*!
	 * escape string when insert or update to db
	 * \param $param string to escape
	 * \return escaped string
	 */
	function EscapeParam($param)
	{
		if ('sqlite' == $this->db_type) {
			return sqlite_escape_string($param);
		}
		return pg_escape_string($param);
	}
	/*!
	 * dump photo_config scheme from db
	 *
	 * \return array with data from scheme 'photo_config'
	 */
	private function GetConfigsFromDB()
	{
		$query = 'SELECT * FROM photo_config';
		$dbResult = $this->_dbh->query($query);
		$result = $dbResult->fetchAll();
		if (false === $result) {
			return array();
		}
		return $result;
	}
	/*!
	 * Get accessible album list from db
	 *
	 * \param $userID logined username
	 * \param $noRightCheck true for get all albums
	 * \return array with data from scheme 'photo_share'
	 */
	private function GetAlbumsFromDB($userID, $noRightCheck)
	{
		$sqlParam = array();
		$sqlParamCount = 0;
		/* prepare permission condition */
		$permConditionClause = '';
		if (!$noRightCheck) {
			$permConditionClause = "public='t' OR password <> ''";
			if (!empty($userID)) {
				$access_right_table = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'])?'photo_access_right_for_dsm_account':'photo_access_right';
				$permConditionClause .= ' OR shareid IN (SELECT shareid FROM '.$access_right_table.' WHERE userid=?)';
				$sqlParam[$sqlParamCount++] = $userID;
			}
		}

		/* query first level albums */
		$whereClause = "WHERE is_subdir='f'";
		if (strlen($permConditionClause)) {
			/* sql param already append to $sqlParam */
			$whereClause .= " AND ({$permConditionClause})";
		}
		$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$rootAlbums = $dbResult->fetchAll();
		if (false === $rootAlbums) {
			return array();
		}

		/* query second level albums accroding to accessible first level albums */
		$secondLevelAlbums = array();
		$whereClause = "WHERE is_subdir='t' AND sharename NOT LIKE '%/%/%'";
		if (strlen($permConditionClause)) {
			/* sql param already append to $sqlParam */
			$whereClause .= " AND ({$permConditionClause})";
		}
		$whereClause .=  " AND sharename LIKE ? {$this->escapeStr}";
		$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		foreach ($rootAlbums as $key => $item) {
			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (csSYNOPhotoMisc::IsSkipPhotoPath(SYNOPHOTO_SERVICE_DIR.'/'.$item['sharename'])) {
				unset($rootAlbums[$key]);
				continue;
			}

			$item['sharename'] = self::EscapeLikeParam($item['sharename']);
			$sqlParam[$sqlParamCount] = "{$item['sharename']}/%";
			$dbResult->execute($sqlParam);
			$result = $dbResult->fetchAll();
			if (false !== $result) {
				// skip photo in remote mount (cifs) or read-only mount (iso9660)
				foreach ($result as $key => $item) {
					if (csSYNOPhotoMisc::IsSkipPhotoPath(SYNOPHOTO_SERVICE_DIR.'/'.$item['sharename'])) {
						unset($result[$key]);
					}
				}
				$secondLevelAlbums = array_merge($secondLevelAlbums, $result);
			}
		}

		$result = array_merge($rootAlbums, $secondLevelAlbums);
		$query = "SELECT * FROM photo_share where password <> '' and is_subdir = 't' AND sharename NOT LIKE '%/%/%' ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$passwordAlbums = $dbResult->fetchAll();
		foreach ($passwordAlbums as $item) {
			if (!in_array($item, $result)) {
				$result[] = $item;
			}
		}
		return $result;
	}

	/*!
	 * Get uploadable level 1,2 albums for non-admin user
	 *
	 * \param $userID non-admin user's userID
	 * \return array with uploadalbe album
	 */
	private function GetUploadableAlbums($userID)
	{
		$result = array();
		if (empty($userID)) {
			return $result;
		}

		$upload_right_table = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'])?'photo_upload_right_for_dsm_account':'photo_upload_right';
		$query = "Select sharename from photo_share where (password is null OR password = '') AND shareid in (select shareid from ".$upload_right_table." where userid = ".$userID.") AND sharename NOT LIKE '%/%/%' order by sharename asc";

		$db_result = $this->_dbh->query($query);

		while($row = $db_result->fetch()) {
			$result[$row[0]] = 1;
		}

		return $result;
	}
	/*!
	 * Cache system config files in session data
	 */
	private function SetSessionSystemConfigsFromFile()
	{
		$requiredConfKeys = 'language|supplang|eventsmtp|eventmail1|eventmail2|ddns_update|enable_demomode';
		$pkgRequireKey = 'runpersonalphotostation|external_host_ip|external_port_photo_https|external_port_photo_http';
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg'] = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, $requiredConfKeys);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg'] = csSYNOPhotoMisc::GetConfigFile(SYNO_DEF_CNF_FILE, $requiredConfKeys);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg'] = csSYNOPhotoMisc::GetConfigFile(SYNO_PKG_CNF_FILE, $pkgRequireKey);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['dsmCfg'] = csSYNOPhotoMisc::GetConfigFile(SYNO_DEF_VERSION_FILE, 'buildnumber');
		if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
			$command = '/usr/syno/bin/synogetkeyvalue '.escapeshellarg(SYNO_PERSONAL_CNF_FILE).' runpersonalphotostation';
			$ret = @exec($command);
			$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation'] = $ret;
		}
	}
	/*!
	 * Cache album/photo sort type/order in session data
	 * \param $sortType sort type
	 *	- 1: by taken time
	 *	- 2: by create time
	 *	- default: by name
	 * \param $sortOrder sort order
	 *	- 1: descending  sort
	 *	- default: ascending sort
	 */
	function SetSessionSortMethod($sortType, $sortOrder)
	{
		$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_by_preference'] = false;
		switch ($sortType) {
			case '1':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'timetaken';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video'] = "date";
				break;
			case '2':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'create_time';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video'] = "date";
				break;
			case '3':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_by_preference'] = true;
				break;
			default:
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'name';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video'] = "path";
		}

		switch ($sortOrder) {
			case '1':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] = 'desc';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_front'] = '>';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_back'] = '<';
				break;
			default:
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] = 'asc';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_front'] = '<';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_back'] = '>';
		}
	}
	/*!
	 * cache frequent access data
	 *
	 * \param $isForced force to refresh cache or not
	 */
	function SetSessionCache($isForced = false)
	{
		/*
		 * accessible_album, accessible_subdir: accessible level 1,2 albums.
		 * uploadable_album: level 1,2 uploadable albums when login user is not admin
		 * accessed_albums: set by AddHitTimes(), accessed albums
		 * photoNum_cache[albumName]: set by GetNumberOfPhotos(), the number of accessed albums' photos
		 * albumCover_cache[albumName]: set by GetAlbumCoverLatestUpload(), the cover of albums
		 * search_result[searchToken]: the photos' db records for searched result
		 * list_cache[albumName]: the browsed thumb list (including subdir and photos)
		 * list_video_cache[albumName]: the video's path of the $albumName album
		 * **function controlled** photo_config[key]=value: set by GetConfigsFromDB() in GetConfig() on demand, photo_config scheme from DB
		 * **reset each load** system_config[key]=value: set by SetSessionSystemConfigsFromFile(), from /etc[.default]/synoinfo.conf
		 */

		/* ensure every cache container is exist */
		$sessionInitField = array('accessible_album', 'accessible_subdir', 'photo_config', 'list_cache',
								  'search_result', 'system_config', 'accessed_albums', 'photoNum_cache',
								  'albumCover_cache', 'list_video_cache', 'uploadable_album', 'most_recent_cache', 'commentable_album');
		foreach ($sessionInitField as $field) {
			if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER][$field])) {
				$_SESSION[SYNOPHOTO_ADMIN_USER][$field] = array();
			}
		}

		/* compatible for desktop edition */
		if (!count($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']) || !is_array($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][array_rand($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'])])) {
			$isForced = true;
		}

		/* cache still fresh */
		if (!$isForced && isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp'] > (time() - $this->CACHE_LIFETIME)) {
			return;
		}

		/* flush non-function controlled cache */
		$sessionStaleField = array('accessible_album', 'accessible_subdir', 'photoNum_cache', 'albumCover_cache', 'list_cache', 'list_video_cache', 'uploadable_album', 'most_recent_cache', 'commentable_album');
		$oldAccessibleAlbums = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'];
		$oldAccessibleSubdirs = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'];
		foreach ($sessionStaleField as $field) {
			$_SESSION[SYNOPHOTO_ADMIN_USER][$field] = array();
		}

		/* cache accessible albums/sub-albums */
		$userID = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) ? $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] : '';
		$isAdmin = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
		$albums = $this->GetAlbumsFromDB($userID, $isAdmin);

		foreach ($albums as $item) {
			if ('t' == $item['is_subdir'] || true === $item['is_subdir']) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$item['sharename']] = $item;
			} else {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$item['sharename']] = $item;
			}
			if ($item['password'] && $isAdmin) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$item['sharename']] = $item['password'];
			}
		}

		/* cache commentable level 1 albums */
		foreach ($albums as $item) {
			if (('f' == $item['is_subdir'] || false == $item['is_subdir']) && ('t' == $item['comment'] || true === $item['comment'])) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['commentable_album'][$item['sharename']] = true;
			}
		}

		/* cache uploadable albums */
		if (!$isAdmin && !empty($userID)) {
			$uploadableAlbums = $this->GetUploadableAlbums($userID);
			foreach (array_keys($uploadableAlbums) as $albumName) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album'][$albumName] = 1;
			}
		}

        /* cache allow_user_comment and allow_guest_comment */
        $_SESSION[SYNOPHOTO_ADMIN_USER]['allow_user_comment'] = ('on' === $this->GetConfig("photo", "allow_user_comment"));
        $_SESSION[SYNOPHOTO_ADMIN_USER]['allow_guest_comment'] = ('on' === $this->GetConfig("photo", "allow_guest_comment"));

		/* set sort property */
		$this->SetSessionSortMethod($this->GetConfig('album', 'thumb_sort_type'),
									$this->GetConfig('album', 'thumb_sort_order'));
		$_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp'] = time();
	}
	/*!
	 * Check user exist in db or not
	 *
	 * \param $userId username
	 * \return true for exist
	 */
	function CheckUserExist($userId)
	{
		$accountSystem = $this->GetConfig('global', 'account_system');
		if (SYNOPHOTO_DSM_ACCOUNT == $accountSystem ) {
			//use DSM account
			@exec("/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($userId), $results, $retval);
			$exist = !$retval;
		} else {
			$query = 'SELECT count(*) FROM photo_user WHERE username=?';
			$sqlParam = array($userId);
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
			$row = $dbResult->fetch();
			$exist = (0 < $row[0]);
		}
		return $exist;
	}

	/*!
	 * check album accessible or not
	 *
	 * \param $albumName album name
	 * \param $password  album password
	 * \return true or error result
	 */
	function CheckAlbumAccessible($albumName, $password)
	{
		$albumToken = explode('/', $albumName);
		if (2 < count($albumToken)) {
			$albumName = "{$albumToken[0]}/{$albumToken[1]}";
		}

		$albumItem = null;
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName])) {
			$albumItem = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName];
		} else if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName])) {
			$albumItem = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName];
		}

		if (!$albumItem) {
			return "error_no_permission";
		}

		/* public album under password protected album */
		$albumParentItem = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumToken[0]];
		if ($albumParentItem['password'] && $this->ConvertAsBool($albumItem['public'])) {
			$albumItem = $albumParentItem;
		}

		/* non password protected album or previous successed */
		if (!$albumItem['password'] ||
			$albumItem['password'] == $_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumItem['sharename']]) {
			return true;
		}

		/* check password */
		if ($albumItem['password']) {
			if ('' == $password) {
				return 'error_need_album_password';
			}
			$password = md5($password);
			if ($password == $albumItem['password']) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumItem['sharename']] = $password;
				return true;
			}
			return 'error_invalid_album_password';
		}

		return true;
	}
	/*!
	 * check image path is accessible (in private or password protected album)
	 *
	 * \param $path image path
	 * \return true or error result
	 */
	function CheckPathAccessible($path)
	{
		$file_name = basename($path);
		$dir = substr($path, 0, strlen($path) - strlen($file_name) - 1);
		$dir = substr($dir, strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1);
		return $this->CheckAlbumAccessible($dir, '');
	}
	/*!
	 * validate username and password, and then return user info
	 *
	 * \param $username username
	 * \param $password password
	 * \return false when validate failed, otherwise data from scheme 'photo_user'
	 */
	function GetValidateUserInfo($username, $password)
	{
		$query = 'SELECT * FROM photo_user WHERE lower(username)=? AND password=?';
		$sqlParam = array(strtolower($username), md5($password));
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$userInfo = $dbResult->fetch();
		return $userInfo; // false when no matched
	}
	/*!
	 * Validate admin password
	 *
	 * \param $password password
	 * \return the password passed or not
	 */
	function ValidateAdminPassword($password, $user)
	{
		$admin_user = ('root' == $user)? 'admin':$user;
		@system("/usr/syno/bin/synoauth ".escapeshellarg($admin_user)." ".escapeshellarg($_POST['passwd']), $retval);
		return !$retval;
	}
	/*!
	 * Get userid from DSM account
	 *
	 * \param $user DSM user name
	 * \return userid for given DSM user, retuen false if the userid can not be found
	 */
	function GetDSMUserID($dsm_user)
	{
		$dsm_uid = false;
		@exec("/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($dsm_user)."|grep 'User uid'", $results, $retval);
		if (!$retval) {
			$uid_Info = explode(']', $results[0]);
			$uid_Tokens = explode('[', $uid_Info[0]);
			$dsm_uid = (count($uid_Tokens) > 1)?$uid_Tokens[1]:false;
		}
		return $dsm_uid;
	}
	/*!
	 * Get config value from scheme 'photo_config'
	 *
	 * \param $moduleName module/section name
	 * \param $configKey key name
	 * \return config value
	 */
	function GetConfig($moduleName, $configKey)
	{
		/* cache db scheme on demand */
		if (0 == count($_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'])) {
			$configs = $this->GetConfigsFromDB();
			foreach ($configs as $item) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'][$item['module_name']][$item['config_key']] = $item['config_value'];
			}
		}
		$item = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'];
		if (isSet($item[$moduleName]) && ($item = $item[$moduleName]) && isSet($item[$configKey])) {
			return $item[$configKey];
		}
		return NULL;
	}
	/*!
	 * Get # of comments for specified photo
	 *
	 * \param $photoId photo id in db
	 * \return # of comments
	 */
	function GetNumberOfComments($photoId)
	{
		$query = 'SELECT count(*) FROM photo_comment WHERE photo_id=?';
		$sqlParam = array($photoId);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$row = $dbResult->fetch();
		return $row[0];
	}
	/*!
	 * Get comments for specified photo
	 *
	 * \param $photoId photo id in db
	 * \param $offset # of comments to skip
	 * \param $limit # of comments to get
	 * \return array with data from scheme 'photo_comment'
	 */
	function GetPhotoComments($photoId, $offset = 0, $limit = 'ALL')
	{
		if ('ALL' == $limit && 'sqlite' == $this->db_type) {
			$limit = -1;//for sqlite limit < 0 is equal to no limit
		}

		$query = "SELECT * FROM photo_comment WHERE photo_id=? ORDER BY date desc LIMIT {$limit} OFFSET {$offset}";
		$sqlParam = array($photoId);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$result = $dbResult->fetchAll();
		if (false === $result) {
			return array();
		}
		return $result;
	}
	/*!
	 * Get comments for specified video
	 *
	 * \param $videoPath video file full path
	 * \param $offset # of comments to skip
	 * \param $limit # of comments to get
	 * \return array with data from scheme 'photo_comment'
	 */
	function GetVideoComments($videoPath, $offset = 0, $limit = 'ALL')
	{
		if ('ALL' == $limit && 'sqlite' == $this->db_type) {
			$limit = -1;//for sqlite limit < 0 is equal to no limit
		}

		$query = "SELECT * FROM video_comment WHERE path=? ORDER BY date desc LIMIT {$limit} OFFSET {$offset}";
		$dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$result = $dbResult->fetchAll();
		if (false === $result) {
			return array();
		}
		return $result;
	}
	/*!
	 * Add comment for the photo
	 *
	 * \param $id photo image id
	 * \param $name user name who adding the comment
	 * \param $email email address of whom adding the comment
	 * \param $comment the comment
	 * \return true for adding success
	 */
	function AddPhotoComment($id, $name, $mail, $comment)
	{
		$name = $this->EscapeParam($name);
		$mail = $this->EscapeParam($mail);
		$comment = $this->EscapeParam($comment);

		$query = "Insert into photo_comment (photo_id, name, email, comment, date) ";
		$query = $query."Values ($id, '$name', '$mail', '$comment', '".date('Y-m-d H:i:s')."')";
		$db_result = $this->_dbh->query($query);

		return true;

	}
	/*!
	 * Add comment for the video
	 *
	 * \param $path video path
	 * \param $name user name who adding the comment
	 * \param $email email address of whom adding the comment
	 * \param $comment the comment
	 * \return true for adding success
	 */
	function AddVideoComment($path, $name, $mail, $comment)
	{
		$path = $this->EscapeParam($path);
		$name = $this->EscapeParam($name);
		$mail = $this->EscapeParam($mail);
		$comment = $this->EscapeParam($comment);

		$dPath = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$query = "Insert into video_comment (path, name, email, comment, date) ";
		$query = $query."Values ('$dPath', '$name', '$mail', '$comment', '".date('Y-m-d H:i:s')."')";

		$db_result = $this->_dbh->query($query);

		return true;
	}
	/*!
	 * Get photo info for specified path
	 *
	 * \param $photoPath photo full path
	 * \return array with data from scheme 'photo_image'
	 */
	function GetPhotoInfo($photoPath)
	{
		$dPath = substr($photoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		/* search db cacher */
		foreach($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID] as $cacheTuple) {
			if (!is_array($cacheTuple[DBCACHER_TUPLE_DATA])) {
				continue;
			}
			foreach ($cacheTuple[DBCACHER_TUPLE_DATA] as $dbTuple) {
				if ($dPath == $dbTuple['path']) {
					$dbTuple['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$dbTuple['path'];
					return $dbTuple;
				}
			}
		}
		/* not found in cache */
		$query = "SELECT * FROM photo_image WHERE path=?";
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		if ($row = $dbResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		}
		return $row;
	}
	/*!
	 * Get video info for specified path
	 *
	 * \param $videoPath video full path
	 * \return array with data from scheme 'video' of mediaserver DB
	 */
	function GetVideoInfo($videoPath)
	{
		$dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		/* search db cacher */
		foreach($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID] as $cacheTuple) {
			if (!is_array($cacheTuple[DBCACHER_TUPLE_DATA])) {
				continue;
			}
			foreach ($cacheTuple[DBCACHER_TUPLE_DATA] as $dbTuple) {
				if ($dPath == $dbTuple['path']) {
					$dbTuple['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$dbTuple['path'];
					return $dbTuple;
				}
			}
		}

		/* not found in cache */
		$query = "SELECT * FROM video WHERE path=?";
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		if ($row = $dbResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		}
		return $row;
	}
	/*!
	 * Get video's customerized  title and description for specified path
	 *
	 * \param $videoPath video full path
	 * \return array with customzeized title and description
	 */
	function GetVideoCustomizedTitleDescription($videoPath)
	{
		$result['title']='';
		$result['description']='';
		$query = "SELECT title, description FROM video_desc WHERE path=?";
		$dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		if ($row = $dbResult->fetch()) {
			$result['title']=$row[0];
			$result['description']=$row[1];
		}

		return $result;
	}
	/*!
	 * Get converted video list
	 *
	 * \return array with url list
	 */
	function GetConvertedVideoInfoFromFullPath($videoPath)
	{
		$result = array();

		$query = "SELECT convert_file_path,video_bitrate,vcodec FROM video_convert WHERE video_path=?";
		$dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$sqlParam = array($dPath);
		$condition = $this->GetConvertedVideoDBCondition();
		if (!empty($condition)) {
			$query .= " AND (${condition})";
		}
		$query .= " ORDER BY video_bitrate ASC";

		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while ($item = $dbResult->fetch()) {
			$result[] = array('path' => $item[0], 'bitrate' => $item[1], 'codec' => $item[2]);
		}

		return $result;
	}
	/*!
	 * Get video_convert table SQL conditions for current client
	 *
	 * \return condition string
	 */
	function GetConvertedVideoDBCondition()
	{
		/*
			h264 profile: baseline(1), main(2), high(3)
			mpeg4 profile: simple(1), advanced(2)

			$_SESSION['video_formats'] = array(
				array(codec, profile, level, width, height, bitrate, array(container1, container2))
				array('h264', 2, 31, 0, 0, 0, array('mp4')),
				array('mpeg4', 1, 0, 640, 480, 2500, array('mp4'))
			);
		*/

		$conditions = array();

		$list = array();
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['video_formats'])) {
			$list = $_SESSION[SYNOPHOTO_ADMIN_USER]['video_formats'];
		}

		if (isSet($_REQUEST['client']) && $_REQUEST['client'] == SYNOPHOTO_UPLOAD_CLIENT_IPHONE) {
			$conditions[] = "convert_type='MOBILE_COMMON' OR convert_type='IPHONE'";
		} else if (isSet($_REQUEST['client']) && $_REQUEST['client'] == SYNOPHOTO_UPLOAD_CLIENT_ANDROID) {
			$conditions[] = "convert_type='MOBILE_COMMON' OR convert_type='ANDROID_UPLOAD'";
		}

		foreach ($list as $item) {
			list($codec, $profile, $level, $width, $height, $bitrate, $formats) = $item;
			$values = array();
			$values[] = ('*' === $codec) ? $this->condition_true : "vcodec='{$codec}'";
			if ($profile && is_numeric($profile)) {
				$values[] = "video_profile<={$profile}";
			}
			if ($level && is_numeric($level)) {
				$values[] = "video_level<={$level}";
			}
			if ($width&& is_numeric($width)) {
				$values[] = "resolutionx<={$width}";
			}
			if ($height && is_numeric($height)) {
				$values[] = "resolutiony<={$height}";
			}
			if ($formats && is_array($formats) && 0 < count($formats)) {
				$containers = array();
				foreach ($formats as $type) {
					$containers[] = "container_type='{$type}'";
				}
				$values[] = '(' . implode(' OR ', $containers) . ')';
			}
			$conditions[] = '(' . implode(' AND ', $values) . ')';
		}

		return implode(' OR ', $conditions);
	}
	/*!
	 * Prepare album photos DB Cache for future use
	 *
	 * \param $albumName alubm name
	 * \param $offset # of photos to skip
	 * \param $length # of photos to prepare
	 * \return prepared db data from scheme 'photo_image'
	 */
	function PrepareAlbumPhotos($albumName, $offset, $limit)
	{
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT * FROM photo_image WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		return $this->_dbCacher->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Prepare album videos DB Cache for future use
	 *
	 * \param $albumName alubm name
	 * \param $offset # of videos to skip
	 * \param $length # of videos to prepare
	 * \return prepared db data from scheme 'video' of mediaserver DB
	 */
	function PrepareAlbumVideos($albumName, $offset, $limit)
	{
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT * FROM video WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ".$this->video_convert_type_condition."ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		return $this->_dbCacherMedia->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Prepare searched photos DB Cache for future use
	 *
	 * \param $cacheToken search token
	 * \param $offset # of photos to skip
	 * \param $length # of photos to prepare
	 * \return prepared db data from scheme 'photo_image'
	 */
	function PrepareSearchPhotos($cacheToken, $offset, $limit)
	{
		if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken])) {
			return;
		}
		$query = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken]['statement'];
		$sqlParam = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken]['param'];
		return $this->_dbCacher->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Prepare searched photos DB Cache for future use
	 *
	 * \param $cacheToken search token
	 * \param $offset # of photos to skip
	 * \param $length # of photos to prepare
	 * \return prepared db data from scheme 'photo_image'
	 */
	function PrepareSearchVideos($cacheToken, $offset, $limit)
	{
		if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result_video'][$cacheToken])) {
			return;
		}
		$query = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result_video'][$cacheToken]['statement'];
		$sqlParam = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result_video'][$cacheToken]['param'];
		return $this->_dbCacherMedia->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Get photo name list for specified album
	 *
	 * \param $albumName alubm name
	 * \return array with name list
	 */
	function GetAlbumPhotoList($albumName)
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName];
		}
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT name FROM photo_image WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		$list = array();
		while (false !== ($row = $dbResult->fetch())) {
			$list[] = $row[0];
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName] = $list;
		return $list;
	}
	/*!
	 * Get video path list for specified album
	 *
	 * \param $albumName alubm name
	 * \return array with SUPPORTED videos path list
	 */
	function GetAlbumVideoList($albumName)
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['list_video_cache'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['list_video_cache'][$albumName];
		}
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT path FROM video WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} "
			.$this->video_convert_type_condition."ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		$list = array();
		while (false !== ($row = $dbResult->fetch())) {
			$list[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['list_video_cache'][$albumName] = $list;
		return $list;
	}
	/*!
	 * Get total videocount for specified album
	 *
	 * \param $albumName alubm name
	 * \return total video count in the album (include both support and unsupport videos)
	 */
	function GetAlbumTotalVideoCount($albumName)
	{
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT count(*) FROM video WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		$totalVideoCount = 0;
		if (false !== ($row = $dbResult->fetch())) {
			$totalVideoCount = intval($row[0]);
		}

		return $totalVideoCount;
	}
	/*!
	 * Get most recent photo path list
	 *
	 * \return array with path list
	 */
	function GetMostRecentPhotoList()
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['most_recent_cache']['photo'])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['most_recent_cache']['photo'];
		}

		$sqlParam = array();

		$list = array();

		/* prepare album condition */
		$albumCond = array();
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'] as $item) {
			if (true !== $this->CheckAlbumAccessible($item['sharename'], '')) {
				continue;
			}

			$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "(path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr})";
			$sqlParam[] = "{$albumRealPath}/%";
			$sqlParam[] = "{$albumRealPath}/%/%";
		}
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'] as $item) {
			if (true !== $this->CheckAlbumAccessible($item['sharename'], '')) {
				continue;
			}

			$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "path LIKE ? {$this->escapeStr}";
			$sqlParam[] = "{$albumRealPath}/%";
		}

		if (count($albumCond)) {
			$albumCond = implode(' OR ', $albumCond);

			$query = "SELECT path FROM photo_image WHERE ({$albumCond}) ORDER BY create_time desc LIMIT ".MOST_RECENT_MAX;
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);

			while (false !== ($row = $dbResult->fetch())) {
				$list[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['most_recent_cache']['photo'] = $list;

		return $list;
	}
	/*!
	 * Get most recent video path list
	 *
	 * \return array with path list
	 */
	function GetMostRecentVideoList()
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['most_recent_cache']['video'])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['most_recent_cache']['video'];
		}

		$sqlParam = array();

		/* prepare album condition */
		$albumCond = array();
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'] as $item) {
			if (true !== $this->CheckAlbumAccessible($item['sharename'], '')) {
				continue;
			}

			$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "(path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr})";
			$sqlParam[] = "{$albumRealPath}/%";
			$sqlParam[] = "{$albumRealPath}/%/%";
		}
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'] as $item) {
			if (true !== $this->CheckAlbumAccessible($item['sharename'], '')) {
				continue;
			}

			$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "path LIKE ? {$this->escapeStr}";
			$sqlParam[] = "{$albumRealPath}/%";
		}

		$list = array();
		if (count($albumCond)) {
			$albumCond = implode(' OR ', $albumCond);

			$query = "SELECT path FROM video WHERE ({$albumCond}) ".$this->video_convert_type_condition."ORDER BY date desc LIMIT ".MOST_RECENT_MAX;
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);

			while (false !== ($row = $dbResult->fetch())) {
				$list[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['most_recent_cache']['video'] = $list;
		return $list;
	}
	/*!
	 * Search photos by conditions, and store result in cache
	 *
	 * \param $moreCond array with search conditions, key as the field name
	 * \return the token of cache store search result
	 */
	function GetSearchToken($moreCond = array())
	{
		$cacheToken = md5(implode('_',$moreCond));
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken])) {
			return $cacheToken;
		}

		$sqlParam = array();
		$sqlParamCount = 0;

		/* prepare album condition */
		$albumCond = array();
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'] as $item) {
			$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "(path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr}) ";
			$sqlParam[] = "{$albumRealPath}/%";
			$sqlParam[] = "{$albumRealPath}/%/%";
		}
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'] as $item) {
			$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "path LIKE ? {$this->escapeStr}";
			$sqlParam[] = "{$albumRealPath}/%";
		}

		/* prepare photo condition, video condition */
		$photoCond = array();
		$videoCondMediaserverDB = array();
		$videoCondPhotoDB = array();

		$videoMediaSqlParam = $sqlParam;
		$videoMediaSqlParamCount = $sqlParamCount;

		$videoPhotoSqlParam = $sqlParam;
		$videoPhotoSqlParamCount = $sqlParamCount;

		foreach ($moreCond as $key => $value) {
			$value = self::EscapeLikeParam(strtolower($value));
			$photoCond[] = "lower({$key}) LIKE ? {$this->escapeStr}";
			$sqlParam[] = "%{$value}%";

			if ('name' == $key) {
				$videoCondMediaserverDB[] =  "lower(title) LIKE ? {$this->escapeStr}";
				$videoMediaSqlParam[] = "%{$value}%";
			} else {
				$videoCondPhotoDB[] = "lower({$key}) LIKE ? {$this->escapeStr}";
				$videoPhotoSqlParam[] = "%{$value}%";
			}

		}

		$video_PhotoDBResult = array();
		/* make sure condition exist */
		if (count($albumCond) && count($videoCondPhotoDB)) {
			$albumCond_video = implode(' OR ', $albumCond);
			$videoCondPhotoDB = implode(' OR ', $videoCondPhotoDB);

			$query = "SELECT path FROM video_desc WHERE ({$albumCond_video}) AND ({$videoCondPhotoDB})";
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($videoPhotoSqlParam);

			while (false !== ($row = $dbResult->fetch())) {
				$video_PhotoDBResult[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}
		}

		// add the path from photo db into sql wehere condition
		foreach ($video_PhotoDBResult as $videoPath) {
			$videoCondMediaserverDB[] =  "path = ?";
			$videoMediaSqlParam[] = $videoPath;
		}
		/* END of prepare photo condition, video condition */


		$result = array();
		$resultVideo = array();
		/* make sure condition exist */
		if (count($albumCond) && count($photoCond)) {
			$albumCond = implode(' OR ', $albumCond);
			// photo query
			$photoCond = implode(' OR ', $photoCond);
			$cacheQuery = "SELECT * FROM photo_image WHERE ({$albumCond}) AND ({$photoCond})";
			$query = "SELECT path FROM photo_image WHERE ({$albumCond}) AND ({$photoCond})";
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);

			while (false !== ($row = $dbResult->fetch())) {
				$result[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}

			// video query
			if (count($videoCondMediaserverDB)) {
				$videoCondMediaserverDB = implode(' OR ', $videoCondMediaserverDB);
				$cacheQueryVideo = "SELECT * FROM video WHERE ({$albumCond}) AND ({$videoCondMediaserverDB})".$this->video_convert_type_condition;
				$query = "SELECT path FROM video WHERE ({$albumCond}) AND ({$videoCondMediaserverDB})".$this->video_convert_type_condition;
				$dbResult = $this->_dbh->prepare($query);
				$dbResult->execute($videoMediaSqlParam);
				while (false !== ($row = $dbResult->fetch())) {
					$resultVideo[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
				}
			}


		} else {
			$cacheQuery = '';
			$sqlParam = array();

			$cacheQueryVideo = '';
			$videoMediaSqlParam = array();
		}

		/* keep only the latest search result */
		$_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'] = array();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken] = array('statement' => $cacheQuery,
														'param' => $sqlParam,
														'result' => $result);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['search_result_video'] = array();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['search_result_video'][$cacheToken] = array('statement' => $cacheQueryVideo,
														'param' => $videoMediaSqlParam,
														'result' => $resultVideo);
		return $cacheToken;
	}
	/*!
	 * Get album info by name
	 *
	 * \param $albumName album name
	 * \return array with data from scheme 'photo_share'
	 */
	function GetAlbum($albumName)
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName];
		}
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName];
		}
		return false;
	}
	/*!
	 * Get albums by conditions
	 *
	 * \param $moreCond array with search conditions, key as the field name
	 * \param $isORCond conditions in $moreCond is concatenate by 'OR' or not
	 * \return array with data from scheme 'photo_share'
	 */
	function GetAlbums($moreCond = array(), $isORCond = false)
	{
		$searchPool = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'];
		if (!isSet($moreCond['is-subdir']) || 'f' == $moreCond['is-subdir'] || false === $moreCond['is-subdir']) {
			$searchPool = array_merge($searchPool, $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir']);
		}
		if (isSet($moreCond['is-subdir'])) {
			unset($moreCond['is-subdir']);
		}
		$result = array();
		foreach ($searchPool as $albumName => $item) {
			$condMatch = array();
			foreach ($moreCond as $key => $value) {
				if (!is_array($value)) {
					$value = array('op' => '=', 'value' => $value);
				}
				$op = strtoupper($value['op']);
				$value = strtoupper($value['value']);
				switch ($op) {
					case '=':
						$condMatch[] = ($value == strtoupper($item[$key]));
						break;
					case 'PREFIX':
						$condMatch[] = ($value == strtoupper(substr($item[$key], 0, strlen($value))));
						break;
					case 'MIDDLE':
						$condMatch[] = (false !== stristr($item[$key], $value));
						break;
					default: // not supported
						$condMatch[] = false;
				}
			}
			$match = $isORCond ? false !== array_search(true, $condMatch, true) : false === array_search(false, $condMatch, true);
			if ($match) {
				$result[] = $item;
			}
		}
		return $result;
	}
	/*!
	 * purge stale log accroding to #SYNOPHOTO_MAX_LOG_TO_KEEP
	 *
	 * \return the logid can be used to insert new record
	 */
	private function PurgePhotoLog()
	{
		$query = 'SELECT count(logid) FROM photo_log';
		$dbResult = $this->_dbh->query($query);
		$logRec = $dbResult->fetch();
		/* purge stale log record */
		if ($logRec[0] >= SYNOPHOTO_MAX_LOG_TO_KEEP) {
			$query =  'SELECT create_time FROM photo_log ORDER BY create_time DESC LIMIT 1 OFFSET '.SYNOPHOTO_REC_TO_DEL;
			$dbResult = $this->_dbh->query($query);
			$truncateLog = $dbResult->fetch();
			$query = "DELETE FROM photo_log WHERE create_time < '{$truncateLog[0]}'";
			$this->_dbh->query($query);
		}
		$query = 'SELECT max(logid) FROM photo_log';
		$dbResult = $this->_dbh->query($query);
		$maxLogId = $dbResult->fetch();
		/* rotate to 1 if > PHP_INT_MAX (2147483647) */
		$maxLogId = $maxLogId[0] >= PHP_INT_MAX ? 1 : $maxLogId[0] + 1;
		return $maxLogId;
	}
	/*!
	 * Add a new log record to db
	 *
	 * \param $msg message string to record
	 * \param $isError this log is for error occurred
	 * \param $user logined username
	 */
	function AddPhotoLog($msg, $isError, $user)
	{
		$isError = $isError ? 't' : 'f';
		$logId = $this->PurgePhotoLog();
		$query = 'INSERT INTO photo_log VALUES(?, ?, ?, ?, ?)';
		$sqlParam = array($logId, date('Y-m-d H:i:s'), $msg, $isError, $user);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
	}
	/*!
	 * Get language to use by system config
	 *
	 * \return ### format language region code
	 */
	function GetLanguage()
	{
		/* use user-defined language */
		if ('1' == $this->GetConfig('global', 'lang_setting') &&
			'def' != ($lang = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['language']) ) {
			return $lang;
		}
		/* use browser default */
		$matches = array();
		if (isSet($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
			preg_match_all('/([-a-z]+)(;q=([\.0-9]+))?/', strtolower(trim($_SERVER['HTTP_ACCEPT_LANGUAGE'])), $matches, PREG_SET_ORDER);
		}
		$acceptLang = array();
		foreach ($matches as $item) {
			$qvalue = isSet($item[3]) ? $item[3] : 1;
			$acceptLang[$qvalue] = $item[1];
		}
		unset($matches);
		/* sort by qvalue (ref. RFC 2616) */
		krsort($acceptLang, SORT_NUMERIC);
		foreach ($acceptLang as $lang) {
			if (false !== ($lang = csSYNOPhotoMisc::GetMappedLanguage($lang)) &&
				false !== stripos($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg']['supplang'], $lang)) {
				return $lang;
			}
		}
		return 'enu';
	}
	/*!
	 * Update photo's property
	 *
	 * \param $path photo's path
	 * \param $title photo's new title
	 * \param $description photo's new description
	 *
	 */
	function UpdatePhotoProperty($path, $title, $description, $realPath)
	{
		$cmd = sprintf('%s -M"set %s %s" %s', SYNO_EXIFTOOL_FILE, "Xmp.dc.description", str_replace('"', '\"', $description), escapeshellarg($realPath));
		@exec($cmd);
		$cmd = sprintf('%s -M"set %s %s" %s', SYNO_EXIFTOOL_FILE, "Iptc.Application2.Caption", str_replace('"', '\"', $description), escapeshellarg($realPath));
		@exec($cmd);

		$path = $this->EscapeParam($path);
		$title = $this->EscapeParam($title);
		$description = $this->EscapeParam($description);

		$query = "Update photo_image set title = '$title', description = '$description' where path = '$path'";
		$db_result = $this->_dbh->query($query);

		//update mtime of all thumbnails for prevent from re-making thumbnail
		$cmd = sprintf('/usr/syno/bin/synophoto_dsm_user --updatethumbnailmtime %s', escapeshellarg($realPath));
		@exec($cmd);

		return true;
	}
	/*!
	 * Update video property
	 *
	 * \param $path video's path
	 * \param $title video's new title
	 * \param $description video's new description
	 *
	 */
	function UpdateVideoProperty($path, $title, $description)
	{
		$path = $this->EscapeParam($path);
		$title = $this->EscapeParam($title);
		$description = $this->EscapeParam($description);
		$query = "Update video_desc set title = '$title', description = '$description' where path = '$path'";
		$db_result = $this->_dbh->query($query);
		if($db_result->rowCount() < 1) {
			if (empty($title)) {
				$file_name = basename($path);
				$file = substr($file_name, 0, strpos($file_name, "."));
				$title = $this->EscapeParam($file);
			}
			$query = "Insert into video_desc (path, title, description) Values ('$path', '$title', '$description')";
			$this->_dbh->query($query);

		}

		return true;
	}
	/*!
	 * Update album property
	 *
	 * \param $shareName album share name
	 * \param $title album's new title
	 * \param $description album's new description
	 * \param $albumPersmission album's new permission. 0:public 1:private 2:keyword
	 * \param $password album's new password.
	 *
	 */
	function UpdateAlbumProperty($shareName, $title, $description, $albumPersmission, $password)
	{
		$shareName = $this->EscapeParam($shareName);
		$title = $this->EscapeParam($title);
		$description = $this->EscapeParam($description);

		$album = $this->GetAlbum($shareName);
		if ($albumPersmission == SYNOPHOTO_ALBUM_PASSWORD && !$password && $album['password']) {
			$password = $album['password'];
		}

		if (!$password) {
			$public = (SYNOPHOTO_ALBUM_PUBLIC == $albumPersmission)?'t':'f';
			$query = "Update photo_share set title = '$title', description = '$description', public = '$public', password = null where sharename = '$shareName'";
		} else {
			$query = "Update photo_share set title = '$title', description = '$description', password = '$password' where sharename = '$shareName'";
		}
		$db_result = $this->_dbh->query($query);

		return true;
	}
	/*!
	 * Add new created album into mediaserver DB
	 *
	 * \param $path new created album's path
	 * \param $title new created album's name
	 */
	function AddNewAlbumIntoMediaserverDB($path, $title)
	{
		$dPath = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$current_date_time = date('Y-m-d H:i:s');
		$query = "Insert into directory (path, title, date, mdate) values ('".$this->EscapeParam($dPath)."', '".$this->EscapeParam($title)."', '".$current_date_time."', '".$current_date_time."');";
		$db_result = $this->_dbh->query($query);

		@exec("/usr/syno/bin/synophotoio -a ".escapeshellarg($path)." > /dev/null 2>&1");

		return true;
	}

	/*!
	 * Add top album into photo DB
	 *
	 * \param $albumName new created album's name
	 * \param $public bool value for album's public
	 * \param $passwd password of album
	 */
	function AddTopAlbumIntoDB($albumName, $public, $passwd)
	{

		// get the largest shareid + 1 as new share id
		$query = "Select shareid from photo_share order by shareid desc limit 1;";
		$db_result = $this->_dbh->query($query);
		$row = $db_result->fetch();
		$new_shareid = $row[0] + 1;

		// insert folder info into photo_share table
		$album_public = $public ? 't':'f';
		$album_password = (null == $passwd)?"null":"'$passwd'";
		$def_allow_comment = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['photo']['album_def_allow_comment'] == 'on' ? 't':'f';
		$query = "Insert into photo_share (shareid, sharename, public, is_subdir, password, comment) values (".$new_shareid.", '".$this->EscapeParam($albumName)."', '".$album_public."', 'f', ".$album_password.", '$def_allow_comment');";
		$db_result = $this->_dbh->query($query);

		return true;
	}
	/*!
	 * Add sub album into photo DB
	 *
	 * \param $parentAlbumName new created album's parent album name
	 * \param $albumName new created album's name
	 * \param $public bool value for album's public
	 * \param $passwd password of album
	 */
	function AddSubAlbumIntoDB($parentAlbumName, $albumName, $public, $passwd)
	{
		// get parent's share id
		$query = "Select public, shareid, password from photo_share where sharename = '".$this->EscapeParam($parentAlbumName)."';";
		$db_result = $this->_dbh->query($query);
		if($row = $db_result->fetch()) {
			$parent_public = $this->ConvertAsBool($row[0]) ? 't' : 'f';
			$parent_shareid = $row[1];
			$parent_password = $row[2];
		} else {
			// no such parent album in DB
			return false;
		}

		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$album_public = $public ? 't':'f';
			$album_password = (null == $passwd)?"null":"'$passwd'";
		} else {
			// if user is not admin -> ignore the public setting and set the new album's public as parent's
			$album_public = $parent_public;
			$album_password = (null == $parent_password)?"null":"'$parent_password'";
		}

		$query = "Select shareid from photo_share order by shareid desc limit 1;";
		$db_result = $this->_dbh->query($query);
		$row = $db_result->fetch();
		$new_shareid = $row[0] + 1;
		$shareName = $parentAlbumName.'/'.$albumName;
		$query = "Insert into photo_share (shareid, sharename, public, is_subdir, password) values (".$new_shareid.", '".$this->EscapeParam($shareName)."', '".$album_public."', 't', ".$album_password.");";
		$db_result = $this->_dbh->query($query);

		if ( "null" == $album_password) {
			if ('f' == $album_public) {
				// Set access Right the same as parent.
				$access_right_table = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'])?'photo_access_right_for_dsm_account':'photo_access_right';
				$query = "Select userid from ".$access_right_table." where shareid = ".$parent_shareid;;
				$db_result = $this->_dbh->query($query);
				while(($row = $db_result->fetch())) {
					$query = "Insert into ".$access_right_table." (userid, shareid, create_time) values (".$row[0].", ".$new_shareid.", '".date('Y-m-d H:i:s')."');";
					$db_result_2 = $this->_dbh->query($query);
				}
			}

			// Set upload Right the same as parent.
			$upload_right_table = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'])?'photo_upload_right_for_dsm_account':'photo_upload_right';
			$query = "Select userid from ".$upload_right_table." where shareid = ".$parent_shareid;
			$db_result = $this->_dbh->query($query);
			while(($row = $db_result->fetch())) {
				$query = "Insert into ".$upload_right_table." (userid, shareid, create_time) values (".$row[0].", ".$new_shareid.", '".date('Y-m-d H:i:s')."');";
				$db_result_2 = $this->_dbh->query($query);
			}
		}

		return true;
	}

	/*!
	 * Check DSM account is admin group
	 *
	 * \param $dsm_user DSM user name
	 * \return true if the user is one of the admin group.
	 */
	function IsDSMAdmin($dsm_user)
	{
		$isAdmin = false;
		@exec("/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($dsm_user)."|grep 'AdminGroup'", $results, $retval);
		if (!$retval) {
			$token = explode(']', $results[0]);
			$token = explode('[', $token[0]);
			$isAdmin = (count($token) > 1 && 1 == $token[1]);
		}
		return $isAdmin;
	}

	function DeletePhoto($photopath)
	{
		$dPath = substr($photopath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$dPath = $this->EscapeParam($dPath);

		$query = "SELECT id FROM photo_image WHERE path = '".$this->EscapeParam($dPath)."'";
		$dbResult = $this->_dbh->query($query);
		if ($row = $dbResult->fetch()) {
			$query = "DELETE FROM photo_image WHERE path = '".$this->EscapeParam($dPath)."'";
			$this->_dbh->query($query);

			$query ="DELETE FROM photo_comment WHERE photo_id = ".$row[0];
			$this->_dbh->query($query);
		}

		$this->CheckPhotoLabel();

		@exec("/usr/syno/bin/synophotoio -d ".escapeshellarg($photopath));
		@exec("/usr/syno/bin/synoindex -d ".escapeshellarg($path));
		return true;
	}

	function DeleteVideo($videopath)
	{
		$vPath = substr($videopath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$vPath = $this->EscapeParam($vPath);

		$query = "DELETE FROM video WHERE path = '".$this->EscapeParam($vPath)."'";
		$this->_dbh->query($query);

		$query = "DELETE FROM video_convert WHERE video_path = '".$this->EscapeParam($vPath)."'";
		$this->_dbh->query($query);

		$query = "DELETE FROM video_comment WHERE path = '".$this->EscapeParam($vPath)."'";
		$this->_dbh->query($query);

		$query = "DELETE FROM video_desc WHERE path = '".$this->EscapeParam($vPath)."'";
		$this->_dbh->query($query);

		$query = "DELETE FROM photo_video_label WHERE video_path = '".$this->EscapeParam($vPath)."'";
		$this->_dbh->query($query);

		$this->CheckPhotoLabel();

		@exec("/usr/syno/bin/synophotoio -d ".escapeshellarg($videopath));
		return true;
	}

	function DeleteAlbum($sharename)
	{
		$shareid = -1;
		$name = $this->EscapeParam($sharename);
		$query = "SELECT shareid FROM photo_share WHERE sharename = '$name'";
		$dbResult = $this->_dbh->query($query);
		if ($row = $dbResult->fetch()) {
			$shareid = $row['shareid'];
		}

		$path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$sharename;
		$real_path  = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$sharename;

		$escape = $this->escapeStr;
		//delete from photo_share, directory
		$query = 'DELETE FROM photo_share WHERE sharename LIKE ? '.$escape." OR sharename='".$name."'";
		$sqlParamName = array(self::EscapeLikeParam($sharename).'/%');
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParamName);

		$access_right_table = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'])?'photo_access_right_for_dsm_account':'photo_access_right';
		$query = 'DELETE FROM ' . $access_right_table . ' WHERE shareid='.$shareid;
		$this->_dbh->query($query);

		$upload_right_table = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'])?'photo_upload_right_for_dsm_account':'photo_upload_right';
		$query = 'DELETE FROM ' . $upload_right_table . ' WHERE shareid='.$shareid;
		$this->_dbh->query($query);

		//delete photo, we need photo id to delete photo comment
		$query = 'SELECT id FROM photo_image WHERE path LIKE ? '.$escape;
		$sqlParamPath = array(self::EscapeLikeParam($path).'/%');
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParamPath);

		$in_condi = '(';
		$count = 0;
		while($row = $dbResult->fetch()){
			$in_condi .= $row['id'].',';
			$count++;
		}
		$in_condi = substr($in_condi, 0, -1).')';
		if (0 == $count) {
			$in_condi = '()';
		}

		//delete comment
		$query = 'DELETE From photo_comment WHERE photo_id IN '.$in_condi;
		$this->_dbh->query($query);

		//delete photo
		$query = 'DELETE FROM photo_image WHERE path LIKE ?'.$escape;
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParamPath);

		//delete video
		$query = 'DELETE FROM video WHERE path LIKE ?'.$escape;
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParamPath);

		$query = 'DELETE FROM video_convert WHERE video_path LIKE ?'.$escape;
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParamPath);

		$query = 'DELETE FROM video_comment WHERE path LIKE ?'.$escape;
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParamPath);

		$query = 'DELETE FROM video_desc WHERE path LIKE ?'.$escape;
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParamPath);

		$query = 'DELETE FROM photo_video_label WHERE video_path LIKE ?'.$escape;
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParamPath);

		$this->CheckPhotoLabel();

		if (file_exists($real_path)) {
			@exec("/usr/syno/bin/synophotoio -D ".escapeshellarg($real_path));
			@exec("/usr/syno/bin/synoindex -D ".escapeshellarg($real_path));
		}
		return true;
	}

	function GetGPSLatLng($filePath)
	{
		$query = "Select gps from ".(csSYNOPhotoMisc::IsPhotoFile($filePath) ? "photo_image" : "video")." where path = ?";
		$sqlParam = array(substr($filePath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX)));
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		if (false !== ($row = $dbResult->fetch()) && '' != $row['gps']) {
			$arr = json_decode($row['gps']);
			return array('lat' => $arr->lat, 'lng' => $arr->lng);
		}
		return NULL;
	}

	function SetGPSToDB($filePath, $lat, $lng)
	{
		$arr = array();
		$arr['lat'] = $lat;
		$arr['lng'] = $lng;

		$query = "update ".(csSYNOPhotoMisc::IsPhotoFile($filePath) ? "photo_image" : "video")." set gps = ? where path = ?";
		$sqlParam = array(json_encode($arr), substr($filePath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX)));
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
	}

	function CheckPhotoLabel()
	{
		$query = 'DELETE FROM photo_label ' .
			'WHERE id NOT IN ( ' .
				'SELECT DISTINCT label_id FROM photo_image_label ' .
					'LEFT OUTER JOIN photo_label ' .
					'ON label_id = photo_label.id ' .
			') ' .
			'AND id NOT IN ( ' .
				'SELECT DISTINCT label_id FROM photo_video_label ' .
					'LEFT OUTER JOIN photo_label ' .
					'ON label_id = photo_label.id ' .
			');';

		$this->_dbh->query($query);
	}

	function GetKeywordCondition($keywordStr, $operator = 'all', $fields = array('title'))
	{
		$param = array();

		if (!is_string($keywordStr) || 0 >= strlen(trim($keywordStr)) || !is_array($fields)) {
			return null;
		}

		$keywords = strtolower(trim($keywordStr));

		if ('all' === $operator || 'any' === $operator) {
			$keywords = array_unique(explode(' ', $keywords));
		} else {
			$keywords = array($keywords);
		}

		foreach ($keywords as &$keyword) {
			if (empty($keyword)) {
				continue;
			}

			$cond = array();

			foreach ($fields as $field) {
				$cond[] = "lower($field) like ? {$this->escapeStr}";
				$value = self::EscapeLikeParam($keyword);
				$param[] = "%{$value}%";
			}

			$keyword = '('.implode(' OR ', $cond).')';
		}

		$separator = '';
		if ('all' === $operator) {
			$separator = ' AND ';
		} else if ('any' === $operator) {
			$separator = ' OR ';
		}

		return array(
			'cond' => '('.implode($separator, $keywords).')',
			'param' => $param
		);
	}

	function GetDateCondition($dateStr, $field = 'timetaken')
	{
		if (!is_string($dateStr) || 0 >= strlen(trim($dateStr))) {
			return '';
		}

		$dates = explode(',' , trim($dateStr));
		$begin = strtotime($dates[0]);
		$end = strtotime($dates[1]);

		if (false === $begin && false === $end) {
			return '';
		} else if (false !== $begin) {
			$cond = "$field >= '".date('Y-m-d', $begin)." 00:00:00'";
			if (false !== $end) {
				$cond .= " AND $field <= '".date('Y-m-d', $end)." 23:59:59'";
			}
		} else {
			$cond = "$field <= '".date('Y-m-d', $end)." 23:59:59'";
		}

		$cond = '('.$cond.')';

		return $cond;
	}

	function GetTagCondition($tagStr, $operator = 'all', $tagType = 'people', $type = 'photo')
	{
		$param = array();

		if (!is_string($tagStr) || 0 >= strlen(trim($tagStr))) {
			return null;
		}

		$tags = explode(',' , trim($tagStr));

		$sqlField = '0';
		if ('geo' === $tagType) {
			$sqlField = '1';
		} else if ('desc' === $tagType) {
			$sqlField = '2';
		}

		if ('photo' === $type) {
			$sqlTemplate =
				"id IN (SELECT image_id FROM photo_image_label LEFT JOIN photo_label on label_id = photo_label.id ".
				"WHERE category = '$sqlField' AND label_id = ? )";
		} else {
			$sqlTemplate =
				"path IN (SELECT video_path FROM photo_video_label LEFT JOIN photo_label on label_id = photo_label.id ".
				"WHERE category = '$sqlField' AND label_id = ? )";
		}

		//!!! check if every item (label_id) is REAL label_id
		//maybe need another check if every person item (person label_id) is REAL label_id for person label

		foreach ($tags as &$tag) {
			$param[] = self::EscapeParam($tag);
			$tag = $sqlTemplate;
		}

		if ('all' == $operator) {
			$cond = '('.implode(' AND ', $tags).')';
		} else if ('any' == $operator) {
			$cond = '('.implode(' OR ', $tags).')';
		}

		return array(
			'cond' => $cond,
			'param' => $param
		);
	}

	function GetItemListByLabel($labelId, $category)
	{
		$result = array();
		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();

		if (0 == count($albumCondition['albumCond'])) {
			return $result;
		}
		$sqlParam = array();
		$query = "SELECT photo_image.path FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE photo_image_label.label_id=? AND status='t'";
		$sqlParam[] = $labelId;

		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$query .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
			$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
		}
		$query .= ' ORDER BY photo_image.create_time DESC';
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while (false !== ($row = $dbResult->fetch())) {
			if ($row['path']) {
				$result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_PHOTO;
			}
		}

		if (0 == $category) {
			return $result;
		}
		$query = 'SELECT video_path AS path From photo_video_label LEFT JOIN video ON video.path=photo_video_label.video_path WHERE label_id=?';
		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$query .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
		}
		$query .= ' ORDER BY date DESC';
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while (false !== ($row = $dbResult->fetch())) {
			$result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}
		return $result;
	}

	function GetNonConfirmItemList()
	{
		$result = array();

		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			return $result;
		}

		$query = "SELECT photo_image.path FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE status='f' ORDER BY photo_image.create_time DESC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute();
		while (false !== ($row = $dbResult->fetch())) {
			if ($row['path']) {
				$result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_PHOTO;
			}
		}
		return $result;
	}
}
?>
