<?php
require_once('../include/synophoto_mobile_conf.php');
require_once('../include/gps_util.php');

function DoIndex($path)
{
	@exec("/usr/syno/bin/synoindex -a ".escapeshellarg($path)." > /dev/null 2>&1");
	@exec("/usr/syno/bin/synoindex -f -a ".escapeshellarg($path)." > /dev/null 2>&1");
}

function TrigerFbSync($albumName)
{
	$ret = FALSE;
	if (empty($albumName) || !csSYNOPhotoMisc::isSetToSyncWithFb($albumName)) {
		goto End;
	}

	$token = csSYNOPhotoDB::GetDBInstance()->GetConfig("photo", "fb_token");
	$confPath = csSYNOPhotoMisc::getFbSyncConfPath($albumName);
	$albumPath = SYNOPHOTO_SERVICE_REAL_DIR."/".$albumName;

	$commend = "/usr/syno/bin/synophoto_sns_utils --pidfile \"".$confPath.".set\" --fbsync \"-t '$token' -c ".escapeshellarg($confPath)." ".escapeshellarg($albumPath)."\"";
	@exec($commend." > /dev/null 2>&1");

	$ret = TRUE;
End:
	return $ret;
}

function GetFirstLevelAlbums()
{
	$result = array();
	$currPath = getcwd();
	@chdir(SYNOPHOTO_SERVICE_DIR);

	foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $dirName) {
		// skip photo in remote mount (cifs) or read-only mount (iso9660)
		if (csSYNOPhotoMisc::IsSkipPhotoPath(SYNOPHOTO_SERVICE_DIR.'/'.$dirName)) {
			continue;
		}
		if ($dirName != SYNOPHOTO_EADIR  && $dirName != '.' && $dirName != '..') {
			$result[] = $dirName;
		}
	}

	@chdir($currPath);
	return $result;
}

function GetUploadDestinationFilePath($fileType, $uploadClient, $album, $uploadBaseName, $ext)
{
	$filename = '';
	$dummyID = '-dummyID-';
	$base_name = '';

	if (!empty($uploadBaseName)) {
		$base_name = $uploadBaseName;
	} else {
		$base_name = 'IMG' . date('_Ymd_His');
	}

	if ($fileType == SYNOPHOTO_UPLOAD_FILE_TYPE_PHOTO) {
		$filename = $base_name .$dummyID. '.jpg';
	} else {
		if ($uploadClient == SYNOPHOTO_UPLOAD_CLIENT_IPHONE) {
			$filename = $base_name .$dummyID. '.MOV';
		} else if ($uploadClient == SYNOPHOTO_UPLOAD_CLIENT_ANDROID) {
			$filename = $base_name .$dummyID. $ext;
		}
	}

	if (file_exists(SYNOPHOTO_SERVICE_DIR . '/' . $album . '/' . str_replace($dummyID, '', $filename))) {
		$sequenceID = 1;
		while (true) {
			if (file_exists(SYNOPHOTO_SERVICE_DIR . '/' . $album . '/' . str_replace($dummyID, '('.$sequenceID.')', $filename))) {
				$sequenceID ++;
				continue;
			} else {
				$filename = str_replace($dummyID, '('.$sequenceID.')', $filename);
				break;
			}
		}
	} else {
		$filename = str_replace($dummyID, '', $filename);
	}

	return SYNOPHOTO_SERVICE_DIR . '/' . $album . '/' . $filename;
}

function CreateAlbum($album, $albumPermission, $password)
{
	$result = '';

	$parentPath = '';
	if (isSet($_REQUEST['parent_dir_path'])) {
		$parentPath = $_REQUEST['parent_dir_path'];
	}

	$album = trim($album);

	$pathInfo = pathinfo(SYNOPHOTO_SERVICE_DIR . '/' . $parentPath . '/'. $album);

	$isAlbumNameValid = true;
	if ($album == "") {
		$isAlbumNameValid = false;
	} else if ($album == "." || $album == "..") {
		$isAlbumNameValid = false;
	} else if (preg_match("/([\\\\:\/\\?\|\*<>])|(^@eadir)|(^\._)/i", $album)) {
		$isAlbumNameValid = false;
	}

	if ($isAlbumNameValid) {
		$destPath = SYNOPHOTO_SERVICE_DIR . '/' . $parentPath . '/' .$pathInfo['basename'];

		// check if dir name is duplicated in ignore-case condition (ex. 'aaa' & 'Aaa')
		if ($handle = opendir(SYNOPHOTO_SERVICE_DIR . '/' . $parentPath)) {
    		while (false !== ($file = readdir($handle))) {
        		if ($file != "." && $file != ".." && is_dir(SYNOPHOTO_SERVICE_DIR . '/' . $parentPath . '/' .$file)) {
            		if (0 == strcasecmp($file, $pathInfo['basename'])) {
            			$result = 'error_duplicated_album_name';
            			break;
            		}
        		}
    		}

		    closedir($handle);
		} else {
			$result = 'error_open_parent_dir_fail';
		}

		if (empty($result)) {
			if (@mkdir($destPath, 0777, false)) {
				csSYNOPhotoAlbum::GetAlbumInstance()->AddNewAlbumIntoDB($parentPath, $album, $albumPermission, $password);
				DoIndex($destPath);
			} else {
				$result = 'error_mkdr_fail';
			}

		}
	} else {
		$result = 'error_bad_dir_name';
	}

	if (empty($result)) {
		// refresh the cache since new album was added
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

		//if the login user is not admin, then unlock the new created album for him
		if ($password && !isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$albumName = $parentPath.'/'.$album;
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName] = md5($password);
		}
	}
	return empty($result)? true: $result;
}

function ProcessUpload($album, $title, $desc, $file, $client, $fileType, $uploadBaseName, $ext)
{
	// set php execution timelimit to no limit. prevent from file upload time out.
	set_time_limit(0);

	$result = false;
	if (UPLOAD_ERR_OK != $file['error']) {
		$result = 'unknown_upload_error';
		goto End;
	}

	$destPath = GetUploadDestinationFilePath($fileType, $client, $album, $uploadBaseName, $ext);

	if (!is_dir(dirname($destPath))) {
		$result = 'bad_destination_path';
		goto End;
	}

	if (!csSYNOPhotoAlbum::GetAlbumInstance()->IsAlbumUploadable($album)) {
		$result = 'no_upload_permission';
		goto End;
	}

	if (!move_uploaded_file($file["tmp_name"], $destPath)) {
		$result = 'unknown_upload_error';
		goto End;
	}

	$IsOldEAFilePrefix = csSYNOPhotoMisc::IsOldEAFilePrefix();

	$fullPath = sprintf("%s/%s/%s", SYNOPHOTO_SERVICE_DIR, $album, basename($destPath));
	SYNOPhotoEA::createEADir($fullPath, $eaDir);
	if (!empty($title)) {
		$titlePath = sprintf("%s/%s", $eaDir, SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_TITLE, $IsOldEAFilePrefix));
		file_put_contents($titlePath, $title);
	}
	if (!empty($desc)) {
		$descPath = sprintf("%s/%s", $eaDir, SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_DESC, $IsOldEAFilePrefix));
		file_put_contents($descPath, $desc);
	}

	if ($fileType == SYNOPHOTO_UPLOAD_FILE_TYPE_VIDEO) {
		$videoHardLinkPath = '';
		if	($client == SYNOPHOTO_UPLOAD_CLIENT_IPHONE) {
			$videoHardLinkPath = $eaDir.'/'.SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_MOBILE_IPHONE, $IsOldEAFilePrefix);
		} else if ($client == SYNOPHOTO_UPLOAD_CLIENT_ANDROID) {
			$videoHardLinkPath = $eaDir.'/'.SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_MOBILE_ANDROID, $IsOldEAFilePrefix);
		}
		$temp = $destPath.'tmp';
		@exec("/usr/syno/bin/qt-faststart ".escapeshellarg($destPath)." ".escapeshellarg($temp));
		@rename($temp,$destPath);
		@link($destPath, $videoHardLinkPath);

		if (!file_exists($videoHardLinkPath)) {
			// for FAT file system cannot hard link
			@copy($destPath, $videoHardLinkPath);
		}
	}

	// write EXIF info into file
	if (isset($_REQUEST['lat']) && isset($_REQUEST['lng'])) {
		SYNOPHOTO_GPS_UTIL_SetGPSLatLng($destPath, $_REQUEST['lat'], $_REQUEST['lng']);
	}

	if (isset($_REQUEST['EXIF_GPSTimeStamp'])) {
		SYNOPHOTO_GPS_UTIL_SetEXIFToFile($destPath, 'Exif.GPSInfo.GPSTimeStamp', $_REQUEST['EXIF_GPSTimeStamp']);
	}

	if (isset($_REQUEST['EXIF_Make']) && isset($_REQUEST['EXIF_Model']) && isset($_REQUEST['EXIF_CreateDate']) && isset($_REQUEST['EXIF_DateTimeOriginal'])) {
		SYNOPHOTO_GPS_UTIL_SetBatchEXIFToFile($destPath, $_REQUEST['EXIF_Make'], $_REQUEST['EXIF_Model'], $_REQUEST['EXIF_CreateDate'], $_REQUEST['EXIF_DateTimeOriginal']);
	}

	if (isset($_REQUEST['DateTimeOriginal'])) {        
		@touch($destPath, $_REQUEST['DateTimeOriginal']);        
	} 

	DoIndex($destPath);
	TrigerFbSync($album);
	$result = true;

	// flush album list cache since new item was added
	if ($fileType == SYNOPHOTO_UPLOAD_FILE_TYPE_PHOTO) {
		unset($_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$album]);

	} else if ($fileType == SYNOPHOTO_UPLOAD_FILE_TYPE_VIDEO) {
		unset($_SESSION[SYNOPHOTO_ADMIN_USER]['list_video_cache'][$album]);

	}
End:
	return $result;
}

function DispatchAction($action)
{
	$result = array();
	switch ($action) {
		case 'albums':
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				$result = GetFirstLevelAlbums();
			}
			break;
		case 'album_check':
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				$path = SYNOPHOTO_SERVICE_DIR . '/' . $_REQUEST['album'];
				$result['success'] = is_dir($path);
			}
			break;
		case 'admin_check':
			$result['success'] = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
			break;
		case 'album_create':
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) || isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
				if (isSet($_REQUEST['album']) && isSet($_REQUEST['album_permission'])) {
					$password = (isSet($_REQUEST['album_password']))?$_REQUEST['album_password']:null;
					$albumPersmission = (int) $_REQUEST['album_permission'];
					$result['success'] = CreateAlbum($_REQUEST['album'], $albumPersmission, $password);
				} else {
					$result['success'] = 'error_bad_parameter';
				}
			} else {
				$result['success'] = 'error_not_login';
			}
			break;
		case 'photo_upload';
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) || isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
				if (isSet($_REQUEST['album']) && isSet($_FILES['file']) &&isSet($_REQUEST['upload_client']) && isSet($_REQUEST['upload_file_type'])) {
					$title = isSet($_REQUEST['title']) ? $_REQUEST['title'] : '';
					$desc = isSet($_REQUEST['description']) ? $_REQUEST['description'] : '';
					$ext = isSet($_REQUEST['upload_file_ext']) ? '.' . $_REQUEST['upload_file_ext'] : '';
					$base_name = isSet($_REQUEST['upload_base_name']) ? $_REQUEST['upload_base_name'] : '';
					$result['success'] = ProcessUpload($_REQUEST['album'], $title, $desc, $_FILES['file'], $_REQUEST['upload_client'], $_REQUEST['upload_file_type'], $base_name, $ext);
				} else {
					$result['success'] = 'error_bad_parameter';
				}
			} else {
				$result['success'] = 'error_not_login';
			}
			break;
		default:
			break;
	}
	return $result;
}

$action = isSet($_REQUEST['action']) ? $_REQUEST['action'] : '';
echo json_encode(DispatchAction($action));
?>
