<?php
require_once('include/synophoto_mobile_conf.php');

$isIPhone = ('iPhone' == $_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser']);

$albumName = @pack('H*', $_GET['dir']);
$password = $_POST['password'];
$checkResult = csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($albumName, $password);
if ("error_no_permission" === $checkResult) {
	header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/m/");
	exit;
}

csSYNOPhotoAlbum::GetAlbumInstance()->AddHitTimes($albumName);
$albumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);
$albumToken = explode('/', $albumName);

if (isSet($_GET['searchToken']) && !empty($_GET['searchToken'])
	&& isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$_GET['searchToken']])
	&& isSet($_GET['search']) && !empty($_GET['search'])
	&& (isSet($_GET['option_name']) || isSet($_GET['option_title']) || isSet($_GET['option_desc'])) ) {
	$searchToken = $_GET['searchToken'];
	$searchParam = "searchToken={$searchToken}&search={$_GET['search']}";
	$condition = array();
	$matchPattern = array('option_name', 'option_title', 'option_desc');
	foreach($matchPattern as $field) {
		if (isSet($_GET[$field])) {
			$searchParam .= "&{$field}=on";
			$condition[$field] = $_GET['search'];
		}
	}
	$seqList = csSYNOPhotoBrowse::GetBrowseInstance()->GetSearchList($condition);
	$albumRealPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}";
	$albumSeq = 1 + array_search($albumRealPath, array_keys($seqList));
	$parentAlbumTitle = __('photo_str_search_result');
	$parentAlbumLink = "search_result.php?showSeq={$albumSeq}&{$searchParam}";
} else if (count($albumToken) > 1) { // sub-dir
	array_pop($albumToken);
	$parentAlbumName = implode('/', $albumToken);
	$seqList = csSYNOPhotoBrowse::GetBrowseInstance()->GetList($parentAlbumName);
	$albumSeq = 1 + array_search($albumName, array_keys($seqList));
	$parentAlbumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($parentAlbumName);
	$parentAlbumTitle = $parentAlbumInfo['showTitle'];
	$parentAlbumLink = "photo_album.php?showSeq={$albumSeq}&dir=".bin2hex(implode('/', $albumToken));
} else {
	$seqList = csSYNOPhotoBrowse::GetBrowseInstance()->GetList('/');
	$albumSeq = 1 + array_search($albumName, array_keys($seqList));
	$parentAlbumTitle = __('Photo Albums');
	$parentAlbumLink = "index.php?showSeq={$albumSeq}";
}

$smarty->assign('toolbarTitle', $albumInfo['showTitle']);
$smarty->assign('photoDir', $_GET['dir']);
$smarty->assign('navPrevText', $parentAlbumTitle);
$smarty->assign('navPrevLink', $parentAlbumLink);

if (!$isIPhone && true !== $checkResult) {
	switch ($checkResult) {
		case "error_invalid_album_password":
			$smarty->assign('alertMsg', __('photo_str_password_error'));
		case "error_need_album_password":
			Header("Cache-Control: no-cache, must-revalidate");
			Header("Pragma: no-cache");
			$smarty->display('photo_album_password.tpl');
			break;
		default:
			header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/m/");
	}
	exit;
}

if (!$isIPhone) {
	$page = 1;
	if (isSet($_GET['showSeq']) && is_numeric($_GET['showSeq'])) {
		$page = ceil($_GET['showSeq'] / PHOTOS_PER_LOAD);
	} else if (isSet($_GET['page']) && is_numeric($_GET['page'])) {
		$page = $_GET['page'];
	}
	$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbList($albumName, ($page - 1) * PHOTOS_PER_LOAD, PHOTOS_PER_LOAD);
	$smarty->assign('page', $page);
	$smarty->assign('isMorePage', $photoList['photoMore']);
	$smarty->assign('photoList', $photoList);
}

$smarty->display('photo_album.tpl');
?>
