<?php
/*!
 * thumb list operation
 */
class csSYNOPhotoThumb {
	/*! reference to a self instance */
	private static $instance = null;
	/*!
	 * Get a exist instance
	 */
	static function GetThumbInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get thumb info for specified photo
	 *
	 * \param $item array with photo info
	 *	- path: photo file path
	 *	- resolutionx: photo width
	 *	- resolutiony: photo height
	 *	- version: photo orientation
	 * \return array with thumb info
	 *	- cover: cover info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *	- link: link to view the photo
	 */
	function GetThumbInfo($item)
	{
		$isPhotoFile = csSYNOPhotoMisc::IsPhotoFile($item['path']);
		if (!$isPhotoFile) {
			return array();
		}
		$result['path'] = $item['path'];
		$result['showTitle'] = htmlspecialchars($item['title']);
		$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], false, $item['resolutionx'], $item['resolutiony'], $item['version']);
		$prefixLength = strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1;
		$dir = substr($item['path'], $prefixLength, strlen($item['path']) - strlen(basename($item['path'])) - $prefixLength - 1);
		$result['link'] = SYNOPHOTO_URL_PREFIX.'/photo/m/photo_one.php?dir='.bin2hex($dir).'&name='.bin2hex(basename($item['path']));
		return $result;
	}
	/*!
	 * Get photo preview info in specified list
	 *
	 * \param $list path list
	 * \param $offset target photo's seq
	 * \return array with preview info
	 *	- prev,curr,next:
	 *		- seq: sequence number in the thumb list
	 *		- title: user-defined title
	 *		- description: user-defined description
	 *		- cover: thumb info
	 *		- album: album name the photo belongs to
	 *		- photoDir: the wrapped album name the photo belongs to
	 *		- photoName: the wrapped photo file name
	 */
	private function GetPreviewInfo($list, $offset)
	{
		$previewInfo = array(array(), array(), array());

		for($idx = $offset-1; $idx <= $offset+1; $idx++) {
			if ($idx < 0 || $idx >= count($list)) {
				continue;
			}
			$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($list[$idx]);
			$item = array();
			$item['seq'] = $idx + 1;
			$item['title'] = htmlspecialchars($photoInfo['title']);
			$item['description'] = htmlspecialchars($photoInfo['description']);
			$item['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($photoInfo['path'], true, $photoInfo['resolutionx'], $photoInfo['resolutiony'], $photoInfo['version']);
			$PhotoPath = $photoInfo['path'];
			$prefixLength = strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1;
			$item['album'] = substr($PhotoPath, $prefixLength, strlen($PhotoPath) - strlen(basename($PhotoPath)) - $prefixLength - 1);
			$item['photoDir'] = bin2hex($item['album']);
			$item['photoName'] = bin2hex($photoInfo['name']);
			$previewInfo[$idx - $offset + 1] = $item;
		}

		return array('curr' => $previewInfo[1], 'prev' => $previewInfo[0], 'next' => $previewInfo[2]);
	}
	/*!
	 * Get photo preview info for specified album
	 *
	 * \param $albumName album name
	 * \param $photoName photo file name
	 * \return returned by GetPhotoView()
	 */
	function GetAlbumPhotoView($albumName, $photoName)
	{
		$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$photoName}";
		$list = csSYNOPhotoBrowse::GetBrowseInstance()->GetList($albumName);
		foreach($list as $name => $isDir) {
			if ($isDir) {
				unset($list[$name]);
				continue;
			}
			$list[$name] = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$name}";
		}
		$list = array_values($list);
		$offset = array_search($photoPath, $list);
		csSYNOPhotoDB::GetDBInstance()->PrepareAlbumPhotos($albumName, $offset, 1);
		return $this->GetPreviewInfo($list, $offset);
	}
	/*!
	 * Get photo preview info for specified search list
	 *
	 * \param $searchToken the cache token returned by csSYNOPhotoDB::SearchPhotos()
	 * \param $albumName album name
	 * \param $photoName photo file name
	 * \return returned by GetPhotoView()
	 */
	function GetSearchPhotoView($searchToken, $albumName, $photoName)
	{
		$photoPath = SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}/{$photoName}";
		$current_admin = preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches) ? substr(urldecode($matches[0]), 2):'root';
		$list = $_SESSION[$current_admin]['search_result'][$searchToken]['result'];
		$offset = array_search($photoPath, $list);
		csSYNOPhotoDB::GetDBInstance()->PrepareSearchPhotos($searchToken, $offset, 1);
		return $this->GetPreviewInfo($list, $offset);
	}
}
?>
