<?php
/*!
 * browsing operation
 */
class csSYNOPhotoBrowse {
	/*! reference to a self instance */
	private static $instance = null;
	/*!
	 * Get a exist instance
	 */
	static function GetBrowseInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get ordered album list by configuration
	 *
	 * \return sorted album list array
	 */
	private function GetAlbumListByOrderConfig()
	{
		$list = json_decode(csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'order_list'), true);
		if (NULL == $list) {
			$list = array();
		}

		$result = array();
		$albums = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']);

		/* make sure data type is string */
		foreach ($list as &$name) {
			settype($name, 'string');
		}
		foreach ($albums as &$name) {
			settype($name, 'string');
		}
		unset($name);

		foreach ($list as $item) {
			if (in_array($item, $albums, true)) {
				array_push($result, $item);
			}
		}
		foreach ($albums as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}
		return $result;
	}
	/*!
	 * Get content name list for a album
	 *
	 * \param $albumName album name
	 * \return array with NAME list
	 */
	function GetList($albumName)
	{
		$dirList = array();
		$photoList = array();

		if ('/' == $albumName) {
			$OrderType = csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'album_order_type');
			if ('1' != $OrderType) {
				$OrderTypeDesc = csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'album_order_type_is_desc');
				if ('1' == $OrderTypeDesc) {
					$albumList = array_reverse(array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']));
				} else {
					$albumList = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']);
				}
			} else {
				$albumList = $this->GetAlbumListByOrderConfig();
			}
			$dirList = $albumList;
		} else {
			$photoList = csSYNOPhotoDB::GetDBInstance()->GetAlbumPhotoList($albumName);
			$unsortedDirList = csSYNOPhotoMisc::GetSubDir($albumName, true);
			if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] == 'name') {
				if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] == 'desc') {
					$dirList = array_reverse(array_keys($unsortedDirList));
				} else {
					$dirList = array_keys($unsortedDirList);
				}
			} else {
				if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] == 'desc') {
					arsort($unsortedDirList);
				} else {
					asort($unsortedDirList);
				}
				$dirList = array_keys($unsortedDirList);
			}
		}

		$list = array();
		foreach($dirList as $name) {
			$list[$name] = true;
		}
		foreach($photoList as $name) {
			$list[$name] = false;
		}
		return $list;
	}
	/*!
	 * get search token by ui search option
	 *
	 * \param $condition conditions for search
	 * \return search token
	 */
	function OptionToSearchToken($condition)
	{
		$photoCond = array();
		$MatchPattern = array('option_name' => 'name', 'option_title' => 'title', 'option_desc' => 'description');
		foreach ($MatchPattern as $key => $field) {
			if (isSet($condition[$key])) {
				$photoCond[$field] = $condition[$key];
			}
		}
		return csSYNOPhotoDB::GetDBInstance()->GetSearchToken($photoCond);
	}
	/*!
	 * Get search result list
	 *
	 * \param $condition conditions for search
	 * \return array with PATH list
	 */
	function GetSearchList($condition)
	{
		$albumCond = array();
		$MatchPattern = array('option_name' => 'sharename', 'option_title' => 'title', 'option_desc' => 'description');
		foreach ($MatchPattern as $key => $field) {
			if (isSet($condition[$key])) {
				$albumCond[$field] = array('op' => 'MIDDLE', 'value' => $condition[$key]);
			}
		}

		$searchToken = $this->OptionToSearchToken($condition);
		$photoList = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$searchToken]['result'];
		$dirList = csSYNOPhotoDB::GetDBInstance()->GetAlbums($albumCond, true);

		$list = array();
		foreach($dirList as $item) {
			$list[$item['sharename']] = true;
		}
		foreach($photoList as $path) {
			$list[$path] = false;
		}
		return $list;
	}
	/*!
	 * Get album thumb
	 *
	 * \param $albumName album name
	 * \return array with album thumb info
	 */
	private function GetAlbumThumb($albumName)
	{
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);
		$item['cover'] = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($albumName);
		$item['cover']['style'] = csSYNOPhotoMisc::GetThumbStyle($item['cover']);
		return $item;
	}
	/*!
	 * Get photo thumb
	 *
	 * \param $albumName album name
	 * \return array with photo thumb info
	 */
	private function GetPhotoThumb($photoPath)
	{
		$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
		$item = csSYNOPhotoThumb::GetThumbInstance()->GetThumbInfo($photoInfo);
		$item['type'] = 'pic';
		$item['cover']['style'] = csSYNOPhotoMisc::GetThumbStyle($item['cover']);
		return $item;
	}
	/*!
	 * Get album list by offset and length
	 *
	 * \param $offset # of albums to skip
	 * \param $length # of albums to list
	 * \return array with album list info
	 *	- albums: album list info
	 *		- array returned by csSYNOPhotoAlbum::GetAlbumInfo()
	 *		- cover: album cover info
	 *		- cover['style']: verious styles returned by csSYNOPhotoMisc::GetThumbStyle()
	 *	- albumMore: # of the rest albums
	 */
	function GetAlbumList($offset, $length)
	{
        $albumList = array();
		$list = $this->GetList('/');

		$seekOffset = 0;
		foreach($list as $name => $isDir) {
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($isDir) {
					$item = $this->GetAlbumThumb($name);
					$albumList[] = $item;
				}
			}
			$seekOffset++;
		}

		$result = array();
		$result['albums'] = $albumList;
		$result['albumMore'] = count($list) - ($offset + count($albumList));
		return $result;
	}
	/*!
	 * Get thumb list by offset and length
	 *
	 * \param $albumName album name
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with thumb list info
	 *	- photos: array merged from GetDirThumbs() and GetPicThumbs()
	 *	- photoMore: # of the rest thumbs
	 */
	function GetThumbList($albumName, $offset, $length)
	{
		csSYNOPhotoDB::GetDBInstance()->PrepareAlbumPhotos($albumName, $offset, $length);

		$thumbList = array();
		$list = $this->GetList($albumName);

		$seekOffset = 0;
		foreach($list as $name => $isDir) {
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($isDir) {
					$thumbList[] = $this->GetAlbumThumb($name);
				} else {
					$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$name}";
					$thumbList[] = $this->GetPhotoThumb($photoPath);
				}
			}
			$seekOffset++;
		}

		$result = array();
		$result['photos'] = $thumbList;
		$result['photoMore'] = count($list) - ($offset + count($thumbList));
		return $result;
	}
	/*!
	 * Get thumb list from search result by offset and length
	 *
	 * \param $condition conditions for search
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with thumb list info
	 *	- token: the cache token returned by csSYNOPhotoDB::GetSearchToken()
	 *	- photos: array merged from GetDirThumbs() and GetPicThumbs()
	 *	- photoMore: # of the rest thumbs
	 */
	function GetSearchThumbList($condition, $offset, $length)
	{
		$searchToken = $this->OptionToSearchToken($condition);
		csSYNOPhotoDB::GetDBInstance()->PrepareSearchPhotos($searchToken, $offset, $length);

		$thumbList = array();
		$list = $this->GetSearchList($condition);

		$seekOffset = 0;
		foreach($list as $name => $isDir) {
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($isDir) {
					$thumbList[] = $this->GetAlbumThumb($name);
				} else {
					$thumbList[] = $this->GetPhotoThumb($name);
				}
			}
			$seekOffset++;
		}

		$result = array();
		$result['token'] = $searchToken;
		$result['photos'] = $thumbList;
		$result['photoMore'] = count($list) - ($offset + count($thumbList));
		return $result;
	}
	/*!
	 * Get comments for specified photo by page number
	 *
	 * \param $albumName album name
	 * \param $photoName photo file name
	 * \param $offset # of comments to skip
	 * \param $length # of comments to list
	 * \return array with comment list info
	 *	- comments: array with comment info
	 *		- name: commentator name
	 *		- email: commentator email
	 *		- comment: comment
	 *		- date: comment date
	 *	- commentsMore: # of the rest comments
	 */
	function GetCommentList($albumName, $photoName, $offset, $length)
	{
		$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$photoName}";
		$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
		$comments = csSYNOPhotoDB::GetDBInstance()->GetPhotoComments($photoInfo['id'], $offset, $length);
		$result['comments'] = array();
		foreach ($comments as $item) {
			$result['comments'][] = array('name' => $item['name'], 'email' => $item['email'], 'comment' => $item['comment'],
										  'date' => csSYNOPhotoMisc::GetReducedDate($item['date'])
										 );
		}
		$result['commentsMore'] = csSYNOPhotoDB::GetDBInstance()->GetNumberOfComments($photoInfo['id']) - $offset - count($result['comments']);
		return $result;
	}
}
?>
