<?php
require_once('../include/synophoto_mobile_conf.php');

function DoIndex($path)
{
	@exec("/usr/syno/bin/synoindex -a ".escapeshellarg($path)." > /dev/null 2>&1");
	@exec("/usr/syno/bin/synophotoio -a ".escapeshellarg($path)." > /dev/null 2>&1");
}

function GetFirstLevelAlbums()
{
	$result = array();
	$currPath = getcwd();
	@chdir(SYNOPHOTO_SERVICE_DIR);

	foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $dirName) {
		if ($dirName != SYNOPHOTO_EADIR && $dirName != '.' && $dirName != '..' && false == csSYNOPhotoMisc::IsSkipPhotoPath(SYNOPHOTO_SERVICE_DIR.'/'.$dirName)) {
			$result[] = $dirName;
		}
	}

	@chdir($currPath);
	return $result;
}

function CreateAlbum($album, $public)
{
	$result = false;
	$pathInfo = pathinfo(SYNOPHOTO_SERVICE_DIR . '/' . $album);
	if (@realpath(SYNOPHOTO_SERVICE_DIR) == @realpath($pathInfo['dirname'])) {
		$destPath = SYNOPHOTO_SERVICE_DIR . '/' . $pathInfo['basename'];
		if ($result = @mkdir($destPath, 0777, false)) {
			SYNOPhotoEA::createEADir($destPath, $eaDir);
			@file_put_contents($eaDir . '/' . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_PUBLIC, csSYNOPhotoMisc::IsOldEAFilePrefix()), $public);
			DoIndex($destPath);
		}
	}

	return $result;
}

function ProcessUpload($album, $title, $desc, $file)
{
	$result = false;
	if (UPLOAD_ERR_OK == $file['error']) {
		$filename = 'IMG' . date('_Ymd_His') . '.jpg';
		$destPath = SYNOPHOTO_SERVICE_DIR . '/' . $album . '/' . $filename;
        if (move_uploaded_file($file["tmp_name"], $destPath)) {
			SYNOPhotoEA::createEADir($destPath, $eaDir);
			if (!empty($title)) {
				$titlePath = sprintf("%s/%s", $eaDir, SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_TITLE, csSYNOPhotoMisc::IsOldEAFilePrefix()));
				file_put_contents($titlePath, $title);
			}
			if (!empty($desc)) {
				$descPath = sprintf("%s/%s", $eaDir, SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_DESC, csSYNOPhotoMisc::IsOldEAFilePrefix()));
				file_put_contents($descPath, $desc);
			}

			DoIndex($destPath);
		}
		$result = true;
	} else {
		switch ($file['error']) {
			case UPLOAD_ERR_INI_SIZE:
				$result = 'The uploaded file exceeds the upload_max_filesize directive in php.ini';
				break;
			case UPLOAD_ERR_FORM_SIZE:
				$result = 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form';
				break;
			case UPLOAD_ERR_PARTIAL:
				$result = 'The uploaded file was only partially uploaded';
				break;
			case UPLOAD_ERR_NO_FILE:
				$result = 'No file was uploaded';
				break;
			case UPLOAD_ERR_NO_TMP_DIR:
				$result = 'Missing a temporary folder';
				break;
			case UPLOAD_ERR_CANT_WRITE:
				$result = 'Failed to write file to disk';
				break;
			case UPLOAD_ERR_EXTENSION:
				$result = 'File upload stopped by extension';
				break;
			default:
				$result = 'Unknown upload error';
		}
	}
	return $result;
}

function DispatchAction($action)
{
	$result = array();
	switch ($action) {
		case 'albums':
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				$result = GetFirstLevelAlbums();
			}
			break;
		case 'album_check':
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				$path = SYNOPHOTO_SERVICE_DIR . '/' . $_REQUEST['album'];
				$result['success'] = is_dir($path);
			}
			break;
		case 'admin_check':
			$result['success'] = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
			break;
		case 'album_create':
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && isSet($_REQUEST['album']) && isSet($_REQUEST['album_public'])) {
				$result['success'] = CreateAlbum($_REQUEST['album'], $_REQUEST['album_public']);
			}
			break;
		case 'photo_upload';
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && isSet($_REQUEST['album']) && isSet($_FILES['file'])) {
				$title = isSet($_REQUEST['title']) ? $_REQUEST['title'] : '';
				$desc = isSet($_REQUEST['description']) ? $_REQUEST['description'] : '';
				$result['success'] = ProcessUpload($_REQUEST['album'], $title, $desc, $_FILES['file']);
			}
			break;
		default:
			break;
	}
	return $result;
}

$action = isSet($_REQUEST['action']) ? $_REQUEST['action'] : '';
echo json_encode(DispatchAction($action));
?>
