<?php
require_once(dirname(__FILE__).'/../syno_conf.php');

$currpath = getcwd();
chdir(SYNOBLOG_MODULES_DIR);
foreach (glob("*.php") as $fullfile) {
	require_once(SYNOBLOG_MODULES_DIR."/".$fullfile);
}
chdir($currpath);

function SYNOBLOG_MODULE_ArrageModules()
{
	$module_list = array();

	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])){
		$module_list[] = SYNOBLOG_MODULE_GetModule('module_admin');
	}
	$modules = csSYNOPhotoMisc::GetConfigDB('main', 'modules_inuse', 'blog_config');
	if (null === $modules) {
		$modules = csSYNOPhotoMisc::GetConfigDB('main', 'layout_left', 'blog_config');
		$modules .= ','.csSYNOPhotoMisc::GetConfigDB('main', 'layout_right', 'blog_config');
	}
	$modules = str_replace(',,', ',', $modules);
	$modules = str_replace('unuse,', '', $modules);
	if($modules != null && $modules != '') {
		$tok = strtok($modules, ",");
		while ($tok !== false) {
			$module_list[] = SYNOBLOG_MODULE_GetModule($tok);
			$tok = strtok(",");
		}
	}
	return $module_list;
}

function SYNOBLOG_MODULE_GetModule($name)
{
	$title = 'photo_str_'.$name.'_title';
	$module['title'] = __($title);//$$title;
	$module['name'] = $name;
	$fn = strtoupper($name)."_GetModuleContent";
	if ($fn()) {
		$module['content'] = $fn();
	}
	return $module;
}

function SYNOBLOG_MODULE_CheckModuleExistence()
{
	global $SYNOPHOTO_BLOG_MODULES;

	$query = "Select module_name from blog_module";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	while ($row = PHOTO_DB_FetchRow($db_result)) {
		$arr[] = $row[0];
	}

	for ($i = 0; $SYNOPHOTO_BLOG_MODULES[$i] != null; $i++) {
		if (!(in_array($SYNOPHOTO_BLOG_MODULES[$i]['name'], $arr))) {
			$query = "Insert into blog_module (module_name, provide_setting) Values ('";
			$query = $query.$SYNOPHOTO_BLOG_MODULES[$i]['name']."', '".$SYNOPHOTO_BLOG_MODULES[$i]['provide_setting']."')";
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}
	}
}


function SYNOBLOG_MODULE_CountVisit()
{
	$date = date('ymd');

	if(isset($_COOKIE['visit_day']) && $_COOKIE['visit_day'] == $date) {
		return;
	}
	setcookie("visit_day", $date, time()+(3600*24));

	if($date != csSYNOPhotoMisc::GetConfigDB('main', 'view_last')) {
		$count = 1;
	} else {
		$count = csSYNOPhotoMisc::GetConfigDB('main', 'view_today') + 1;
	}

	csSYNOPhotoMisc::UpdateConfigDBDontCheckAdmin('main', 'view_today', $count);

	// Update total view
	$count = csSYNOPhotoMisc::GetConfigDB('main', 'view_total') + 1;
	csSYNOPhotoMisc::UpdateConfigDBDontCheckAdmin('main', 'view_total', $count);

	// Update last view
	csSYNOPhotoMisc::UpdateConfigDBDontCheckAdmin('main', 'view_last', $date);
}

?>
