<?php
require_once 'include/SYNOPhotoEA.php';

ini_set("session.use_only_cookies", 0); // Allow sessionid followed by url.
set_time_limit(0); // Reset time limit for big files

session_cache_limiter("must-revalidate");

if (!session_id()) {
	session_start();
}

define('SYNOPHOTO_ADMIN_PASS', 'hlinak3');
define('SYNOBLOG_IMAGE_DIR', 'Blog Images');

if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)) {
	define("SYNOPHOTO_ADMIN_USER", substr(urldecode($matches[0]), 1));
	define('SYNOPHOTO_ADMIN_NAME', substr(urldecode($matches[0]), 2));
	define("SYNOPHOTO_SERVICE_DIR", "/var/services/homes/".SYNOPHOTO_ADMIN_NAME."/photo");
	define('SYNOPHOTO_URL_PREFIX', $matches[0]);
	define('SYNOPHOTO_ESACPE_STR', " ESCAPE '\'");
} else {
	define('SYNOPHOTO_SERVICE_DIR', '/var/services/photo');
	define('SYNOPHOTO_ADMIN_USER', 'root');
	define('SYNOPHOTO_ADMIN_NAME', 'root');
	define('SYNOPHOTO_URL_PREFIX', '');
	define('SYNOPHOTO_ESACPE_STR', '');
}

SYNOPHOTO_CONVERT_AccessRightCheck();

// unlock the session data as soon as session data is updated,
// so that other convert.php request of the same session id won't need to wait until the session data unlocked.
session_write_close();

$SYNOPHOTO_ALLOW_PICT_NAMES_EXT = array(
	"jpg",
	"jpeg",
	"jpe",
	"bmp",
	"gif",
	"png",
	"tiff",
	"tif",
	// Camera raw files
	"arw", "srf", "sr2", // Sony
	"dcr", "k25", "kdc", // Kodak
	"cr2","crw",// Canon
	"nef", // nikon
	"mrw", // Minolta
	"ptx", "pef",// Pentax
	"raf", // Fuji
	"3fr", // Hasselblad
	"erf", // (Epson)
	"mef", // (Mamiya)
	"mos", // (Leaf)
	"orf", // (Olympus),
	"rw2", // (Panasonic)
	"dng", // Adobe Digital Negative
	"x3f", // Sigma Raw Image
	"raw"  // Panasonic
);

$SYNOPHOTO_ALLOW_PICT_WITH_THUMB_EXT = array(
	"jpg",
	"jpeg",
	"jpe",
	"bmp",
	"tiff",
	"tif",
	// Camera raw files
	"arw", "srf", "sr2", // Sony
	"dcr", "k25", "kdc", // Kodak
	"cr2","crw",// Canon
	"nef", // nikon
	"mrw", // Minolta
	"ptx", "pef",// Pentax
	"raf", // Fuji
	"3fr", // Hasselblad
	"erf", // (Epson)
	"mef", // (Mamiya)
	"mos", // (Leaf)
	"orf", // (Olympus),
	"rw2", // (Panasonic)
	"dng", // Adobe Digital Negative
	"x3f", // Sigma Raw Image
	"raw"  // Panasonic

);

// The mimetype of raw image files is not listed here
$SYNOPHOTO_ALLOW_PICT_NAMES_MIME = array(
	'jpg' => 'image/jpeg',
	'jpeg' => 'image/jpeg',
	'jpe' => 'image/jpeg',
	'bmp' => 'image/bmp',
	'gif' => 'image/gif',
	'png' => 'image/png',
	'tiff' => 'image/tiff',
	'tif' => 'image/tiff'
);

$SYNOPHOTO_VIDEO_MIME = array(
	'3gp' => 'video/3gpp',
	'asf' => 'video/x-ms-asf',
	'avi' => 'video/x-msvideo',
	'm4v' => 'video/x-m4v',
	'mov' => 'video/quicktime',
	'mp4' => 'video/mp4',
	'mpe' => 'video/mpeg',
	'mpeg'=> 'video/mpeg',
	'mpg'=>	'video/mpeg',
	'qt' => 'video/quicktime',
	'wmv' => 'video/x-ms-wmv'
);

if (isset($_GET['currdir']) && isset($_GET['currname'])) {

	$dir = SYNOPHOTO_SERVICE_DIR."/".$_GET['currdir'];
	$name = $_GET['currname'];

	$is_photo_file = SYNOPHOTO_CONVERT_IsPhotoFile($name);

	if (isset($_GET['showorig'])) {
		if ($is_photo_file) {
			if (!SYNOPHOTO_CONVERT_CheckAllowOrig($dir, $name)) {
				exit;
			}
			$mime_type = SYNOPHOTO_CONVERT_GetPhotoMimeType($name);
			$file = $dir."/".$name;
		} else {
			$mime_type = "video/x-flv";
			$file = SYNOPHOTO_CONVERT_GetPathFromDirFile($dir, $name, SYNOPhotoEA::FILE_FILM_FLV);
			$name = $name.".flv";
		}
	} else if (isset($_GET['showthumb'])) {
		$file = SYNOPHOTO_CONVERT_GetPathFromDirFile($dir, $name, SYNOPhotoEA::FILE_THUMB_M);
		$mime_type = "image/jpeg";
	} else {
		$file = SYNOPHOTO_CONVERT_GetPathFromDirFile($dir, $name, SYNOPhotoEA::FILE_THUMB_XL);
		$mime_type = "image/jpeg";
	}
} elseif (isset($_GET['dir']) && isset($_GET['name'])) {

	$dir = SYNOPHOTO_SERVICE_DIR."/".@pack('H*', $_GET['dir']);
	$name = @pack('H*', $_GET['name']);

	$is_photo_file = SYNOPHOTO_CONVERT_IsPhotoFile($name);

	// 0:small; 1:big; 2:org; 3:flv; 4:320px thumb; 5:800px thumb; 6:mp4_H; 7:mp4_M; 8:mp4_L
	// 9:mobile mp4 film; 10: iphone film; 11:android 3gp/mp4 film
	$typeList = array(
		'0' => array('type' => SYNOPhotoEA::FILE_THUMB_S, 'mime' => 'image/jpeg'),
		'1' => array('type' => SYNOPhotoEA::FILE_THUMB_B, 'mime' => 'image/jpeg'),
		'3' => array('type' => SYNOPhotoEA::FILE_FILM_FLV, 'mime' => 'video/x-flv'),
		'4' => array('type' => SYNOPhotoEA::FILE_THUMB_M, 'mime' => 'image/jpeg'),
		'5' => array('type' => SYNOPhotoEA::FILE_THUMB_L, 'mime' => 'image/jpeg'),
		'6' => array('type' => SYNOPhotoEA::FILE_FILM_H_MP4, 'mime' => 'video/mp4'),
		'7' => array('type' => SYNOPhotoEA::FILE_FILM_M_MP4, 'mime' => 'video/mp4'),
		'8' => array('type' => SYNOPhotoEA::FILE_FILM_L_MP4, 'mime' => 'video/mp4'),
		'9' => array('type' => SYNOPhotoEA::FILE_FILM_MOBILE_MP4, 'mime' => 'video/mp4'),
		'10' => array('type' => SYNOPhotoEA::FILE_FILM_MOBILE_IPHONE, 'mime' => 'video/mp4'),
		'11' => array('type' => SYNOPhotoEA::FILE_FILM_MOBILE_ANDROID, 'mime' => 'video/mp4'),
		'12' => array('type' => SYNOPhotoEA::FILE_THUMB_XL, 'mime' => 'image/jpeg'),
		'13' => array('type' => SYNOPhotoEA::FILE_FILM_H264_MP4, 'mime' => 'video/mp4'),
		'14' => array('type' => SYNOPhotoEA::FILE_FILM_MPEG4_MP4, 'mime' => 'video/mp4'),
		'15' => array('type' => SYNOPhotoEA::FILE_FILM_CONVERT_MPEG4_MP4, 'mime' => 'video/mp4'),
	);

	$type = $_GET['type'];
	if ($type === '2') {
		if (!SYNOPHOTO_CONVERT_CheckAllowOrig($dir, $name)) {
			exit;
		}
		if ($is_photo_file) {
			$mime_type = SYNOPHOTO_CONVERT_GetPhotoMimeType($name);
		} else {
			$mime_type = SYNOPHOTO_CONVERT_GetVideoMimeType($name, 'application/octet-stream');
		}
		$file = $dir."/".$name;
	} else {
		if (!array_key_exists($type, $typeList)) {
			// not valid type
			exit;
		}
		$file = SYNOPHOTO_CONVERT_GetPathFromDirFile($dir, $name, $typeList[$type]['type']);
		$mime_type = $typeList[$type]['mime'];

		if ($type === '3') {
			$name .= '.flv';
		}
	}
}

$signature = SYNOPHOTO_CONVERT_CreateSig($file);
if (!$signature) {
	// if S not exists, use M
	// if B, L not exists, use XL
	// S:0, B:1, M:4, L:5, XL:12
	if ($type === '0') {
		$file = SYNOPHOTO_CONVERT_GetPathFromDirFile($dir, $name, $typeList['4']['type']);
	} else if ($type === '1' || $type === '5') {
		$file = SYNOPHOTO_CONVERT_GetPathFromDirFile($dir, $name, $typeList['12']['type']);
	}
	$signature = SYNOPHOTO_CONVERT_CreateSig($file);
}

if ($signature) {
	SYNOPHOTO_CONVERT_CheckSigExit($signature);
	@header("Last-Modified: " . $signature[0]);
}

$contentDisp = 'inline';
if (isSet($_GET['dl'])) {
	$mime_type = 'application/octet-stream';
	$contentDisp = 'attachment';
	@header("X-Download-Options: noopen ");
}

@header("Cache-Control: max-age=".(3600*24*7));
@header("Content-Type: ".$mime_type);

if ($is_photo_file) {
	$filename = $name;

	// Windows Phone WebHttpReponse cannot accept non-ascii character in response header
	// Replace non-ascii character with '_'
	if (preg_match("/Windows Phone OS/i", $_SERVER['HTTP_USER_AGENT'])) {
		$filename = preg_replace('/[^(\x20-\x7F)]*/', '_', $filename);
	}

	@header("Content-Disposition: $contentDisp; filename=\"".addslashes($filename).'"');
} else {
	if (isSet($_GET['dl'])) {
		@header("Content-Disposition: $contentDisp; filename=\"".addslashes($filename).'"');
	}
}

SYNOPHOTO_CONVERT_Rrange_Download($file);

function SYNOPHOTO_CONVERT_GetPhotoMimeType($path)
{
	global $SYNOPHOTO_ALLOW_PICT_NAMES_MIME;

	$path = strtolower($path);
	$path_parts = pathinfo($path);
	$extension = $path_parts['extension'];
	if (array_key_exists($extension, $SYNOPHOTO_ALLOW_PICT_NAMES_MIME)) {
		return $SYNOPHOTO_ALLOW_PICT_NAMES_MIME[$extension];
	}
	else {
		return "image/x-" . strtolower($extension);
	}

}

function SYNOPHOTO_CONVERT_IsPhotoFile($path)
{
	global $SYNOPHOTO_ALLOW_PICT_NAMES_EXT;

	$path = strtolower($path);
	$path_parts = pathinfo($path);
	$extension = $path_parts['extension'];
	if (in_array($extension, $SYNOPHOTO_ALLOW_PICT_NAMES_EXT)) {
		return true;
	} else {
		return false;
	}
}
function SYNOPHOTO_CONVERT_GetVideoMimeType($path, $default)
{
	global $SYNOPHOTO_VIDEO_MIME;

	$path = strtolower($path);
	$path_parts = pathinfo($path);
	$extension = $path_parts['extension'];
	if (array_key_exists($extension, $SYNOPHOTO_VIDEO_MIME)) {
		return $SYNOPHOTO_VIDEO_MIME[$extension];
	}
	return $default;
}


function SYNOPHOTO_CONVERT_IsPhotoFileWithThumb($path)
{
	global $SYNOPHOTO_ALLOW_PICT_WITH_THUMB_EXT;

	$path = strtolower($path);
	$path_parts = pathinfo($path);
	$extension = $path_parts['extension'];
	if (in_array($extension, $SYNOPHOTO_ALLOW_PICT_WITH_THUMB_EXT)) {
		return true;
	} else {
		return false;
	}
}

function SYNOPHOTO_CONVERT_GetPathFromDirFile($dir, $file, $typeString)
{
	$thumbFile = '';
	SYNOPhotoEA::checkFilePathByDirFile($dir, $file, $typeString, $thumbFile);
	return $thumbFile;
}

function SYNOPHOTO_CONVERT_CreateSig($thumbpath)
{
	$filest = @stat($thumbpath);
	$etag = "";
	if ($filest != FALSE) {
		$lastmod = gmdate('D, d M Y H:i:s', $filest[9]) . ' GMT';
		return array($lastmod);
	} else {
		return FALSE;
	}
}

function SYNOPHOTO_CONVERT_CheckSigExit($signature)
{
	$etag = $signature[0];
	$lastmod = $signature[1];

	if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
		$ims = preg_replace('/;.*$/', '', $_SERVER['HTTP_IF_MODIFIED_SINCE'] );
		if ($ims == $lastmod) {
			@header("HTTP/1.1 304 Not Modified");
			exit;
		}
	}
}

function SYNOPHOTO_CONVERT_AccessRightCheck()
{
	if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] == SYNOPHOTO_ADMIN_PASS) {
		return;
	}

	if (isset($_GET['currdir']) && isset($_GET['currname'])) {
		$_GET['dir'] = bin2hex($_GET['currdir']);
		$_GET['name'] = bin2hex($_GET['currname']);
	}

	if (!isset($_GET['dir']) || $_GET['dir'] == "" || !isset($_GET['name']) || $_GET['name'] == "") {
		header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/index.php");
		exit;
	}

	if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'])) {
		SYNOPHOTO_CONVERT_GetAccessibleAlbums();
	}
	SYNOPHOTO_CONVERT_AlbumAccessRightCheck(@pack('H*', $_GET['dir']));
}

function SYNOPHOTO_CONVERT_AlbumAccessRightCheck($albumName)
{
	if (!file_exists(SYNOPHOTO_SERVICE_DIR."/".$albumName)) {
		header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/index.php");
		exit;
	}

	if (SYNOBLOG_IMAGE_DIR == $albumName) {
		return true;
	}

	$albumToken = explode('/', $albumName);
	if (1 < count($albumToken)) {
		$albumName = $albumToken[0]."/".$albumToken[1];
	}
	if (1 == count($albumToken)) {
		if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName])) {
			SYNOPHOTO_CONVERT_RedirectToLoginPage($albumName);
			return false;
		}
		if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName]['password'] &&
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName]['password'] !=
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
			SYNOPHOTO_CONVERT_RedirectToLoginPage($albumName, 1);
			return false;
		}
		return true;
	}

	if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName])) {
		SYNOPHOTO_CONVERT_RedirectToLoginPage($albumName);
		return false;
	}
	if ('f' == $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['public'] &&
		'' == $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password']) {
		return true;
	}
	if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] &&
		$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] ==
		$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
		return true;
	}
	if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] &&
		$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] !=
		$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
		SYNOPHOTO_CONVERT_RedirectToLoginPage($albumName, 1);
		return false;
	}
	if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']["{$albumToken[0]}"]['password'] &&
		$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']["{$albumToken[0]}"]['password'] !=
		$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album']["{$albumToken[0]}"]) {
		SYNOPHOTO_CONVERT_RedirectToLoginPage($albumToken[0], 1);
		return false;
	}
	return true;
}

function SYNOPHOTO_CONVERT_RedirectToLoginPage($albumName, $isForPassword=false)
{
	SYNOPHOTO_CONVERT_CheckDBConnect();
	$query = "Select sharename from photo_share where sharename = '".SYNOPHOTO_CONVERT_EscapeParam($albumName)."'";
	$db_result = $GLOBALS['dbconn_photo']->query($query);

	echo "<script>";
	if ($row = $db_result->fetch()) {
		if ($isForPassword) {
			echo "parent.location = \"".SYNOPHOTO_URL_PREFIX."/photo/login.php?albumName=".bin2hex($albumName)."&password=true&".
			"&url=".bin2hex($_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING'])."\";";
		} else {
			echo "parent.location = \"".SYNOPHOTO_URL_PREFIX."/photo/login.php?url=".bin2hex($_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING'])."\";";
		}
	} else {
		echo "parent.location = \"".SYNOPHOTO_URL_PREFIX."/photo/index.php\";";
	}
	echo "</script>";
	exit;
}

function SYNOPHOTO_CONVERT_EscapeParam($param)
{
	$db_type = $GLOBALS['dbconn_photo']->getAttribute(constant("PDO::ATTR_DRIVER_NAME"));
	if ('sqlite' == $db_type) {
		return sqlite_escape_string($param);
	}
	return pg_escape_string($param);
}

function SYNOPHOTO_CONVERT_EscapeLikeParam($param)
{
	$param = str_replace('\\', '\\\\', $param);
	$param = str_replace('_', '\\_', $param);
	$param = str_replace('%', '\\%', $param);
	return $param;
}

function SYNOPHOTO_CONVERT_GetAccessibleAlbums()
{
	SYNOPHOTO_CONVERT_CheckDBConnect();

	$userID = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) ? $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] : '';
	$isAdmin = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

	$sqlParam = array();
	$sqlParamCount = 0;

	$use_dsm_account = '';
	$query = "Select config_value from photo_config where module_name = 'global' and config_key = 'account_system'";
	$db_result = $GLOBALS['dbconn_photo']->query($query);
	if ($row = $db_result->fetch()) {
		if ($row[0] == 1) {
			$use_dsm_account = '_for_dsm_account';
		}
	}

	/* prepare permission condition */
	$permConditionClause = '';
	if (!$isAdmin) {
		$permConditionClause = "password <> '' OR (public='t' ";
		if (!empty($userID)) {
			$permConditionClause .= ' OR shareid IN (SELECT shareid FROM photo_access_right'.$use_dsm_account.' WHERE userid=?)';
			$sqlParam[$sqlParamCount++] = $userID;
		}
		$permConditionClause .= ')';
	}

	/* query first level albums */
	$whereClause = "WHERE is_subdir='f'";
	if (strlen($permConditionClause)) {
		/* sql param already append to $sqlParam */
		$whereClause .= " AND ({$permConditionClause})";
	}
	$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
	$dbResult = $GLOBALS['dbconn_photo']->prepare($query);
	$dbResult->execute($sqlParam);
	$rootAlbums = $dbResult->fetchAll();
	if (false === $rootAlbums) {
		return;
	}

	/* query second level albums accroding to accessible first level albums */
	$secondLevelAlbums = array();
	$whereClause = "WHERE is_subdir='t' AND sharename NOT LIKE '%/%/%'";
	if (strlen($permConditionClause)) {
		/* sql param already append to $sqlParam */
		$whereClause .= " AND ({$permConditionClause})";
	}
	$whereClause .=  " AND sharename LIKE ? ".SYNOPHOTO_ESACPE_STR;
	$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
	$dbResult = $GLOBALS['dbconn_photo']->prepare($query);
	foreach ($rootAlbums as $item) {
		$item['sharename'] = SYNOPHOTO_CONVERT_EscapeLikeParam($item['sharename']);
		$sqlParam[$sqlParamCount] = "{$item['sharename']}/%";
		$dbResult->execute($sqlParam);
		$result = $dbResult->fetchAll();
		if (false !== $result) {
			$secondLevelAlbums = array_merge($secondLevelAlbums, $result);
		}
	}
	$result = array_merge($rootAlbums, $secondLevelAlbums);

	$query = "SELECT * FROM photo_share where password <> '' and is_subdir = 't' AND sharename NOT LIKE '%/%/%' ORDER BY sharename ASC";
	$dbResult = $GLOBALS['dbconn_photo']->prepare($query);
	$dbResult->execute();
	$passwordAlbums = $dbResult->fetchAll();
	foreach ($passwordAlbums as $item) {
		if (!in_array($item, $result)) {
			$result[] = $item;
		}
	}
	SYNOPHOTO_CONVERT_ArrageAlbumSessionData($result, $isAdmin);
}

function SYNOPHOTO_CONVERT_ArrageAlbumSessionData($albums, $isAdmin)
{
	foreach ($albums as $item) {
		$item['public'] = SYNOPHOTO_CONVERT_ConvertBool($item['public']);
		$item['is_subdir'] = SYNOPHOTO_CONVERT_ConvertBool($item['is_subdir']);
		if ('t' == $item['is_subdir']) {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$item['sharename']] = $item;
		} else {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$item['sharename']] = $item;
		}
		if ($isAdmin) {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$item['sharename']] = $item['password'];
		}
	}
}

function SYNOPHOTO_CONVERT_CheckAllowOrig($dir, $name)
{
	if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] == SYNOPHOTO_ADMIN_PASS) {
		return TRUE;
	}

	if (SYNOPHOTO_CONVERT_IsPhotoFile($name)) {
		if (!SYNOPHOTO_CONVERT_IsPhotoFileWithThumb($name)) {
			return TRUE;
		}
	} else {
		$file = SYNOPHOTO_CONVERT_GetPathFromDirFile($dir, $name, SYNOPhotoEA::FILE_FILM_FAIL);
		// User can download video when this video can not be converted to flv.
		if (@file_exists($file)) {
			return TRUE;
		}
		$is_video = TRUE;
	}

	$result = FALSE;

	$config_name = "allow_orig";
	if ($is_video) {
		$config_name = "allow_video_download";
	}

	//make sure use correct database
	SYNOPHOTO_CONVERT_CheckDBConnect();

	$query = "Select config_value from photo_config where module_name = 'photo' and config_key = '".$config_name."'";
	$db_result = $GLOBALS['dbconn_photo']->query($query);
	if ($row = $db_result->fetch()) {
		if ($row[0] == 'on') {
			$result = TRUE;
		}
	}
	return $result;
}

function SYNOPHOTO_CONVERT_ConvertBool($var)
{
	return ($var === true || $var == 't') ? 't' : 'f';
}

function SYNOPHOTO_CONVERT_CheckDBConnect()
{
	$username = 'admin';
	$dbname_photo = 'photo';

	//personal photo station
	if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
		$current_admin = substr(urldecode($matches[0]), 2);
		if (!isset($GLOBALS['admin_username']) || $GLOBALS['admin_username'] != $current_admin) {
			$user_photo_db = "/var/services/homes/{$current_admin}/photo/.SYNOPPSDB";
			try{
				if (!file_exists($user_photo_db)) {
					header("Location: /photo/report.php?nosrv=true&msgkey=photo_str_service_disabled");
					exit;
				}
				$GLOBALS['dbconn_photo'] = new PDO("sqlite:{$user_photo_db}");
				$GLOBALS['dbconn_photo']->exec('PRAGMA case_sensitive_like=1');
				$GLOBALS['admin_username'] = $current_admin;
			} catch (PDOException $e) {
				die($e->getMessage());
			}
		}
	} else{
		if (!isset($GLOBALS['dbconn_photo']) || $GLOBALS['dbconn_photo'] == null ||
			$GLOBALS['dbconn_photo']->getAttribute(constant("PDO::ATTR_DRIVER_NAME")) != 'pgsql') {
			$GLOBALS['admin_username'] = 'root';
			try{
				$GLOBALS['dbconn_photo'] = new PDO("pgsql:dbname=$dbname_photo;host=localhost", $username, "" );
			} catch (PDOException $e) {
				die($e->getMessage());
			}
		}
	}
}

function SYNOPHOTO_CONVERT_Rrange_Download($file)
{
	$fp = @fopen($file, 'rb');
	if (FALSE == $fp) {
		return FALSE;
	}

	$size   = filesize($file); // File size
	$length = $size;		   // Content length
	$start  = 0;			   // Start byte
	$end	= $size - 1;	   // End byte
	// Now that we've gotten so far without errors we send the accept range header
	/* At the moment we only support single ranges.
	 * Multiple ranges requires some more work to ensure it works correctly
	 * and comply with the spesifications: http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.2
	 *
	 * Multirange support annouces itself with:
	 * header('Accept-Ranges: bytes');
	 *
	 * Multirange content must be sent with multipart/byteranges mediatype,
	 * (mediatype = mimetype)
	 * as well as a boundry header to indicate the various chunks of data.
	 */
	//header("Accept-Ranges: 0-$length");
	header('Accept-Ranges: bytes');
	// multipart/byteranges
	// http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.2
	if (isset($_SERVER['HTTP_RANGE'])) {
		$c_start = $start;
		$c_end   = $end;
		// Extract the range string
		list(, $range) = explode('=', $_SERVER['HTTP_RANGE'], 2);
		// Make sure the client hasn't sent us a multibyte range
		if (strpos($range, ',') !== false) {

			// (?) Shoud this be issued here, or should the first
			// range be used? Or should the header be ignored and
			// we output the whole content?
			header('HTTP/1.1 416 Requested Range Not Satisfiable');
			header("Content-Range: bytes $start-$end/$size");
			// (?) Echo some info to the client?
			exit;
		}
		// If the range starts with an '-' we start from the beginning
		// If not, we forward the file pointer
		// And make sure to get the end byte if spesified
		if ($range{0} == '-') {

			// The n-number of the last bytes is requested
			$c_start = $size - substr($range, 1);
		}
		else {

			$range  = explode('-', $range);
			$c_start = $range[0];
			$c_end   = (isset($range[1]) && is_numeric($range[1])) ? $range[1] : $size;
		}
		/* Check the range and make sure it's treated according to the specs.
		 * http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html
		 */
		// End bytes can not be larger than $end.
		$c_end = ($c_end > $end) ? $end : $c_end;
		// Validate the requested range and return an error if it's not correct.
		if ($c_start > $c_end || $c_start > $size - 1 || $c_end >= $size) {

			header('HTTP/1.1 416 Requested Range Not Satisfiable');
			header("Content-Range: bytes $start-$end/$size");
			// (?) Echo some info to the client?
			exit;
		}
		$start  = $c_start;
		$end	= $c_end;
		$length = $end - $start + 1; // Calculate new content length
		fseek($fp, $start);
		header('HTTP/1.1 206 Partial Content');
	}
	// Notify the client the byte range we'll be outputting
	header("Content-Range: bytes $start-$end/$size");
	header("Content-Length: $length");

	// Start buffered download
	$buffer = 1024 * 8;
	while(!feof($fp) && ($p = ftell($fp)) <= $end) {

		if ($p + $buffer > $end) {

			// In case we're only outputtin a chunk, make sure we don't
			// read past the length
			$buffer = $end - $p + 1;
		}

		echo fread($fp, $buffer);
		flush(); // Free up memory. Otherwise large files will trigger PHP's memory limit.
	}
	fclose($fp);
}
?>
