#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

if [ -z "$SYNOPKG_PKGNAME" ]; then
    PACKAGE_NAME="PhotoStation"
else
    PACKAGE_NAME=$SYNOPKG_PKGNAME
fi

PHOTO_PACKAGE_FOLDER="/var/packages/${PACKAGE_NAME}"

PSQL="/usr/syno/pgsql/bin/psql"
DATABASE="photo"
SQL="${PHOTO_PACKAGE_FOLDER}/target/photo_scripts/sql/upgrade/015_change_datatype_userid.pgsql"
checkUIDSQL="SELECT udt_name FROM information_schema.columns WHERE table_name = 'photo_access_right_for_dsm_account' AND column_name = 'userid';"

ExecSqlCommand()
{
    $PSQL -U admin $DATABASE -c "$1" > /dev/null 2>&1
}

echo "whether the datatype of userid in personal library tables is int4 or not"
$PSQL -U admin $DATABASE -c "$checkUIDSQL" | grep "int8" > /dev/null 2>&1
if [ $? = 0 ]; then
    echo "Already changed to int8, return"
    return 0
fi

echo "Change datatype of userid in personal library tables"
$PSQL -U admin $DATABASE < $SQL
if [ $? != 0 ]; then
    echo "Failed to change datatype of userid in personal library tables"
    exit
fi

exit 0;
