#!/bin/sh
# Copyright (c) 2000-2008 Synology Inc. All rights reserved.

PGSQL="/usr/syno/pgsql/bin/psql -U admin"

SQL_TEST_TYPE="select data_type FROM information_schema.columns where table_name = 'photo_image' and column_name = 'timetaken'"
SQL_MODIFY_TIME="update photo_image set timetaken = regexp_replace(timetaken, E'(\\\d\\\d\\\d\\\d):(\\\d\\\d):(\\\d\\\d) (\\\d\\\d):(\\\d\\\d):(\\\d\\\d)', E'\\\1-\\\2-\\\3 \\\4:\\\5:\\\6')"
SQL_RESET_WRONG_TIME="update photo_image set timetaken = '1970-01-01 00:00:00' where timetaken !~ E'(\\\d\\\d\\\d\\\d)-(\\\d\\\d)-(\\\d\\\d) (\\\d\\\d):(\\\d\\\d):(\\\d\\\d)'"
SQL_ALTER_TYPE="ALTER TABLE photo_image ALTER COLUMN timetaken TYPE timestamp USING CAST (timetaken AS timestamp);"

echo "To test if timetaken type is timestamp"
$PGSQL photo -c "$SQL_TEST_TYPE" | grep timestamp > /dev/null 2>&1
Ret=$?

if [ $Ret = 1 ]; then
	#Modify the timetaken to the right format and then change data_type from varchar to timestamp
	$PGSQL photo -c "$SQL_MODIFY_TIME"
	$PGSQL photo -c "$SQL_RESET_WRONG_TIME"
	$PGSQL photo -c "$SQL_ALTER_TYPE"
	if [ $? != 0 ]; then
		echo "Failed to change timetaken type in table photo_image at photo database"
		exit
	fi
	/usr/syno/bin/synoindex -R photo
fi
