BEGIN;

CREATE TABLE photo_label (
  id INTEGER PRIMARY KEY,
  name text,
  category int4 NOT NULL,
  info text DEFAULT ''
);

CREATE TABLE photo_image_label (
  id INTEGER PRIMARY KEY,
  image_id int4 NOT NULL,
  label_id int4 NOT NULL,
  info text DEFAULT '',
  status text default 't',
  CONSTRAINT photo_image_label_photo_id_fkey1 FOREIGN KEY (image_id) REFERENCES photo_image (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
  CONSTRAINT photo_image_label_label_id_fkey1 FOREIGN KEY (label_id) REFERENCES photo_label (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE
);

CREATE TABLE photo_video_label (
  id INTEGER PRIMARY KEY,
  video_path text NOT NULL,
  label_id int4 NOT NULL,
  info text DEFAULT '',
  status text DEFAULT 't',
  updated char(1),
  CONSTRAINT photo_image_label_label_id_fkey1 FOREIGN KEY (label_id) REFERENCES photo_label (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE
);


COMMIT;
