<?php

define('SYNO_PHOTO_DSM_USER_PROG', '/usr/syno/bin/synophoto_dsm_user');
define('SYNO_PHOTO_LEGACY_KEY_PARAM', 'legacy_key');
define('SYNO_PHOTO_MERGED_KEY', 'migrate_recently_add_comment');

/* get old merged key in config file */
$options = getopt("", array(SYNO_PHOTO_LEGACY_KEY_PARAM.':'));
$oldMergedKey = ('yes' === $options[SYNO_PHOTO_LEGACY_KEY_PARAM]);

/* list dsm users */
$dsmUserList = getDSMUserList();
$usernameList = array_merge(array(''), $dsmUserList);

foreach ($usernameList as $username) {
    $user = $username;
    $dbh = getDatabaseHandler();
    $escapeStr = getEscapeString();

    //no database, skip
    if (!$dbh) {
        continue;
    }

	if ($oldMergedKey) {
		setMergedKeyToDB();
		continue;
	}

	$newMergedKey = getMergedKeyFromDB();
	if ($newMergedKey) {
		continue;
	}

    $result = getRecentlyConfig();
	migrateToSmartAlbum($result);

	setMergedKeyToDB();
}

function readSmartAlbumFile()
{
    global $user;
    if (strlen($user)){
        $smartAlbumFile = "/var/services/homes/{$user}/photo/@eaDir/smart_album.json";
    } else {
        $smartAlbumFile = "/var/services/photo/@eaDir/smart_album.json";
    }

    //test whether smart album file config exist or not
    if (!@file_exists($smartAlbumFile)) {
        return null;
    }

    //get contents from smart album config file
    if (!$smartAlbumJsonStr = @file_get_contents($smartAlbumFile)) {
        return null;
    }

    //parse contents
    if (!$smartAlbumList = json_decode($smartAlbumJsonStr, true)) {
        return null;
    }   

    return $smartAlbumList; 
}

function writeSmartAlbumFile($smartAlbumList)
{
    global $user;
    if (strlen($user)){
        $smartAlbumFile = "/var/services/homes/{$user}/photo/@eaDir/smart_album.json";
    } else {
        $smartAlbumFile = "/var/services/photo/@eaDir/smart_album.json";
    }

    //encode smart album list to json string
    if (!$smartAlbumListJsonStr = json_encode($smartAlbumList)) {
        return false;
	}

    //beautify json string
    $smartAlbumListJsonStr = indentJson($smartAlbumListJsonStr);

    //create @eaDir
    if(!@file_exists($eaDir)) {
        @mkdir($eaDir);
    }

    //put contents to smart album config file
    if (!@file_put_contents($smartAlbumFile, $smartAlbumListJsonStr)) {
        return false;
    }

    chmod($smartAlbumFile, 0666);

    return true;
}

function getString($string)
{
    // get DSM language
    $lang = getDSMLang();
    if (empty($lang)) {
        return $string;
    }
    if ('def' === $lang) {
        $lang = 'enu';
    }
    $langFile = "/var/packages/PhotoStation/target/photo/language/{$lang}.php";
    include($langFile);
    $pattern = preg_replace('/[^0-9a-z]/i','_', $string);
    if (!isset($$pattern)) {
        return $string;
    }
    return $$pattern;
}

function getName($smartAlbumList, $string)
{
	$targetName = getString($string);
	$newName = $targetName;
	$suffix = 0;

	while (isset($smartAlbumList['smart_albums'][$newName])) {
		$newName = $targetName.'_'.(++$suffix);
	}

	return $newName;
}

function migrateToSmartAlbum($data)
{
    if ('on' !== $data['recent_photo'] && 'on' !== $data['recent_video'] && 'on' !== $data['recent_commented_photo'] && 'on' !== $data['recent_commented_video']) {
        return;
    }

    $smartAlbumList = readSmartAlbumFile();
    if ('on' === $data['recent_photo']) {
        unset($smart);
        $smart['desc'] = '';
        $smart['show_photo'] = true;
        $smart['show_video'] = false;
        $rule_set['field'] = 'date';
        $rule_set['operator'] = 'recently_add';
        $rule_set['value'] = $data['recent_photo_num'];
        $smart['rule_sets'][0] = array();
        array_push($smart['rule_sets'][0], $rule_set);
        $smartAlbumList['smart_albums'][getName($smartAlbumList, 'photo_str_recent_photo')] = $smart;
    }
    if ('on' === $data['recent_video']) {
        unset($smart);
        $smart['desc'] = '';
        $smart['show_photo'] = false;
        $smart['show_video'] = true;
        $rule_set['field'] = 'date';
        $rule_set['operator'] = 'recently_add';
        $rule_set['value'] = $data['recent_video_num'];
        $smart['rule_sets'][0] = array();
        array_push($smart['rule_sets'][0], $rule_set);
        $smartAlbumList['smart_albums'][getName($smartAlbumList, 'photo_str_recent_video')] = $smart;
    }
    if ('on' === $data['recent_commented_photo']) {
        unset($smart);
        $smart['desc'] = '';
        $smart['show_photo'] = true;
        $smart['show_video'] = false;
        $rule_set['field'] = 'date';
        $rule_set['operator'] = 'recently_comment';
        $rule_set['value'] = $data['recent_commented_photo_num'];
        $smart['rule_sets'][0] = array();
        array_push($smart['rule_sets'][0], $rule_set);
        $smartAlbumList['smart_albums'][getName($smartAlbumList, 'photo_str_recent_commented_photo')] = $smart;
    }
    if ('on' === $data['recent_commented_video']) {
        unset($smart);
        $smart['desc'] = '';
        $smart['show_photo'] = false;
        $smart['show_video'] = true;
        $rule_set['field'] = 'date';
        $rule_set['operator'] = 'recently_comment';
        $rule_set['value'] = $data['recent_commented_video_num'];
        $smart['rule_sets'][0] = array();
        array_push($smart['rule_sets'][0], $rule_set);
        $smartAlbumList['smart_albums'][getName($smartAlbumList, 'photo_str_recent_commented_video')] = $smart;
    }
    writeSmartAlbumFile($smartAlbumList);
}

function getRecentlyConfig()
{
    global $dbh, $escapeStr;
    $sqlParam = array();

    $sql = "select config_key, config_value from photo_config where module_name=?";
    $sqlParam[] = 'photo';
    $dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);

    $photoConfig = $dbResult->fetchAll(PDO::FETCH_ASSOC);
    foreach ($photoConfig as $row) {
        if ('recent_photo' === $row['config_key']) {
            $result['recent_photo'] = $row['config_value'];
        }
        if ('recent_video' === $row['config_key']) {
            $result['recent_video'] = $row['config_value'];
        }
        if ('recent_photo_num' === $row['config_key']) {
            $result['recent_photo_num'] = $row['config_value'];
        }
        if ('recent_video_num' === $row['config_key']) {
            $result['recent_video_num'] = $row['config_value'];
        }
        if ('recent_commented_photo' === $row['config_key']) {
            $result['recent_commented_photo'] = $row['config_value'];
        }
        if ('recent_commented_video' === $row['config_key']) {
            $result['recent_commented_video'] = $row['config_value'];
        }
        if ('recent_commented_photo_num' === $row['config_key']) {
            $result['recent_commented_photo_num'] = $row['config_value'];
        }
        if ('recent_commented_video_num' === $row['config_key']) {
            $result['recent_commented_video_num'] = $row['config_value'];
        }
    }
    return $result;
}

function indentJson($json)
{
    if (!json_decode($json)) {
        return $json;
	}

    $result = '';
    $pos = 0;
    $strLen = strlen($json);
    $indentStr = "\t";
    $newLine = "\n";
    $prevChar = '';
    $outOfQuotes = true;

    for($i = 0; $i <= $strLen; $i++) {
        // Grab the next character in the string
        $char = substr($json, $i, 1);

        // Are we inside a quoted string?
        if($char == '"' && $prevChar != '\\') {
            $outOfQuotes = !$outOfQuotes;
        }
        // If this character is the end of an element,
        // output a new line and indent the next line
        else if(($char == '}' || $char == ']') && $outOfQuotes) {
            $result .= $newLine;
            $pos --;
            for ($j=0; $j<$pos; $j++) {
                $result .= $indentStr;
            }
        }
        // Add the character to the result string
        $result .= $char;

        // If the last character was the beginning of an element,
        // output a new line and indent the next line
        if (($char == ',' || $char == '{' || $char == '[') && $outOfQuotes) {
            $result .= $newLine;
            if ($char == '{' || $char == '[') {
                $pos ++;
            }
            for ($j = 0; $j < $pos; $j++) {
                $result .= $indentStr;
            }
        }
        $prevChar = $char;
    }

    return $result;
}

function getDSMLang()
{
    @exec("/usr/syno/bin/synogetkeyvalue /etc/synoinfo.conf language", $dsmLang);
    return $dsmLang[0];
}

function getDSMUserList()
{
	@exec(SYNO_PHOTO_DSM_USER_PROG." --enum", $dsmUserCount);
	@exec(SYNO_PHOTO_DSM_USER_PROG." --enum 0 ".intval($dsmUserCount[0]), $dsmUserList);
	$list = array();
	foreach($dsmUserList as &$dsmUser) {
		$dsmUser = explode(',', $dsmUser);
		if (count($dsmUser) != 6) {
			continue;
		}
		$list[] = $dsmUser[1];
	}
	return $list;
}


function getDatabaseHandler()
{
	global $user;

	$dbh = null;

	if (strlen($user)){
		$user_photo_db = "/var/services/homes/$user/photo/.SYNOPPSDB";

		if(!file_exists($user_photo_db)){
			return $dbh;
		}

		try {
			$dbh = new PDO("sqlite:{$user_photo_db}");
			$dbh->exec('PRAGMA case_sensitive_like=1');
			$dbh->exec('PRAGMA foreign_keys=ON');
		} catch (PDOException $e) {
			die($e->getMessage());
		}
	} else {
		try {
			$dbh = new PDO('pgsql:dbname=photo', 'admin', '', array(PDO::ATTR_PERSISTENT => false, PDO::ATTR_EMULATE_PREPARES => true));
		} catch (PDOException $e) {
			die($e->getMessage());
		}
	}

	return $dbh;
}

function getEscapeString()
{
	global $user;

	return strlen($user) ? "ESCAPE '\'" : "";
}

function setMergedKeyToDB()
{
	global $dbh, $escapeStr;

	$sqlCond = "SELECT * FROM photo_config WHERE module_name = 'photo' AND config_key = '".SYNO_PHOTO_MERGED_KEY."'";
	$sqlParam = array();

	$dbResult = $dbh->prepare($sqlCond);
	$dbResult->execute($sqlParam);

	if (false !== ($row = $dbResult->fetch())) {
		$id = $row['config_id'];
		$sqlCond = "UPDATE photo_config SET config_value = 'on' WHERE config_id = ".$row['config_id'];
	} else {
		$sqlCond = "INSERT INTO photo_config (module_name, config_key, config_value) VALUES ('photo', '".SYNO_PHOTO_MERGED_KEY."', 'on')";
	}

	$dbResult = $dbh->prepare($sqlCond);
	$dbResult->execute($sqlParam);
}

function getMergedKeyFromDB()
{
	global $dbh, $escapeStr;

	$sqlCond = "SELECT * FROM photo_config WHERE module_name = 'photo' AND config_key = '".SYNO_PHOTO_MERGED_KEY."'";
	$sqlParam = array();

	$dbResult = $dbh->prepare($sqlCond);
	$dbResult->execute($sqlParam);

	$ret = false;
	if (false !== ($row = $dbResult->fetch())) {
		if ('on' === $row['config_value']) {
			$ret = true;
		}
	}

	return $ret;
}

?>
