<?PHP

require_once('permission.inc.php');

class PermissionAPI extends WebAPI
{
	function __construct()
	{
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		/* if not admin, returns directly */
		csSYNOPhotoMisc::CheckSessionTimeOut();

		if (!strcasecmp($this->method, "getalbum")) {
			$this->GetAlbum();
		}
		if (!strcasecmp($this->method, "editalbum")) {
			$this->EditAlbum();
		}
		if (!strcasecmp($this->method, "editgroup")) {
			$this->EditGroup();
		}
	}

	private function GetAlbum()
	{
		$ret = false;
		$resp = array();

		if (!isset($_REQUEST['type'])) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}
		/* set params */
		if (!isset($_REQUEST['id']) || '' === $_REQUEST['id'] || 'album_' === $_REQUEST['id']) {
			$albumName = '';
		} else {
			$id_arr = explode('_', $_REQUEST['id']);
			if ('album' == $id_arr[0] && 2 === count($id_arr)) {
				$albumName = @pack('H*', $id_arr[1]);
			} else {
				$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
				goto End;
			}
		}

		$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName);
		if (!file_exists($path)) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		$start = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 15;
		$search = isset($_REQUEST['query']) ? $_REQUEST['query'] : '';

		$needUsr = strstr($_REQUEST['type'], 'user_permission') ? true : false;
		$needGrp = strstr($_REQUEST['type'], 'group_permission') ? true : false;
		if (!$needUsr && !$needGrp) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		if ($needUsr) {
			$resp['user_permission'] = array();
			if (false === ($data = $this->GetAlbumUserData($albumName, $start, $limit, $search))) {
				$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
				goto End;
			}
			$users = $data['all'];
			foreach ($users as $row) {
				$user = null;
				$user['id'] = $row['userid'];
				$user['name'] = $row['username'];
				$user['description'] = $row['description'];
				$user['disabled'] = $row['disabled'];

				$pObj = null;
				$pObj['browse'] = $row['browse'];
				$pObj['upload'] = $row['upload'];
				$pObj['manage'] = $row['manage'];

				$user['permission'] = $pObj;
				$resp['user_permission'][] = $user;
			}
			$resp['total_user_count'] = $data['totalCount'];
		}

		if ($needGrp) {
			$resp['group_permission'] = array();
			if (false === ($data = $this->GetAlbumGroupData($albumName, $start, $limit, $search))) {
				$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
				goto End;
			}
			$groups = $data['all'];
			foreach ($groups as $row) {
				$group = null;
				$group['id'] = $row['groupid'];
				$group['name'] = $row['groupname'];
				$group['description'] = $row['description'];
				$group['disabled'] = $row['disabled'];

				$pObj = null;
				$pObj['browse'] = $row['browse'];
				$pObj['upload'] = $row['upload'];
				$pObj['manage'] = $row['manage'];

				$group['permission'] = $pObj;
				$resp['group_permission'][] = $group;
			}
			$resp['total_group_count'] = $data['totalCount'];
		}

		$this->SetResponse($resp);

		$ret = true;
	End:
		return $ret;
	}

	private function EditAlbum()
	{
		$ret = false;

		/* set params */
		if (!isset($_REQUEST['id']) || '' === $_REQUEST['id'] || 'album_' === $_REQUEST['id']) {
			$albumName = '/';
		} else {
			$id_arr = explode('_', $_REQUEST['id']);
			if ('album' == $id_arr[0] && 2 === count($id_arr)) {
				$albumName = @pack('H*', $id_arr[1]);
			} else {
				$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
				goto End;
			}
		}

		/* set user modified list */
		$userBrowseDelete = isset($_REQUEST['user_browse_delete']) ? $_REQUEST['user_browse_delete'] : '';
		$userUploadDelete = isset($_REQUEST['user_upload_delete']) ? $_REQUEST['user_upload_delete'] : '';
		$userManageDelete = isset($_REQUEST['user_manage_delete']) ? $_REQUEST['user_manage_delete'] : '';
		$userBrowseAdd = isset($_REQUEST['user_browse_add']) ? $_REQUEST['user_browse_add'] : '';
		$userUploadAdd = isset($_REQUEST['user_upload_add']) ? $_REQUEST['user_upload_add'] : '';
		$userManageAdd = isset($_REQUEST['user_manage_add']) ? $_REQUEST['user_manage_add'] : '';
		/* set group modified list */
		$groupBrowseDelete = isset($_REQUEST['group_browse_delete']) ? $_REQUEST['group_browse_delete'] : '';
		$groupUploadDelete = isset($_REQUEST['group_upload_delete']) ? $_REQUEST['group_upload_delete'] : '';
		$groupManageDelete = isset($_REQUEST['group_manage_delete']) ? $_REQUEST['group_manage_delete'] : '';
		$groupBrowseAdd = isset($_REQUEST['group_browse_add']) ? $_REQUEST['group_browse_add'] : '';
		$groupUploadAdd = isset($_REQUEST['group_upload_add']) ? $_REQUEST['group_upload_add'] : '';
		$groupManageAdd = isset($_REQUEST['group_manage_add']) ? $_REQUEST['group_manage_add'] : '';

		/* get the album info first */
		$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName);
		if (!file_exists($path)) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}
		$query = "SELECT shareid, sharename, public, password FROM photo_share WHERE sharename = '" . PHOTO_DB_EscapeParam($albumName) . "'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		/* get album type, 0 for public, 1 for private, 2 for password */
		if ($row['public']) {
			$type = 0;
		} elseif ('' === $row['password']) {
			$type = 1;
		} else {
			$type = 2;
		}
		$shareid = $row['shareid'];
		$sharename = $row['sharename'];

		switch ($type) {
			case 0:
				/* update for user permission */
				/* add/delete self upload right */
				SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $userUploadAdd, PHOTO_UPLOAD_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $userUploadDelete, PHOTO_UPLOAD_RIGHT_TABLE);
				/* add/delete self manage right */
				SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $userManageAdd, PHOTO_MANAGE_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $userManageDelete, PHOTO_MANAGE_RIGHT_TABLE);
				/* add child browse, upload, manage rights for manager */
				SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $userManageAdd, PHOTO_MANAGE_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $userManageAdd, PHOTO_UPLOAD_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $userManageAdd, PHOTO_ACCESS_RIGHT_TABLE);
				/* delete parent's manage right */
				SYNOPHOTO_ADMIN_DeleteParentRightBySharename($sharename, $userManageDelete, PHOTO_MANAGE_RIGHT_TABLE);

				/* update for group permission */
				$this->AddGroupPermission($shareid, $groupBrowseAdd, 1);
				$this->AddGroupPermission($shareid, $groupUploadAdd, 2);
				$this->AddGroupPermission($shareid, $groupManageAdd, 4);
				$this->DeleteGroupPermission($shareid, $groupBrowseDelete, 1);
				$this->DeleteGroupPermission($shareid, $groupUploadDelete, 2);
				$this->DeleteGroupPermission($shareid, $groupManageDelete, 4);

				$this->AddChildGroupRightBySharename($sharename, $groupManageAdd, 1);
				$this->AddChildGroupRightBySharename($sharename, $groupManageAdd, 2);
				$this->AddChildGroupRightBySharename($sharename, $groupManageAdd, 4);
				$this->DeleteParentGroupRightBySharename($sharename, $groupManageDelete, 4);

				break;
			case 1:
				/* add/delete self browse right */
				SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $userBrowseAdd, PHOTO_ACCESS_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $userBrowseDelete, PHOTO_ACCESS_RIGHT_TABLE);
				/* add/delete self upload right */
				SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $userUploadAdd, PHOTO_UPLOAD_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $userUploadDelete, PHOTO_UPLOAD_RIGHT_TABLE);
				/* add/delete self manage right */
				SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $userManageAdd, PHOTO_MANAGE_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $userManageDelete, PHOTO_MANAGE_RIGHT_TABLE);
				/* add child browse, upload, manage rights for manager */
				SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $userManageAdd, PHOTO_MANAGE_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $userManageAdd, PHOTO_UPLOAD_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $userManageAdd, PHOTO_ACCESS_RIGHT_TABLE);
				/* delete parent's manage right */
				SYNOPHOTO_ADMIN_DeleteParentRightBySharename($sharename, $userManageDelete, PHOTO_MANAGE_RIGHT_TABLE);
				/* delete child's browse right */
				SYNOPHOTO_ADMIN_DeleteChildRightBySharename($sharename, $userBrowseDelete, PHOTO_ACCESS_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_DeleteChildRightBySharename($sharename, $userBrowseDelete, PHOTO_UPLOAD_RIGHT_TABLE);
				SYNOPHOTO_ADMIN_DeleteChildRightBySharename($sharename, $userBrowseDelete, PHOTO_MANAGE_RIGHT_TABLE);

				/* update for group permission */
				$this->AddGroupPermission($shareid, $groupBrowseAdd, 1);
				$this->AddGroupPermission($shareid, $groupUploadAdd, 2);
				$this->AddGroupPermission($shareid, $groupManageAdd, 4);
				$this->DeleteGroupPermission($shareid, $groupBrowseDelete, 1);
				$this->DeleteGroupPermission($shareid, $groupUploadDelete, 2);
				$this->DeleteGroupPermission($shareid, $groupManageDelete, 4);

				$this->AddChildGroupRightBySharename($sharename, $groupManageAdd, 1);
				$this->AddChildGroupRightBySharename($sharename, $groupManageAdd, 2);
				$this->AddChildGroupRightBySharename($sharename, $groupManageAdd, 4);
				$this->DeleteParentGroupRightBySharename($sharename, $groupManageDelete, 4);
				$this->DeleteChildGroupRightBySharename($sharename, $groupBrowseDelete, 1);
				$this->DeleteChildGroupRightBySharename($sharename, $groupBrowseDelete, 2);
				$this->DeleteChildGroupRightBySharename($sharename, $groupBrowseDelete, 4);

				break;
			case 2:
				/* remove all permissions if album is password */
				$query = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = ".$shareid;
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
				$query = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid = ".$shareid;
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
				$query = "Delete from " . PHOTO_MANAGE_RIGHT_TABLE . " where shareid = ".$shareid;
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

				/* update for group permission */
				$query = "DELETE FROM " . PHOTO_GROUP_PERMISSION_TABLE . "WHERE shareid = " . $shareid;
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

				break;
		}

		$ret = true;
	End:
		return $ret;
	}

	private function EditGroup()
	{
		$ret = false;

		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}
		$gid = $_REQUEST['id'];

		/* set album modified list */
		$albumBrowseDelete = isset($_REQUEST['album_browse_delete']) ? $_REQUEST['album_browse_delete'] : '';
		$albumUploadDelete = isset($_REQUEST['album_upload_delete']) ? $_REQUEST['album_upload_delete'] : '';
		$albumManageDelete = isset($_REQUEST['album_manage_delete']) ? $_REQUEST['album_manage_delete'] : '';
		$albumBrowseAdd = isset($_REQUEST['album_browse_add']) ? $_REQUEST['album_browse_add'] : '';
		$albumUploadAdd = isset($_REQUEST['album_upload_add']) ? $_REQUEST['album_upload_add'] : '';
		$albumManageAdd = isset($_REQUEST['album_manage_add']) ? $_REQUEST['album_manage_add'] : '';

		$this->AddAlbumPermission($gid, $albumBrowseAdd, 1);
		$this->AddAlbumPermission($gid, $albumUploadAdd, 2);
		$this->AddAlbumPermission($gid, $albumManageAdd, 4);
		$this->DeleteAlbumPermission($gid, $albumManageDelete, 4);
		$this->DeleteAlbumPermission($gid, $albumUploadDelete, 2);
		$this->DeleteAlbumPermission($gid, $albumBrowseDelete, 1);

		$ret = true;
	End:
		return $ret;
	}

	private function GetAlbumUserData($sharename, $start = 0, $limit = 15, $search = '')
	{
		/* edit sharename for root album */
		if ('' === $sharename) {
			$sharename = '/';
		}
		$query = "SELECT * FROM photo_share WHERE sharename = '" . PHOTO_DB_EscapeParam($sharename) . "'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if ($row = PHOTO_DB_FetchRow($db_result)) {
			$shareid = $row['shareid'];
			$isPublic = ('t' == $row['public']);
		} else {
			return false;
		}

		$parentid = null;
		/* find the nearest private parent */
		if (false !== strstr($sharename, '/')) {
			$parent = substr($sharename, 0, strpos($sharename, "/"));
			$query = "SELECT * FROM photo_share WHERE sharename = '".PHOTO_DB_EscapeParam($parent)."'";
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$row = PHOTO_DB_FetchRow($db_result);
			if ('' == $row['password'] && PHOTO_DB_ConvertBool($row['public']) == 'f') {
				// For parent albunm be privated
				// Only users who have the permission of the parent album can be candidates of the second album.
				// So we must filter them out
				$parentid = $row['shareid'];
			}
		}

		$users = $this->GetAllUsers($start, $limit, $search);
		$result['totalCount'] = $users['totalCount'];
		$result['all'] = array();

		for ($i = $start; $i < $users['totalCount'] && $i < $start + $limit; $i++) {
			$idx = $i - $start;
			$result['all'][$idx]['disabled'] = 0;
			if (null != $parentid) {
				$query = "SELECT * FROM " . PHOTO_ACCESS_RIGHT_TABLE . " WHERE shareid = " . $parentid;
				$query .= " AND userid = " . $users['all_users'][$idx]['userid'];
				$db_result_parent = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

				// Only users who have the permission of the parent album can be candidates of the second album.
				if (false === ($row_parent = PHOTO_DB_FetchRow($db_result_parent))) {
					$result['all'][$idx]['disabled'] = 1;
				}
			}

			$result['all'][$idx]['userid'] = $users['all_users'][$idx]['userid'];
			$result['all'][$idx]['username'] = $users['all_users'][$idx]['username'];
			$result['all'][$idx]['description'] = $users['all_users'][$idx]['description'];

			/* check album access right */
			$query = "SELECT * FROM " . PHOTO_ACCESS_RIGHT_TABLE . " WHERE shareid = " . $shareid;
			$query .= " AND userid = " . $users['all_users'][$idx]['userid'];
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

			$row = PHOTO_DB_FetchRow($db_result);
			if (($row != null || $isPublic) && (0 == $result['all'][$idx]['disabled'])) {
				$result['all'][$idx]['browse'] = 1;
				$result['all'][$idx]['browse_orig'] = 1;
			} else {
				$result['all'][$idx]['browse'] = 0;
				$result['all'][$idx]['browse_orig'] = 0;
			}
			/* check album upload right */
			$query_2 = "Select * from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid = " . $shareid;
			$query_2 .= " and userid = " . $users['all_users'][$idx]['userid'];
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_2);

			$row_2 = PHOTO_DB_FetchRow($db_result_2);
			if ($row_2 != null) {
				$result['all'][$idx]['upload'] = 1;
				$result['all'][$idx]['upload_orig'] = 1;
			} else {
				$result['all'][$idx]['upload'] = 0;
				$result['all'][$idx]['upload_orig'] = 0;
			}
			/* check album manage right */
			$query_3 = "Select * from " . PHOTO_MANAGE_RIGHT_TABLE . " where shareid = " . $shareid;
			$query_3 .= " and userid = " . $users['all_users'][$idx]['userid'];
			$db_result_3 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_3);

			$row_3 = PHOTO_DB_FetchRow($db_result_3);
			if ($row_3 != null) {
				$result['all'][$idx]['manage'] = 1;
				$result['all'][$idx]['manage_orig'] = 1;
			} else {
				$result['all'][$idx]['manage'] = 0;
				$result['all'][$idx]['manage_orig'] = 0;
			}
		}
		return $result;
	}

	private function GetAllUsers($start, $limit, $search)
	{
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
			return $this->GetAllDSMUser($start, $limit, $search);
		}

		$i = 0;
		$query = "SELECT * FROM photo_user WHERE admin = 'f' AND username LIKE '%" . PHOTO_DB_EscapeParam($search) . "%' ORDER BY username ASC LIMIT $limit OFFSET $start";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$result['all_users'][$i]['userid'] = $row['userid'];
			$result['all_users'][$i]['username'] = $row['username'];
			$result['all_users'][$i]['description'] = $row['description'];
			$i++;
		}
		$query = "SELECT count(*) FROM photo_user WHERE admin = 'f' AND username LIKE '%" . PHOTO_DB_EscapeParam($search) . "%'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$row = PHOTO_DB_FetchRow($db_result);
		$result['totalCount'] = $row[0];
		return $result;
	}

	private function GetAllDSMUser($start, $limit, $query = '')
	{
		$command = "/usr/syno/bin/synophoto_dsm_user --enum " . escapeshellarg($query);
		@exec($command, $pListUserCount, $retval);
		if (0 > $retval) {
			$result['totalCount'] = 0;
			return json_encode($result);
		}
		$result['totalCount'] = $pListUserCount[0];

		/* get the order of user info */
		$dir = "ASC";

		/* modify start value to skip admin and guest */
		if (isset($pListUserCount[1])) {
			$result['totalCount'] --;
			if ($pListUserCount[1] < $start) {
				$start += 1;
			}
		}
		if (isset($pListUserCount[2])) {
			$result['totalCount'] --;
			if ($pListUserCount[2] < $start) {
				$start += 1;
			}
		}
		/* modify limit value accoring to start value */
		if (isset($pListUserCount[1])) {
			if ($start <= $pListUserCount[1] && $pListUserCount[1] < $start + $limit) {
				$limit += 1;
			}
		}
		if (isset($pListUserCount[2])) {
			if ($start <= $pListUserCount[2] && $pListUserCount[2] < $start + $limit) {
				$limit += 1;
			}
		}

		$command = "/usr/syno/bin/synophoto_dsm_user --enum " . escapeshellarg($start) . " " . escapeshellarg($limit) . " " . $dir . ":" . escapeshellarg($query);
		@exec($command, $pListUserName, $retval);

		if (0 !== $retval) {
			$result['totalCount'] = 0;
			return json_encode($result);
		}

		$i = 0;
		$result['all_users'] = array();
		foreach ($pListUserName as $user_str) {
			$user_info = split(',', $user_str);
			if ('guest' == $user_info[1] || 'admin' == $user_info[1]) {
				continue;
			}

			$result['all_users'][$i]['userid'] = $user_info[0];
			$result['all_users'][$i]['username'] = $user_info[1];
			$result['all_users'][$i]['description'] = htmlspecialchars($user_info[2], ENT_QUOTES);
			$result['all_users'][$i]['disable'] = ($user_info[3] == 'true') ? "t" : "f";
			$result['all_users'][$i]['admin'] = ($user_info[5] == 1) ? "t" : "f";

			$i++;
		}

		return $result;
	}

	private function GetAlbumGroupData($sharename, $start = 0, $limit = 15, $search = '')
	{
		/* edit sharename for root album */
		if ('' === $sharename) {
			$sharename = '/';
		}
		$query = "SELECT * FROM photo_share WHERE sharename = '" . PHOTO_DB_EscapeParam($sharename) . "'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if ($row = PHOTO_DB_FetchRow($db_result)) {
			$shareid = $row['shareid'];
			$isPublic = ('t' == $row['public']);
		} else {
			return false;
		}

		$parentid = null;
		/* find the nearest private parent */
		if (false !== strstr($sharename, '/')) {
			$parent = substr($sharename, 0, strpos($sharename, "/"));
			$query = "SELECT * FROM photo_share WHERE sharename = '".PHOTO_DB_EscapeParam($parent) . "'";
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$row = PHOTO_DB_FetchRow($db_result);
			if ('' == $row['password'] && PHOTO_DB_ConvertBool($row['public']) == 'f') {
				// For parent albunm be privated
				// Only users who have the permission of the parent album can be candidates of the second album.
				// So we must filter them out
				$parentid = $row['shareid'];
			}
		}

		$groups = $this->GetAllGroups($start, $limit, $search);
		$result['totalCount'] = $groups['totalCount'];
		$result['all'] = array();
		for ($i = $start; $i < $groups['totalCount'] && $i < $start + $limit; $i ++) {
			$idx = $i - $start;
			$result['all'][$idx]['disabled'] = 0;
			if (null != $parentid) {
				$query = "SELECT * FROM " . PHOTO_GROUP_PERMISSION_TABLE . " WHERE shareid = " . $parentid;
				$query .= " AND groupid = " . $groups['all_groups'][$idx]['groupid'];
				$db_result_parent = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

				// Only groups which have the permission of the parent album can be candidates of the second album.
				if (false === ($row_parent = PHOTO_DB_FetchRow($db_result_parent))) {
					$result['all'][$idx]['disabled'] = 1;
				}
			}

			$result['all'][$idx]['groupid'] = $groups['all_groups'][$idx]['groupid'];
			$result['all'][$idx]['groupname'] = $groups['all_groups'][$idx]['groupname'];
			$result['all'][$idx]['description'] = $groups['all_groups'][$idx]['description'];

			$query = "SELECT * FROM " . PHOTO_GROUP_PERMISSION_TABLE . " WHERE shareid = " . $shareid;
			$query .= " AND groupid = " . $groups['all_groups'][$idx]['groupid'];
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

			$row = PHOTO_DB_FetchRow($db_result);
			if ((($row != null && (1 & $row['permission'])) || $isPublic) && (0 == $result['all'][$idx]['disabled'])) {
				$result['all'][$idx]['browse'] = 1;
				$result['all'][$idx]['browse_orig'] = 1;
			} else {
				$result['all'][$idx]['browse'] = 0;
				$result['all'][$idx]['browse_orig'] = 0;
			}
			if ($row != null && (2 & $row['permission'])) {
				$result['all'][$idx]['upload'] = 1;
				$result['all'][$idx]['upload_orig'] = 1;
			} else {
				$result['all'][$idx]['upload'] = 0;
				$result['all'][$idx]['upload_orig'] = 0;
			}
			if ($row != null && (4 & $row['permission'])) {
				$result['all'][$idx]['manage'] = 1;
				$result['all'][$idx]['manage_orig'] = 1;
			} else {
				$result['all'][$idx]['manage'] = 0;
				$result['all'][$idx]['manage_orig'] = 0;
			}
		}
		return $result;
	}

	private function GetAllGroups($start, $limit, $search)
	{
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
			return $this->GetAllDSMGroup($start, $limit, $search);
		}

		$i = 0;
		$query = "SELECT * FROM photo_group WHERE groupname LIKE '%" . PHOTO_DB_EscapeParam($search) . "%' ORDER BY groupname ASC LIMIT $limit OFFSET $start";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$result['all_groups'][$i]['groupid'] = $row['groupid'];
			$result['all_groups'][$i]['groupname'] = $row['groupname'];
			$result['all_groups'][$i]['description'] = $row['description'];
			$i ++;
		}
		$query = "SELECT count(*) FROM photo_group WHERE groupname LIKE '%" . PHOTO_DB_EscapeParam($search) . "%'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$row = PHOTO_DB_FetchRow($db_result);
		$result['totalCount'] = $row[0];
		return $result;
	}

	private function GetAllDSMGroup($start, $limit, $query = '')
	{
		$command = "/usr/syno/bin/synophoto_dsm_user --group " . escapeshellarg($query);
		@exec($command, $pListGroupCount, $retval);
		if (0 > $retval) {
			$result['totalCount'] = 0;
			return $result;
		}
		$result['totalCount'] = $pListGroupCount[0];

		$command = "/usr/syno/bin/synophoto_dsm_user --group " . escapeshellarg($start) . " " . escapeshellarg($limit) . " ASC:" . escapeshellarg($query);
		@exec($command, $pListGroupName, $retval);

		if (0 !== $retval) {
			$result['totalCount'] = 0;
			return $result;
		}

		$i = 0;
		$result['all_groups'] = array();
		foreach ($pListGroupName as $group_str) {
			$group_info = split(',', $group_str);
			$result['all_groups'][$i]['groupid'] = $group_info[0];
			$result['all_groups'][$i]['groupname'] = $group_info[1];
			$result['all_groups'][$i]['description'] = htmlspecialchars($group_info[2], ENT_QUOTES);

			$i ++;
		}

		return $result;
	}

	private function AddGroupPermission($shareid, $groups, $type)
	{
		if ($shareid == null || $shareid == "" || $groups == null || $groups == "") {
			return;
		}
		$ids = explode(',', $groups);
		foreach ($ids as $id) {
			if ('' === $id) {
				continue;
			}
			$query = "UPDATE " . PHOTO_GROUP_PERMISSION_TABLE . " SET permission = permission | $type WHERE shareid = " . $shareid . " AND groupid = " . $id;
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
				$date = date('Y-m-d H:i:s');
				$query = "INSERT INTO " . PHOTO_GROUP_PERMISSION_TABLE . " (groupid, shareid, permission, create_time) ";
				$query = $query . "VALUES (" . $id . ", " . $shareid . ", " . $type . ", '" . $date . "')";
				$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			}
		}
	}

	private function AddAlbumPermission($gid, $albums, $type)
	{
		if ($gid == null || $gid == "" || $albums == null || $albums == "") {
			return;
		}
		$ids = explode(',', $albums);
		foreach ($ids as $id) {
			if ('' === $id) {
				continue;
			}
			$query = "UPDATE " . PHOTO_GROUP_PERMISSION_TABLE . " SET permission = permission | $type WHERE shareid = " . $id . " AND groupid = " . $gid;
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
				$date = date('Y-m-d H:i:s');
				$query = "INSERT INTO " . PHOTO_GROUP_PERMISSION_TABLE . " (groupid, shareid, permission, create_time) ";
				$query = $query . "VALUES (" . $gid . ", " . $id . ", " . $type . ", '" . $date . "')";
				$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			}
		}
	}

	private function DeleteGroupPermission($shareid, $groups, $type)
	{
		if ($shareid == null || $shareid == "" || $groups == null || $groups == "") {
			return;
		}
		$type = -1 - $type;
		$ids = explode(',', $groups);
		foreach ($ids as $id) {
			if ('' === $id) {
				continue;
			}
			$query = "UPDATE " . PHOTO_GROUP_PERMISSION_TABLE . " SET permission = permission & $type WHERE shareid = " . $shareid . " AND groupid = " . $id;
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}
		$query = "DELETE FROM " . PHOTO_GROUP_PERMISSION_TABLE . " WHERE permission = 0";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}

	private function DeleteAlbumPermission($gid, $albums, $type)
	{
		if ($gid == null || $gid == "" || $albums == null || $albums == "") {
			return;
		}
		$type = -1 - $type;
		$ids = explode(',', $albums);
		foreach ($ids as $id) {
			if ('' === $id) {
				continue;
			}
			$query = "UPDATE " . PHOTO_GROUP_PERMISSION_TABLE . " SET permission = permission & $type WHERE shareid = " . $id . " AND groupid = " . $gid;
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}
		$query = "DELETE FROM " . PHOTO_GROUP_PERMISSION_TABLE . " WHERE permission = 0";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}

	private function AddChildGroupRightBySharename($sharename, $groups, $type)
	{
		if($sharename == null || $sharename == "" || $groups == null || $groups == "") {
			return;
		}
		if ("/" === $sharename) {
			$query = "SELECT shareid FROM photo_share WHERE sharename <> '/' AND sharename NOT LIKE '%/%/%'";
		} else {
			$query = "SELECT shareid FROM photo_share WHERE sharename LIKE '" . PHOTO_DB_EscapeParam($sharename) . "/%'";
			$query .= " AND sharename NOT LIKE '" . PHOTO_DB_EscapeParam($sharename) . "/%/%'";
		}
		if ($table === PHOTO_ACCESS_RIGHT_TABLE) {
			$query .= " AND public='f'";
		}
		$query .= " AND password=''";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$shareid = $row['shareid'];
			$this->AddGroupPermission($shareid, $groups, $type);
		}
	}

	private function DeleteChildGroupRightBySharename($sharename, $groups, $type)
	{
		if($sharename == null || $sharename == "" || $groups == null || $groups == "") {
			return;
		}
		$escape = PHOTO_DB_GetEscape();
		$query = "SELECT shareid FROM photo_share WHERE sharename LIKE '" . PHOTO_DB_EscapeParam($sharename) . "/%'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$shareid = $row['shareid'];
			$this->DeleteGroupPermission($shareid, $groups, $type);
		}
	}

	private function DeleteParentGroupRightBySharename($sharename, $groups, $type)
	{
		if($sharename == null || $sharename == "" || $groups == null || $groups == "") {
			return;
		}
		if ('/' === $sharename || '' === $sharename) {
			return;
		}
		$parentName = substr($sharename, 0, strrpos($sharename, '/'));
		if ('' === $parentName) {
			$parentName = '/';
		}
		$escape = PHOTO_DB_GetEscape();
		$query = "SELECT shareid FROM photo_share WHERE sharename='" . $parentName . "'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if ($row = PHOTO_DB_FetchRow($db_result)) {
			$shareid = $row['shareid'];
			$this->DeleteGroupPermission($shareid, $groups, $type);
		}
		$this->DeleteParentGroupRightBySharename($parentName, $groups, $type);
	}
}

$api = new PermissionAPI();
$api->Run();
