<?PHP

require_once('info.inc.php');

class InfoAPI extends WebAPI {
    function __construct() {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process() {
        if (!strcasecmp($this->method, "getinfo")) {
            $this->GetInfo();
        }
    }

    private function GetInfo() {
        $resp = array();

        // get version
        $resp['version_string'] = csSYNOPhotoMisc::GetPackageVersion();
        $split = explode('-', $resp['version_string']);
        $resp['version'] = (int)$split[1];

        // get dsm version
        $resp['dsm_version'] = (int)csSYNOPhotoMisc::GetDsmVersion();

        // get PhotoStation title
        $resp['title'] = csSYNOPhotoMisc::GetConfigDB("photo", "photo_page_title", "photo_config");

        // get root album sort_by
        $value = csSYNOPhotoMisc::GetConfigDB("album", "thumb_sort_type", "photo_config");
        $resp['sort_by'] = 'filename';
        if ('0' === $value) {
            $resp['sort_by'] = 'filename';
        } elseif ('1' === $value) {
            $resp['sort_by'] = 'takendate';
        } elseif ('2' === $value) {
            $resp['sort_by'] = 'createdate';
        }

        // get root album sort_direction
        $value = csSYNOPhotoMisc::GetConfigDB("album", "thumb_sort_order", "photo_config");
        $resp['sort_direction'] = ('1' === $value) ? 'desc' : 'asc';

        // get paging setting
        $value = csSYNOPhotoMisc::GetConfigDB("album", "paging_use_bar", "photo_config");
        $resp['paging_use_bar'] = 'off' !== $value; //return "on" by default
        $value = intval(csSYNOPhotoMisc::GetConfigDB("album", "paging_item_count", "photo_config"));
        $resp['paging_item_count'] = $value > 0 ? $value : 50;

        // get folder sort direction
        $value = csSYNOPhotoMisc::GetConfigDB("album", "album_order_type_is_desc", "photo_config");
        $resp['folder_sort_direction'] = ("1" === $value) ? 'desc' : 'asc';

        // get allow downoload original photo
        $value = csSYNOPhotoMisc::GetConfigDB("photo", "allow_orig", "photo_config");
        $resp['allow_download_orig'] = ('on' === $value) ? true : false;

		// get allow download album
		$value = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_album_download');
		$resp['allow_download_album'] = ('on' === $value) ? true : false;

		// get allow download video
		$value = csSYNOPhotoMisc::GetConfigDB('photo', 'allow_video_download', 'photo_config');
		$resp['allow_download_video'] = ('on' === $value) ? true : false;

		// get disable right button
		$value = csSYNOPhotoMisc::GetConfigDB('photo', 'disable_right_button', 'photo_config');
		$resp['disable_right_button'] = ('on' === $value) ? true : false;

        // get allow search
        $value = csSYNOPhotoMisc::GetConfigDB("photo", "hide_search", "photo_config");
        $resp['hide_search'] = ('on' === $value) ? true : false;

        // get allow rss feed
        $value = csSYNOPhotoMisc::GetConfigDB("photo", "hide_rss_feed", "photo_config");
        $resp['hide_rss_feed'] = ('on' === $value) ? true : false;

        // get enable blog
        $resp['enable_blog'] = csSYNOPhotoMisc::IsBlogEnabled();
 
		$resp['external_host'] = csSYNOPhotoMisc::GetServerHost();
		$resp['allow_social_share'] = !("on" == csSYNOPhotoDB::GetDBInstance()->GetConfig("photo", "disable_share"));
		$resp['allow_social_upload'] = ("on" == csSYNOPhotoMisc::GetConfigDB("photo", "allow_guest_fb_upload", "photo_config"));
		$resp['social_network_list'] = SocialNetwork::ReadList();

        // get virtual album (people, geo, desc tag)
        $tag['people_tag'] = $tag['geo_tag'] = $tag['desc_tag'] = false;
        if ('on' === ($value = csSYNOPhotoMisc::GetConfigDB("photo", "person_label_album", "photo_config"))) {
            $tag['people_tag'] = true;
        }
        if ('on' === ($value = csSYNOPhotoMisc::GetConfigDB("photo", "place_label_album", "photo_config"))) {
            $tag['geo_tag'] = true;
        }
        if ('on' === ($value = csSYNOPhotoMisc::GetConfigDB("photo", "general_label_album", "photo_config"))) {
            $tag['desc_tag'] = true;
        }
        $resp['virtual_tag'] = $tag;

        // get default get location
        $value = csSYNOPhotoMisc::GetConfigDB("gmap", "gps_default", "photo_config");
        $location['lat'] = $location['lng'] = '';
        $arr = explode(',', $value);
        if (2 === count($arr)) {
            $location['lat'] = $arr[0];
            $location['lng'] = $arr[1];
        }
        $resp['default_geo_location'] = $location;

        // get home category
        $resp['home_category'] = csSYNOPhotoMisc::GetConfigDB("album", "home_category", "photo_config");

        // get default album type
        $resp['default_album_public'] = false;
        if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['albumdefpublic']) &&
            'yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['albumdefpublic']) {
            $resp['default_album_public'] = true;
        }

        // FIXME
        $resp['default_category'] = "";
	// get disable_aboutme
	$resp['disable_aboutme'] = 'on' === csSYNOPhotoMisc::GetConfigDB("photo", "disable_aboutme", "photo_config") ? true : false;

        $this->SetResponse($resp);
    }
}

$api = new InfoAPI();
$api->Run();

?>
