<?php

require_once('auth.inc.php');
require_once('authutil.php');
require_once('albumutil.php');

class AuthAPI extends WebAPI {
    function __construct() {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process() {
        if (!strcasecmp($this->method, "login")) {
            $this->Login();
        } elseif (!strcasecmp($this->method, "logout")) {
            $this->Logout();
        } elseif (!strcasecmp($this->method, "checkauth")) {
            $this->CheckAuth();
        }
    }

    private function GetConfig() {
        $resp = array();
        // php session id
        $resp['sid'] = session_id();

        // get username
        // not personal photo
        if ('root' === SYNOPHOTO_ADMIN_USER) {
            $resp['username'] = (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && !isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) ? 'admin' : $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
        } else {
        // personal photo
            $resp['username'] = (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && !isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) ? SYNOPHOTO_ADMIN_NAME : $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
        }

        // get manager
        $resp['is_admin'] = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

        // get commentable
        $resp['allow_comment'] = AlbumAPIUtil::IsAlbumCommentalbGlobal();

        $permission['browse'] = csSYNOPhotoMisc::CheckAlbumAccessible('/');
        $permission['upload'] = csSYNOPhotoMisc::CheckAlbumUploadable('/');
        $permission['manage'] = csSYNOPhotoMisc::CheckAlbumManageable('/');
        $resp['permission'] = $permission;

        $resp['enable_face_recog'] = false;
        if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runfacerecognition']) &&
	  'yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runfacerecognition'] &&
          false === strstr($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg']['unique'], '88f628')) {
            $resp['enable_face_recog'] = true;
        }

        return $resp;
    }

    private function PhotoLogin() {
        $error_code = WEBAPI_ERR_NONE;
        $command = "/usr/syno/bin/synoautoblock --deny \"".$_SERVER['REMOTE_ADDR']."\"";
        @system($command, $retval);
        $command = "";
        if ($retval == 1) {
            $error_code = PHOTOSTATION_AUTH_LOGIN_NOPRIVILEGE;
        //if username is ADMIN
        } elseif (strtoupper($_REQUEST['username']) == "ADMIN" || strtoupper($_REQUEST['username']) == strtoupper(SYNOPHOTO_ADMIN_NAME)) {
            $ret = AuthAPIUtil::SYNOPHOTO_LOGIN_ValidateAdmin();
            if(1 == $ret) {
                $command = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
            } else {
                $error_code = PHOTOSTATION_AUTH_LOGIN_ERROR;
                $command = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
            }
        } else {
        // not ADMIN
            // PhotoStation user
            if ("0" == $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['global']['account_system'] || 'root' != SYNOPHOTO_ADMIN_USER){
                $ret = AuthAPIUtil::SYNOPHOTO_LOGIN_ValidateUser();
            } else {
            // DSM user
                $ret = AuthAPIUtil::SYNOPHOTO_LOGIN_ValidateDsmUser();
            }

            if($ret == 1) {
                $command = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
            } elseif ($ret == -1) {
                $error_code = PHOTOSTATION_AUTH_LOGIN_DISABLE_ACCOUNT;  // for PhotoStation user
            } else {
                $error_code = PHOTOSTATION_AUTH_LOGIN_ERROR;
                $command = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
            }
        }

        if ($command != "") {
            putenv('SYNOAUTOBLOCK_SERVICE=Photo Station');
            @system($command, $retval);
            putenv('SYNOAUTOBLOCK_SERVICE');
        }
        return $error_code;
    }

    private function IsEnableDemoMode()
    {
        $isDemoMode = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, 'enable_demomode');
        if ('yes' === $isDemoMode['enable_demomode']) {
            return true;
        }
        return false;
    }

    private function PhotoLogout() {
        unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
    }

    private function Login() {
		if (!isset($_REQUEST['username'])) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			goto End;
		}
        if (!$this->IsEnableDemoMode())  {
            $error_code = $this->PhotoLogin();
            if (WEBAPI_ERR_NONE != $error_code) {
                $this->SetError($error_code);
                goto End;
            }
        }
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
        $resp = $this->GetConfig();
        $this->SetResponse($resp);
    End:
        return;
    }

    private function Logout() {
        $this->PhotoLogout();
    }

    private function CheckAuth() {
        $resp = $this->GetConfig();
		AuthAPIUtil::SYNOPHOTO_LOGIN_UpdateUserGroupSession($resp['username']);
        $this->SetResponse($resp);
    }
}

$api = new AuthAPI();
$api->Run();

?>

