<?php

require_once('album.inc.php');
require_once('albumutil.php');
require_once '../include/SYNOPhotoEA.php';

class AlbumAPI extends WebAPI {
	function __construct() {
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process() {
		if (!strcasecmp($this->method, "list")) {
			csSYNOPhotoDB::GetDBInstance()->SetSessionCache();
			session_write_close();
			$this->AlbumList();
		} elseif (!strcasecmp($this->method, "getinfo")) {
			csSYNOPhotoDB::GetDBInstance()->SetSessionCache();
			session_write_close();
			$this->GetInfo();
		} else {
			csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
			csSYNOPhotoMisc::CheckSessionTimeOut(true);

			if (!strcasecmp($this->method, "create")) {
				$this->Create();
			} elseif (!strcasecmp($this->method, "edit")) {
				$this->Edit();
			} elseif (!strcasecmp($this->method, "delete")) {
				$this->Delete();
			} elseif (!strcasecmp($this->method, "move")) {
				$this->Move();
			} elseif (!strcasecmp($this->method, "arrangeitem")) {
				$this->ArrangeItem();
			} elseif (!strcasecmp($this->method, "cleararrangeitem")) {
				$this->ClearArrangeItem();
			}
		}
	}

    private function GetParams_Info() {
        $params = array();

        if (!isset($_REQUEST['id']) || '' === $_REQUEST['id']) {
            $params['id'] = null; // null means shared root folder
        } else {
            $split = explode(',', $_REQUEST['id']);
            $params['id'] = array();
            foreach ($split as $albumID) {
                $arr = explode('album_', $albumID);
                if (2 !== count($arr)) {
                    return false;
                }
                array_push($params['id'], $arr[1]);
            }
        }
        $params['password'] = (isset($_REQUEST['password'])) ? $_REQUEST['password'] : null;
        $params['additional'] = explode(',', $_REQUEST['additional']);

        return $params;
    }

    private function GetParams_Create_Edit() {
        $params = array();

        $params['name'] = $_REQUEST['name'];
        $params['id'] = (isset($_REQUEST['id'])) ? $_REQUEST['id'] : null; // null means shared root folder
        if (isset($_REQUEST['id'])) {
            $split = explode('album_', $_REQUEST['id']);
            if (2 != count($split)) {
                return false;
            }
            $params['id'] = $split[1];
        }
        $params['title'] = (isset($_REQUEST['title'])) ? $_REQUEST['title'] : null;
        $params['description'] = (isset($_REQUEST['description'])) ? $_REQUEST['description'] : null;
        $params['sort_by'] = (isset($_REQUEST['sort_by'])) ? $_REQUEST['sort_by'] : null;
        if ((null !== $params['sort_by']) && !in_array($params['sort_by'], array('filename', 'takendate', 'createdate', 'preference', 'default'))) {
            return false;
        }
        $params['sort_direction'] = (isset($_REQUEST['sort_direction'])) ? $_REQUEST['sort_direction'] : null;
        if ((null !== $params['sort_direction']) && !in_array($params['sort_direction'], array('asc', 'desc'))) {
            return false;
        }
        $params['allow_comment'] = (isset($_REQUEST['allow_comment'])) ? $_REQUEST['allow_comment'] : null;
        if ((null !== $params['allow_comment']) && !in_array($params['allow_comment'], array('true', 'false'))) {
            return false;
        }
        $params['type'] = (isset($_REQUEST['type'])) ? $_REQUEST['type'] : null;
        if ((null !== $params['type']) && !in_array($params['type'], array('public', 'private', 'password'))) {
            return false;
        }
        $params['password'] = (isset($_REQUEST['password'])) ? $_REQUEST['password'] : null;
        if ('password' === $params['type'] && null === $params['password']) {
            return false;
        }

        return $params;
    }

    private function GetTagIdString($tags)
    {
        $arr = explode(',', $tags);
        $idArr = array();
        foreach ($arr as $tag) {
            $split = explode('tag_', $tag);
            if (2 !== count($split)) {
                return Error;
            }
            array_push($idArr, $split[1]);
        }
        $idString = implode(',', $idArr);
    Error:
        return $idString;
    }

    private function GetParams_list() {

        $params = array();

        if (!isset($_REQUEST['offset']) || !isset($_REQUEST['limit']) || !isset($_REQUEST['type'])) {
            // FIXME - filter type
            return false;
        }
        $params['offset'] = $_REQUEST['offset'];
        $params['limit'] = $_REQUEST['limit'];
        $params['type'] = array();
        $arr = explode(',', $_REQUEST['type']);
        foreach ($arr as $item) {
            if (!in_array($item, array('album', 'photo', 'video'))) {
                return false;
            }
            array_push($params['type'], $item);
        }

        $params['id'] = (isset($_REQUEST['id'])) ? $_REQUEST['id'] : null; // null means shared root folder
		$params['albumName'] = '/';
        if (isset($_REQUEST['id'])) {
            $split = explode('_', $_REQUEST['id']);  // ex: album_id
            $params['id'] = $split[1];
			$params['albumName'] = @pack('H*', $split[1]);
        }
        $params['password'] = (isset($_REQUEST['password'])) ? $_REQUEST['password'] : null;

        // additional operator
        $params['additional'] = array();
        $params['additional'] = explode(',', $_REQUEST['additional']);

        // sort operator
        $params['sort_by'] = isset($_REQUEST['sort_by']) ? $_REQUEST['sort_by'] : 'preference';
        if (!in_array($params['sort_by'], array('filename', 'takendate', 'createdate', 'preference', 'mtime'))) {
            return false;
        }

        if (!isset($_REQUEST['sort_direction'])) {
            $value = csSYNOPhotoMisc::GetConfigDB("album", "thumb_sort_order", "photo_config");
            $params['sort_direction'] = AlbumAPIUtil::ConvertToSortDirection($value);
        } else {
            $params['sort_direction'] = $_REQUEST['sort_direction'];
        }
        if (!in_array($params['sort_direction'], array('asc', 'desc'))) {
            return false;
        }

        // filter operator
        $params['keyword'] = (isset($_REQUEST['keyword'])) ? $_REQUEST['keyword'] : null;
        if (isset($_REQUEST['keyword'])) {
            $default = 'all';
            $params['keyword_op'] = (isset($_REQUEST['keyword_op'])) ? $_REQUEST['keyword_op'] : $default;
            if (isset($params['keyword_op']) && !in_array($params['keyword_op'], array('any', 'all', 'exact'))) {
                return false;
            }
        }
        $params['date'] = (isset($_REQUEST['date'])) ? $_REQUEST['date'] : null;
        if (isset($_REQUEST['date'])) {
            $default = 'taken';
            $params['date_op'] = (isset($_REQUEST['date_op'])) ? $_REQUEST['date_op'] : $default;
            if (isset($params['date_op']) && !in_array($params['date_op'], array('taken', 'upload', 'recently_add', 'recently_comment'))) {
                return false;
            }
        }
        $params['people_tag'] = (isset($_REQUEST['people_tag'])) ? $_REQUEST['people_tag'] : null;
        if (isset($_REQUEST['people_tag'])) {
            $params['people_tag'] = $this->GetTagIdString($_REQUEST['people_tag']);
            $default = 'all';
            $params['people_tag_op'] = (isset($_REQUEST['people_tag_op'])) ? $_REQUEST['people_tag_op'] : $default;
            if (isset($params['people_tag_op']) && !in_array($params['people_tag_op'], array('all', 'any'))) {
                return false;
            }
        }
        $params['geo_tag'] = (isset($_REQUEST['geo_tag'])) ? $_REQUEST['geo_tag'] : null;
        if (isset($_REQUEST['geo_tag'])) {
            $params['geo_tag'] = $this->GetTagIdString($_REQUEST['geo_tag']);
            $default = 'all';
            $params['geo_tag_op'] = (isset($_REQUEST['geo_tag_op'])) ? $_REQUEST['geo_tag_op'] : $default;
            if (isset($params['geo_tag_op']) && !in_array($params['geo_tag_op'], array('all', 'any'))) {
                return false;
            }
        }
        $params['desc_tag'] = (isset($_REQUEST['desc_tag'])) ? $_REQUEST['desc_tag'] : null;
        if (isset($_REQUEST['desc_tag'])) {
            $params['desc_tag'] = $this->GetTagIdString($_REQUEST['desc_tag']);
            $default = 'all';
            $params['desc_tag_op'] = (isset($_REQUEST['desc_tag_op'])) ? $_REQUEST['desc_tag_op'] : $default;
            if (isset($params['desc_tag_op']) && !in_array($params['desc_tag_op'], array('all', 'any'))) {
                return false;
            }
        }

        return $params;
    }

	private function GetParams_ArrangeItem()
	{
		if (!isset($_REQUEST['offset']) || !isset($_REQUEST['limit']) || !isset($_REQUEST['item_id'])) {
			return false;
		}

		$params = array();
		$params['id'] =  (isset($_REQUEST['id'])) ? $_REQUEST['id'] : null; // null means shared root folder
		if (null !== $params['id'] && '' !== $params['id']) {
			$split = explode('_', $params['id']);  // ex: 'album_id'
			if (2 !== count($split)) {
				return false;
			}
			if ('album' !== $split[0]) {
				return false;
			}
			$params['albumName'] = @pack('H*', $split[1]);
		} else {
			$params['albumName'] = '/';
		}

		$params['offset'] = $_REQUEST['offset'];
		$params['limit'] = $_REQUEST['limit'];

		$params['item_id'] = array();
		$params['item_name'] = array();
		$items = explode(',', $_REQUEST['item_id']);
		// item must be photo or video, and make sure album must be ahead of photo and video
		foreach ($items as $item) {
			$arr = explode('_', $item);
			if (!in_array($arr[0], array('album', 'photo', 'video'))) {
				return false;
			}
			if ('photo' === $arr[0] || 'video' === $arr[0]) {
				$filename = @pack('H*', $arr[2]);
				array_push($params['item_name'], $filename);
			} elseif ('album' === $arr[0]) {
				$foldername = @pack('H*', $arr[1]);
				array_push($params['item_name'], basename($foldername).SYNOPHOTO_USER_SORT_ALBUM_SYMBOL);
			}
		}
		$params['item_id'] = $items;

		return $params;
	}

	private function GetParams_ClearArrangeItem()
	{
		$params = array();
		$params['id'] =  (isset($_REQUEST['id'])) ? $_REQUEST['id'] : null; // null means shared root folder
		if (null !== $params['id'] && '' !== $params['id']) {
			$split = explode('_', $params['id']);  // ex: 'album_id'
			if (2 !== count($split)) {
				return false;
			}
			if ('album' !== $split[0]) {
				return false;
			}
			$params['albumName'] = @pack('H*', $split[1]);
		} else {
			$params['albumName'] = '/';
		}

		return $params;
	}

    private function ConvertSmartCondition($params) {

        $matchPattern = array('id', 'keyword', 'keyword_op', 'date', 'date_op', 'people_tag', 'people_tag_op', 'geo_tag', 'geo_tag_op', 'desc_tag', 'desc_tag_op');
        $formatPattern = array('dir', 'k', 'k_op', 'd', 'd_op', 'pt', 'pt_op', 'gt', 'gt_op', 'dt', 'dt_op');
        $condition = array();
        foreach($matchPattern as $field) {
            if (isset($params[$field])) {
                $index = array_keys($matchPattern, $field);
                $condition[$formatPattern[$index[0]]] = $params[$field];
            }
        }
        return $condition;
    }

    private function GenItemID($type, $item, $params) {

        if ('album' === $type) {
            $id = "{$type}_{$item['dir']}";
        } elseif ('photo' === $type || 'video' === $type) {
            $fileName = basename($item['path']);
            $dirName = dirname($item['path']);
            if (SYNOPHOTO_SERVICE_REAL_DIR === $dirName) {
                $shareNameID = bin2hex('/');
            } else {
                $arr = explode(SYNOPHOTO_SERVICE_REAL_DIR.'/', $dirName);
                $shareNameID = bin2hex($arr[1]);
            }
            $fileID = bin2hex(basename($item['path']));
            $id = "{$type}_{$shareNameID}_{$fileID}";
        }

        return $id;
    }

    private function CheckRootSharedFolder($sharePath) {
        if ('' === $sharePath) {
            return true;
        }
        return false;
    }

    private function CheckAlbumAccessRight($sharePath, $password) {
        $ret = WEBAPI_ERR_NONE;
        // admin
        if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
            return WEBAPI_ERR_NONE;
        }

        // not root share folder
        if (!$this->CheckRootSharedFolder($sharePath)) {
            $albumInfo = csSYNOPhotoDB::GetDBInstance()->GetAlbum($sharePath);
            if (empty($albumInfo['password'])) {
                // Check accessible
                if (!csSYNOPhotoMisc::CheckAlbumAccessible($sharePath)) {
                    $ret = PHOTOSTATION_ALBUM_NO_ACCESS_RIGHT;
                }
            } else {
                if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$sharePath])) {
                    if ((md5($password) !== $albumInfo['password'])) {
                        $ret = PHOTOSTATION_ALBUM_PASSWORD_ERROR;
                    } else {
                        session_start();
                        $_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$sharePath] = md5($password);
                        session_write_close();
                    }
                }
            }
        }
        return $ret;
    }

    private function FormAdditional($type, $item, $params) {
        if ('album' === $type) {
            if (in_array('album_sorting', $params['additional'])) {
                $sharePath = @pack('H*', $item['dir']);
                $sortData = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumThumbSortType($sharePath);
                $sortBy = AlbumAPIUtil::ConvertToSortName($sortData['type']);
                $additional['album_sorting']['sort_by'] = $sortBy;
                $additional['album_sorting']['sort_direction'] = AlbumAPIUtil::ConvertToSortDirection($sortData['order']);
                $additional['album_sorting']['has_preference_sort'] = !empty($sortData);
            }
            if (in_array('album_permission', $params['additional'])) {
                // here
                $sharePath = @pack('H*', $item['dir']);
                $additional['album_permission'] = AlbumAPIUtil::GetAlbumPermission($sharePath);
            }
            if (in_array('item_count', $params['additional'])) {
                $sharePath = @pack('H*', $item['dir']);
                $additional['item_count'] = array(
                    'photo' => csSYNOPhotoDB::GetDBInstance()->getPhotoCountByAlbumPath($sharePath),
                    'video' => csSYNOPhotoDB::GetDBInstance()->getVideoCountByAlbumPath($sharePath)
                );
            }
        } elseif ('photo' === $type) {
            if (in_array('photo_exif', $params['additional'])) {
                $sharePath = @pack('H*', $params['id']);
                $photoInfo = $item;
                $additional['photo_exif']['takendate'] = $photoInfo['timetaken'];
                $additional['photo_exif']['camera'] = $photoInfo['camera_make'];
                $additional['photo_exif']['camera_model'] = $photoInfo['camera_model'];
                $additional['photo_exif']['exposure'] = $photoInfo['exposure'];
                $additional['photo_exif']['aperture'] = $photoInfo['aperture'];
                $additional['photo_exif']['iso'] = $photoInfo['iso'];
                $additional['photo_exif']['gps'] = json_decode($photoInfo['gps'], true);
            }
        } elseif ('video' === $type) {
            if (in_array('video_codec', $params['additional'])) {
                $videoInfo = $item;
                $additional['video_codec']['container'] = $videoInfo['container_type'];
                $additional['video_codec']['vcodec'] = $videoInfo['video_codec'];
                $additional['video_codec']['acodec'] = $videoInfo['audio_codec'];
                $additional['video_codec']['resolutionx'] = $videoInfo['resolutionx'];
                $additional['video_codec']['resolutiony'] = $videoInfo['resolutiony'];
                $additional['video_codec']['frame_bitrate'] = $videoInfo['frame_bitrate'];
                $additional['video_codec']['video_bitrate'] = $videoInfo['video_bitrate'];
                $additional['video_codec']['audio_bitrate'] = $videoInfo['audio_bitrate'];
            }
            if (in_array('video_quality', $params['additional'])) {
                $additional['video_quality'] = AlbumAPIUtil::GetConvertedVideoInfo($item['path']);
            }
        }
        return $additional;
    }

    private function IsAlbumCommentalb($sharePath) {
        $arr = explode('/', $sharePath);
		$level1ShareName = $arr[0];
        return isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['commentable_album'][$level1ShareName]);
    }

    private function FormAlbum($item_node, $allowComment) {
        $item_info = array();
        $item_info['description'] = $item_node['desc'];
        $sharePath = @pack('H*', $item_node['dir']);
        $item_info['sharepath'] = $sharePath;
        $arr = explode('/', $sharePath);
        $item_info['name'] = $arr[count($arr)-1];
        $item_info['title'] = empty($item_node['title']) ? $item_info['name'] : $item_node['title'];
        $item_info['hits'] = $item_node['hit'];
        $item_info['allow_comment'] = $allowComment;

        // get album access right
        if ('t' == $item_node['isPublic']){
            $access_right = 'public';
        } else {
            if ($item_node['needPassword']) {
                $access_right = 'password';
            } else {
                $access_right = 'private';
            }
        }
        $item_info['type'] = $access_right;

        return $item_info;
    }

    private function FormPhoto($item_node) {
        $item_info = array();
        $item_info['name'] = $item_node['name'];
        $item_info['title'] = $item_node['title'];
        $item_info['description'] = $item_node['description'];
        $item_info['createdate'] = $item_node['createdate'];
        $item_info['takendate'] = $item_node['timetaken'];
        $item_info['size'] = $item_node['size'];
        $item_info['resolutionx'] = $item_node['resolutionx'];
        $item_info['resolutiony'] = $item_node['resolutiony'];
        $item_info['rotated'] = (0 === (int)$item_node['version'] %2) ? false : true;
        $item_info['rotate_version'] = (int)$item_node['version'];

        return $item_info;
    }

    private function FormVideo($item_node) {
        $item_info = array();
        $item_info['name'] = $item_node['name'];
        $customTitleDesc = csSYNOPhotoDB::GetDBInstance()->GetVideoCustomizedTitleDescription($item_node['path']);
        $item_info['title'] = empty($customTitleDesc['title']) ? $item_node['title'] : $customTitleDesc['title'];
        $item_info['description'] = $customTitleDesc['description'];
        $item_info['size'] = $item_node['filesize'];
        $item_info['duration'] = $item_node['duration'];
        $item_info['takendate'] = $item_node['mdate'];
        $item_info['createdate'] = $item_node['date'];
        $item_info['gps'] = json_decode($item_node['gps']);

        return $item_info;
    }

    private function FormItems($itemList, $params) {
        $items = array();
        $allowComment = AlbumAPIUtil::IsAlbumCommentalbGlobal();
        $needThumbSize = in_array('thumb_size', $params['additional']);

        foreach($itemList['items'] as $item_node) {
            $item= array();

            $typeName = AlbumAPIUtil::ConvertToTypeName($item_node['itemType']);
            $item['type'] = $typeName;
            $item['id'] = $this->GenItemID($typeName, $item_node, $params);
            $item_info = array();
            if ('album' == $item['type']) {
                $sharePath = @pack('H*', $item_node['dir']);
                $result = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($sharePath);

				$coverPath = $result['coverPath'];
                $item_info = $this->FormAlbum($item_node, $allowComment);
				$blCalculateThumbByOrig = false;
            } elseif ('photo' == $item['type']) {
				$coverPath = $item_node['path'];
                $item_info = $this->FormPhoto($item_node);

				$orig_resolutionx = $item_node['resolutionx'];
				$orig_resolutiony = $item_node['resolutiony'];
				$blThumbRotated = (0 === (int)$item_node['version'] %2) ? false : true;
				$blCalculateThumbByOrig = true;
            } elseif ('video' == $item['type']) {
				$coverPath = $item_node['path'];
                $item_info = $this->FormVideo($item_node);

				$orig_resolutionx = $item_node['resolutionx'];
				$orig_resolutiony = $item_node['resolutiony'];
				$blThumbRotated = false;
				$blCalculateThumbByOrig = true;
            }

            // additional handler
            $item['info'] = $item_info;
            $item['additional'] = $this->FormAdditional($item['type'], $item_node, $params);
			AlbumAPIUtil::FillThumbStatus($item, $coverPath, $needThumbSize, $blCalculateThumbByOrig, $orig_resolutionx, $orig_resolutiony, $blThumbRotated);

            array_push($items, $item);
        }

        return $items;
    }

    private function GetAlbumShareName($value) {
        if (empty($value)) {
            return false;
        }

        $shareNameList = array();
        $albumIDs = explode(',', $value);
        foreach ($albumIDs as $albumID) {
            $arr = explode('album_', $albumID);
            if (2 !== count($arr)) {
                return false;
            }
            array_push($shareNameList, @pack('H*', $arr[1]));
        }
        return $shareNameList;
    }

    private function GetRootAlbumInfo($params) {
        $info['description'] = '';
        $info['sharepath'] = '/';
        $info['name'] = '/';
        $info['title'] = csSYNOPhotoMisc::GetConfigDB("photo", "photo_page_title", "photo_config");
        $info['hits'] = null;
        $info['allow_comment'] = ('on' === csSYNOPhotoMisc::GetConfigDB("photo", "album_def_allow_comment", "photo_config")) ? true : false;
        $info['type'] = 'public';

        $item['id'] = null;
        $item['info'] = $info;
        if (in_array('album_sorting', $params['additional'])) {
            $value = csSYNOPhotoMisc::GetConfigDB("album", "album_order_type", "photo_config");
            $additional['album_sorting']['sort_by'] = ('1' === $value) ? 'preference' : 'filename';
            $value = csSYNOPhotoMisc::GetConfigDB("album", "album_order_type_is_desc", "photo_config");
            $additional['album_sorting']['sort_direction'] = ('1' === $value) ? 'desc' : 'asc';
            $value = csSYNOPhotoAlbum::GetAlbumThumbSortType($info['sharepath']);
            $additional['album_sorting']['has_preference_sort'] = !empty($value);
        }
        if (in_array('album_permission', $params['additional'])) {
            $permission = AlbumAPIUtil::GetAlbumPermission('/');
            $additional['album_permission'] = $permission;
        }
        if (null !== $additional) {
            $item['additional'] = $additional;
        }
        return $item;
    }

    private function GetInfo() {
        // Get and check params
        $params = array();
        $params = $this->GetParams_Info();
        if (!$params) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        $needThumbSize = in_array('thumb_size', $params['additional']);
        $items = array();
        if (null === $params['id']) {
            $item = $this->GetRootAlbumInfo($params);
            array_push($items, $item);
        } else {
            $allowComment = AlbumAPIUtil::IsAlbumCommentalbGlobal();
            foreach ($params['id'] as $id) {
                $shareName = @pack('H*', $id);
                $albumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($shareName);
                $result = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($shareName);

				$coverPath = $result['coverPath'];

                $item['id'] = "album_{$id}";
                $item['info'] = $this->FormAlbum($albumInfo, $allowComment);
                $item['type'] = 'album';
                $additional = $this->FormAdditional('album', $albumInfo, $params);
                if (null !== $additional) {
                    $item['additional'] = $additional;
                }
				AlbumAPIUtil::FillThumbStatus($item, $coverPath, $needThumbSize, false);
                array_push($items, $item);
            }
        }

        $resp['items'] = $items;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function AlbumList() {
        // Get and check params
        $params = array();
        $params = $this->GetParams_list();
        if (!$params) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        $sharePath = @pack('H*', $params['id']);
        // Check access right
        if (WEBAPI_ERR_NONE != ($error_code = $this->CheckAlbumAccessRight($sharePath, $params['password']))) {
            $this->SetError($error_code);
            goto End;
        }
        
        // search operator
        $itemsSort = array();
        if (isset($params['keyword']) || isset($params['date']) || isset($params['people_tag']) || isset($params['geo_tag']) || isset($params['desc_tag'])) {
            $smart_condition = $this->ConvertSmartCondition($params);
            $itemList = csSYNOPhotoBrowse::GetBrowseInstance()->GetSearchThumbList($smart_condition, $params['offset'], $params['limit'], true);
            // filter type
            $filterItems = AlbumAPIUtil::FilterByType($itemList['items'], $params['type']);
			$total = $itemList['itemCount'];
            // FIXME - sorting for search operator
            $itemsSort['items'] = $filterItems;
        } else {
        // album operator
			session_start();
			$_SESSION[SYNOPHOTO_ADMIN_USER]['album_thumb_sort_by'] = $params['sort_by'];
			$_SESSION[SYNOPHOTO_ADMIN_USER]['album_thumb_sort_order'] = $params['sort_direction'];
			session_write_close();
            $itemsSort = array();
            $itemsSort = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbList_New(isset($params['id']) ? $sharePath : '/', (int)$params['offset'], (int)$params['limit'], $params['sort_by'], $params['sort_direction'], !in_array('album', $params['type']), !in_array('video', $params['type']), !in_array('photo', $params['type']));
            $total = $itemsSort['itemCount'];
            if (isset($params['id'])) {
                csSYNOPhotoAlbum::GetAlbumInstance()->AddHitTimes($sharePath);
            }
        }

        $resp = array();
        $resp['total'] = $total;
        $offset = (0 > (int)$params['limit']) ? $resp['total'] : $params['offset'] + $params['limit'];
        $resp['offset'] = ($offset > $resp['total']) ?  $resp['total'] : $offset;
        $resp['items'] = $this->FormItems($itemsSort, $params);
        $this->SetResponse($resp);

    End:
        return;
    }

    private function Create() {
        if (!isset($_REQUEST['name'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // name can't include [.] start or [\/:*?<>|]
        if (preg_match('/[\\\\\/:\*\?<>\|]/', $_REQUEST['name'], $matches) || preg_match('/^\./', $_REQUEST['name'], $matches)) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // Get and check params
        $params = array();
        $params = $this->GetParams_Create_Edit();
        if (!$params) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get parent share name
        $parentShareName = (null !== $params['id']) ? @pack('H*', $params['id']) : '';

        $ret = AlbumAPIUtil::SYNOPHOTO_ADMIN_AddAlbum($parentShareName, $params);
        if (-1 === $ret) {
            $this->SetError(PHOTOSTATION_ALBUM_CREATE_FAIL);
            goto End;
        } elseif (-2 === $ret) {
            $this->SetError(PHOTOSTATION_ALBUM_NO_UPLOAD_RIGHT);
            goto End;
        } elseif (-3 === $ret) {
            $this->SetError(PHOTOSTATION_ALBUM_NOT_ADMIN);
            goto End;
        } elseif (-4 === $ret) {
            $this->SetError(PHOTOSTATION_ALBUM_HAS_EXIST);
            goto End;
        }

        $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('sharename', 'photo_share', 'shareid', $ret);
        $albumID = 'album_'.bin2hex($row['sharename']);
        $resp['id'] = $albumID;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function Delete() {
        if (!isset($_REQUEST['id'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        if (false === ($shareNameList = $this->GetAlbumShareName($_REQUEST['id']))) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        $failCount = 0;
        foreach ($shareNameList as $shareName) {
			self::OutputSingleSpace();

            if ('/' === $shareName) {
                $failCount++;
                continue;
            }
            $dirName = dirname($shareName);
            $dirName = ('.' === $dirName) ? '/' : $dirName;
            if (!csSynoPhotoMisc::CheckAlbumManageable($dirName)) {
                $failCount++;
                continue;
            }
            SYNOPHOTO_ADMIN_DeleteOneAlbum($shareName);
        }
        if ($failCount === count($shareNameList)) {
            $this->SetError(PHOTOSTATION_ALBUM_NO_MANAGE_RIGHT);
            goto End;
        }
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
        SYNOPHOTO_LABEL_UTIL_Check_Photo_Label();

    End:
        return;
    }

    private function Edit() {
        // Get and check params
        $params = array();
        $params = $this->GetParams_Create_Edit();
        if (!$params || null === $params['id']) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
 
        if ((false === ($shareNameList = $this->GetAlbumShareName($_REQUEST['id'])))) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        $shareName = $shareNameList[0];

        $ret = AlbumAPIUtil::SYNOPHOTO_ADMIN_UpdateAlbum($shareName, $params);
        if (-1 === $ret) {
            $this->SetError(PHOTOSTATION_ALBUM_EDIT_FAIL);
            goto End;
        } elseif (-2 === $ret) {
            $this->SetError(PHOTOSTATION_ALBUM_NO_MANAGE_RIGHT);
            goto End;
        } elseif (-3 === $ret) {
            $this->SetError(PHOTOSTATION_ALBUM_NOT_ADMIN);
            goto End;
        }
    End:
        return;
	}

	private function Move() {
		$ret = false;
		$resp = array();

		/* return when lack of params */
		if (!isset($_REQUEST['id']) || !isset($_REQUEST['sharepath']) || !isset($_REQUEST['duplicate'])) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			goto End;
		}
		/* set params */
		$destShareName = @pack('H*', $_REQUEST['sharepath']);
		if ('' !== $destShareName) {
			$destPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $destShareName);
		} else {
			$destPath = SYNOPHOTO_SERVICE_REAL_DIR . "/";
		}

		if (0 !== strncmp($destPath, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			goto End;
		}

		if (!csSynoPhotoMisc::CheckAlbumUploadable('' == $destShareName ? '/' : $destShareName)) {
			$this->SetError(PHOTOSTATION_ALBUM_NO_MANAGE_RIGHT);
			goto End;
		}

		$is_overwritten = 'overwritten' === $_REQUEST['duplicate'] ? true : false;

		$destShareData = array();
		$destShareData['shareid'] = -1;

		if ($_REQUEST['sharepath'] == '') {
			$destShareData['sharename'] = '';
			$query = "SELECT shareid, sharename, public, password FROM photo_share WHERE sharename='/'";
			$sqlParam = array();
		} else {
			$destShareData['sharename'] = $destShareName;
			$query = "SELECT shareid, sharename, public, password FROM photo_share WHERE sharename=?";
			$sqlParam = array($destShareData['sharename']);
		}

		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		if($row = PHOTO_DB_FetchRow($db_result)) {
			$destShareData['shareid'] = $row['shareid'];
			$destShareData['public'] = PHOTO_DB_ConvertBool($row['public']);
			$destShareData['password'] = $row['password'];
		}

		$ids = explode(',', $_REQUEST['id']);
		foreach ($ids as $idStr) {
			self::OutputSingleSpace();

			$id_arr = explode('_', $idStr);
			$albumName = @pack('H*', $id_arr[1]);
			$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName);
			if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
				continue;
			}
			SYNOPHOTO_ADMIN_MoveOneAlbum($destShareData, $albumName, $is_overwritten);
		}
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

		$ret = true;
		End:
			return $ret;
	}

	private function ArrangeItem()
	{
		if (false === ($params = $this->GetParams_ArrangeItem())) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			goto End;
		}

		// chack permission
		if (!csSynoPhotoMisc::CheckAlbumManageable($params['albumName'])) {
			$this->SetError(PHOTOSTATION_ALBUM_NO_MANAGE_RIGHT);
			goto End;
		}

		// get sort_by and sort_direction
		$sort_by = $_SESSION[SYNOPHOTO_ADMIN_USER]['album_thumb_sort_by'];
		if (empty($sort_by)) {
			$value = csSYNOPhotoMisc::GetConfigDB("album", "thumb_sort_type", "photo_config");
			$sort_by = AlbumAPIUtil::ConvertToSortName($value);
		}
		$sort_direction = $_SESSION[SYNOPHOTO_ADMIN_USER]['album_thumb_sort_order'];
		if (empty($sort_direction)) {
			$value = csSYNOPhotoMisc::GetConfigDB("album", "thumb_sort_order", "photo_config");
			$sort_direction = AlbumAPIUtil::ConvertToSortDirection($value);
		}

		// get original path list
		$pathList = csSYNOPhotoBrowse::GetBrowseInstance()->GetList_new($params['albumName'], 0, -1, $sort_by, $sort_direction, false, false, false);
		$totalCount = $pathList['totalCount'];

		// adjust offset and limit
		$offset = $params['offset'];
		$limit = (-1 === (int)$params['limit']) ? (int)$totalCount : (int)$params['limit'];
		if ($offset >= $totalCount || $limit != count($params['item_name'])) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			goto End;
		}

		// get original name list
		$nameList = array();
		foreach ($pathList['list'] as $path => $itemType) {
			$name = (SYNOPHOTO_ITEM_TYPE_ALBUM === $itemType) ? basename($path).SYNOPHOTO_USER_SORT_ALBUM_SYMBOL : basename($path);
			$nameList[] = $name;
		}

		// get sort name list
		array_splice($nameList, $offset, $limit, $params['item_name']);
		$sortNameList = $nameList;

		// make sure album must be ahead of photo and video
		$blHavePhotoVideoItem = false;
		$blPhotoVideoAheadAlbum = false;
		foreach ($sortNameList as $name) {
			if ('/' === $name[strlen($name)-1]) {
				if ($blHavePhotoVideoItem) {
					$blPhotoVideoAheadAlbum = true;
					break;
				}
			} else {
				$blHavePhotoVideoItem = true;
			}
		}
		if ($blPhotoVideoAheadAlbum) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			goto End;
		}

		// seve to conf
		$data['type'] = AlbumAPIUtil::ConvertToSortCode('preference');
		$data['list'] = $sortNameList;
		csSYNOPhotoAlbum::GetAlbumInstance()->SaveAlbumThumbSortType($params['albumName'], $data);

	End:
		return;
	}

	private function ClearArrangeItem()
	{
		if (false === ($params = $this->GetParams_ClearArrangeItem())) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			goto End;
		}

		$albumName = $params['albumName'];

		// chack permission
		if (!csSynoPhotoMisc::CheckAlbumManageable($albumName)) {
			$this->SetError(PHOTOSTATION_ALBUM_NO_MANAGE_RIGHT);
			goto End;
		}

		//remove sort file directly in PS6
		if ('/' === $albumName) {
			$fullDirPath = SYNOPHOTO_SERVICE_REAL_DIR;
			$sortFile = $fullDirPath . '/' . SYNOPhotoEA::SYNO_EA_DIR . '/' . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_ALBUM_SORT);
		} else {
			$fullDirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_REAL_DIR, $albumName);
			if (false === SYNOPhotoEA::checkFilePath($fullDirPath, SYNOPhotoEA::FILE_ALBUM_SORT, $sortFile)) {
				goto End;
			}
		}

		@unlink($sortFile);

	End:
		return;
	}
}

$api = new AlbumAPI();
$api->Run();


?>
