<?php
/*!
 * album list operation
 */
class csSYNOPhotoAlbum {
	/*! reference to db handler */
	private $_dbh;
	private $escapeStr = '';
	/*! reference to a self instance */
	private static $instance = null;
	/*! convert type condition to query video_convert table */
	private static $video_convert_type_condition;
	/*!
	/*!
	 * Constructor
	 */
	function __construct()
	{
		$this->_dbh = csSYNOPhotoDB::GetDBInstance()->_dbh;
		$this->escapeStr = csSYNOPhotoDB::GetDBInstance()->escapeStr;

		$condition = csSYNOPhotoDB::GetDBInstance()->GetConvertedVideoDBCondition();
		if (!empty($condition)) {
			$this->video_convert_type_condition = "AND path in (SELECT video_path FROM video_convert WHERE {$condition})";
		}
	}
	/*!
	 * Get a exist instance
	 */
	static function GetAlbumInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get the user-defined album cover for the sub-dir $albumName
	 *
	 * \param $albumName the sub-dir album name
	 * \return cover file path
	 */
	private function GetSubAlbumCover($albumName)
	{
		$result = '';

		$fullDirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_DIR, $albumName);
		if (false === SYNOPhotoEA::checkFilePath($fullDirPath, SYNOPhotoEA::FILE_ALBUM_COVER, $coverFile)) {
			return '';
		}
		if (false === ($result = @file_get_contents($coverFile))) {
			return '';
		}

		$result = trim(SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/".$result);
		if (!@is_file($result)) {
			$result = '';
		}

		return $result;
	}
	/*!
	 * pick the latest upload image in the album as cover
	 *
	 * \param $albumName the album name
	 * \return cover file path
	 */
	private function GetAlbumCoverLatestUpload($albumName)
	{
		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$querySub = "SELECT path,resolutionx,resolutiony,version FROM photo_image WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY create_time DESC LIMIT 1";
		$queryvVideoSub = "SELECT path,resolutionx,resolutiony FROM video WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ".$this->video_convert_type_condition.' ORDER BY date DESC LIMIT 1';
		$queryAll = "SELECT path,resolutionx,resolutiony,version FROM photo_image WHERE path LIKE ? {$this->escapeStr} ORDER BY create_time DESC LIMIT 1";
		$queryVideoAll = "SELECT path,resolutionx,resolutiony FROM video WHERE path LIKE ? {$this->escapeStr} ".$this->video_convert_type_condition.' ORDER BY date DESC LIMIT 1';
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$result = '';

		$dbPhotoResult = $this->_dbh->prepare($querySub);
		$dbPhotoResult->execute($sqlParam);
		if($row = $dbPhotoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			return $row;
		}

		$dbVideoResult = $this->_dbh->prepare($queryvVideoSub);
		$dbVideoResult->execute($sqlParam);
		if($row = $dbVideoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			return $row;
		}

		/* no photo or video in the album*/
		/* search each sub-dir for top album */
		if (false === strpos($albumName, '/')) {
			$condition = array('sharename' => array('op' => 'PREFIX', 'value' => $albumName.'/'));
			$albums = csSYNOPhotoDB::GetDBInstance()->GetAlbums($condition);
			foreach ($albums as $album) {
				if (true !== csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($album['sharename'], '')) {
					continue;
				}
				$result = $this->GetAlbumCoverLatestUpload($album['sharename']);
				if (!empty($result)) {
					break;
				}
			}
			return $result;
		}
		/* pick one photo in the album and its sub-dir */
		$dbPhotoResult = $this->_dbh->prepare($queryAll);
		$dbPhotoResult->execute(array($sqlParam[0]));
		if($row = $dbPhotoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			return $row;
		}

		$dbVideoResult = $this->_dbh->prepare($queryVideoAll);
		$dbVideoResult->execute(array($sqlParam[0]));
		if($row = $dbVideoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		}
		return $row;
	}

	/*!
	 * Get cover for album $albumName
	 *
	 * \param $albumName the album name
	 * \return array with cover info
	 *	- src: cover file path
	 *	- width: cover width
	 *	- height: cover height
	 */
	function GetAlbumCover($albumName)
	{
		//Show lock icon when the album is locked
		$album = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
		if ($album['password'] && true !== csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($albumName, '')) {
			$result['cover']['src'] = SYNOPHOTO_IMG_LOCKED;
   			$imageInfoBigCover = @getImageSize(SYNOPHOTO_IMG_LOCKED_FILE_PATH);
   			$result['cover']['width'] = $imageInfoBigCover[0];
   			$result['cover']['height'] = $imageInfoBigCover[1];

   			$result['bigCover']['src'] = SYNOPHOTO_IMG_LOCKED_HIGH_QUALITY;
   			$imageInfoCover = @getImageSize(SYNOPHOTO_IMG_LOCKED_FILE_PATH_HIGH_QUALITY);
   			$result['bigCover']['width'] = $imageInfoCover[0];
   			$result['bigCover']['height'] = $imageInfoCover[1];
			return $result;
		}

		if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['albumCover_cache'][$albumName])) {
			/* get user-defined cover */
			$coverFile = $this->GetSubAlbumCover($albumName);

			if (!empty($coverFile)) {
				$isPhotoFileWithThumb = csSYNOPhotoMisc::IsPhotoFileWithThumb($coverFile);
				if ($isPhotoFileWithThumb) {
					$filePath = csSYNOPhotoMisc::GetThumbPathFromFullPath($coverFile, SYNOPHOTO_THUMBSMALL, false);
				} else {
					$filePath = $coverFile;
				}

				if (!csSYNOPhotoMisc::IsPhotoFile($coverFile) ||
					!@file_exists($filePath) ||
					true !== csSYNOPhotoDB::GetDBInstance()->CheckPathAccessible($coverFile)) {
					$coverFile = '';
				}
			}

			/* use latest upload photo as cover */
			if (empty($coverFile)) {
				$coverFile = $this->GetAlbumCoverLatestUpload($albumName);
			}
			$_SESSION[SYNOPHOTO_ADMIN_USER]['albumCover_cache'][$albumName] = $coverFile;
		}

		$coverFile = $_SESSION[SYNOPHOTO_ADMIN_USER]['albumCover_cache'][$albumName];
		/* use empty image */
		$result['cover'] = array();
		$result['bigCover'] = array();
		if (empty($coverFile)) {
   			$result['cover']['src'] = SYNOPHOTO_IMG_EMPTY;
   			$imageInfoBigCover = @getImageSize(SYNOPHOTO_IMG_EMPTY_FILE_PATH);
   			$result['cover']['width'] = $imageInfoBigCover[0];
   			$result['cover']['height'] = $imageInfoBigCover[1];

   			$result['bigCover']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
   			$imageInfoCover = @getImageSize(SYNOPHOTO_IMG_EMPTY_FILE_PATH_HIGH_QUALITY);
   			$result['bigCover']['width'] = $imageInfoCover[0];
   			$result['bigCover']['height'] = $imageInfoCover[1];
		} else if (is_array($coverFile) && isSet($coverFile['version'])) {
			// thumb is from photo file
   			$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBSMALL, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
			$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
		} else if (is_array($coverFile) && !isSet($coverFile['version'])) {
			// thumb is from video file
			$result['cover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBSMALL, $coverFile['resolutionx'], $coverFile['resolutiony']);
			$result['bigCover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, $coverFile['resolutionx'], $coverFile['resolutiony']);
		}else {
   			$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile, SYNOPHOTO_THUMBSMALL, 0, 0, -1);
   			$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile, SYNOPHOTO_THUMBMEDIUM, 0, 0, -1);
		}
		return $result;
	}

	/*!
	 * Get # of photos in the album after layer 2
	 * Do not need to check priviledge of user when getting number of photos of albums after layer 2.
	 * \param $albumName the album name
	 * \return the # of photos and videos
	 */
	function GetNumberOfPhotosAtAlbumsAfterLayer2($albumName)
	{
		$sqlParam = array();
		$sqlParamCount = 0;
		$sqlParam1Index = ++$sqlParamCount;
		$query = 'SELECT count(*) FROM photo_image WHERE (path LIKE ?)';
		$queryVideo = 'SELECT count(*) FROM video WHERE ((path LIKE ?)';

		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}");
		$sqlParam[] = "{$albumRealPath}/%";

		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		$dbVideoResult = $this->_dbh->prepare($queryVideo.' )'.$this->video_convert_type_condition);
		$dbVideoResult->execute($sqlParam);

		$row = $dbResult->fetch();
		$photoCount = $row[0];
		$row = $dbVideoResult->fetch();
		$videoCount = $row[0];

		return $photoCount + $videoCount;
	}
	/*!
	 * Get # of photos in the album
	 *
	 * \param $albumName the album name
	 * \param $isIncludeSubDir the # of photos include all sub-dir or not
	 * \return the # of photos and videos
	 */
	function GetNumberOfPhotos($albumName, $isIncludeSubDir)
	{
		$result = array(true => false, false => false);
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName])) {
			$counted = $_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName];
			$result[true] = isSet($counted[true]) ? $counted[true] : false;
			$result[false] = isSet($counted[false]) ? $counted[false] : false;
		}
		if (false !== $result[$isIncludeSubDir]) {
			return $result[$isIncludeSubDir];
		}

		// count for photo & video
		$sqlParam = array();
		$sqlParamCount = 0;
		$sqlParam1Index = ++$sqlParamCount;
		$sqlParam2Index = ++$sqlParamCount;
		$query = "SELECT count(*) FROM photo_image WHERE (path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr})";
		$queryVideo = "SELECT count(*) FROM video WHERE ((path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr})";
		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$sqlParam[] = "{$albumRealPath}/%";
		$sqlParam[] = "{$albumRealPath}/%/%";
		if (!$isIncludeSubDir) {
			/* # of photos in the album */
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
			$dbVideoResult = $this->_dbh->prepare($queryVideo.' )'.$this->video_convert_type_condition);
			$dbVideoResult->execute($sqlParam);
		} else {
			/* # of photos in all albums in the album */
			$condition = array('sharename' => array('op' => 'PREFIX', 'value' => $albumName.'/'));
			$albums = csSYNOPhotoDB::GetDBInstance()->GetAlbums($condition);
			foreach ($albums as $item) {
				$sqlParamIndex = ++$sqlParamCount;
				$itemRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
				$query .= " OR path LIKE ? {$this->escapeStr}";
				$queryVideo.= " OR path LIKE ? {$this->escapeStr}";
				$sqlParam[] = "{$itemRealPath}/%";
			}
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);

			$dbVideoResult = $this->_dbh->prepare($queryVideo.' )'.$this->video_convert_type_condition);
			$dbVideoResult->execute($sqlParam);
		}
		$row = $dbResult->fetch();
		$photoCount = $row[0];
		$row = $dbVideoResult->fetch();
		$videoCount = $row[0];

		$result[$isIncludeSubDir] = $photoCount + $videoCount;
		$_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName] = $result;
		return $result[$isIncludeSubDir];
	}
	/*!
	 * Check if album is uploadable by current login user
	 *
	 * \param $albumName album name
	 * \return true if the album is uploadable for the user
	 */
	function IsAlbumUploadable($albumName)
	{
		if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			return true;
		}

		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
			return false;
		}

		$sharename = $albumName;
		if(strstr($sharename, '/')) {
			$arr = explode('/', $sharename);
			$sharename = $arr[0].'/'.$arr[1];
		}
		return isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album'][$sharename]);
	}

	/*!
	 * Get album information
	 *
	 * \param $albumName album name
	 * \return array with album info
	 *	- name: folder name
	 *	- title: user-defined title
	 *	- description: user-defined description
	 *	- hits: album hits
	 *	- showTitle: title or name when title is empty
	 *	- photos: # of photos in all alubms in the album
	 *	- link: link to browse the album
	 */
	function GetAlbumInfo($albumName)
	{
		if (false === strpos($albumName, '/')) {
			// 1st level album
			$item = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
			$result['name'] = $item['sharename'];
			$result['title'] = $item['title'];
			$result['desc'] = $item['description'];
			$isPublic = $item['public'];
			$result['hit'] = $item['hits'];
			$result['dirName'] = $item['sharename'];
			$result['photos'] = 0;//for DSM bug#21213
		} else {
			$tok = explode('/', $albumName);
			if (2 == count($tok)) {
				// 2nd level album
				$item = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
				$result['name'] = $item['sharename'];
				$result['title'] = $item['title'];
				$result['desc'] = $item['description'];
				$isPublic = $item['public'];
				$result['hit'] = $item['hits'];
				$result['dirName'] = $tok[1];
			} else {
				$result['name'] = $albumName;
				$result['title'] = '';
				$result['desc'] = '';
				$isPublic = false; // dummy data
				$result['hit'] = 0;
				$result['dirName'] = $tok[count($tok)-1];
			}
			$result['photos'] = 0;//for DSM bug#21213
		}

		$result['permissionType'] = $item['password'] ? SYNOPHOTO_ALBUM_PASSWORD : ($isPublic ? SYNOPHOTO_ALBUM_PUBLIC : SYNOPHOTO_ALBUM_PRIVATE);
		$result['showTitle'] = empty($result['title']) ? $result['dirName'] : $result['title'];
		$result['dir'] = bin2hex($albumName);
		$result['uploadable'] = $this->IsAlbumUploadable($albumName);

		return $result;
	}
	/*!
	 * Get mos recentalbum information
	 *
	 * \param $source most recent source. Photo or video.
	 * \return array with album info
	 *	- name: folder name
	 *	- title: user-defined title
	 *	- description: user-defined description
	 *	- hits: album hits
	 *	- showTitle: title or name when title is empty
	 *	- photos: # of photos in all alubms in the album
	 *	- link: link to browse the album
	 */
	function GetMostRecentAlbumInfo($source)
	{
		if ('photo' == $source) {
			$title = "[__MostRecentPhotos__]";
		} else {
			$title = "[__MostRecentVideos__]";
		}
		$result['name'] = '';
		$result['title'] = $title;
		$result['desc'] = '';
		$result['isPublic'] = TRUE;
		$result['hit'] = 0;
		$result['dirName'] = '';

		$result['showTitle'] = '';
		$result['dir'] = '';
		$result['uploadable'] = FALSE;

		return $result;
	}
	/*!
	 * add album hit times
	 *
	 * \param $albumName album name
	 */
	function AddHitTimes($albumName)
	{
		$albumToken = explode('/', $albumName);
		/* hit apply to at most 2 level sub-dir */
		if (count($albumToken) > 2) {
			$albumName = "{$albumToken[0]}/{$albumToken[1]}";
		}
		/* hit one time for each session */
		if (!in_array($albumName, $_SESSION[SYNOPHOTO_ADMIN_USER]['accessed_albums'], true)) {
			array_push($_SESSION[SYNOPHOTO_ADMIN_USER]['accessed_albums'], $albumName);
			$query = "UPDATE photo_share SET hits=hits+1 WHERE sharename=?";
			$sqlParam = array($albumName);
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
			$albumInfo = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) && ('f' == $albumInfo['public'] || false == $albumInfo['public'])) {
				$msg = "{$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']} accessed photo album [".htmlspecialchars($albumName).']';
				csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($msg, 1, $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']);
			}
		}
	}
	/*!
	 * edit album's property
	 *
	 * \param $shareName album share name
	 * \param $title album's new title
	 * \param $description album's new description
	 * \param $albumPersmission album's new permission. 0:public 1:private 2:keyword
	 * \param $password album's new password.
	 */
	function EditAlbumProperty($shareName, $title, $description, $albumPersmission, $password)
	{
		$passwordEncoded = ('' != $password) ? md5($password) : null;
		$result = csSYNOPhotoDB::GetDBInstance()->UpdateAlbumProperty($shareName, $title, $description, $albumPersmission, $passwordEncoded);
		// flush the cache since album property has been changed
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
		return $result;
	}
	/*!
	 * Add new created album into DB
	 *
	 * \param $parentPath parent album's path
	 * \param $albumName new created album's name
	 * \param $albumPermission 0:public 1:private 2:passsword protected
	 * \param $password password of album
	 */
	function AddNewAlbumIntoDB($parentPath, $albumName, $albumPermission, $password)
	{
		$isPublic = (SYNOPHOTO_ALBUM_PUBLIC == $albumPermission) ? true : false;

		$passwordEncoded = ('' != $password) ? md5($password) : null;
		if (empty($parentPath)) {
			csSYNOPhotoDB::GetDBInstance()->AddTopAlbumIntoDB($albumName, $isPublic, $passwordEncoded);
		} else if (!strstr($parentPath, '/')) {
			csSYNOPhotoDB::GetDBInstance()->AddSubAlbumIntoDB($parentPath, $albumName, $isPublic, $passwordEncoded);
		}

		return true;

	}

	function GetAlbumThumbSortType($albumName)
	{
		$result = '';

		$fullDirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_DIR, $albumName);
		if (false === SYNOPhotoEA::checkFilePath($fullDirPath, SYNOPhotoEA::FILE_ALBUM_SORT, $sortFile)) {
			return '';
		}
		if (false === ($result = @file_get_contents($sortFile))) {
			return '';
		}

		$result = json_decode($result, true);
		if (empty($result)) {
			return '';
		}
		return $result;
	}

	function GetLabelAlbumTitle($category)
	{
		switch ($category) {
			case 0:
				$title = 'photo_str_person_label';
				break;
			case 1:
				$title = 'photo_str_place_label';
				break;
			case 2:
				$title = 'photo_str_general_label';
				break;
		}
		return $title;
	}

	function GetLabelAlbumInfoFirst($category)
	{
		$result['dir'] = $category;
		$result['name'] = '';
		$result['title'] = $this->GetLabelAlbumTitle($category);
		$result['desc'] = '';
		$result['isPublic'] = TRUE;
		$result['hit'] = 0;
		$result['dirName'] = '';

		$result['showTitle'] = $this->GetLabelAlbumTitle($category);
		$result['uploadable'] = FALSE;
		$result['isVirtual'] = true;
		$result['isLabelVirtual'] = true;

		return $result;
	}

	function GetLabelAlbumInfo($category, $tagName, $id)
	{
		$title = $tagName;
		$result['dir'] = $id;
		$result['labelId'] = $id;
		$result['labelCategory'] = $category;
		$result['name'] = '';
		$result['title'] = $title;
		$result['desc'] = '';
		$result['isPublic'] = TRUE;
		$result['hit'] = 0;
		$result['dirName'] = '';

		$result['showTitle'] = htmlspecialchars($title, ENT_QUOTES);
		$result['uploadable'] = FALSE;
		$result['isVirtual'] = true;
		$result['isLabelVirtual'] = true;

		return $result;
	}

	function GetLabelAlbumCoverFromDB($id)
	{
		$sqlParam = array();
		if (-1 == $id) {
			$photoQuery = "SELECT path, resolutionx, resolutiony, version FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE photo_image_label.status='f' ORDER BY photo_image.create_time DESC LIMIT 1";
			$dbPhotoResult = $this->_dbh->prepare($photoQuery);
			$tt = $dbPhotoResult->execute($sqlParam);
			if($row = $dbPhotoResult->fetch()) {
				$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
				return $row;
			}
			return null;
		}

		$photoQuery = "SELECT path, resolutionx, resolutiony, version FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE photo_image_label.label_id=? AND photo_image_label.status='t'";
		$videoQuery = "SELECT path, resolutionx, resolutiony FROM photo_video_label LEFT JOIN video ON photo_video_label.video_path=video.path WHERE photo_video_label.label_id=? ";

		$sqlParam[] = $id;
		if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
			if(count($albumCondition['albumCond']) > 0) {
				$photoQuery .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
				$videoQuery .= ' AND ('.implode(' OR ', $albumCondition['albumCond']).' )';
				$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
			} else {
				return null;
			}
		}

		$photoQuery .= " ORDER BY photo_image.create_time DESC LIMIT 1";
		$videoQuery .= " ORDER BY video.date DESC LIMIT 1";

		$dbPhotoResult = $this->_dbh->prepare($photoQuery);
		$tt = $dbPhotoResult->execute($sqlParam);
		if($row = $dbPhotoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			return $row;
		}

		$dbPhotoResult = $this->_dbh->prepare($videoQuery);
		$tt = $dbPhotoResult->execute($sqlParam);
		if($row = $dbPhotoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			return $row;
		}
		return null;
	}

	function GetLabelAlbumCover($id)
	{
		$coverFile = $this->GetLabelAlbumCoverFromDB($id);
		$result = null;
		if (-1 == $id && empty($coverFile)) {
			return $result;
		} else if (empty($coverFile)) {
			$result['bigCover']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$imageInfoCover = @getImageSize(SYNOPHOTO_IMG_EMPTY_FILE_PATH_HIGH_QUALITY);
			$result['bigCover']['width'] = $imageInfoCover[0];
			$result['bigCover']['height'] = $imageInfoCover[1];
			$result['cover']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$result['cover']['width'] = $imageInfoCover[0];
			$result['cover']['height'] = $imageInfoCover[1];
		} else if (is_array($coverFile) && isSet($coverFile['version'])) {
			// thumb is from photo file
			$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
			$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBSMALL, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
		} else if (is_array($coverFile) && !isSet($coverFile['version'])) {
			// thumb is from video file
			$result['bigCover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, $coverFile['resolutionx'], $coverFile['resolutiony']);
			$result['cover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBSMALL, $coverFile['resolutionx'], $coverFile['resolutiony']);
		}

		return $result;
	}
}
?>
