<?php
require_once('synophoto_mobile_conf.php');

function SYNOPHOTO_GPS_UTIL_EXIF_SUPPORTED($filePath)
{
	$ext = strtolower(end(explode('.', $filePath)));
	if (!in_array($ext, array('jpg','jpeg','jpe','tif','tiff','nef'))) {
		return false;
	}

	$type = @exif_imagetype($filePath);
	switch ($type) {
	case IMAGETYPE_JPEG:
	case IMAGETYPE_JP2:
	case IMAGETYPE_TIFF_II:
	case IMAGETYPE_TIFF_MM:
		return true;
	}
	return false;
}

function SYNOPHOTO_GPS_UTIL_GetURational($str)
{
	if (!is_string($str)) {
		return $str;
	}
	list($dividend, $divider) = @explode('/', $str);
	if (!$divider) {
		return 0;
	}
	return $dividend / $divider;
}

function SYNOPHOTO_GPS_UTIL_GETGPSFromFile($filePath)
{
	$exif = @exif_read_data($filePath, 'GPS', true);
	if (!$exif || !$exif["GPS"]["GPSLatitudeRef"] || !$exif["GPS"]["GPSLongitudeRef"]) {
		return NULL;
	}

	// Bug #19264: Fix the problem that Photo Shop will make GPSLongitudeRef be null.
	if ($exif["GPS"]["GPSLatitudeRef"] && !$exif["GPS"]["GPSLongitudeRef"]) {
		$cmd = sprintf('%s -g Exif.GPSInfo.GPSLongitudeRef -Pt %s', SYNO_EXIFTOOL_FILE, escapeshellarg($filePath));
		$result = exec($cmd);
		if (NULL == $result || "" == $result) {
			return NULL;
		}
		$exif["GPS"]["GPSLongitudeRef"] = substr(trim($result), 0, 1);
	} else if (!$exif["GPS"]["GPSLatitudeRef"] && $exif["GPS"]["GPSLongitudeRef"]) {
		$cmd = sprintf('%s -g Exif.GPSInfo.GPSLatitudeRef -Pt %s', SYNO_EXIFTOOL_FILE, escapeshellarg($filePath));
		$result = exec($cmd);
		if (NULL == $result || "" == $result) {
			return NULL;
		}
		$exif["GPS"]["GPSLatitudeRef"] = substr(trim($result), 0, 1);
	}

	$latRef = $exif["GPS"]["GPSLatitudeRef"];
	$lad = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"]["GPSLatitude"][0]);
	$lam = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"]["GPSLatitude"][1]);
	$las = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"]["GPSLatitude"][2]);

	$lngRef = $exif["GPS"]["GPSLongitudeRef"];
	$lnd = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"]["GPSLongitude"][0]);
	$lnm = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"]["GPSLongitude"][1]);
	$lns = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"]["GPSLongitude"][2]);

	$lat = ($latRef == 'N' ? 1.0 : -1.0) * ($lad + ($lam + $las/60.0) / 60.0);
	$lng = ($lngRef == 'E' ? 1.0 : -1.0) * ($lnd + ($lnm + $lns/60.0) / 60.0);
	return array('lat' => $lat, 'lng' => $lng);
}

function SYNOPHOTO_GPS_UTIL_GetGPSFromEADir($filePath)
{
	$result = NULL;
	SYNOPhotoEA::checkFilePath($filePath, SYNOPhotoEA::FILE_GPS, $gpsFilePath);
	$data = @file_get_contents($gpsFilePath);
	if ($data) {
		$data = json_decode($data);
		$result = array('lat' => $data->lat, 'lng' => $data->lng);
	}
	return $result;
}

function SYNOPHOTO_GPS_UTIL_SetGPSToFile($filePath, $lat, $lng)
{
	$cmd = sprintf('%s -M "set Exif.GPSInfo.GPSLatitude %s" '.
				   '-M "set Exif.GPSInfo.GPSLongitude %s" '.
				   '-M "set Exif.GPSInfo.GPSMapDatum WGS-84" '.
				   '-M "set Exif.GPSInfo.GPSLatitudeRef %s" '.
				   '-M "set Exif.GPSInfo.GPSLongitudeRef %s" %s 2>&1',
				   '/usr/syno/bin/exiv2',
				   SYNOPHOTO_GPS_UTIL_Dec_2_Deg($lat),
				   SYNOPHOTO_GPS_UTIL_Dec_2_Deg($lng),
				   ($lat >= 0 ? 'N' : 'S'),
				   ($lng >= 0 ? 'E' : 'W'), escapeshellarg($filePath));

	@exec($cmd);
	@chmod($filePath, 0777);

	//update mtime of all thumbnails for prevent from re-making thumbnail
	$cmd = sprintf('/usr/syno/bin/synophoto_dsm_user --updatethumbnailmtime %s', escapeshellarg($filePath));
	@exec($cmd);
}

//Decimal to Degrees, Minutes & Seconds
function SYNOPHOTO_GPS_UTIL_Dec_2_Deg($decValue)
{
	$decValue = abs($decValue);
	$degree = intval($decValue);
	$minutes = ($decValue - $degree) * 60;
	$seconds = ($minutes - intval($minutes)) * 60;
	$result = "$degree/1 ".intval($minutes).'/1 '.intval($seconds*1000).'/1000';
	return $result;
}

function SYNOPHOTO_GPS_UTIL_SetEXIFToFile($filePath, $EXIFKey, $EXIFValue)
{
	$cmd = sprintf('%s -M "set %s %s " %s 2>&1',
			SYNO_EXIFTOOL_FILE,
			$EXIFKey, $EXIFValue,
			escapeshellarg($filePath));

	@exec($cmd);
	@chmod($filePath, 0777);
}

function SYNOPHOTO_GPS_UTIL_SetBatchEXIFToFile($filePath, $make, $model, $createDate, $dateTimeOrig)
{
	$cmd = sprintf('%s -M "set Exif.Image.Make %s" '.
				   '-M "set Exif.Image.Model %s" '.
				   '-M "set Exif.Photo.DateTimeOriginal %s" '.
				   '-M "set Exif.Photo.DateTimeDigitized %s" %s 2>&1',
			SYNO_EXIFTOOL_FILE,
			$make, $model,
			$createDate, $dateTimeOrig,
			escapeshellarg($filePath));

	@exec($cmd);
	@chmod($filePath, 0777);
}

function SYNOPHOTO_GPS_UTIL_SetGPSToEADir($filePath, $lat, $lng)
{
	$eaDir = '';

	SYNOPhotoEA::createEADir($filePath, $eaDir);
	$gpsFilePath = sprintf("%s/%s", $eaDir, SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_GPS, csSYNOPhotoMisc::IsOldEAFilePrefix()));

	@file_put_contents($gpsFilePath, json_encode(array('lat' => $lat, 'lng' => $lng)));
	@chmod($gpsFilePath, 0777);
}

function SYNOPHOTO_GPS_UTIL_SetGPSLatLng($filePath, $lat, $lng)
{
	csSYNOPhotoDB::GetDBInstance()->SetGPSToDB($filePath, $lat, $lng);
	if (SYNOPHOTO_GPS_UTIL_EXIF_SUPPORTED($filePath)) {
		SYNOPHOTO_GPS_UTIL_SetGPSToFile($filePath, $lat, $lng);
	} else {
		SYNOPHOTO_GPS_UTIL_SetGPSToEADir($filePath, $lat, $lng);
	}
	return csSYNOPhotoDB::GetDBInstance()->GetGPSLatLng($filePath);
}

function SYNOPHOTO_GPS_UTIL_GPSEqual($coor1, $coor2)
{
	if (is_array($coor1) && is_array($coor2) &&
		abs($coor1['lat'] - $coor2['lat']) < 0.000001 &&
		abs($coor1['lng'] - $coor2['lng']) < 0.000001) {
		return true;
	}
	return false;
}
?>
