<?php
/*!
 * album list operation
 */
class csSYNOPhotoAlbum {
	/*! reference to db handler */
	private $_dbh;
	public $escapeStr;
	/*! reference to a self instance */
	private static $instance = null;
	/*!
	 * Constructor
	 */
	function __construct()
	{
		$this->_dbh = csSYNOPhotoDB::GetDBInstance()->_dbh;
		$this->escapeStr = csSYNOPhotoDB::GetDBInstance()->escapeStr;
	}
	/*!
	 * Get a exist instance
	 */
	static function GetAlbumInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get the user-defined album cover for the sub-dir $albumName
	 *
	 * \param $albumName the sub-dir album name
	 * \return cover file path
	 */
	private function GetSubAlbumCover($albumName)
	{
		$result = '';

		$fullDirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_DIR, $albumName);
		if (false === SYNOPhotoEA::checkFilePath($fullDirPath, SYNOPhotoEA::FILE_ALBUM_COVER, $coverFile)) {
			return '';
		}
		if (false === ($result = @file_get_contents($coverFile))) {
			return '';
		}

		$result = trim(SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/".$result);
		if (!@is_file($result)) {
			$result = '';
		}

		return $result;
	}
	/*!
	 * pick the latest upload image in the album as cover
	 *
	 * \param $albumName the album name
	 * \return cover file path
	 */
	private function GetAlbumCoverLatestUpload($albumName)
	{
		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$querySub = "SELECT path,resolutionx,resolutiony,version FROM photo_image WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY create_time DESC LIMIT 1";
		$queryAll = "SELECT path,resolutionx,resolutiony,version FROM photo_image WHERE path LIKE ? {$this->escapeStr} ORDER BY date DESC LIMIT 1";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$result = '';

		$dbResult = $this->_dbh->prepare($querySub);
		$dbResult->execute($sqlParam);
        $row = $dbResult->fetch();

		/* no photo in the album*/
		if (false === $row) {
			/* search each sub-dir for top album */
			if (false === strpos($albumName, '/')) {
				$condition = array('sharename' => array('op' => 'PREFIX', 'value' => $albumName.'/'));
				$albums = csSYNOPhotoDB::GetDBInstance()->GetAlbums($condition);
				foreach ($albums as $album) {
					if (true !== csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($album['sharename'], '')) {
						continue;
					}
					$result = $this->GetAlbumCoverLatestUpload($album['sharename']);
					if (!empty($result)) {
						break;
					}
				}
				return $result;
			}
			/* pick one photo in the album and its sub-dir */
			$dbResult = $this->_dbh->prepare($queryAll);
			$dbResult->execute(array($sqlParam[0]));
			$row = $dbResult->fetch();
		}
		if(!empty($row)) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		}
		return $row;
	}
	/*!
	 * Get cover for album $albumName
	 *
	 * \param $albumName the album name
	 * \return array with cover info
	 *	- src: cover file path
	 *	- width: cover width
	 *	- height: cover height
	 */
	function GetAlbumCover($albumName)
	{
		//Show lock icon when the album is locked
		$album = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
		if ($album['password'] && true !== csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($albumName, '')) {
			$result['src'] = SYNOPHOTO_IMG_LOCKED;
			$imageInfoCover = @getImageSize(SYNOPHOTO_IMG_LOCKED_FILE_PATH);
			$result['width'] = $imageInfoCover[0];
			$result['height'] = $imageInfoCover[1];
			return $result;
		}

		if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['albumCover_cache'][$albumName])) {
			/* get user-defined cover */
			$coverFile = $this->GetSubAlbumCover($albumName);

			if (!empty($coverFile)) {
				$isPhotoFileWithThumb = csSYNOPhotoMisc::IsPhotoFileWithThumb($coverFile);
				if ($isPhotoFileWithThumb) {
					$filePath = csSYNOPhotoMisc::GetThumbPathFromFullPath($coverFile, false, false);
				} else {
					$filePath = $coverFile;
				}

				if (!csSYNOPhotoMisc::IsPhotoFile($coverFile) ||
					!@file_exists($filePath) ||
					true !== csSYNOPhotoDB::GetDBInstance()->CheckPathAccessible($coverFile)) {
					$coverFile = '';
				}
			}

			/* use latest upload photo as cover */
			if (empty($coverFile)) {
				$coverFile = $this->GetAlbumCoverLatestUpload($albumName);
			}
			$_SESSION[SYNOPHOTO_ADMIN_USER]['albumCover_cache'][$albumName] = $coverFile;
		}

		$coverFile = $_SESSION[SYNOPHOTO_ADMIN_USER]['albumCover_cache'][$albumName];
		/* use empty image */
		$result = array();
		if (empty($coverFile)) {
			$result['src'] = SYNOPHOTO_IMG_EMPTY;
			$imageInfo = @getImageSize(SYNOPHOTO_IMG_EMPTY_FILE_PATH);
			$result['width'] = $imageInfo[0];
			$result['height'] = $imageInfo[1];
		} else if (is_array($coverFile)) {
			$result = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], false, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
		} else {
			$result = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile, false, 0, 0, -1);
		}
		return $result;
	}
	/*!
	 * Get # of photos in the album
	 *
	 * \param $albumName the album name
	 * \param $isIncludeSubDir the # of photos include all sub-dir or not
	 * \return the # of photos
	 */
	function GetNumberOfPhotos($albumName, $isIncludeSubDir)
	{
        $result = array(true => false, false => false);
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName])) {
			$counted = $_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName];
			$result[true] = isSet($counted[true]) ? $counted[true] : false;
			$result[false] = isSet($counted[false]) ? $counted[false] : false;
		}
		if (false !== $result[$isIncludeSubDir]) {
			return $result[$isIncludeSubDir];
		}

		$sqlParam = array();
		$query = "SELECT count(*) FROM photo_image WHERE (path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr})";
		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$sqlParam[] = "{$albumRealPath}/%";
		$sqlParam[] = "{$albumRealPath}/%/%";

		if (!$isIncludeSubDir) {
			/* # of photos in the album */
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
		} else {
			/* # of photos in all albums in the album */
			$condition = array('sharename' => array('op' => 'PREFIX', 'value' => $albumName.'/'));
			$albums = csSYNOPhotoDB::GetDBInstance()->GetAlbums($condition);
			foreach ($albums as $item) {
				$itemRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
				$query .= " OR path LIKE ? {$this->escapeStr}";
				$sqlParam[] = "{$itemRealPath}/%";
			}
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
		}
		$row = $dbResult->fetch();
		$result[$isIncludeSubDir] = $row[0];
		$_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName] = $result;
		return $result[$isIncludeSubDir];
	}
	/*!
	 * Get album information
	 *
	 * \param $albumName album name
	 * \return array with album info
	 *	- name: folder name
	 *	- title: user-defined title
	 *	- description: user-defined description
	 *	- hits: album hits
	 *	- showTitle: title or name when title is empty
	 *	- photos: # of photos in all alubms in the album
	 *	- link: link to browse the album
	 */
	function GetAlbumInfo($albumName)
	{
		if (false === strpos($albumName, '/')) {
			$item = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
			$result['name'] = $item['sharename'];
			$result['title'] = $item['title'];
			$result['desc'] = $item['description'];
			$result['hit'] = $item['hits'];
		} else {
			$tok = explode('/', $albumName);
			$result['name'] = $albumName;
			$result['title'] = $tok[count($tok)-1];
			$result['desc'] = '';
			$result['hit'] = 0;
		}
		$result['showTitle'] = htmlspecialchars(empty($result['title']) ? $result['name'] : $result['title']);
		$result['link'] = SYNOPHOTO_URL_PREFIX.'/photo/m/photo_album.php?dir='.bin2hex($albumName);

		return $result;
	}
	/*!
	 * add album hit times
	 *
	 * \param $albumName album name
	 */
	function AddHitTimes($albumName)
	{
		$albumToken = explode('/', $albumName);
		/* hit apply to at most 2 level sub-dir */
		if (count($albumToken) > 2) {
			$albumName = "{$albumToken[0]}/{$albumToken[1]}";
		}
		/* hit one time for each session */
		if (!in_array($albumName, $_SESSION[SYNOPHOTO_ADMIN_USER]['accessed_albums'], true)) {
			array_push($_SESSION[SYNOPHOTO_ADMIN_USER]['accessed_albums'], $albumName);
			$query = 'UPDATE photo_share SET hits=hits+1 WHERE sharename=?';
			$sqlParam = array($albumName);
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
			$albumInfo = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) && ('f' == $albumInfo['public'] || false === $albumInfo['public'])) {
				$msg = "{$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']} accessed photo album [".htmlspecialchars($albumName).']';
				csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($msg, 1, $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']);
			}
		}
	}
}
?>
