<?php
// for debug
//error_reporting(E_ALL);
function show($content){$fp = fopen('/tmp/log', 'a');fwrite($fp, json_encode($content));fclose($fp);return true;}

define('SYNO_CNF_FILE', '/etc/synoinfo.conf');
define('SYNO_DEF_CNF_FILE', '/etc.defaults/synoinfo.conf');
define('SYNO_DEF_VERSION_FILE', '/etc.defaults/VERSION');
define('SYNOPHOTO_ADMIN_PASS', 'hlinak3');

define('SYNOPHOTO_MOBILE_ROOT', dirname(__FILE__).'/..');
define('SMARTY_DIR', SYNOPHOTO_MOBILE_ROOT . '/lib/');
define('SYNO_PKG_DIR', '/var/packages/PhotoStation');
define('SYNO_PKG_CNF_FILE', SYNO_PKG_DIR.'/etc/settings.conf');

define('SYNOPHOTO_ROOT', dirname(__FILE__).'/../..');
define('SYNOPHOTO_EADIR', '@eaDir');
define('SYNOPHOTO_LANGS_DIR', SYNOPHOTO_ROOT.'/language');

//Photo Station account system
define('SYNOPHOTO_INDEPENDENT_ACCOUNT', "0");
define('SYNOPHOTO_DSM_ACCOUNT', "1");

//personal photo station
if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
	define('SYNOPHOTO_ADMIN_USER', substr(urldecode($matches[0]), 1));
	define('SYNOPHOTO_ADMIN_NAME', substr(urldecode($matches[0]), 2));
	define('SYNOPHOTO_URL_PREFIX', $matches[0]);
	define('SYNOPHOTO_SERVICE_DIR', '/var/services/homes/'.SYNOPHOTO_ADMIN_NAME.'/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR', @readlink('/var/services/homes').'/'.SYNOPHOTO_ADMIN_NAME.'/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PATH', '');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PREFIX', @readlink('/var/services/homes').'/'.SYNOPHOTO_ADMIN_NAME.'/photo/');
	define('SYNO_PERSONAL_CNF_FILE', '/usr/syno/etc/preference/'.SYNOPHOTO_ADMIN_NAME.'/synoinfo.conf');
} else{//photo station
	define('SYNOPHOTO_ADMIN_USER', 'root');
	define('SYNOPHOTO_ADMIN_NAME', 'root');
	define('SYNOPHOTO_URL_PREFIX', '');
	define('SYNOPHOTO_SERVICE_DIR', '/var/services/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR', @readlink(SYNOPHOTO_SERVICE_DIR));
	define('SYNOPHOTO_SERVICE_REAL_DIR_PATH', @readlink(SYNOPHOTO_SERVICE_DIR).'/');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PREFIX', '');
}

define('SYNOPHOTO_IMAGES_DIR_FULL', SYNOPHOTO_ROOT . '/images');
define('SYNOPHOTO_IMG_EMPTY', '/photo/images/empty.jpg');
define('SYNOPHOTO_IMG_EMPTY_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/empty.jpg');
define('SYNOPHOTO_IMG_LOCKED', '/photo/images/locked_75.png');
define('SYNOPHOTO_IMG_LOCKED_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/locked_75.png');
define('SYNOPHOTO_IMG_BROKEN', '/photo/images/broken.png');
define('SYNOPHOTO_IMG_BROKEN_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/broken.png');
define('SYNOPHOTO_IMG_THUMB', '/photo/images/thumb.gif');
define('SYNOPHOTO_IMG_THUMB_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/thumb.gif');
define('SYNOPHOTO_IMG_THUMB_BIG', '/photo/images/thumb_big.gif');
define('SYNOPHOTO_IMG_THUMB_BIG_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/thumb_big.gif');
define('SYNOPHOTO_IMG_FULL_BIG', '/photo/images/full_big.jpg');
define('SYNOPHOTO_IMG_FULL_BIG_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/full_big.gif');
define('SYNOPHOTO_IMG_FULL', '/photo/images/full.gif');
define('SYNOPHOTO_IMG_FULL_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/full.gif');
define('SYNOPHOTO_IMG_MOVIE', '/photo/images/movie.png');
define('SYNOPHOTO_IMG_MOVIE_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/movie.png');
define('SYNOPHOTO_RSRV_DISK_SPACE', 104857600);	//100*1024*1024 bytes = 100M

define('SYNOPHOTO_THUMB_WIDTH', 71);
define('SYNOPHOTO_THUMB_HEIGHT', 71);
define('SYNOPHOTO_THUMBALBUM_WIDTH', 57);
define('SYNOPHOTO_THUMBALBUM_HEIGHT', 57);
define('SYNOPHOTO_THUMBSMALL_WIDTH', 50);
define('SYNOPHOTO_THUMBSMALL_HEIGHT', 50);
define('SYNOPHOTO_THUMBBIG_WIDTH', 220);
define('SYNOPHOTO_THUMBBIG_HEIGHT', 170);

define('SYNOPHOTO_MAX_LOG_TO_KEEP', 1000);
define('SYNOPHOTO_REC_TO_DEL', 100);

define('ALBUMS_PER_LOAD', 12);
define('PHOTOS_PER_LOAD', 24);
define('COMMENTS_PER_LOAD', 10);

$SYNOPHOTO_ALLOW_PICT_NAMES_EXT = array(
	'jpg', 'jpeg', 'jpe', 'bmp', 'gif', 'png', 'tiff', 'tif',
	// Camera raw files
	"arw", "srf", "sr2", // Sony
	"dcr", "k25", "kdc", // Kodak
	"cr2","crw",// Canon
	"nef", // nikon
	"mrw", // Minolta
	"ptx", "pef",// Pentax
	"raf", // Fuji
	"3fr", // Hasselblad
	"erf", // (Epson)
	"mef", // (Mamiya)
	"mos", // (Leaf)
	"orf", // (Olympus),
	"rw2", // (Panasonic)
	"dng", // Adobe Digital Negative
	"x3f", // Sigma Raw Image
	"raw"  // Panasonic
);
$SYNOPHOTO_ALLOW_ORIG_NAMES_EXT = array('gif');

require_once 'SYNOPhotoEA.php';
require_once('synophoto_mobile_csPhotoMisc.php');
require_once('synophoto_mobile_csPhotoDB.php');
require_once('synophoto_mobile_csPhotoAlbum.php');
require_once('synophoto_mobile_csPhotoThumb.php');
require_once('synophoto_mobile_csPhotoBrowse.php');
require_once(SMARTY_DIR . 'Smarty.class.php');

/*!
 * Get translated localization string
 *
 * \param $string the string to be translated
 * \return the translated string or input string when no translated string found.
 */

function __($string)
{
	include(SYNOPHOTO_LANGS_DIR.'/'.$_SESSION[SYNOPHOTO_ADMIN_USER]['lang'].'.php');
	$pattern = preg_replace('/[^0-9a-z]/i','_', $string);
	if (isSet($$pattern)) {
		return $$pattern;
	}
	$pattern = 'photo_mobile_'.preg_replace('/[^0-9a-z]/i','_', $string);
	if (isSet($$pattern)) {
		return $$pattern;
	}
	return $string;
}

function undoMagicQuotes(&$value)
{
	$value = is_array($value) ? array_map('undoMagicQuotes', $value) :
			 stripslashes($value);
	return $value;
}

function GetSessionIdentifier()
{
	$token = $_SERVER['REMOTE_ADDR'];
	if (isSet($_SERVER["HTTP_X_FORWARDED_FOR"])) {
		$token .= $_SERVER["HTTP_X_FORWARDED_FOR"];
	}
	return $token;
}

function RestoreSession()
{
	if (!isSet($_GET['SESSID'])) {
		return false;
	}

	$sessionDir = session_save_path();
	if (empty($sessionDir)) {
		$sessionDir = sys_get_temp_dir();
	}

	$sessionPath = $sessionDir . '/sess_' . $_GET['SESSID'];
	$serializedSession = @file_get_contents($sessionPath);
	if (empty($serializedSession)) {
		return false;
	}

	/* backup */
	$currIdentifier = $_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'];
	$currSession = session_encode();
	/* restore */
	session_unset();
	if (session_decode($serializedSession)
		&& isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'])
		&& $currIdentifier == $_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier']) {
		return true;
	}
	/* rollback */
	session_unset();
	session_decode($currSession);
	return false;
}

// set umask to 0
@umask(0);

session_start();
if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['forMobile'])) {
	unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
}

$_SESSION[SYNOPHOTO_ADMIN_USER]['forMobile'] = true;
$_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'] = GetSessionIdentifier();
if (isSet($_GET['SESSID'])) {
	RestoreSession();
	/* remove SESSION ID from url */
	$queryString = '?' . $_SERVER['QUERY_STRING'];
	$queryString = preg_replace("/[\?&]SESSID=[^&]+/", "", $queryString);
	header("Location: {$_SERVER['SCRIPT_NAME']}{$queryString}");
	exit;
}

$smarty = new Smarty;
$_SESSION[SYNOPHOTO_ADMIN_USER]['lang'] = csSYNOPhotoDB::GetDBInstance()->GetLanguage();
$_SESSION[SYNOPHOTO_ADMIN_USER]['hideSearch'] = ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'hide_search'));

/* undo escape by magic_quotes */
if ((function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) ||
	(ini_get('magic_quotes_sybase') && ('off' != strtolower(ini_get('magic_quotes_sybase')))) ) {
	undoMagicQuotes($_GET);
	undoMagicQuotes($_POST);
	undoMagicQuotes($_REQUEST);
	undoMagicQuotes($_COOKIE);
}

/* replace netbios name to server address */
if (false !== strpos($_SERVER['HTTP_HOST'], '_')) {
	header("Location: http://{$_SERVER['SERVER_ADDR']}{$_SERVER['REQUEST_URI']}");
	exit;
}

if (!file_exists(SYNOPHOTO_SERVICE_DIR)) {
	header('Location: /photo/report.php?msgkey=photo_str_share_not_found');
	exit;
}

if (!preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
	/* check whether photo service enabled */
	if (!file_exists(SYNO_PKG_DIR.'/enabled')) {
		header('Location: /photo/report.php?msgkey=photo_str_service_disabled');
		exit;
	}
} else{
	if (!file_exists(SYNO_PKG_DIR.'/enabled') ||
		!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runpersonalphotostation']) ||
		'yes' != $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runpersonalphotostation'] ||
		!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation']) ||
		'yes' != $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation']) {
		header('Location: /photo/report.php?msgkey=photo_str_service_disabled');
		exit;
	}
}

/* check logined user exist or not */
if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) && !csSYNOPhotoDB::GetDBInstance()->CheckUserExist($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
	header("Location: {SYNOPHOTO_URL_PREFIX}/photo/report.php?msgkey=photo_str_useracct_removed");
	exit;
}

/* pick a edition according to mobile device */
if (preg_match('/webkit/i', $_SERVER['HTTP_USER_AGENT']) &&
	preg_match('/(iPhone|iPod|Android)/i', $_SERVER['HTTP_USER_AGENT']) ) {
	$_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser'] = 'iPhone';
} else if (preg_match('/(MSIE|IEMobile)/i', $_SERVER['HTTP_USER_AGENT']) ) {
	/* user-agent pattern for browser didn't support css well */
	$_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser'] = 'Old';
} else {
	$_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser'] = 'Mobile';
}

$smarty->template_dir = ('iPhone' == $_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser']) ? './templates/iphone' : './templates/mobile';
$smarty->compile_dir  = '/tmp';
$smarty->compile_id = $_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser'];
if ('Old' == $_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser']) {
	$smarty->assign('isCssBreak', true);
}
?>
