<?php
require_once('../include/synophoto_mobile_conf.php');

if (isSet($_POST['action']) && $_POST['action'] == "login") {
	$username = isSet($_POST['username']) ? $_POST['username'] : '';
	$password = isSet($_POST['passwd']) ? $_POST['passwd'] : '';
	$isValid = false;
	$errText = 'login_failed';

	unset($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'], $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'], $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

    $commend = "/usr/syno/bin/synoautoblock --deny \"".$_SERVER['REMOTE_ADDR']."\"";
    @system($commend, $retval);
    $commend = "";
    if ($retval == 1) {
        $errText = 'login_noprivilege';
    //if username is ADMIN
	} else if ('admin' == strtolower($username) || strtolower(SYNOPHOTO_ADMIN_NAME) == strtolower($username)) {
		if (csSYNOPhotoDB::GetDBInstance()->ValidateAdminPassword($password, SYNOPHOTO_ADMIN_NAME)) {
			$isValid = true;
			$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
            $commend = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
		} else {
            $commend = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
        }
	} else {
		$accountSystem = csSYNOPhotoDB::GetDBInstance()->GetConfig('global', 'account_system');
		if (SYNOPHOTO_INDEPENDENT_ACCOUNT == $accountSystem || 'root' != SYNOPHOTO_ADMIN_USER) {
            $userInfo = csSYNOPhotoDB::GetDBInstance()->GetValidateUserInfo($username, $password);
            if (false !== $userInfo) {
                if (true === $userInfo['disabled'] || 't' == $userInfo['disabled']) {
                    $errText = 'login_disabled';
                } else {
                    $isValid = true;
                    $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = $userInfo['userid'];
                    $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $userInfo['username'];
                    if ('t' == $userInfo['admin'] || true === $userInfo['admin']) {
                        $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
                    }
                    $commend = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
                }
			} else {
                $commend = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
			}
		} else {
            //use DSM account
            if (csSYNOPhotoDB::GetDBInstance()->ValidateAdminPassword($password, $username)) {
                $isValid = true;
                $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = csSYNOPhotoDB::GetDBInstance()->GetDSMUserID($username);
                $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $username;
                $_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'] = true;
				if (csSYNOPhotoDB::GetDBInstance()->IsDSMAdmin($username)) {
					$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
				}
                $commend = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
            } else {
                $commend = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
            }
		}
	}
    if ($commend != "") {
		putenv('SYNOAUTOBLOCK_SERVICE=Photo Station');
		@system($commend, $retval);
		putenv('SYNOAUTOBLOCK_SERVICE');
    }
	$status = $isValid ? 'logged in' : 'failed to login';
	if ('yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['enable_demomode']) {
		$logMsg = "{$username} {$status} from [xxx.xxx.xxx.xxx]";
	} else {
		$logMsg = "{$username} {$status} from [{$_SERVER['REMOTE_ADDR']}]";
	}

	csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($logMsg, $isValid, $username);

	$result = array('success' => $isValid ? true : csSYNOPhotoMisc::GetPhotoText($errText));
	if (isSet($_GET['method']) && 'page' == $_GET['method']) {
		$redirect = $isValid ? SYNOPHOTO_URL_PREFIX.'/photo/m' : SYNOPHOTO_URL_PREFIX.'/photo/m/login.php?success='.urlencode($result['success']);
		header("Location: {$redirect}");
	} else {
		echo json_encode($result);
	}
} else if (isSet($_GET['action']) && $_GET['action'] == "logout") {
	unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
	$redirect = SYNOPHOTO_URL_PREFIX.'/photo/m';
	header("Location: {$redirect}");
}
?>
