<?php
require_once(dirname(__FILE__).'/syno_conf.php');

switch ($_POST['action']) {
case 'get_data':
	echo SYNOPHOTO_TIMELINE_UTIL_GetAllData();
	break;
case 'get_thumb_info':
	echo SYNOPHOTO_TIMELINE_UTIL_GetThumbInfo();
	break;
}

function SYNOPHOTO_TIMELINE_UTIL_GetAllData()
{
	$result = array();
	$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
	if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && count($albumCondition['albumCond']) == 0) {//no accessable dir
		$result['data']['photo'] = array();
		$result['data']['video'] = array();
		$result['success'] = true;
		return json_encode($result);
	}

	$result['data'] = SYNOPHOTO_TIMELINE_UTIL_GetAllPhotoVideoData($albumCondition);
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_TIMELINE_UTIL_GetAllPhotoVideoData($albumCondition)
{
	$result = array();
	$result['photo'] = array();
	$result['video'] = array();
	$sqlParam = array();

	$photoTimeField = $_SESSION[SYNOPHOTO_ADMIN_USER]['timeline_photo_show_time_by'];
	$videoTimeField = $_SESSION[SYNOPHOTO_ADMIN_USER]['timeline_video_show_time_by'];

	$query = "SELECT id, $photoTimeField, gps FROM photo_image ";
	if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && count($albumCondition['albumCond']) > 0) {
		$query .= ' WHERE ('.implode(' OR ', $albumCondition['albumCond']).') ';
		$sqlParam = $albumCondition['sqlParam'];
	}

	$query .= " ORDER BY $photoTimeField, path";

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($rows = $db_result->fetchAll(PDO::FETCH_ASSOC)) {
		$result['photo'] =  $rows;
	}

	$query = "SELECT id, $videoTimeField, gps FROM video ";
	if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && count($albumCondition['albumCond']) > 0) {
		$query .= ' WHERE ('.implode(' OR ', $albumCondition['albumCond']).') ';
	}
	$query .= " ORDER BY $videoTimeField, path";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($rows = $db_result->fetchAll(PDO::FETCH_ASSOC)) {
		$result['video'] =  $rows;
	}

	return $result;
}

function SYNOPHOTO_TIMELINE_UTIL_GetThumbInfo()
{
	$result['success'] = false;
	$result['photoList'] = array();
	$result['videoList'] = array();
	if (!isSet($_POST['photoList']) && !isSet($_POST['videoList'])) {
		return json_encode($result);
	}

	$photoTimeField = $_SESSION[SYNOPHOTO_ADMIN_USER]['timeline_photo_show_time_by'];
	$videoTimeField = $_SESSION[SYNOPHOTO_ADMIN_USER]['timeline_video_show_time_by'];

	$sqlParam = array();
	if ($_POST['photoList'] !== '') {
		$queryCondi = SYNOPHOTO_TIMELINE_UTIL_GetIdListQueryCondition(explode(',', $_POST['photoList']));
		$sqlParam = $queryCondi['sqlParam'];
		$query = 'SELECT * from photo_image WHERE id IN ('.implode(',', $queryCondi['condi']).") ORDER BY $photoTimeField, path";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		while (false !== ($row = $db_result->fetch())) {
			$result['photoList'][] = SYNOPHOTO_TIMELINE_UTIL_CreatePhotoItem($row);
		}
	}
	if ($_POST['videoList'] !== '') {
		$queryCondi = SYNOPHOTO_TIMELINE_UTIL_GetIdListQueryCondition(explode(',', $_POST['videoList']));
		$sqlParam = $queryCondi['sqlParam'];
		$query = 'SELECT * from video WHERE id IN ('.implode(',', $queryCondi['condi']).") ORDER BY $videoTimeField, path";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		while (false !== ($row = $db_result->fetch())) {
			$result['videoList'][] = SYNOPHOTO_TIMELINE_UTIL_CreateVideoItem($row);
		}
	}
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_TIMELINE_UTIL_CreatePhotoItem($data)
{
	$result = array();
	$result['id'] = $data['id'];
	$result['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$data['path'];
	$result['title'] = $data['title'];
	$result['description'] = $data['description'];
	$result['gps'] = json_decode($data['gps']);
	$result['timetaken'] = $data['timetaken'];
	$result['create_time'] = $data['create_time'];
	$result['image'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($result['path'], SYNOPHOTO_THUMBMEDIUM, $data['resolutionx'], $data['resolutiony'], $data['version'], false);
	$result['imageXL'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($result['path'], SYNOPHOTO_THUMBXLARGE, $data['resolutionx'], $data['resolutiony'], $data['version'], false);
	$result['url'] = csSYNOPhotoThumb::GetThumbInstance()->GetItemUrlLink($result['path']);
	$result['isCommentable'] = csSYNOPhotoBrowse::GetBrowseInstance()->isFileCommentable($result['path']);
	$result['itemType'] = 1;
	return $result;
}

function SYNOPHOTO_TIMELINE_UTIL_CreateVideoItem($data)
{
	$result = array();
	if (isSet($data['video.id'])){
		$result['id'] = $data['video.id'];
		$result['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$data['video.path'];
		$result['description'] = $data['video_desc.description'];
	} else {
		$result['id'] = $data['id'];
		$result['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$data['path'];
		$result['description'] = $data['description'];
	}

	$result['title'] = !empty($data['customTitle']) ? $data['customTitle'] : $data['title'];
	$result['image'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($result['path'], SYNOPHOTO_THUMBMEDIUM, $data['resolutionx'], $data['resolutiony'], false);
	$result['imageXL'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($result['path'], SYNOPHOTO_THUMBXLARGE, $data['resolutionx'], $data['resolutiony'], false);
	$result['mdate'] = $data['mdate'];
	$result['date'] = $data['date'];
	$result['gps'] = json_decode($data['gps']);
	$result['video'] = csSYNOPhotoMisc::GetConvertedVideoFileInfoFromFullPath($result['path']);
	$result['url'] = csSYNOPhotoThumb::GetThumbInstance()->GetItemUrlLink($result['path'], (count($result['video'])==0));
	$result['splash_src'] = urlencode(($_SERVER["HTTPS"]?'https':'http')."://".$_SERVER['HTTP_HOST'].$result['imageXL']['src'].'&.jpg');
	if (isSet($result['video']['mp4_orig_src'])) {
		$result['origRotate'] = csSYNOPhotoDB::GetDBInstance()->checkVideoConvertOrigRotate($result['path'], $data['resolutionx']/$data['resolutiony']);
	}
	$result['isCommentable'] = csSYNOPhotoBrowse::GetBrowseInstance()->isFileCommentable($result['path']);
	$result['itemType'] = 2;
	return $result;
}

function SYNOPHOTO_TIMELINE_UTIL_GetIdListQueryCondition($list)
{
	$condi = array();
	$sqlParam = array();
	foreach($list as $id){
		$condi[] = '?';
		$sqlParam[] = $id;
	}
	$result['condi'] = $condi;
	$result['sqlParam'] = $sqlParam;
	return $result;
}

function SYNOPHOTO_TIMELINE_UTIL_GetDBTimeFieldName($type)
{
	$fieldName = ('photo' == $type) ? $_SESSION[SYNOPHOTO_ADMIN_USER]['timeline_photo_show_time_by'] : $_SESSION[SYNOPHOTO_ADMIN_USER]['timeline_video_show_time_by'];
	if ('root' !== SYNOPHOTO_ADMIN_USER){ //personal photp
		return "$fieldName";
	}
	return "CAST($fieldName AS text)";
}

function SYNOPHOTO_TIMELINE_UTIL_GetLabelItemData()
{
	$result = array();
	$result['photo'] = array();
	$result['video'] = array();

	$query = "SELECT label_id, image_id AS id, status AS s from photo_image_label LEFT JOIN photo_label ON photo_image_label.label_id=photo_label.id WHERE photo_label.name != ''";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if ($rows = $db_result->fetchAll(PDO::FETCH_ASSOC | PDO::FETCH_GROUP)) {
		$result['photo'] = $rows;
	}

	$query = 'SELECT label_id, video.id AS id, status from photo_video_label LEFT JOIN video ON video.path=photo_video_label.video_path';
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if ($rows = $db_result->fetchAll(PDO::FETCH_ASSOC | PDO::FETCH_GROUP)) {
		$result['video'] = $rows;
	}

	$query = "SELECT category, id FROM photo_label WHERE name != ''";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if ($rows = $db_result->fetchAll(PDO::FETCH_COLUMN | PDO::FETCH_GROUP)) {
		$result['category'][0] = empty($rows[0]) ? array() : $rows[0];
		$result['category'][1] = empty($rows[1]) ? array() : $rows[1];
		$result['category'][2] = empty($rows[2]) ? array() : $rows[2];
	}
	return $result;
}
?>
