<?php
$type = (array_key_exists('type', $_GET)) ? $_GET['type'] : null;
require_once('syno_conf.php');
/* get the stylesheet tpl */

$stylesheet = '../template/synotheme_' . $type . '.css';
$cv = (array_key_exists('cv', $_GET)) ? $_GET['cv'] :0;


/* set the dynamic information */
$config = SYNOTHENE_GetInitConfig((1 > $cv) ? 'theme_swp':'theme', $type . '_config', $type);
if ($config) {
		if ('1' == $config['show_bkg_img'] && file_exists(SYNOTHEME_BKG_SYNO_FILE)) { //yes
			$maga = @getimagesize(SYNOTHEME_BKG_SYNO_FILE);
		} else if ('2' == $config['show_bkg_img'] && file_exists(SYNOTHEME_BKG_CUSTOM_FILE)) { // yes
			$maga = @getimagesize(SYNOTHEME_BKG_CUSTOM_FILE);
		} else if (strstr($config['show_bkg_img'], 'preview_bkg_custom') && file_exists(SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE)) { // yes
			$maga = @getimagesize(SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE);
		} else if (strstr($config['show_bkg_img'], 'http')) { //yes absolut
			$maga[0] = 1920;
			$maga[1] = 1200;
		}

		$config['bkg_url' ]	="background-attachment: fixed;";
		$config['bkg_url' ]	.="background-position: 50% 0;";

		if ((1 > $cv) && (1920 < min($maga[0], $maga[1]))){
			$config['bkg_url' ]	.="background-size: 100%;";
		}

		$config['grey_font_color'] = ($config['template'] == 'White')? '444444' : 'bbbbbb';
		$config['black_font_color'] = ($config['template'] == 'White')? '222222' : 'ffffff';
		$config['info_box_bg_color'] = ($config['template'] == 'White')? 'ffffff' : '000000';
		$config['blog_banner'] = ($config['template'] == 'White')? '0077cc' : 'ffffff';
		$config['font_disabled'] = ($config['template'] == 'White')? '999999' : '444444';
		$config['photo_border_color'] = ($config['template'] == 'White')? '777777' : 'bbbbbb';
		$config['desc_color'] = ($config['template'] == 'White')? '666666' : 'aaaaaa';
		$config['empty_desc_color'] = ($config['template'] == 'White')? 'aaaaaa' : '777777';
		$config['_0099ff'] = ($config['template'] == 'White')? '0099ff' : '4ce1ff';
		$config['_005599'] = ($config['template'] == 'White')? '005599' : '1386bf';
		$config['_aaaaaa'] = ($config['template'] == 'White')? 'aaaaaa' : '333333';
		$config['_0077cc'] = ($config['template'] == 'White')? '0077cc' : '40bfff';
		$config['_d9213f'] = ($config['template'] == 'White')? 'd9213f' : 'bf1330';
		$config['_f24965'] = ($config['template'] == 'White')? 'f24965' : 'e53956';
		$config['_a60823'] = ($config['template'] == 'White')? 'a60823' : 'a6001c';
		$config['_ffffff'] = ($config['template'] == 'White')? 'ffffff' : '222222';
		$config['_406080'] = ($config['template'] == 'White')? '406080' : 'ffffff';
		$config['_999999'] = ($config['template'] == 'White')? '999999' : '000000';
		$config['_777777'] = ($config['template'] == 'White')? '777777' : 'ffffff';
		$config['_969ba0'] = ($config['template'] == 'White')? '969ba0' : '32373c';
		$config['_dce1e6'] = ($config['template'] == 'White')? 'dce1e6' : '282d32';
		$config['_78828c'] = ($config['template'] == 'White')? '78828c' : '646e78';
		$config['_2f8c00'] = ($config['template'] == 'White')? '2f8c00' : '267300';


		$config['path_link_color'] = ('0077cc' == $config['font_color']) ? $config['black_font_color'] : $config['font_color'];
		$config['header_link_color'] = ('0077cc' == $config['font_color']) ? $config['grey_font_color'] : $config['font_color'];
		$config['font_color'] = ('0077cc' == $config['font_color']) ? $config['_0077cc'] : $config['font_color'];

		if (false == $config['font_color_hover'] =  SYNOTHEME_calculateHoverClickColorCode($config['font_color'], 'hover')) {
			$config['font_color_hover'] = $config['_0099ff'];
		}

		if (false == $config['font_color_click'] =  SYNOTHEME_calculateHoverClickColorCode($config['font_color'], 'click')) {
			$config['font_color_click'] = $config['_005599'];
		}

		if (false == $config['path_link_color_hover'] =  SYNOTHEME_calculateHoverClickColorCode($config['path_link_color'], 'hover')) {
			$config['path_link_color_hover'] = $config['_0099ff'];
		}

		if (false == $config['path_link_color_click'] =  SYNOTHEME_calculateHoverClickColorCode($config['path_link_color'], 'click')) {
			$config['path_link_color_click'] = $config['_005599'];
		}

		$config['path_link_color'] = $config['black_font_color'];
		// will be output as css
		header('Content-type: text/css');
		extract($config);

		$content = preg_replace('/\{\$([\w]+)\}/e','\$$1',@file_get_contents($stylesheet));

		$custom_css = (1 > $cv) ? SYNOTHEME_CSS_CUSTOM_EDIT_FILE : SYNOTHEME_CSS_CUSTOM_FILE;
		if (file_exists($custom_css)) {
			$content .= "\n\n".file_get_contents($custom_css);
		}

		echo $content;
}



function SYNOTHENE_GetInitConfig($mode, $sql, $type) {
	global $SYNOTHEME_CONFIG;
	$CONFIG_DEFAULT = $SYNOTHEME_CONFIG[$type]["White"];
	$config = array();
	foreach ($CONFIG_DEFAULT as $key => $value) {
		if (null == $tmp_value = csSYNOPhotoMisc::GetConfigDB($mode, $key, $sql)) {
			$config[$key] = $value;
		} else {
			$config[$key] = $tmp_value;
		}
		if (null == $tmp_value && !strcmp('theme', $mode) && isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) &&
				$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] == SYNOPHOTO_ADMIN_PASS ) {
			csSYNOPhotoMisc::UpdateConfigDB('theme', $key, $value, $sql);
		}
	}
	return $config;
}

function SYNOTHEME_calculateHoverClickColorCode($in, $type) {
	if (6 != strlen($in) || !strcasecmp('000000', $in) || !strcasecmp('ffffff', $in)) {
		return false;
	}

	$vals['r'] = hexdec( substr($in, 0, 2) );
	$vals['g'] = hexdec( substr($in, 2, 2) );
	$vals['b'] = hexdec( substr($in, 4, 2) );

	foreach( $vals as $val ) {
		if (!strcasecmp('hover', $type)) {
			$val = (221 > $val) ? $val + 34 : 255;
		}
		if (!strcasecmp('click', $type)) {
			$val = (34 < $val) ? $val - 34 : 35;
		}
		$out .= str_pad(dechex($val), 2, '0', STR_PAD_LEFT);
	}

	return $out;
}

?>
