<?php

require_once(SYNOPHOTO_INCLUDE_GPS_UTIL);
require_once(SYNOPHOTO_INCLUDE_LABEL_UTIL);
/*!
 * thumb list operation
 */
class csSYNOPhotoThumb {
	/*! reference to a self instance */
	private static $instance = null;
	/*!
	 * Get a exist instance
	 */
	static function GetThumbInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get thumb info for specified photo
	 *
	 * \param $item array with photo info
	 *	- path: photo file path
	 *	- resolutionx: photo width
	 *	- resolutiony: photo height
	 *	- version: photo orientation
	 * \return array with thumb info
	 *	- cover: cover info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *  - bigThumb: big thumb info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *	- link: link to view the photo
	 */
	function GetThumbInfo($item, $isForSlideShow = false, $isForSlideModule = false, $thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE)
	{
		$isPhotoFile = csSYNOPhotoMisc::IsPhotoFile($item['path']);
		if (!$isPhotoFile) {
			return array();
		}
		$result['id'] = $item['id'];
		$result['path'] = $item['path'];
		$result['gps'] = json_decode($item['gps']);
		$result['title'] = htmlspecialchars($item['title'], ENT_QUOTES);
		$result['name'] = htmlspecialchars($item['name'], ENT_QUOTES);
		$result['desc'] = htmlspecialchars($item['description'], ENT_QUOTES);
		$result['url'] = $this->GetItemUrlLink($item['path']);
		if ($isForSlideShow) {
			$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBSMALL, $item['resolutionx'], $item['resolutiony'], $item['version']);
			$result['xLargeThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBXLARGE, $item['resolutionx'], $item['resolutiony'], $item['version']);
			return $result;
		}

		if ($isForSlideModule) {
			$result['url'] = $this->GetItemUrlLink($item['path']);
			$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBMEDIUM, $item['resolutionx'], $item['resolutiony'], $item['version']);
			return $result;
		}

		if (!$isForSlideShow && !$isForSlideModule) {
			$result['resolutionx'] = $item['resolutionx'];
			$result['resolutiony'] = $item['resolutiony'];
            $result['size'] = $item['size'];
			$result['timetaken'] = $item['timetaken'];
            $result['createdate'] = $item['create_time'];
			$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBSMALL, $item['resolutionx'], $item['resolutiony'], $item['version']);
			$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBMEDIUM, $item['resolutionx'], $item['resolutiony'], $item['version']);
			$result['bigCover']['style'] = csSYNOPhotoMisc::GetThumbStyle($result['bigCover'], $thumbSize, (1 == $_SESSION[SYNOPHOTO_ADMIN_USER]['layout_type']));
			$result['largeThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBLARGE, $item['resolutionx'], $item['resolutiony'], $item['version']);
			$result['xLargeThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBXLARGE, $item['resolutionx'], $item['resolutiony'], $item['version']);
			$result['isCommentable'] = csSYNOPhotoBrowse::GetBrowseInstance()->isFileCommentable($item['path']);
			$result['canRotate'] = csSYNOPhotoMisc::IsPhotoFileWithThumb($item['path']);
			$result['info'] = self::GetPhotoThumbInfoSummary($item);
			$result['label'] = SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($item['id']);
            $result['version'] = $item['version'];
		}
		return $result;
	}

	function GetPhotoThumbInfoSummary($item)
	{
		$result['info_0'] = htmlspecialchars(basename($item['path']), ENT_QUOTES);//name
		$result['info_1'] = round($item['size']/1024)."	KB";//size
		if($item['resolutionx'] == 0 && $item['resolutiony'] ==	0) {
			$result['info_2'] = '';
		} else {
			$result['info_2'] = $item['resolutionx'].' x '.$item['resolutiony'];
		}
		$result['info_3'] = $item['timetaken'];
		$result['info_4'] = $item['camera_make'];
		$result['info_5'] = $item['camera_model'];
		$result['info_6'] = $item['exposure'];
		$result['info_7'] = $item['aperture'];
		$result['info_8'] = $item['iso'];//iso
		if ($item['iso'] == 0) {
			$result['info_8'] = '';
		}
		return $result;
	}
		/*!
	 * Get thumb info for specified video
	 *
	 * \param $item array with video info
	 *	- path: video file path
	 *	- resolutionx: video width
	 *	- resolutiony: video height
	 *
	 * \return array with thumb info
	 *	- cover: cover info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *  - bigThumb: big thumb info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *	- link: link to view the photo
	 */
	function GetVideoThumbInfo($item, $isForSlideShow = false, $thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE)
	{
		// charlie temp - maybe need to check if video extension name ex '.rm' is valid
		$dir = substr($item['path'], strlen(SYNOPHOTO_SERVICE_REAL_DIR.'/'), strlen($item['path']) - strlen(basename($item['path'])) - strlen(SYNOPHOTO_SERVICE_REAL_DIR.'/') - 1);
		$result['path'] = $item['path'];
        $result['name'] = basename($item['path']);
		$result['id'] = $item['id'];
		$result['gps'] = json_decode($item['gps']);
		$customTitleDesc = csSYNOPhotoDB::GetDBInstance()->GetVideoCustomizedTitleDescription($item['path']);
		if (empty($customTitleDesc['title'])) {
			$result['title'] = htmlspecialchars($item['title'], ENT_QUOTES);
		} else {
			$result['title'] = htmlspecialchars($customTitleDesc['title'], ENT_QUOTES);
		}
		$result['desc'] = htmlspecialchars($customTitleDesc['description'], ENT_QUOTES);
		$result['cover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBSMALL, $item['resolutionx'], $item['resolutiony']);
		$result['xLargeThumb'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBXLARGE, $item['resolutionx'], $item['resolutiony']);
		$result['video'] = csSYNOPhotoMisc::GetConvertedVideoFileInfoFromFullPath($item['path']);
		$result['splash_src'] = urlencode(($_SERVER["HTTPS"]?'https':'http')."://".$_SERVER['HTTP_HOST'].$result['xLargeThumb']['src'].'&.jpg');
		$result['url'] = $this->GetItemUrlLink($item['path'], (count($result['video'])==0));
		if (isSet($result['video']['mp4_orig_src'])) {
			$result['origRotate'] = csSYNOPhotoDB::GetDBInstance()->checkVideoConvertOrigRotate($item['path'], $item['resolutionx']/$item['resolutiony']);
		}
		if(!$isForSlideShow) {
			$result['resolutionx'] = $item['resolutionx'];
			$result['resolutiony'] = $item['resolutiony'];
			$result['timetaken'] = $item['mdate'];
            $result['createdate'] = $item['date'];
			$result['date'] = $item['date'];
			$result['mdate'] = $item['mdate'];
			$result['duration'] = $item['duration'];
			$videoIconOffset = 0;
			$result['bigCover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBMEDIUM, $item['resolutionx'], $item['resolutiony']);
			$result['bigCover']['style'] = csSYNOPhotoMisc::GetThumbStyle($result['bigCover'], $thumbSize, (1 == $_SESSION[SYNOPHOTO_ADMIN_USER]['layout_type']), $videoIconOffset);
			$result['bigCover']['videoOffset'] = $videoIconOffset;
			$result['largeThumb'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBLARGE, $item['resolutionx'], $item['resolutiony']);
			$result['isCommentable'] = csSYNOPhotoBrowse::GetBrowseInstance()->isFileCommentable($item['path']);
			$result['info'] = self::GetVideoThumbInfoSummary($item);

			$swf_url = SYNOPHOTO_URL_PREFIX."/blog/include/v&dir=".csSYNOPhotoMisc::UrlEncode(csSYNOPhotoMisc::UrlEncode($dir))."&file=".csSYNOPhotoMisc::UrlEncode(csSYNOPhotoMisc::UrlEncode(basename($item['path'])));
			$result['swf_url'] = $swf_url;
			$result['label'] = SYNOPHOTO_LABEL_UTIL_GetVideoLabels($item['path']);
		}

		return $result;
	}

	function GetVideoThumbInfoSummary($item)
	{
		$result['info_0'] = htmlspecialchars(basename($item['path']), ENT_QUOTES);//name
		$result['info_1'] = round($item['filesize']/1024)."	KB";//size
		$result['info_2'] = $item['resolutionx'].' x '.$item['resolutiony'];
		$result['info_3'] = $item['duration']." Sec.";
		$result['info_4'] = (($item['frequency'])/1000.0)."	KHz";
		$result['info_5'] = $item['channel'];
		$result['info_6'] = round(($item['frame_bitrate'])/1024)." Kbit/Sec.";
		$result['info_7'] = round(($item['audio_bitrate'])/1024)." Kbit/Sec.";
		return $result;
	}
	/*!
	 * edit photo or video property
	 *
	 * \param $path file path
	 * \param $itemType idenfity photo or video
	 * \param $title item's new title
	 * \param $description item's new description
	 */
	function EditItemProperty($path, $itemType, $title, $description)
	{
		$realPath = $path;
		$path = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$result = false;
		if (SYNOPHOTO_ITEM_TYPE_PHOTO == $itemType) {
			$result = csSYNOPhotoDB::GetDBInstance()->UpdatePhotoProperty($path, $title, $description, $realPath);
			if ($result) {
				//flush photo dbcacher cache since data had been changed
				unset($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID]);
			}
		} else if (SYNOPHOTO_ITEM_TYPE_VIDEO == $itemType) {
			$result = csSYNOPhotoDB::GetDBInstance()->UpdateVideoProperty($path, $title, $description);
				if ($result) {
				//flush video dbcacher cache since data had been changed
				unset($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID]);
			}
		}

		return $result;
	}
	/*!
	 * get link to the picture on photo station
	 *
	 * \param $path file path
	 */
	function GetItemUrlLink($path, $checkVideoFail = false)
	{
		$pos = strrpos($path, '/');
		$dir = substr($path, 0, $pos);
		$dir = substr($dir, strlen(SYNOPHOTO_SERVICE_REAL_DIR.'/'));

		$result = 'photo_one.php?';

		$failFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBSMALL, true);
		$failVideoFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBSMALL , true, true);
		if (csSYNOPhotoMisc::IsPhotoFile($path) && @file_exists($failFile)) {
			$result = 'convert.php?type=2&dl=1&';
		}else if (!csSYNOPhotoMisc::IsPhotoFile($path) && $checkVideoFail) {
			$result = 'convert.php/'.basename($path).'?type=2&dl=1&';
		}
		$result .= 'name='.bin2hex(basename($path)).'&dir='.bin2hex($dir);

		if (!csSYNOPhotoMisc::IsPhotoFile($path) && $checkVideoFail && !@file_exists($failVideoFile)) {
			$result = '';
		}


		return $result;
	}
}
?>
