<?php
/*!
 * album list operation
 */
class SmartAlbum {
	private $_dbh;
	//private $escapeStr = '';
	public $escapeStr = ''; // #1507 - avoid erro when sharing smart album
	private static $instance = null;
	private static $video_convert_type_condition;

	function __construct()
	{
		$this->_dbh = csSYNOPhotoDB::GetDBInstance()->_dbh;
		$this->escapeStr = csSYNOPhotoDB::GetDBInstance()->escapeStr;
	}

	static function GetSmartAlbumInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	/**
	 *	WebAPI interface
	 */
	function AddSmartAlbum($data)
	{
		$returnJson = array(
			"success" => false
		);

		if (!$json = json_decode($data, true)) {
			csSYNOPhotoMisc::Synophoto_Log('not valid json format');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		if (!isset($json['name']) || 0 >= strlen($json['name']) ||
			!isset($json['show_photo']) || !isset($json['show_video']) ||
			empty($json['rule_sets']) || !is_array($json['rule_sets'])) {
			csSYNOPhotoMisc::Synophoto_Log('some field is not set');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		$albumName = $json['name'];
		$albumDesc = $json['desc'];
		$albumShowPhoto = !!$json['show_photo'];
		$albumShowVideo = !!$json['show_video'];
		$albumRuleSet = $json['rule_sets'];

		if (!$albumShowPhoto && !$albumShowVideo) {
			$albumShowPhoto = true;
			$albumShowVideo = true;
		}

		if (!$smartAlbumList = SmartAlbum::ReadSmartAlbumFile()) {
			$smartAlbumList["smart_albums"] = array();
		}

		if (isset($smartAlbumList["smart_albums"][$albumName])) {
			csSYNOPhotoMisc::Synophoto_Log("the smart album with name [$albumName] already exist");
			$returnJson["error"]["code"] = 103;
			$returnJson["error"]["message"] = 'The smart album already exist';
			return json_encode($returnJson);
		}

		//to do!! input format validation!!
		$smartAlbumList["smart_albums"][$albumName]["desc"] = $albumDesc;
		$smartAlbumList["smart_albums"][$albumName]["show_photo"] = $albumShowPhoto;
		$smartAlbumList["smart_albums"][$albumName]["show_video"] = $albumShowVideo;
		$smartAlbumList["smart_albums"][$albumName]["rule_sets"] = $albumRuleSet;

		if (!SmartAlbum::WriteSmartAlbumFile($smartAlbumList)) {
			csSYNOPhotoMisc::Synophoto_Log("Write failed");
			$returnJson["error"]["code"] = 104;
			$returnJson["error"]["message"] = 'Write failed';
			return json_encode($returnJson);
		}

		$returnJson["success"] = true;
		return json_encode($returnJson);
	}

	/**
	 *  WebAPI interface
	 */
	function LoadSmartAlbumConfig($data)
	{
		$returnJson = array(
			"success" => false
		);

		$returnData = array();

		if (!$json = json_decode($data, true)) {
			csSYNOPhotoMisc::Synophoto_Log('not valid json format');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		if (!isset($json['name']) || 0 >= strlen($json['name'])) {
			csSYNOPhotoMisc::Synophoto_Log('some field is not set');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		$albumName = $json['name'];

		if (!$smartAlbumList = SmartAlbum::ReadSmartAlbumFile()) {
			csSYNOPhotoMisc::Synophoto_Log("Read failed");
			$returnJson["error"]["code"] = 103;
			$returnJson["error"]["message"] = 'Read failed';
			return json_encode($returnJson);
		}

		if (!isset($smartAlbumList["smart_albums"][$albumName])) {
			csSYNOPhotoMisc::Synophoto_Log("the smart album with name \"$albumName\" does not exist");
			$returnJson["error"]["code"] = 103;
			$returnJson["error"]["message"] = 'The smart album does not exist';
			return json_encode($returnJson);
		}

		$smartAlbum = $smartAlbumList["smart_albums"][$albumName];

		$returnData["name"] = $albumName;
		$returnData["desc"] = $smartAlbum["desc"];
		$returnData["show_photo"] = $smartAlbum["show_photo"];
		$returnData["show_video"] = $smartAlbum["show_video"];
		$returnData["rule_sets"] = $smartAlbum["rule_sets"];

		if (!$smartAlbum["show_photo"] && !$smartAlbum["show_video"]) {
			$returnData["show_photo"] = true;
			$returnData["show_video"] = true;
		}

		$returnJson["success"] = true;
		$returnJson["data"] = $returnData;
		return json_encode($returnJson);
	}

	/**
	 *  WebAPI interface
	 */
	function EditSmartAlbum($data)
	{
		$returnJson = array(
			"success" => false
		);

		if (!$json = json_decode($data, true)) {
			csSYNOPhotoMisc::Synophoto_Log('not valid json format');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		if (!isset($json['name']) || 0 >= strlen($json['name']) ||
			!isset($json['orig_name']) || 0 >= strlen($json['orig_name']) ||
			!isset($json['show_photo']) || !isset($json['show_video']) ||
			empty($json['rule_sets']) || !is_array($json['rule_sets'])) {
			csSYNOPhotoMisc::Synophoto_Log('some field is not set');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		$origAlbumName = $json['orig_name'];
		$albumName = $json['name'];
		$albumDesc = $json['desc'];
		$albumShowPhoto = !!$json['show_photo'];
		$albumShowVideo = !!$json['show_video'];
		$albumRuleSet = $json['rule_sets'];

		if (!$albumShowPhoto && !$albumShowVideo) {
			$albumShowPhoto = true;
			$albumShowVideo = true;
		}

		if (!$smartAlbumList = SmartAlbum::ReadSmartAlbumFile()) {
			$smartAlbumList["smart_albums"] = array();
		}

		if (!isset($smartAlbumList["smart_albums"][$origAlbumName])) {
			csSYNOPhotoMisc::Synophoto_Log("the smart album with name \"$albumName\" does not exist");
			$returnJson["error"]["code"] = 103;
			$returnJson["error"]["message"] = 'The smart album does not exist';
			return json_encode($returnJson);
		}

		unset($smartAlbumList["smart_albums"][$origAlbumName]);

		//to do!!
		//input format validation!!
		$smartAlbumList["smart_albums"][$albumName]["desc"] = $albumDesc;
		$smartAlbumList["smart_albums"][$albumName]["show_photo"] = $albumShowPhoto;
		$smartAlbumList["smart_albums"][$albumName]["show_video"] = $albumShowVideo;
		$smartAlbumList["smart_albums"][$albumName]["rule_sets"] = $albumRuleSet;

		if (!SmartAlbum::WriteSmartAlbumFile($smartAlbumList)) {
			csSYNOPhotoMisc::Synophoto_Log("Write failed");
			$returnJson["error"]["code"] = 104;
			$returnJson["error"]["message"] = 'Write failed';
			return json_encode($returnJson);
		}

		$returnJson["success"] = true;
		return json_encode($returnJson);
	}

	/**
	 *  WebAPI interface
	 */
	function DeleteSmartAlbum($data)
	{
		$returnJson = array(
			"success" => false
		);

		if (!$json = json_decode($data, true)) {
			csSYNOPhotoMisc::Synophoto_Log('not valid json format');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		if (!isset($json['name']) || 0 >= strlen($json['name'])) {
			csSYNOPhotoMisc::Synophoto_Log('some field is not set');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		$albumName = $json['name'];

		if (!$smartAlbumList = SmartAlbum::ReadSmartAlbumFile()) {
			csSYNOPhotoMisc::Synophoto_Log("Read failed");
			$returnJson["error"]["code"] = 103;
			$returnJson["error"]["message"] = 'Read failed';
			return json_encode($returnJson);
		}

		if (!isset($smartAlbumList["smart_albums"][$albumName])) {
			csSYNOPhotoMisc::Synophoto_Log("the smart album with name \"$albumName\" does not exist");
			$returnJson["error"]["code"] = 103;
			$returnJson["error"]["message"] = 'The smart album does not exist';
			return json_encode($returnJson);
		}

		unset($smartAlbumList["smart_albums"][$albumName]);

		if (!SmartAlbum::WriteSmartAlbumFile($smartAlbumList)) {
			csSYNOPhotoMisc::Synophoto_Log("Write failed");
			$returnJson["error"]["code"] = 104;
			$returnJson["error"]["message"] = 'Write failed';
			return json_encode($returnJson);
		}

		$returnJson["success"] = true;
		return json_encode($returnJson);
	}

	/**
	 *  WebAPI interface
	 */
	function ListSmartAlbum()
	{
		$returnJson = array(
			"success" => false
		);

		$data = array(
			"total" => 0,
			"albumList" => array()
		);

		$isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

		//convert smart album file into array
		if (!$smartAlbumList = SmartAlbum::ReadSmartAlbumFile()) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		if (!is_array($smartAlbumList["smart_albums"])) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		foreach ($smartAlbumList["smart_albums"] as $key => $album) {
			if (!$album["show_photo"] && !$album["show_video"]) {
				$album["show_photo"] = true;
				$album["show_video"] = true;
			}

			if (!$isAdmin && 0 >= SmartAlbum::GetItemCountInSmartAlbum($album)) {
				continue;
			}

			$data["albumList"][] = array(
				"name" => (string)$key,
				//"desc" => $album["desc"],
				"desc" => "",
				"cover" => SmartAlbum::GetCoverOfSmartAlbum($album)
			);
			$data["total"]++;
		}

		$returnJson["data"] = $data;
		$returnJson["success"] = true;

		return json_encode($returnJson);
	}

	/**
	 *  WebAPI interface
	 */
	function ListItem($data)
	{
		$returnJson = array(
			"success" => false
		);

		if (!$json = json_decode($data, true)) {
			csSYNOPhotoMisc::Synophoto_Log('not valid json format');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		if (!isset($json['name']) || 0 >= strlen($json['name'])) {
			csSYNOPhotoMisc::Synophoto_Log('some field is not set');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		$smartAlbumName = $json['name'];
		$offset = (int)$json['offset'] > 0 ? (int)$json['offset']: 0;
		$limit = (int)$json['limit'] > 0 ? (int)$json['limit']: 0;

		$data = array(
			"total" => 0,
			"itemList" => array()
		);

		//convert smart album file into array
		if (!$smartAlbumList = SmartAlbum::ReadSmartAlbumFile()) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		if (!is_array($smartAlbumList["smart_albums"])) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		$album = $smartAlbumList["smart_albums"][$smartAlbumName];

		if (isset($json['taken_date'])) {
			$rule_sets = array();
			$taken_date = $json['taken_date'];
			$dateStr = ($taken_date === '1970-01-01') ? 'unknown' : $taken_date . "," . $taken_date;
			$date_filter = array(
				"field" => date,
				"operator" => taken,
				"value" => $dateStr
			);

			foreach ($album["rule_sets"] as $ruleSetKey => $ruleSet) {
				$ruleSet[] = $date_filter; //append taken_date condition to rule set
				$rule_sets[] = $ruleSet;
			}
			$album["rule_sets"] = $rule_sets;
		}

		if (empty($album)) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		if (!$album['show_photo'] && !$album['show_video']) {
			$album['show_photo'] = true;
			$album['show_video'] = true;
		}

		$data["itemList"] = array();
		$data["total"] = SmartAlbum::GetItemCountInSmartAlbum($album);
		if ($data["total"] > 0) {
			$data["itemList"] = SmartAlbum::GetItemsInSmartAlbum($album, $offset, $limit);
		}

		$returnJson["data"] = $data;
		$returnJson["success"] = true;

		return json_encode($returnJson);
	}

    function GetSmartCondition($smartAlbumName) {
        $smartAlbumList = SmartAlbum::ReadSmartAlbumFile();
        $type = array();
        if ($smartAlbumList['smart_albums'][$smartAlbumName]['show_photo']) {
            array_push($type, 'photo');
        }
        if ($smartAlbumList['smart_albums'][$smartAlbumName]['show_video']) {
            array_push($type, 'video');
        }
        $data['type'] = implode(',', $type);
        $ruleSets = $smartAlbumList['smart_albums'][$smartAlbumName]['rule_sets'][0];
        foreach ($ruleSets as $rule) {
            switch ($rule['field']) {
            case 'keyword':
                $data['keyword'] = $rule['value'];
                $data['keyword_op'] = $rule['operator'];
                break;
            case 'date':
                $data['date'] = $rule['value'];
                $data['date_op'] = $rule['operator'];
                break;
            case 'people':
                $arr = explode(',', $rule['value']);
                $peopleArr = array();
                foreach ($arr as $id) {
                    array_push($peopleArr, 'tag_'.$id);
                }
                $data['people_tag'] = implode(',', $peopleArr);
                $data['people_tag_op'] = $rule['operator'];
                break;
            case 'geo':
                $arr = explode(',', $rule['value']);
                $geoArr = array();
                foreach ($arr as $id) {
                    array_push($geoArr, 'tag_'.$id);
                }
                $data['geo_tag'] = implode(',', $geoArr);
                $data['geo_tag_op'] = $rule['operator'];
                break;
            case 'desc':
                $arr = explode(',', $rule['value']);
                $descArr = array();
                foreach ($arr as $id) {
                    array_push($descArr, 'tag_'.$id);
                }
                $data['desc_tag'] = implode(',', $descArr);
                $data['desc_tag_op'] = $rule['operator'];
                break;
            case 'recently_add':
                $data['recently_add'] = $rule['value'];
                break;
            case 'recently_comment':
                $data['recently_comment'] = $rule['value'];
                break;
            default:
                break;
            }
        }
        return $data;
    }

	function ReadSmartAlbumFile()
	{
		$smartAlbumFile = SYNOPHOTO_SERVICE_DIR."/".SYNOPHOTO_EADIR.'/smart_album.json';

		//test whether smart album file config exist or not
		if (!@file_exists($smartAlbumFile)) {
			return null;
		}

		//get contents from smart album config file
		if (!$smartAlbumJsonStr = @file_get_contents($smartAlbumFile)) {
			return null;
		}

		//parse contents
		if (!$smartAlbumList = json_decode($smartAlbumJsonStr, true)) {
			return null;
		}

		return $smartAlbumList;
	}

	private function WriteSmartAlbumFile($smartAlbumList)
	{
		$eaDir = SYNOPHOTO_SERVICE_DIR."/".SYNOPHOTO_EADIR;
		$smartAlbumFile = $eaDir.'/smart_album.json';

		//encode smart album list to json string
		if (!$smartAlbumListJsonStr = json_encode($smartAlbumList)) {
			return false;
		}

		//beautify json string
		$smartAlbumListJsonStr = csSYNOPhotoMisc::indentJson($smartAlbumListJsonStr);

		//create @eaDir
		if(!@file_exists($eaDir)) {
			@mkdir($eaDir);
		}

		//put contents to smart album config file
		if (!@file_put_contents($smartAlbumFile, $smartAlbumListJsonStr)) {
			return false;
		}

		return true;
	}

    private function GetRecentlyAddSqlCondition($album, $type)
    {
        $field = ('photo' === $type) ? 'create_time' : 'date';

        foreach ($album['rule_sets'][0] as $rule) {
            if ('date' == $rule['field'] && 'recently_add' === $rule['operator']) {
                $sqlCondition = array(
                    'order' => "$field DESC",
                    'value' => $rule['value']
                );
                break;
            }
        }
        return $sqlCondition;
    }

    private function GetRecentlyCommentSqlCondition($album, $type)
    {
        $table = ('photo' === $type) ? 'photo_image' : 'video';
        $field = ('photo' === $type) ? 'id' : 'path';
        $commentTable = ('photo' === $type) ? 'photo_comment' : 'video_comment';
        $commentField = ('photo' === $type) ? 'photo_id' : 'path';
        $commentFieldAs = ('photo' === $type) ? 'photo_id' : 'video_path';

        foreach ($album['rule_sets'][0] as $rule) {
            if ('date' == $rule['field'] && 'recently_comment' === $rule['operator']) {
                $sqlCondition = array(
                    'query' => "LEFT JOIN (SELECT $commentField AS $commentFieldAs, max(date) AS comment_time FROM $commentTable GROUP BY $commentField) comment " .
                        "ON $table.$field = comment.$commentFieldAs",
                    'cond' => 'comment_time IS NOT NULL',
                    'order' => 'comment_time DESC',
                    'value' => $rule['value']
                );
                break;
            }
        }
        return $sqlCondition;
    }

	private function GetItemsInSmartAlbum($album, $offset = 0, $limit = 0)
	{
		$returnList = array();

		$offset = (int)$offset > 0 ? (int)$offset : 0;
		$limit = (int)$limit > 0 ? (int)$limit : 0;

		if ($album['show_photo']) {
			$photoSqlCond = SmartAlbum::GetSmartAlbumToSqlCondition($album, 'photo');
            $photoRecentlyAddSqlCond = SmartAlbum::GetRecentlyAddSqlCondition($album, 'photo');
            $photoRecentlyCommentSqlCond = SmartAlbum::GetRecentlyCommentSqlCondition($album, 'photo');
		}
		if ($album['show_video']) {
			$videoSqlCond = SmartAlbum::GetSmartAlbumToSqlCondition($album, 'video');
            $videoRecentlyAddSqlCond = SmartAlbum::GetRecentlyAddSqlCondition($album, 'video');
            $videoRecentlyCommentSqlCond = SmartAlbum::GetRecentlyCommentSqlCondition($album, 'video');
		}

		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
		if (!count($albumCondition['albumCond'])) {
			goto END;
		}
		$albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);

		$recentlyCount = false;

		//query photos
		if ($photoSqlCond['cond'] || $photoRecentlyAddSqlCond || $photoRecentlyCommentSqlCond) {
			$query = "SELECT * FROM photo_image";
			$cond = "WHERE ({$albumCondition['albumCond']})";

            if ($photoSqlCond['cond']) {
				$cond .= " AND ({$photoSqlCond['cond']})";
			}
			$order = "create_time DESC";
			if ($photoRecentlyAddSqlCond) {
				$order = $photoRecentlyAddSqlCond['order'];
				$recentlyCount = $photoRecentlyAddSqlCond['value'];
			} elseif ($photoRecentlyCommentSqlCond) {
				$query .= " {$photoRecentlyCommentSqlCond['query']}";
				$cond .= " AND {$photoRecentlyCommentSqlCond['cond']}";
				$order = $photoRecentlyCommentSqlCond['order'];
				$recentlyCount = $photoRecentlyCommentSqlCond['value'];
			}

			if (false !== $recentlyCount) {
				if ($offset >= $recentlyCount) {
					return array();
				}
				$offset = 0;
				if ($limit > $recentlyCount) {
					$limit = $recentlyCount;
				}
			}

			$query = "$query $cond ORDER BY $order ".($limit > 0 ? " LIMIT $limit" : "").($offset > 0 ? " OFFSET $offset;" : ";");

			$dbResult = SmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
			$dbResult->execute(array_merge($albumCondition['sqlParam'], $photoSqlCond['param']));

            $uniqueId = array();
			while (false !== ($row = $dbResult->fetch())) {
                if (in_array((int)$row['id'], $uniqueId)) {
                    continue;
                }
				$item = array(
					'type' => 'photo',
					'id' => $row['id'],
					'path' => SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'],
					'name' => $row['name'],
					'title' => $row['title'],
					'takendate' => $row['timetaken'],
					'createdate' => $row['create_time'],
					'commentdate' => $row['comment_time'],
					'description' => $row['description']
				);
                array_push($uniqueId, (int)$row['id']);
				$returnList[] = $item;
			}
		}

		//query videos
		if ($videoSqlCond['cond'] || $videoRecentlyAddSqlCond || $videoRecentlyCommentSqlCond) {
			$query = "SELECT id, video.path, title, description, mdate, date FROM (SELECT description, video.* FROM video LEFT JOIN video_desc ON video.path = video_desc.path) video";
			$cond = "WHERE ({$albumCondition['albumCond']})";

            if ($videoSqlCond['cond']) {
				$cond .= " AND ({$videoSqlCond['cond']})";
			}
			$order = "date DESC";
			if ($videoRecentlyAddSqlCond) {
				$order = $videoRecentlyAddSqlCond['order'];
				$recentlyCount = $videoRecentlyAddSqlCond['value'];
			} elseif ($videoRecentlyCommentSqlCond) {
				$query .= " {$videoRecentlyCommentSqlCond['query']}";
				$cond .= " AND {$videoRecentlyCommentSqlCond['cond']}";
				$order = $videoRecentlyCommentSqlCond['order'];
				$recentlyCount = $videoRecentlyCommentSqlCond['value'];
			}

			if (false !== $recentlyCount) {
				if ($offset >= $recentlyCount) {
					return array();
				}
				$offset = 0;
				if ($limit > $recentlyCount) {
					$limit = $recentlyCount;
				}
			}

			$query = "$query $cond ORDER BY $order ".($limit > 0 ? " LIMIT $limit" : "").($offset > 0 ? " OFFSET $offset;" : ";");

			$dbResult = SmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
			$dbResult->execute(array_merge($albumCondition['sqlParam'], $videoSqlCond['param']));

            $uniqueId = array();
			while (false !== ($row = $dbResult->fetch())) {
                if (in_array((int)$row['id'], $uniqueId)) {
                    continue;
                }
				$item = array(
					'type' => 'video',
					'id' => $row['id'],
					'path' => SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'],
					'name' => basename($row['path']),
					'title' => $row['title'],
					'takendate' => $row['mdate'],
					'createdate' => $row['date'],
					'description' => $row['description']
				);
                array_push($uniqueId, (int)$row['id']);
				$returnList[] = $item;
			}
		}

		if (false !== $recentlyCount) { //recently condition is set
			if ($photoRecentlyAddSqlCond) {
				usort($returnList, "self::SortByCreateDate");
			} else if ($photoRecentlyCommentSqlCond) {
				usort($returnList, "self::SortByCommentDate");
			}

			if ($limit <= 0 || $offset + $limit > $recentlyCount) {
				$returnList = array_slice($returnList, $offset, $recentlyCount - $offset);
			} else {
				$returnList = array_slice($returnList, $offset, $limit);
			}
		}

	END:
		return $returnList;
	}

	private function GetItemCountInSmartAlbum($album)
	{
		$returnCount = 0;

		if ($album['show_photo']) {
			$photoSqlCond = SmartAlbum::GetSmartAlbumToSqlCondition($album, 'photo');
            $photoRecentlyAddSqlCond = SmartAlbum::GetRecentlyAddSqlCondition($album, 'photo');
            $photoRecentlyCommentSqlCond = SmartAlbum::GetRecentlyCommentSqlCondition($album, 'photo');
		}
		if ($album['show_video']) {
			$videoSqlCond = SmartAlbum::GetSmartAlbumToSqlCondition($album, 'video');
            $videoRecentlyAddSqlCond = SmartAlbum::GetRecentlyAddSqlCondition($album, 'video');
            $videoRecentlyCommentSqlCond = SmartAlbum::GetRecentlyCommentSqlCondition($album, 'video');
		}

		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
		if (!count($albumCondition['albumCond'])) {
			goto END;
		}
		$albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);

		$recentlyCount = false;

		if ($photoSqlCond['cond'] || $photoRecentlyAddSqlCond || $photoRecentlyCommentSqlCond) {
			$query = "SELECT count(*) FROM photo_image";
			$cond = "WHERE ({$albumCondition['albumCond']})";

            if ($photoSqlCond['cond']) {
				$cond .= " AND ({$photoSqlCond['cond']})";
			}
			if ($photoRecentlyAddSqlCond) {
				$recentlyCount = $photoRecentlyAddSqlCond['value'];
			} elseif ($photoRecentlyCommentSqlCond) {
				$query .= " {$photoRecentlyCommentSqlCond['query']}";
				$cond .= " AND {$photoRecentlyCommentSqlCond['cond']}";
				$recentlyCount = $photoRecentlyCommentSqlCond['value'];
			}

			$query = "$query $cond";

			$dbResult = SmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
			$dbResult->execute(array_merge($albumCondition['sqlParam'], $photoSqlCond['param']));

			if (false !== ($row = $dbResult->fetch())) {
				$returnCount += (int)$row[0];
			}
		}

		if ($videoSqlCond['cond'] || $videoRecentlyAddSqlCond || $videoRecentlyCommentSqlCond) {
			$query = "SELECT COUNT(*) FROM (SELECT description, video.* FROM video LEFT JOIN video_desc ON video.path = video_desc.path) video";
			$cond = "WHERE ({$albumCondition['albumCond']})";

            if ($videoSqlCond['cond']) {
				$cond .= " AND ({$videoSqlCond['cond']})";
			}
			if ($videoRecentlyAddSqlCond) {
				$recentlyCount = $videoRecentlyAddSqlCond['value'];
			} elseif ($videoRecentlyCommentSqlCond) {
				$query .= " {$videoRecentlyCommentSqlCond['query']}";
				$cond .= " AND {$videoRecentlyCommentSqlCond['cond']}";
				$recentlyCount = $videoRecentlyCommentSqlCond['value'];
			}

			$query = "$query $cond";

			$dbResult = SmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
			$dbResult->execute(array_merge($albumCondition['sqlParam'], $videoSqlCond['param']));

			if (false !== ($row = $dbResult->fetch())) {
				$returnCount += (int)$row[0];
			}
		}

		if (false !== $recentlyCount) { //recently condition is set
			if ($returnCount > $recentlyCount) {
				$returnCount = $recentlyCount;
			}
		}

	END:
		return $returnCount;
	}

	function GetCoverOfSmartAlbumByName($albumName) {
		$data['success'] = false;

		$isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

		//convert smart album file into array
		if (!$smartAlbumList = SmartAlbum::ReadSmartAlbumFile()) {
			return $data;
		}

		if (!is_array($smartAlbumList["smart_albums"])) {
			return $data;
		}

		foreach ($smartAlbumList["smart_albums"] as $key => $album) {
			if ((string)$key === (string)$albumName) {
				if (!$isAdmin && 0 >= SmartAlbum::GetItemCountInSmartAlbum($album)) {
					break;
				}

				$data = array(
					"success" => true,
					"name" => (string)$key,
					"cover" => SmartAlbum::GetCoverOfSmartAlbum($album)
				);
				break;
			}
		}

		return $data;
	}

	private function GetCoverOfSmartAlbum($album)
	{
		$returnCover = '';

		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
		if (!count($albumCondition['albumCond'])) {
			goto END;
		}
		$albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);

		if ($album['show_photo']) {
			$photoSqlCond = SmartAlbum::GetSmartAlbumToSqlCondition($album, 'photo');
            $photoRecentlyAddSqlCond = SmartAlbum::GetRecentlyAddSqlCondition($album, 'photo');
            $photoRecentlyCommentSqlCond = SmartAlbum::GetRecentlyCommentSqlCondition($album, 'photo');

            if ($photoSqlCond['cond'] || $photoRecentlyAddSqlCond || $photoRecentlyCommentSqlCond) {
                $query = "SELECT * FROM photo_image";
                $cond = "WHERE ({$albumCondition['albumCond']})";

                if ($photoSqlCond['cond']) {
                    $cond .= " AND ({$photoSqlCond['cond']})";
                }
                $order = "create_time DESC";
                if ($photoRecentlyAddSqlCond) {
                    $order = $photoRecentlyAddSqlCond['order'];
                } elseif ($photoRecentlyCommentSqlCond) {
                    $query .= " {$photoRecentlyCommentSqlCond['query']}";
                    $cond .= " AND {$photoRecentlyCommentSqlCond['cond']}";
                    $order = $photoRecentlyCommentSqlCond['order'];
                }

                $query = "$query $cond ORDER BY $order LIMIT 1;";

				$dbResult = SmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
				$dbResult->execute(array_merge($albumCondition['sqlParam'], $photoSqlCond['param']));

				if (false !== ($row = $dbResult->fetch())) {
					$returnCover = array(
						'type' => 'photo',
						'path' => SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']
					);
					$photoCTime = $row['create_time'];
				}
			}
		}

		if ($album['show_video']) {
			$videoSqlCond = SmartAlbum::GetSmartAlbumToSqlCondition($album, 'video');
            $videoRecentlyAddSqlCond = SmartAlbum::GetRecentlyAddSqlCondition($album, 'video');
            $videoRecentlyCommentSqlCond = SmartAlbum::GetRecentlyCommentSqlCondition($album, 'video');

            if ($videoSqlCond['cond'] || $videoRecentlyAddSqlCond || $videoRecentlyCommentSqlCond) {
                $query = "SELECT video.path, date FROM (SELECT description, video.* FROM video LEFT JOIN video_desc ON video.path = video_desc.path) video";
                $cond = "WHERE ({$albumCondition['albumCond']})";

                if ($videoSqlCond['cond']) {
                    $cond .= " AND ({$videoSqlCond['cond']})";
                }
                $order = "date DESC";
                if ($videoRecentlyAddSqlCond) {
                    $order = $videoRecentlyAddSqlCond['order'];
                } elseif ($videoRecentlyCommentSqlCond) {
                    $query .= " {$videoRecentlyCommentSqlCond['query']}";
                    $cond .= " AND {$videoRecentlyCommentSqlCond['cond']}";
                    $order = $videoRecentlyCommentSqlCond['order'];
                }

                $query = "$query $cond ORDER BY $order LIMIT 1";

				$dbResult = SmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
				$dbResult->execute(array_merge($albumCondition['sqlParam'], $videoSqlCond['param']));

				if (false !== ($row = $dbResult->fetch())) {
					if (!photoCTime || ($row['date'] > $photoCTime)) {
						$returnCover = array(
							'type' => 'video',
							'path' => SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']
						);
					}
				}
			}
		}

	END:
		return $returnCover;
	}

	protected function SortByCreateDate($a, $b)
	{
		if ($a['createdate'] === $b['createdate']) {
			return 0;
		}
		return ($a['createdate'] < $b['createdate']) ? 1 : -1;
	}

	protected function SortByCommentDate($a, $b)
	{
		if ($a['commentdate'] === $b['commentdate']) {
			return 0;
		}
		return ($a['commentdate'] < $b['commentdate']) ? 1 : -1;
	}

	private function GetSmartAlbumToSqlCondition($album, $type)
	{
		$returnCond = array(
			'cond' => '',
			'param' => array()
		);

		$cond = array();
		$param = array();

		if (!is_array($album["rule_sets"])) {
			goto END;
		}

		foreach ($album["rule_sets"] as $ruleSetKey => $ruleSet) {
			if ((!$ruleCond = SmartAlbum::GetRuleSetToSqlCondition($ruleSet, $type)) || !$ruleCond['cond']) {
				continue;
			}

			$cond[] = $ruleCond['cond'];
			$param = array_merge($param, $ruleCond['param']);
		}

		if (empty($cond)) {
			goto END;
		}

		$returnCond['cond'] = "(" . implode(") AND (", $cond) . ")";
		$returnCond['param'] = $param;

	END:
		return $returnCond;
	}

	private function GetRuleSetToSqlCondition($ruleSet, $type)
	{
		$returnCond = array(
			'cond' => '',
			'param' => array()
		);

		$cond = array();
		$param = array();

		if (!is_array($ruleSet) || empty($ruleSet)) {
			goto END;
		}

		foreach ($ruleSet as $key => $rule) {
			if ((!$ruleCond = SmartAlbum::GetRuleToSqlCondition($rule, $type)) || !($ruleCond['cond'])) {
				continue;
			}

			$cond[] = $ruleCond['cond'];
			$param = array_merge($param, $ruleCond['param']);
		}

		if (empty($cond)) {
			goto END;
		}

		$returnCond['cond'] = "(" . implode(") AND (", $cond) . ")";
		$returnCond['param'] = $param;

	END:
		return $returnCond;
	}

	private function GetRuleToSqlCondition($rule, $type)
	{
		$returnCond = array(
			'cond' => '',
			'param' => array()
		);

		if (('photo' !== $type && 'video' !== $type) ||
			!isset($rule['field']) || '' == $rule['field'] ||
			!isset($rule['operator']) || '' == $rule['operator'] ||
			!isset($rule['value'])  || '' == $rule['value']) {
			goto END;
		}

		$field = $rule['field'];
		$operator = $rule['operator'];
		$value = $rule['value'];

		if ('keyword' === $field) {
			$returnCond = csSYNOPhotoDB::GetKeywordCondition($value, $operator,
														   'photo' === $type ? array('name', 'title', 'description') : array('title', 'description'));
		} else if ('date' === $field) {
			if ('taken' === $operator) {
				if ($value === 'unknown') {
					if ('photo' === $type) {
						$cond = "(timetaken IS NULL OR date(timetaken)='1970-01-01')";
					} else {
						$cond = "(mdate IS NULL OR date(mdate)='1970-01-01')";
					}
				} else {
					$cond = csSYNOPhotoDB::GetDateCondition($value, 'photo' === $type ? 'timetaken' : 'mdate');
				}
				$returnCond['cond'] = $cond;
			} elseif ('upload' === $operator) {
				$returnCond['cond'] = csSYNOPhotoDB::GetDateCondition($value, 'photo' === $type ? 'create_time' : 'date');
			}
		} else if ('people' === $field || 'geo' === $field || 'desc' === $field) {
			$returnCond = csSYNOPhotoDB::GetTagCondition($value, $operator, $field, $type);
            
		}

	END:
		return $returnCond;
	}
}

?>
