<?php
require_once("../include/syno_conf.php");

if (!csSYNOPhotoMisc::CheckAlbumManageable($_POST['albumName'])) {
	csSYNOPhotoMisc::CheckAdminTimeOut();
}

if(isset($_POST['public']) && isset($_POST['node'])) {
	echo SYNOPHOTO_IMG_GetPublicTreeData($_POST['node']);
	exit;
}
if(isset($_POST['node'])) {
	echo SYNOPHOTO_IMG_GetTreeData($_POST['node']);
	exit;
}

switch ($_POST['action']) {
case 'get_album_photo':
	$files = SYNOPHOTO_IMG_GetAlbumPhoto($_POST['current_dir']);
	echo json_encode($files);
	break;
case 'get_album_video':
	$files = SYNOPHOTO_IMG_GetAlbumVideo($_POST['current_dir']);
	echo json_encode($files);
	break;
case 'get_all':
	$photo_files = SYNOPHOTO_IMG_GetAlbumPhoto($_POST['current_dir']);
	$video_files = SYNOPHOTO_IMG_GetAlbumVideo($_POST['current_dir']);
	$result['images'] = array_merge($photo_files['images'], $video_files['images']);
	echo json_encode($result);
	break;
}

function SYNOPHOTO_IMG_GetAlbumPhoto($album)
{
	$files['images'] = array();
	$i = 0;

	if($album == null || $album == "") {
		return $files;
	}

	$escape = PHOTO_DB_GetEscape();
	$query = "Select * from photo_image where path like ? $escape and path not like ? $escape order by path ";
	$sqlParam = array(SYNOPHOTO_SERVICE_REAL_DIR_PATH.PHOTO_DB_EscapForLike($album)."/%",
					  SYNOPHOTO_SERVICE_REAL_DIR_PATH.PHOTO_DB_EscapForLike($album)."/%/%");

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	while(($row = PHOTO_DB_FetchRow($db_result))) {
		$path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[1];
		$file_name = basename($path);
		$dir_name = substr(str_replace("/".$file_name, "", $path), strlen(SYNOPHOTO_SERVICE_REAL_DIR."/"));

		$thumb['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($path, SYNOPHOTO_THUMBSMALL, $row['resolutionx'], $row['resolutiony'], $row['version']);
		$thumb['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($path, SYNOPHOTO_THUMBBIG, $row['resolutionx'], $row['resolutiony'], $row['version']);

		$src = $thumb['cover']['src'];
		$url = $thumb['bigCover']['src'];

		if ($row['version'] % 2 == 0) {
			$tmp = csSYNOPhotoMisc::GetJustFitWidthHeight($row['resolutionx'],$row['resolutiony'],120,120);
		} else {
			$tmp = csSYNOPhotoMisc::GetJustFitWidthHeight($row['resolutiony'],$row['resolutionx'],120,120);
		}


		$files['images'][$i]['dir'] = htmlspecialchars($dir_name);
		$files['images'][$i]['name'] = htmlspecialchars($file_name);
		$files['images'][$i]['url'] = $url;
		$files['images'][$i]['src'] = $src;
		$files['images'][$i]['item_id'] = $row['id'];
		$files['images'][$i]['dispaly_info'] = htmlspecialchars($dir_name."/".$file_name);
		$files['images'][$i]['thumb_width'] = $tmp['width'];
		$files['images'][$i]['thumb_height'] = $tmp['height'];

		$i++;
	}
	return $files;
}

function SYNOPHOTO_IMG_GetAlbumVideo($album)
{
	$files['images'] = array();
	$i = 0;

	if($album == null || $album == "") {
		return $files;
	}

	$escape = PHOTO_DB_GetEscape();
	$query = "Select * from video where path like ? $escape and path not like ? $escape order by path";
	$sqlParam = array(SYNOPHOTO_SERVICE_REAL_DIR_PATH.PHOTO_DB_EscapForLike($album).'/%',
					  SYNOPHOTO_SERVICE_REAL_DIR_PATH.PHOTO_DB_EscapForLike($album).'/%/%');

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		$path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[1];
		if(0 == count(csSYNOPhotoMisc::GetConvertedVideoFileInfoFromFullPath($path))) {
			continue;
		}
		$file_name = basename($path);
		$dir_name = substr(str_replace("/".$file_name, "", $path), strlen(SYNOPHOTO_SERVICE_REAL_DIR."/"));

		$url = SYNOPHOTO_URL_PREFIX."/photo/convert.php?showthumb=true&currname=".csSYNOPhotoMisc::UrlEncode($file_name)."&currdir=".csSYNOPhotoMisc::UrlEncode($dir_name)."&showvideo=ture";
		$src = SYNOPHOTO_URL_PREFIX."/blog/include/v&dir=".csSYNOPhotoMisc::UrlEncode(csSYNOPhotoMisc::UrlEncode($dir_name))."&file=".csSYNOPhotoMisc::UrlEncode(csSYNOPhotoMisc::UrlEncode($file_name));

		$files['images'][$i]['dir'] = htmlspecialchars($dir_name);
		$files['images'][$i]['name'] = htmlspecialchars($file_name);
		$files['images'][$i]['url'] = $url;
		$files['images'][$i]['src'] = $src;
		$files['images'][$i]['item_id'] = $row['id'];
		$files['images'][$i]['dispaly_info'] = htmlspecialchars($dir_name."/".$file_name);

		$tmp = csSYNOPhotoMisc::GetJustFitWidthHeight($row['resolutionx'],$row['resolutiony'],120,120);
		$files['images'][$i]['thumb_width'] = $tmp['width'];
		$files['images'][$i]['thumb_height'] = $tmp['height'];

		$i++;
	}
	return $files;
}

function SYNOPHOTO_IMG_GetPublicTreeData($path)
{
	if (!strstr($path, 'source')) {
		return json_encode(array());
	}

	$escape = PHOTO_DB_GetEscape();

	$blQueryDB = true;
	if($path == "source") {
		$query = "Select sharename from photo_share where is_subdir = 'f' and public = 't'";
		$sqlParam = array();
	} else if (3 > count(explode('/',$path,3))){
		$query = "Select sharename from photo_share where public = 't' and sharename like ? $escape order by sharename";
		$sqlParam = array(substr($path, 7).'/%');
	} else {
		$blQueryDB = false;
	}
	$i = 0;
	if($blQueryDB) {
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		while(($row = PHOTO_DB_FetchRow($db_result))) {
			$result[$i]['text'] = htmlspecialchars(basename($row[0]));
			$result[$i]['id'] = 'source/'.$row[0];
			$result[$i]['cls'] = 'root';
			$i++;
		}
	} else {
		$currpath = getcwd();
		$albumPath = substr($path, 7);//7= 'sourse/';
		$temp_path = SYNOPHOTO_SERVICE_REAL_DIR."/".$albumPath;

		if(!is_dir($temp_path))
			return json_encode(array());

		@chdir($temp_path);
		foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $dir) {
			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (csSYNOPhotoMisc::isSkipPhotoDev($temp_path.'/'.$dir, $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])
				|| !csSYNOPhotoMisc::IsUtf8($dir)) {
				continue;
			}
			if ($dir == SYNOPHOTO_EADIR || $dir == '.' || $dir == '..'
				|| (false === strpos($albumPath, '/') &&
				!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir']["{$albumPath}/{$dir}"]))) {
				continue;
			}

			$result[$i]['text'] = htmlspecialchars($dir);
			$result[$i]['id'] = 'source/'.$albumPath.'/'.$dir;
			$result[$i]['cls'] = 'root';
			$i++;
		}
		@chdir($currPath);
	}
	return json_encode($result);

}

function SYNOPHOTO_IMG_GetTreeData($path)
{
	if($path == "source") {
		$query = "Select sharename from photo_share where is_subdir = 'f' order by sharename";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$i = 0;
		while(($row = PHOTO_DB_FetchRow($db_result))) {
			$result[$i]['text'] = htmlspecialchars($row[0]);
			$result[$i]['id'] = 'source/'.$row[0];
			$result[$i]['cls'] = 'root';
			$i++;
		}
	} else {
		$currpath = getcwd();
		$temp_path = SYNOPHOTO_SERVICE_REAL_DIR."/".substr($path, 7);//7= 'sourse/'

		if(!is_dir($temp_path)) return NULL;
		$result = array();

		@chdir($temp_path);
		foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $fullfile) {
			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (csSYNOPhotoMisc::isSkipPhotoDev($temp_path.'/'.$fullfile, $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])
				 || !csSYNOPhotoMisc::IsUtf8($fullfile)) {
				continue;
			}
			$thefile = array();

			$pos = strrpos($fullfile, "/");
			if ($pos != false || $fullfile == "@eaDir" || $fullfile == '.' || $fullfile == '..') {
				continue;
			}
			$thefile['text'] = htmlspecialchars($fullfile);
			$thefile['id'] = $path."/".$fullfile;
			$thefile['cls'] = 'root';
			$result[] = $thefile;
		}
		@chdir($currpath);
	}
	return json_encode($result);
}
?>
