<?
require_once("syno_conf.php");

set_time_limit(0);
session_start();

$_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'] = csSYNOPhotoMisc::GetSessionIdentifier();

if (isset($_REQUEST['session'])) {
	csSYNOPhotoMisc::RestoreSession();
}

// Bug #16541: Update new upload rights information in current session.
csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

$conf = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, "enable_demomode");
if ("yes" == $conf["enable_demomode"]) {
	SYNOPHOTO_UPLOAD_HandleResponseError(__(photo_str_error_demo));
}

switch ($_REQUEST['action']) {
case 'check_subfolder':
	if (isSet($_REQUEST['path']) && $_REQUEST['path'] != "") {
		$result = SYNOPHOTO_UPLOAD_CheckSubFolder();
	} else {
		$result['success'] = true;
	}
	echo json_encode($result);
	exit;
case 'getshares':
	if ('fm_root' == $_POST['node']) {
		echo SYNOPHOTO_UPLOAD_GetUserValidShare();
	} else {
		echo SYNOPHOTO_UPLOAD_EnumUserValidDir();
	}
	exit;
case 'getfiles':
	echo SYNOPHOTO_UPLOAD_EnumUserValidFiles();
	exit;
case 'get_dsm_files':
	$files = GetDSMPhotoVideoFile($_POST['current_dir']);
	echo json_encode($files);
	exit;
case 'copy':
	echo SYNOPHOTO_UPLOAD_CopyFiles();
	exit;
case 'aviary_add':
	echo SYNOPHOTO_AVIARY_Add();
	exit;
}

if (!isset($_REQUEST['overwrite'])) {
	SYNOPHOTO_UPLOAD_HandleResponseError(__(photo_str_error_unknown_desc));
}

if (isset($_REQUEST['MultiPowUpload'])) {
	//flash upload
	$Filedata = $_FILES['Filedata'];
} else if (isset($_REQUEST['HTML5Upload'])) {
	//html5 upload
	$Filedata = $_FILES['upload'];
} else {
	$Filedata = pos($_FILES);
}

if (!isset($Filedata) || !is_uploaded_file($Filedata['tmp_name'])) {
	SYNOPHOTO_UPLOAD_HandleResponseError(__(photo_str_error_unknown_desc));
}

if ($Filedata['size'] > 2 * 1024 * 1024 * 1024) {
	SYNOPHOTO_UPLOAD_HandleResponseError(__(photo_str_upload_size_error));
}

if (!csSYNOPhotoMisc::IsPhotoFile($Filedata['name']) && !csSYNOPhotoMisc::IsVideoFile($Filedata['name'])) {
	SYNOPHOTO_UPLOAD_HandleResponseError(__(photo_str_upload_file_format_unsupport));
}

if (!csSYNOPhotoMisc::CheckAlbumUploadable($_REQUEST['path'])) {
	SYNOPHOTO_UPLOAD_HandleResponseError(__('photo_permission_denied'));
}

if (!SYNOPHOTO_UPLOAD_SubFolderCreate()) {
	SYNOPHOTO_UPLOAD_HandleResponseError(__('photo_permission_denied'));
}

$isThumbnailFile = false;
if (strstr($Filedata['name'], $_REQUEST['thumbnailName'])) {
	if ($_REQUEST['overwrite'] == "2") {
		SYNOPHOTO_UPLOAD_HandleResponseError('Currently not support upload thumbnail on rename mode');
	}
	$isThumbnailFile = true;
}

if ($isThumbnailFile) {
	$eaDir = SYNOPHOTO_SERVICE_DIR."/".$_REQUEST['path']."/".$_REQUEST['create_subfolder']."/".SYNOPHOTO_EADIR."/".$_REQUEST['originalFileName'];
	@mkdir($eaDir, 0777, true);
	$destination_path = $eaDir."/".$_REQUEST['thumbnailName'].".jpg";
} else {
	// Create @eaDir when got the original file.
	$eaDir = SYNOPHOTO_SERVICE_DIR."/".$_REQUEST['path']."/".$_REQUEST['create_subfolder']."/".SYNOPHOTO_EADIR."/".$Filedata['name'];
	@mkdir($eaDir, 0777, true);
	$destination_path = SYNOPHOTO_SERVICE_DIR."/".$_REQUEST['path']."/".$_REQUEST['create_subfolder']."/".$Filedata['name'];
}

if (file_exists($destination_path)) {
	if ($_REQUEST['overwrite'] == "0") {//ingnore
		SYNOPHOTO_UPLOAD_HandleResponseError(__(photo_str_upload_skip_file));
	} else if ($_REQUEST['overwrite'] == "2") {//rename
        $dir = pathinfo($destination_path, PATHINFO_DIRNAME);
		$name = pathinfo($destination_path, PATHINFO_FILENAME);
		$ext = pathinfo($destination_path, PATHINFO_EXTENSION);

		$rename_suffix = 0;
		$rename_path = $destination_path;

		while (file_exists($rename_path)) {
			$rename_path = $dir.'/'.$name.'_'.(++$rename_suffix).'.'.$ext;
		}

		$destination_path = $rename_path;
	}
}

if (!move_uploaded_file($Filedata['tmp_name'], $destination_path)) {
	SYNOPHOTO_UPLOAD_HandleResponseError(__(photo_str_error_unknown_desc));
}

$path_parts = pathinfo($rename_path ? $rename_path : $Filedata['name']);

@chmod($destination_path, 0777);
if (!$isThumbnailFile) {
	if (isSet($_POST['fileModificationDate']) && $_POST['fileModificationDate'] !== "") {
		@touch($destination_path, $_POST['fileModificationDate']/1000);
	}

	if (!isSet($_REQUEST['create_subfolder']) || $_REQUEST['create_subfolder'] == "") {
		$partial_path = $_REQUEST['path']."/".$path_parts['basename'];
	} else {
		$partial_path = $_REQUEST['path']."/".$_REQUEST['create_subfolder']."/".$path_parts['basename'];
	}
	SYNOPHOTO_UPLOAD_DoIndex($destination_path, trim($partial_path, "/"), $path_parts);
}

$return["success"] = true;

if (isset($_REQUEST['form_id'])) {
	$return["form_id"] = $_REQUEST['form_id'];
}

$return["result"] = "success";
$return['name'] = $Filedata['name'];

$user = "admin";
if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
	$user = $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
}

if (!$isThumbnailFile) {
	csSYNOPhotoDB::GetDBInstance()->AddPhotoLog("Upload ".$Filedata['name']." to /photo/".$_REQUEST['path']."/".$_REQUEST['create_subfolder']." successfully.", 't', $user);
}

echo json_encode($return);

//end of execution, exit
exit;

function SYNOPHOTO_UPLOAD_HandleResponseError($error_msg) {
	$return["success"] = true;
	$return["result"] = "fail";
	$return['error'] = $error_msg;
	$return['name'] = $Filedata['name'];

	echo json_encode($return);
	exit;
}

function SYNOPHOTO_UPLOAD_SubFolderCreate()
{
	if (!isSet($_REQUEST['create_subfolder']) || $_REQUEST['create_subfolder'] == "") {
		return TRUE;
	}

	$path = SYNOPHOTO_SERVICE_DIR."/".$_REQUEST['path']."/".$_REQUEST['create_subfolder'];
	if (file_exists($path)) {
		if (csSYNOPhotoMisc::CheckAlbumUploadable($_REQUEST['path']."/".$_REQUEST['create_subfolder'])) {
			return TRUE;
		}
		return FALSE;
	}

	if (!($result = @mkdir($path, 0777, true))) {
		return FALSE;
	}

	SYNOPHOTO_UPLOAD_AddFolderToDB($_REQUEST['path'],  trim($_REQUEST['path']."/".$_REQUEST['create_subfolder'], "/"));
	return TRUE;
}

function SYNOPHOTO_UPLOAD_AddFolderToDB($parent_album, $album)
{
	$real_path = SYNOPHOTO_SERVICE_REAL_DIR."/".$album;

	$path = PHOTO_DB_EscapeParam($real_path);
	$album = PHOTO_DB_EscapeParam($album);
	$parent_album = PHOTO_DB_EscapeParam($parent_album);
	$def_allow_comment = 'f';

	$arr = explode("/", $album);
	if (count($arr) > 2) {
		return;
	}

	if ("" != $parent_album) {
		$is_subdir = "t";

		$query = "Select public, shareid from photo_share where sharename = '".$parent_album."';";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if ($row = PHOTO_DB_FetchRow($db_result)) {
			$parent_public = PHOTO_DB_ConvertBool($row[0]);
			$parent_shareid = $row[1];
		} else {
			return;
		}
	} else {
		$is_subdir = "f";

		if ($_REQUEST['privilege'] == "0") {
			$parent_public = 't';
		} else {
			$parent_public = 'f';
		}
		if (csSYNOPhotoMisc::GetConfigDB("photo", "album_def_allow_comment", "photo_config") === 'on') {
			$def_allow_comment = 't';
		}
	}

	$query = "Select shareid from photo_share order by shareid desc limit 1;";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$row = PHOTO_DB_FetchRow($db_result);
	$new_shareid = $row[0] + 1;

	$query = "Insert into photo_share (shareid, sharename, public, is_subdir, comment) values (".$new_shareid.", '".$album."', '".$parent_public."', '".$is_subdir."', '$def_allow_comment');";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	if (!isSet($_REQUEST['privilege']) || $_REQUEST['privilege'] == "1") {
		csSYNOPhotoDB::GetDBInstance()->inheritAlbumPrivilege($parent_shareid, $new_shareid);
	}

	if ($_REQUEST['privilege'] == "2") { // Set password
		$query = "Update photo_share set password = '".md5($_REQUEST['password'])."' where shareid = ".$new_shareid.";";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}

	@exec("/usr/syno/bin/synoindex -a ".escapeshellarg($real_path)." > /dev/null 2>&1");
	@exec("/usr/syno/bin/synophotoio -a ".escapeshellarg($real_path)." > /dev/null 2>&1");

}

function SYNOPHOTO_UPLOAD_DoIndex($path, $partial_path, $path_parts)
{
	@exec("/usr/syno/bin/synoindex -a ".escapeshellarg($path)." > /dev/null 2>&1");
	@exec("/usr/syno/bin/synophotoio -a ".escapeshellarg($path)." > /dev/null 2>&1");

	if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)) {
		$destination_path = $partial_path;
	} else {
		$destination_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$partial_path;
	}

	if (csSYNOPhotoMisc::IsPhotoFile($path)) {
		$name = PHOTO_DB_EscapeParam($path_parts['basename']);
		$title = PHOTO_DB_EscapeParam($path_parts['filename']);
		$query = "Insert into photo_image (path, name, title) values ('".PHOTO_DB_EscapeParam($destination_path)."', '".$name."', '".$title."');";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$albumName = str_replace(basename($partial_path), "", $partial_path);
		$arr = explode("/", trim($albumName, "/"));
		if (1 < count($arr)) {
			$albumName = $arr[0]."/".$arr[1];
		} else {
			$albumName = $arr[0];
		}
		SYNOPHOTO_UPLOAD_StartSyncWithFb($albumName);
	} else {
		// Todo: Insert into mediaserver?
	}
}

function SYNOPHOTO_UPLOAD_GetUserValidShare()
{
	$result = array();

	$shareList = SYNOPHOTO_UPLOAD_GetUserValidShareList();
	foreach ($shareList as $share) {
		$item = array();
		if ("photo" == strtolower($share['shareName']) && 'root' == SYNOPHOTO_ADMIN_USER) {
			continue;
		}
		$item['text'] = htmlspecialchars($share['shareName']);
		$item['id'] = $share['path'];
		$result[] = $item;
	}
	return json_encode($result);
}

function SYNOPHOTO_UPLOAD_GetUserValidShareList()
{
	$result = array();

	if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] &&
		isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
		$username = $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
	} else if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$username = ('root' == SYNOPHOTO_ADMIN_USER)? 'admin':SYNOPHOTO_ADMIN_NAME;
	} else {
		return $result;
	}

	$command = "/usr/syno/bin/synophoto_dsm_user --getshare ".escapeshellarg($username);
	@exec($command, $output, $retval);

	foreach ($output as $line) {
		$data = explode("\t", $line);
		if (2 > count($data)) {
			continue;
		}
		$item = array();
		$item['shareName'] = trim($data[0], "\n");
		$item['path'] = trim($data[1], "\n");
		$result[] = $item;
	}
	return $result;
}

function SYNOPHOTO_UPLOAD_EnumUserValidDir()
{
	$currpath = getcwd();
	$result = array();
	if (false === ($ret = @chdir($_POST['node']))) {
		return json_encode($result);
	}
	foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $fullfile) {
		// skip photo in remote mount (cifs) or read-only mount (iso9660)
		if (csSYNOPhotoMisc::isSkipPhotoDev($_POST['node'].'/'.$fullfile, $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])
			|| !csSYNOPhotoMisc::IsUtf8($fullfile)) {
			continue;
		}
		if ("@eaDir" == $fullfile || $fullfile == '.' || $fullfile == '..') {
			continue;
		}
		$path = $_POST['node']."/".$fullfile;
		if ($path == SYNOPHOTO_SERVICE_REAL_DIR) {
			continue;
		}
		$item = array();
		$item['text'] = htmlspecialchars($fullfile);
		$item['id'] = $path;
		$result[] = $item;
	}
	chdir($currpath);
	return json_encode($result);
}

function SYNOPHOTO_UPLOAD_EnumUserValidFiles()
{
	$currpath = getcwd();
	chdir($_POST['target']);

	$result = array();
	$result['items'] = array();

	foreach (glob("*") as $fullfile) {
		$path = $_POST['target']."/".$fullfile;
		if (!is_file($path) || (!csSYNOPhotoMisc::IsPhotoFile($path) && !csSYNOPhotoMisc::IsVideoFile($path))) {
			continue;
		}
		$type = 0;
		if (csSYNOPhotoMisc::IsVideoFile($path)) {
			$type = 1;
		}
		$item = array();
		$item['filename'] = $fullfile;
		$item['fileid'] = $path;
		$item['filesize'] = filesize($path);
		$item['type'] = $type; // 0: photo; 1: video; 2: dir
		$result['items'][] = $item;
	}
	chdir($currpath);
	return json_encode($result);
}

function GetDSMPhotoVideoFile($dir)
{
	$files['files'] = array();
	$currPath = getcwd();
	if (false === @chdir($dir)) {
		return $files;
	};

	$i = 0;
	foreach (glob("*") as $fullfile) {
		$path = $dir . '/' . $fullfile;
		if (!is_file($path) || (!csSYNOPhotoMisc::IsPhotoFile($path) && !csSYNOPhotoMisc::IsVideoFile($path))) {
			continue;
		}
		$type = 0;
		if (csSYNOPhotoMisc::IsVideoFile($path)) {
			$type = 1;
		}
		$item = array();
		$item['dir'] = htmlspecialchars($dir);
		$item['name'] = htmlspecialchars($fullfile);
		$item['item_id'] = htmlspecialchars($path);
		$item['dispaly_info'] = htmlspecialchars($path);
		$item['thumb_width'] = 50;
		$item['thumb_height'] = 50;
		if (!$type) {
			$item['type'] = 'photo';
			$item['url'] = './photo_new/images/Window/image_default_photo_dark.png';
			$item['src'] = './photo_new/images/Window/image_default_photo_dark.png';
		} else {
			$item['type'] = 'video';
			$item['url'] = './photo_new/images/Window/image_default_video_dark.png';
			$item['src'] = './photo_new/images/Window/image_default_video_dark.png';
		}
		$files['files'][$i] = $item;
		$i++;
	}
	@chdir($currPath);
	return $files;
}

function SYNOPHOTO_UPLOAD_CopyFiles()
{
	$return["result"] = "fail";

	if (!csSYNOPhotoMisc::CheckPathValid($_REQUEST['path']) ||
		!csSYNOPhotoMisc::CheckPathValid($_REQUEST['create_subfolder']) ||
		!isSet($_REQUEST['list'])) {
		$return["error"] = __('photo_permission_denied');
		return json_encode($return);
	}

	if (!csSYNOPhotoMisc::CheckAlbumUploadable($_REQUEST['path'])) {
		$return["error"] = __('photo_permission_denied');
		return json_encode($return);
	}

	if (!SYNOPHOTO_UPLOAD_SubFolderCreate()) {
		$return["error"] = __('photo_permission_denied');
		return json_encode($return);
	}

	$files = json_decode($_REQUEST['list']);
	$destination_dir = SYNOPHOTO_SERVICE_DIR."/".$_REQUEST['path']."/".$_REQUEST['create_subfolder']."/";
	for ($i = 0; $i < count($files); $i++) {
		$destination_path = $destination_dir.basename($files[$i]);
		if (file_exists($destination_path) && $_REQUEST['overwrite'] == "0") {
			$return['cp_result'][$i] = __('photo_str_upload_skip_file');
			continue;
		}
		if (SYNOPHOTO_UPLOAD_DoCopy($files[$i], $destination_path)) {
			// Copy eaDir of file if it exists
			$basename = basename($files[$i]);
			$src_ea = dirname($files[$i])."/".SYNOPHOTO_EADIR."/".$basename;
			$dest_ea = $destination_dir.SYNOPHOTO_EADIR."/".$basename;
			if (file_exists($src_ea)) {
				SYNOPHOTO_UPLOAD_DoCopy($src_ea, $dest_ea);
			}
			if (!isSet($_REQUEST['create_subfolder']) || $_REQUEST['create_subfolder'] == "") {
				$partial_path = $_REQUEST['path']."/".$basename;
			} else {
				$partial_path = $_REQUEST['path']."/".$_REQUEST['create_subfolder']."/".$basename;
			}
			SYNOPHOTO_UPLOAD_DoIndex($destination_path, trim($partial_path, "/"),  pathinfo($basename));
			$return['cp_result'][$i] = __('photo_str_upload_success');
		} else {
			$return['cp_result'][$i] = __('photo_str_error_unknown_desc');
		}
	}

	$return["result"] = "success";
	return json_encode($return);
}

function SYNOPHOTO_UPLOAD_CheckSubFolder()
{
	if (!isSet($_REQUEST['create_subfolder']) || $_REQUEST['create_subfolder'] == "") {
		$result['success'] = FALSE;
		$result['error'] = __(photo_str_error_unknown_desc);
		return $result;
	}

	$path = SYNOPHOTO_SERVICE_DIR."/".$_REQUEST['path']."/".$_REQUEST['create_subfolder'];
	if (file_exists($path)) {
		if (csSYNOPhotoMisc::CheckAlbumUploadable($_REQUEST['path']."/".$_REQUEST['create_subfolder'])) {
			$result['success'] = TRUE;
			return $result;
		}
		$result['success'] = FALSE;
		$result['error'] = __(photo_permission_denied);
		return $result;
	}
	$result['success'] = TRUE;
	return $result;
}

function SYNOPHOTO_UPLOAD_StartSyncWithFb($albumName)
{
	if (!csSYNOPhotoMisc::isSetToSyncWithFb($albumName)) {
		return;
	}
	$token = csSYNOPhotoMisc::GetConfigDB("photo", "fb_token", "photo_config" );
	$confPath = csSYNOPhotoMisc::getFbSyncConfPath($albumName);
	$albumPath = SYNOPHOTO_SERVICE_REAL_DIR."/".$albumName;
	$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? '-o':'';
	$commend = "/usr/syno/bin/synophoto_sns_utils --pidfile \"".$confPath.".set\" --fbsync \"$useOrig -t '$token' -c ".escapeshellarg($confPath)." ".escapeshellarg($albumPath)."\"";
	@exec($commend." > /dev/null 2>&1");
}

function SYNOPHOTO_UPLOAD_DoCopy($src, $dst)
{
	if (!SYNOPHOTO_UPLOAD_CheckPathIsInValidShare($src)) {
		return false;
	}

	if (is_dir($src)) {
		$hasError = false;
		@mkdir($dst, 0777, true);
		$files = scandir($src);
		foreach ($files as $file) {
			if ($file != "." && $file != "..") {
				if(!SYNOPHOTO_UPLOAD_DoCopy("$src/$file", "$dst/$file")) {
					$hasError = true;
				}
			}
		}
		return !$hasError;
	}
	if (file_exists($src)) {
	   return copy($src, $dst);
	}
}

function SYNOPHOTO_UPLOAD_CheckPathIsInValidShare($fullPath)
{
	if (!csSYNOPhotoMisc::CheckPathValid($fullPath)) {
		return false;
	}

	$shareList = SYNOPHOTO_UPLOAD_GetUserValidShareList();

	foreach ($shareList as $share) {
		if (0 == strncmp($fullPath, $share['path'], strlen($share['path']))) {
			return true;
		}
	}
	return false;
}

function SYNOPHOTO_AVIARY_Add() {
    // save data from aviary url
    $return['success'] = false;

    if (!isset($_GET['dir']) || !isset($_GET['name']) || !isset($_GET['fname']) || !isset($_GET['sid'])) {
	$return['msg'] = 'Wrong params';
	echo json_encode($return);
	exit;
    }

    $dir = @pack('H*', $_GET['dir']);
    $oriName = @pack('H*', $_GET['name']);
    $ext = substr($oriName, strrpos($oriName, '.') + 1);
    $fname = $_GET['fname'] . ".jpg";// . $ext;

	session_write_close();
	session_id($_GET['sid']);
	session_start();

	if (!csSYNOPhotoMisc::CheckAlbumManageable($dir)) {
		$return['msg'] = 'No manage privilege';
		echo json_encode($return);
		exit;
	}

    if (!csSYNOPhotoMisc::IsPhotoFile($fname)) {
	$return['msg'] = 'Not a photo';
	echo json_encode($return);
	exit;
    }

	if ('/' === $dir) {
		$dir = SYNOPHOTO_SERVICE_REAL_DIR;
	} else {
		$dir = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $dir;
	}

	$cwd = getcwd();

	if (!@chdir($dir)) {
		@chdir($cwd);
		$return['msg'] = 'Not a photo';
		csSYNOPhotoMisc::Synophoto_Log("Not a photo");
		echo json_encode($return);
		exit;
	}

	foreach(glob('*') as $file) {
		if (strtolower($file) !== strtolower($fname)) {
			continue;
		}

		$eaDir = $dir . "/@eaDir/" . $file;
		$cmd = "/usr/syno/bin/synophotoio -D ".escapeshellarg($dir . "/@eaDir/" . $file);
		@exec($cmd);
		$cmd = "/usr/syno/bin/synophotoio -d ".escapeshellarg($dir . "/" . $file);
		@exec($cmd);
		$cmd = "/usr/syno/bin/synoindex -d ".escapeshellarg($dir . "/" . $file);
		@exec($cmd);
	}

	@chdir($cwd);

    $image_data = file_get_contents($_REQUEST['url']);
    file_put_contents($dir . "/" . $fname, $image_data);

    @chmod($dir . "/" . $fname, 0777);

    // call synoindex for the new modified file
    $path = @pack('H*', $_GET['dir']);
    $destination_dir = SYNOPHOTO_SERVICE_DIR . "/" . $path . "/";
    $basename = basename($fname);
    $destination_path = $destination_dir . $basename;
    $partial_path = $path . "/" . $basename;

    SYNOPHOTO_UPLOAD_DoIndex($destination_path, trim($partial_path, "/"),  pathinfo($basename));

    $return["success"] = true;
    return json_encode($return);
}
?>
