#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.

GREP="/bin/grep"
PGSQL="/usr/syno/pgsql/bin/psql -U admin"
DATABASE="photo"

echo "Check root folder (/) in photo_share table or not"
SQL="SELECT sharename FROM photo_share WHERE sharename='/'"
$PGSQL $DATABASE -c "$SQL" | $GREP "(0 rows)" > /dev/null 2>&1
hasRootFolder=$?

if [ $hasRootFolder = 0 ]; then
	echo "Re-index photo db due to root folder not in photo_share"
	/usr/syno/bin/synoindex -R photo > /dev/null 2>&1
fi

