BEGIN;

CREATE TABLE photo_label (
	id serial NOT NULL unique,
	name text,
	category int4 NOT NULL,
	info text DEFAULT '',
        CONSTRAINT photo_label_id_primary_key PRIMARY KEY (id)
);

CREATE TABLE photo_image_label (
  id serial NOT NULL,
  image_id int4 NOT NULL,
  label_id int4 NOT NULL,
  info text DEFAULT '',
  status bool default true,
  PRIMARY KEY (id),
  CONSTRAINT photo_image_label_photo_id_fkey1 FOREIGN KEY (image_id) REFERENCES photo_image (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
  CONSTRAINT photo_image_label_label_id_fkey1 FOREIGN KEY (label_id) REFERENCES photo_label (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE
);

CREATE TABLE photo_video_label (
  id serial NOT NULL,
  video_path text NOT NULL,
  label_id int4 NOT NULL,
  info text DEFAULT '',
  status bool default true,
  PRIMARY KEY (id),
  updated char(1),
  CONSTRAINT photo_video_label_label_id_fkey1 FOREIGN KEY (label_id) REFERENCES photo_label (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE
);

COMMIT;
