BEGIN;

create table category
(
	id INTEGER NOT NULL,
	name TEXT NOT NULL,
	hidden TEXT DEFAULT 'f',
	order_number INTEGER NOT NULL,
	create_date timestamp DEFAULT current_timestamp,
	modify_date timestamp DEFAULT current_timestamp,
	CONSTRAINT category_pkey PRIMARY KEY (id),
	CONSTRAINT category_ukey UNIQUE (name)
);

create table category_items
(
	id INTEGER NOT NULL,
	category_id INTEGER NOT NULL,
	type TEXT NOT NULL,
	order_number INTEGER not NULL,
	album_id INTEGER
		REFERENCES photo_share (shareid)
		ON UPDATE CASCADE ON DELETE CASCADE,
	tag_id INTEGER
		REFERENCES photo_label (id)
		ON UPDATE CASCADE ON DELETE CASCADE,
	smart_id TEXT,
	CONSTRAINT category_items_pkey PRIMARY KEY (id),
	CONSTRAINT category_item_album_ukey UNIQUE (category_id, album_id),
	CONSTRAINT category_items_tag_ukey UNIQUE (category_id, tag_id),
	CONSTRAINT category_items_smart_ukey UNIQUE (category_id, smart_id),
	CONSTRAINT category_items_fkey FOREIGN KEY (category_id)
		REFERENCES category (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

COMMIT;
