<?PHP

require_once('photo.inc.php');
require_once('photoutil.php');
require_once('albumutil.php');

class TimelineAPI extends WebAPI
{
	function __construct()
	{
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache();
		if (!strcasecmp($this->method, "getindex")) {
			$this->GetIndex();
		}
	}

	private function GetIndex()
	{
		$ret = false;
		$resp = array();
		$dates = array();
		$year_index = array();
		$month_index = array();
		
		/* required params setting */
		$type = $_REQUEST['type'];
		if (!strstr($type, 'photo') && !strstr($type, 'video')) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}
		$filter_smart = isset($_REQUEST['filter_smart']) ? $_REQUEST['filter_smart'] : '';
		$filter_tag = isset($_REQUEST['filter_tag']) ? $_REQUEST['filter_tag'] : '';
		$filter_album = isset($_REQUEST['filter_album']) ? $_REQUEST['filter_album'] : '';
		
		if ('' !== $filter_album) {
			$arr = explode('_', $filter_album);
			if ('album' !== $arr[0]) {
				$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
				goto End;
			}
			if (false === ($albumPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . @pack('H*', $arr[1])))) {
				$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
				goto End;
			}
			$personalAlbumPath = @pack('H*', $arr[1]);
		} else {
			$albumPath = SYNOPHOTO_SERVICE_REAL_DIR;
			$personalAlbumPath = '';
		}

		if ('root' !== SYNOPHOTO_ADMIN_USER) { //personal photo station
			if ('' !== $filter_album) {
				$escPath = PHOTO_DB_EscapeParam($personalAlbumPath . '/%');
			} else {
				$escPath = PHOTO_DB_EscapeParam($personalAlbumPath . '%');
			}
		} else {
			$escPath = PHOTO_DB_EscapeParam($albumPath . '/%');
		}

		if ('' === $filter_smart) {
			/* filter by albumname and tag */
			$sqlParam = array();
			$photoQuery = '';
			if (strstr($type, 'photo')) {
				$photoQuery .= "SELECT p.timetaken as date ";
				$photoQuery .= "FROM photo_image as p ";
				$photoQuery .= "WHERE p.path LIKE '" . $escPath . "' ";

				if ('' !== $filter_tag) {
					$photoQuery .= "AND p.id IN (SELECT photo_image_label.image_id FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id = photo_image.id ";
					$photoQuery .= "WHERE (" . PhotoAPIUtil::getLabelIDConstraint($filter_tag) . ")) ";
				}
				$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();

				if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && count($albumCondition['albumCond']) > 0) {
					$photoQuery .= "AND (" . implode(' OR ', $albumCondition['albumCond']) . ') ';
					$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
				}
			}
			$videoQuery = '';
			if (strstr($type, 'video')) {
				$videoQuery = "SELECT v.mdate as date ";
				$videoQuery .= "FROM video v ";
				$videoQuery .= "WHERE v.path LIKE '" . $escPath . "' ";

				if ('' !== $filter_tag) {
					$videoQuery .= "AND v.path IN (SELECT video_path FROM photo_video_label LEFT JOIN video ON photo_video_label.video_path = video.path ";
					$videoQuery .= "WHERE (" . PhotoAPIUtil::getLabelIDConstraint($filter_tag) . "))";
				}
				$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
				if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && count($albumCondition['albumCond']) > 0) {
					$videoQuery .= "AND (" . implode(' OR ', $albumCondition['albumCond']) . ') ';
					$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
				}
			}

			if ('' !== $photoQuery && '' !== $videoQuery) {
				$query = "SELECT date(g.date) as date from ($photoQuery UNION $videoQuery) as g";
			} elseif ('' === $photoQuery) {
				$query = "SELECT date(g.date) as date from ($videoQuery) as g";
			} else {
				$query = "SELECT date(g.date) as date from ($photoQuery) as g";
			}

			$query .= " GROUP BY date(g.date) ORDER BY date(g.date) desc";
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			while ($row = PHOTO_DB_FetchRow($db_result)) {
				if (strlen($row["date"]) < 10) {
					$dates[] = '1970-01-01';
				} else {
					$dates[] = $row["date"];
				}
			}
		} else {
			/* for smart album */
			$arr = explode('_', $filter_smart);
			if ('smart' !== $arr[0]) {
				$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
				goto End;
			}
			$albumName = @pack('H*', $arr[1]);
			$data = array(
				"name" => $albumName,
				"offset" => 0,
				"limit" => -1
			);
			$smart = json_decode(SmartAlbum::ListItem(json_encode($data)), true);
			if (!$smart['success']) {
				$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
				goto End;
			}
			$itemLists = $smart['data']['itemList'];

			foreach ($itemLists as $row) {
				if (!strstr($type, $row['type'])) {
					continue;
				}
				if (false !== ($item = PhotoAPIUtil::getItemByPath($row['path'], $additional, $row['type'], false))) {
					$takentime = $item['info']['takendate'];
					$date = substr($takentime, 0, 10);
					if (strlen($date) < 10) {
						$date = '1970-01-01';
					}
					if (FALSE == in_array($date, $dates)) {
						$dates[] = $date;
					}
				}
			}
		}

		arsort($dates);
		$sorted_dates = array();
		foreach ($dates as $date) {
			$sorted_dates[] = $date;
		}
		$dates = $sorted_dates;

		$objs = array();
		for ($i=0; $i<count($dates); $i++) {
			$item = array();
			$item['date'] = $dates[$i];
			$item['year'] = substr($dates[$i], 0, 4);
			$item['month'] = substr($dates[$i], 5, 2);
			$item['day'] = substr($dates[$i], 8, 2);
			$item['index'] = $i;
			$objs[] = $item;
		}

		// set return data
		$resp['total'] = count($dates);
		$resp['date'] = $dates;
		$resp['date_objs'] = $objs;

		$this->SetResponse($resp);


		$ret = true;
		End:
			return $ret;
		
	}

}

$api = new TimelineAPI();
$api->Run();
