<?php

require_once('tag.inc.php');
require_once('albumutil.php');

class TagAPI extends WebAPI {
    function __construct() {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process()
    {
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache();

        if (!strcasecmp($this->method, "list")) {
            $this->TagList();
        } elseif (!strcasecmp($this->method, "getinfo")) {
            $this->GetInfo();
        } else {
            csSYNOPhotoMisc::CheckSessionTimeOut(true);

            if (!strcasecmp($this->method, "create")) {
                 $this->Create();
            } else if (!strcasecmp($this->method, "searchplace")) {
                $this->SearchPlace();
            } else {
                csSYNOPhotoMisc::CheckSessionTimeOut();

                if (!strcasecmp($this->method, "edit")) {
                    $this->Edit();
                } elseif (!strcasecmp($this->method, "delete")) {
                    $this->Delete();
                }
            }
        }
    }

	private function GetParams_SearchPlace()
	{
		if (!isset($_REQUEST['query']) || !isset($_REQUEST['location'])) {
			return false;
		}
		$params = array();
		$params['query'] = $_REQUEST['query'];
		$params['location'] = $_REQUEST['location'];
		$params['radius'] = (isset($_REQUEST['radius'])) ? $_REQUEST['radius'] : '500';
		return $params;
	}

    private function GetParams_Edit()
    {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['name'])) {
            return false;
        }
        $arr = explode('tag_', $_REQUEST['id']);
        if (2 !== count($arr)) {
            return false;
        }
        $params['id'] = $arr[1];
        $params['name'] = $_REQUEST['name'];

        // for geo tag
        $params['place_id'] = (isset($_REQUEST['place_id'])) ? $_REQUEST['place_id'] : null;
        $params['reference'] = (isset($_REQUEST['reference'])) ? $_REQUEST['reference'] : null;
        $params['lat'] = (isset($_REQUEST['lat'])) ? $_REQUEST['lat'] : null;
        $params['lng'] = (isset($_REQUEST['lng'])) ? $_REQUEST['lng'] : null;
        $params['address'] = (isset($_REQUEST['address'])) ? $_REQUEST['address'] : null;
        return $params;
    }

    private function GetParams_Create()
    {
        if (!isset($_REQUEST['name']) || !isset($_REQUEST['type'])) {
            return false;
        }
        $params['name'] = $_REQUEST['name'];
        $params['type'] = $_REQUEST['type'];
        if (!in_array($params['type'], array('people', 'geo', 'desc'))) {
            return false;
        }

        // for geo tag
        if ('geo' === $params['type']) {
            $params['place_id'] = (isset($_REQUEST['place_id'])) ? $_REQUEST['place_id'] : null;
            $params['reference'] = (isset($_REQUEST['reference'])) ? $_REQUEST['reference'] : null;
            $params['lat'] = (isset($_REQUEST['lat'])) ? $_REQUEST['lat'] : null;
            $params['lng'] = (isset($_REQUEST['lng'])) ? $_REQUEST['lng'] : null;
            $params['address'] = (isset($_REQUEST['address'])) ? $_REQUEST['address'] : null;
        }
        return $params;
    }

    private function GetParams_Info()
    {
        if (!isset($_REQUEST['id'])) {
            return false;
        }
        $params['id'] = array();
        $arr = explode(',', $_REQUEST['id']);
        foreach ($arr as $item) {
            $split = explode('tag_', $item);
            if (2 !== count($split)) {
                return false;
            }
            array_push($params['id'], $split[1]);
        }

        $params['thumbnail_status'] = isset($_REQUEST['thumbnail_status']) ? $_REQUEST['thumbnail_status'] : 'false';
        if (!in_array($params['thumbnail_status'], array('true', 'false'))) {
            return false;
        }

        $params['additional'] = explode(',', $_REQUEST['additional']);
        return $params;
    }

    private function GetParams_List()
    {
        if (!isset($_REQUEST['offset']) || !isset($_REQUEST['limit']) || !isset($_REQUEST['type'])) {
            return false;
        }
        if (!is_numeric($_REQUEST['offset']) || !is_numeric($_REQUEST['limit'])) {
            return false;
        }
        $params['offset'] = (int)$_REQUEST['offset'];
        $params['limit'] = (int)$_REQUEST['limit'];
        $params['type'] = explode(',', $_REQUEST['type']);
        foreach ($params['type'] as $type) {
            if (!in_array($type, array('people', 'geo', 'desc'))) {
                return false;
            }
        }

        $params['thumbnail_status'] = isset($_REQUEST['thumbnail_status']) ? $_REQUEST['thumbnail_status'] : 'false';
        if (!in_array($params['thumbnail_status'], array('true', 'false'))) {
            return false;
        }

        $params['sort_by'] = (isset($_REQUEST['sort_by'])) ? $_REQUEST['sort_by'] : 'title';
        if ((null !== $params['sort_by']) && !in_array($params['sort_by'], array('title'))) {
            return false;
        }
        $params['sort_direction'] = (isset($_REQUEST['sort_direction'])) ? $_REQUEST['sort_direction'] : 'asc';
        if ((null !== $params['sort_direction']) && !in_array($params['sort_direction'], array('asc', 'desc'))) {
            return false;
        }

        $params['unconfirm_people_tag'] = isset($_REQUEST['unconfirm_people_tag']) ? $_REQUEST['unconfirm_people_tag'] : 'false';
        if (!in_array($params['unconfirm_people_tag'], array('true', 'false'))) {
            return false;
        }

        $params['additional'] = explode(',', $_REQUEST['additional']);

        return $params;
    }

    private function CategoryNameToNum($name)
    {
        if (!isset($name)) {
            return false;
        }
        switch ($name) {
        case 'people':
            $codeNum = 0;
            break;
        case 'geo':
            $codeNum = 1;
            break;
        case 'desc':
            $codeNum = 2;
            break;
        default:
            return false;
            break;
        }
        return $codeNum;
    }

    private function CategoryNumToName($num)
    {
        if (!isset($num)) {
            return false;
        }
        switch ($num) {
        case 0:
            $name = 'people';
            break;
        case 1:
            $name = 'geo';
            break;
        case 2:
            $name = 'desc';
            break;
        default:
            return false;
            break;
        }
        return $name;
    }

    private function UpdateTag($id, $name, $info)
    {
        if (!isset($id) || !isset($name)) {
            return false;
        }

        $query = "UPDATE photo_label SET name = ?, info = ? WHERE id = ?";
        $sqlParam = array($name, $info, $id);
        if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
        return true;
    }

    private function GetTagListByIDs($IDs)
    {
        $idString = implode(',', $IDs);
        $query = "SELECT * FROM photo_label WHERE id in ({$idString})";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        if (false === ($row = PHOTO_DB_FetchAll($db_result))) {
            return false;
        }
        return $row;
    }

    private function GetTagList($limit = false, $offset = false, $sort_by = 'name', $sort_direction = 'asc', $types)
    {
        $sortBy = ('title' === $sort_by) ? 'name' : 'name';
        $sortDirection = ('desc' === $sort_direction) ? 'desc' : 'asc';

        $conditionArr = array();
        foreach ($types as $type) {
            array_push($conditionArr, "category={$type}");
        }
        $condition = implode(' OR ', $conditionArr);

        if (false !== $limit && false !== $offset) {
            $query = "SELECT * FROM photo_label WHERE {$condition} ORDER BY {$sortBy} {$sortDirection} limit {$limit} offset {$offset}";
        } else {
            $query = "SELECT * FROM photo_label WHERE {$condition} ORDER BY {$sortBy} {$sortDirection}";
        }
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        if (false === ($row = PHOTO_DB_FetchAll($db_result))) {
            return false;
        }
        return $row;
    }

    private function GetTotalTagList($types)
    {
        $conditionArr = array();
        foreach ($types as $type) {
            array_push($conditionArr, "category={$type}");
        }
        $condition = implode(' OR ', $conditionArr);

        $query = "SELECT count(id) FROM photo_label WHERE {$condition}";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        return $row[0];
    }

    private function GetTotalPhotoVideoByTagID($tagID)
    {
        // photo
        $query = "SELECT count(id) FROM photo_image_label WHERE label_id={$tagID}";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        $photoCount = $row[0];

        // video
        $query = "SELECT count(id) FROM photo_video_label WHERE label_id={$tagID}";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        $videoCount = $row[0];

        $total = $photoCount + $videoCount;
        return $total;
    }

    private function FormAdditional($data, $params)
    {
        if (in_array('info', $params['additional'])) {
            $type = $this->CategoryNumToName($data['category']);
            if ('people' === $type) {
                $people['name'] = $data['name'];
                $additional['info'] = $people;
            } elseif ('geo' === $type) {
                $geo['name'] = $data['name'];
                if (false !== ($extra = json_decode($data['info'], true))) {
                    $geo['lat'] = $extra['lat'];
                    $geo['lng'] = $extra['lng'];
                    $geo['place_id'] = $extra['placeId'];
                    $geo['address'] = (null === $extra['address']) ? '' : $extra['address'];
                }
                $additional['info'] = $geo;
            } elseif ('desc' === $type) {
                $desc['name'] = $data['name'];
                $additional['info'] = $desc;
            }
        }
        if (in_array('extra', $params['additional'])) {
            $additional['extra'] = $data['info'];
        }
        if (in_array('count', $params['additional'])) {
            $total = $this->GetTotalPhotoVideoByTagID($data['id']);
            $additional['count'] = (int)$total;
        }
        return $additional;
    }

    private function FormListTags($data, $params)
    {
        $needThumbSize = in_array('thumb_size', $params['additional']);

        $tags = array();
        foreach ($data as $key => $value) {
            // 0 - people tag; 1 - get tag; 2 - desc tag
            if (0 === $key && !in_array('people', $params['type'])) {
                continue;
            }
            if (1 === $key && !in_array('geo', $params['type'])) {
                continue;
            }
            if (2 === $key && !in_array('desc', $params['type'])) {
                continue;
            }
            foreach ($data[$key] as $item) {
                unset($tag);
                $item['category'] = $key;
                $tag_type = $this->CategoryNumToName($item['category']);
                $tag['id'] = 'tag_'.$item['id'];
                $tag['type'] = 'tag';
                $tag['tag_type'] = $tag_type;
                $tag['name'] = $item['name'];
                $additional = $this->FormAdditional($item, $params);
                if (null !== $additional) {
                    $tag['additional'] = $additional;
                }
                if ('true' === $params['thumbnail_status']) {
                    $result = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumCoverFromDB($item['id']);
                    $coverPath = $result['path'];
                    AlbumAPIUtil::FillThumbStatus($tag, $coverPath, $needThumbSize, false);
                }
                array_push($tags, $tag);
            }
        }
        return $tags;
    }

    private function FormInfoTags($data, $params)
    {
        $needThumbSize = in_array('thumb_size', $params['additional']);

        $tags = array();
        foreach ($data as $item) {
            $tag['id'] = 'tag_'.$item['id'];
            $tag['type'] = 'tag';
            $tag['tag_type'] = $this->CategoryNumToName($item['category']);
            $tag['name'] = $item['name'];
            $additional = $this->FormAdditional($item, $params);
            if (null !== $additional) {
                $tag['additional'] = $additional;
            }
            if ('true' === $params['thumbnail_status']) {
                $result = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumCoverFromDB($item['id']);
                $coverPath = $result['path'];
                AlbumAPIUtil::FillThumbStatus($tag, $coverPath, $needThumbSize, false);
            }
            array_push($tags, $tag);
        }
        return $tags;
    }

    private function AddUnConfirmTag($list, $params, &$tags)
    {
        $needThumbSize = in_array('thumb_size', $params['additional']);

        $arr = array();
        $unConfirmTag['id'] = SYNOPHOTO_UNCONFIRM_TAG_ID;
        $unConfirmTag['type'] = 'tag';
        $unConfirmTag['tag_type'] = 'people';
        $unConfirmTag['name'] = '';

		$coverPath = '';
        if (is_array($list)) {
            $pathList = array_keys($list);
			$coverPath = $pathList[0];
        }
		AlbumAPIUtil::FillThumbStatus($unConfirmTag, $coverPath, $needThumbSize, false);

        array_push($arr, $unConfirmTag);
        array_splice($tags, 0, 0, $arr);
    }

    private function SortName_ASC($a, $b) {
        if ($a['name'] == $b['name']) {
            return 0;
        }
        return ($a['name'] < $b['name']) ? -1 : 1;
    }

    private function SortName_DESC($a, $b) {
        if ($a['name'] == $b['name']) {
            return 0;
        }
        return ($a['name'] > $b['name']) ? -1 : 1;
    }

    private function SortTags($sortBy, $sortDirection, &$sortTags)
    {
        if ('title' === $sortBy) {
            if ('asc' === $sortDirection) {
                usort($sortTags, 'self::SortName_ASC');
            } else {
                usort($sortTags, 'self::SortName_DESC');
            }
        }
    }

    private function TagList()
    {
        if (false === ($params = $this->GetParams_List())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        // get category type number  - people(0), geo(1), desc(2)
        $types = array();
        foreach ($params['type'] as $type) {
            if (false === ($num = $this->CategoryNameToNum($type))) {
                $this->SetError(WEBAPI_ERR_BAD_REQUEST);
                goto End;
            }
            array_push($types, $num);
        }
        // database query
        $result = SYNOPHOTO_LABEL_UTIL_GetAllLabel(false, $types);
        $totalTags = $this->FormListTags($result, $params);
        
        // sorting
        $this->SortTags($params['sort_by'], $params['sort_direction'], $totalTags);

        // add people unconfirm tag
        if (in_array('people', $params['type']) && 'true' === $params['unconfirm_people_tag']) {
            $list = AlbumAPIUtil::GetUnConfirmItemList();
            if (0 < (int)$list['total']) {
                $this->AddUnConfirmTag($list, $params, $totalTags);
            }
        }
        $total = count($totalTags);

        // set offset and limit
        if (0 > $params['limit']) {
            $tags = array_slice($totalTags, $params['offset']);
        } else {
            $tags = array_slice($totalTags, $params['offset'], $params['limit']);
        }

        $resp['total'] = (int)$total;
        $offset = (0 > $params['limit']) ? $resp['total'] : $params['offset'] + $params['limit'];
        $resp['offset'] = ($offset > $total) ?  (int)$total : (int)$offset;
        $resp['tags'] = $tags;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function GetInfo()
    {
        if (false === ($params = $this->GetParams_Info())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // database query
        if (false === ($result = $this->GetTagListByIDs($params['id']))) {
            $this->SetError(PHOTOSTATION_TAG_GETINFO_FAIL);
            goto End;
        }
        // form to webapi format
        $tags = $this->FormInfoTags($result, $params);

        $resp['tags'] = $tags;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function CheckAtLeastOneAlbumManageable()
    {
        if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			return true;
        }
        if (0 < count($_SESSION[SYNOPHOTO_ADMIN_USER]['manageable_album'])) {
            return true;
        }
        return false;
    }

    private function CheckGeoTagExist($name, $info)
    {
        if (false === ($row = SYNOPHOTO_LABEL_UTIL_GetGeoLabel($name, json_encode($info)))) {
            return false;
        }

        $dbInfo = json_decode($row['info'], true);
        if ($info['placeId'] !== $dbInfo['placeId']) {
            return false;
        }
        return $row;
    }

    private function Create()
    {
        // check permmision
        if (!$this->CheckAtLeastOneAlbumManageable()) {
            $this->SetError(PHOTOSTATION_TAG_ACCESS_DENY);
            goto End;
        }

        if (false === ($params = $this->GetParams_Create())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        // add label parameter
        $label['name'] = $params['name'];
        $label['category'] = $this->CategoryNameToNum($params['type']);
        $label['info'] = '';
        if ('geo' === $params['type']) {
			$info['placeId'] = '';
            if (null !== $params['place_id']) {
                $info['placeId'] = $params['place_id'];
            }
            if (null !== $params['reference']) {
                $info['reference'] = $params['reference'];
            }
            if (null !== $params['lat']) {
                $info['lat'] = $params['lat'];
            }
            if (null !== $params['lng']) {
                $info['lng'] = $params['lng'];
            }
            if (null !== $params['address']) {
                $info['address'] = $params['address'];
            }
            if (!empty($info)) {
                $json = json_encode($info);
                $label['info'] = $json;
            }
        }

        $blCreateNewTag = false;
        if ('geo' === $params['type']) {
            // (name, place_id) as primary key in geo tag
            if (false === ($row = $this->CheckGeoTagExist($label['name'], $info))) {
                $blCreateNewTag = true;
            }
        } elseif ('people' === $params['type'] || 'desc' === $params['type']) {
            // (name, category) as primary key in people, desc tag
            if (false === ($row = SYNOPHOTO_LABEL_UTIL_GetLabel($label['name'], $label['category']))) {
                $blCreateNewTag = true;
            }
        }
        if ($blCreateNewTag) {
            // database query
            if (false === SYNOPHOTO_LABEL_UTIL_AddNewLabel($label)) {
                $this->SetError(PHOTOSTATION_TAG_CREATE_FAIL);
                goto End;
            }
            // get id
            if ('geo' === $params['type']) {
                $row = SYNOPHOTO_LABEL_UTIL_GetGeoLabel($label['name'], json_encode($info));
            } elseif ('people' === $params['type'] || 'desc' === $params['type']) {
                $row = SYNOPHOTO_LABEL_UTIL_GetLabel($label['name'], $label['category']);
            }

            if (false === $row) {
                $this->SetError(PHOTOSTATION_TAG_CREATE_FAIL);
                goto End;
            }
        }

        $resp['id'] = 'tag_'.$row['id'];
        $this->SetResponse($resp);
    End:
        return;
    }

    private function CheckTagExsit($tagId, $name, $placeId, $type)
    {
        $labels = SYNOPHOTO_LABEL_UTIL_GetLable();
        $jsonLabels = json_decode($labels, true);
        if (false === $jsonLabels['success']) {
            return true;
        }
        foreach ($jsonLabels['labels'] as $label) {
            $dbId = $label['id'];
            $dbName = $label['name'];
            $dbType = $this->CategoryNumToName($label['category']);
            $info = json_decode($label['info'], true);
            $dbPlaceId = $info['placeId'];

            if ($dbId != $tagId && $dbName === $name && $dbType === $type) {
                if ('geo' === $type && $dbPlaceId === $placeId) {
                    return true;
                } elseif ('people' === $type || 'desc' === $type) {
                    return true;
                }
            }
        }
        return false;
    }

    private function Edit()
    {
        // check permmision
        if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
            $this->SetError(PHOTOSTATION_TAG_ACCESS_DENY);
            goto End;
        }

        if (false === ($params = $this->GetParams_Edit())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get original label
        $ids = array();
        array_push($ids, $params['id']);
        if (false === ($result = $this->GetTagListByIDs($ids))) {
            $this->SetError(PHOTOSTATION_TAG_EDIT_FAIL);
            goto End;
        }
        $origLabel = json_decode($result[0]['info'], true);
        $type = $this->CategoryNumToName($result[0]['category']);
        // add label parameter
        $label['info'] = '';
        if ('geo' === $type) {
            $info['placeId'] = (null !== $params['place_id']) ? $params['place_id'] : $origLabel['placeId'];
            $info['reference'] = (null !== $params['reference']) ? $params['reference'] : $origLabel['reference'];
            $info['lat'] = (null !== $params['lat']) ? $params['lat'] : $origLabel['lat'];
            $info['lng'] = (null !== $params['lng']) ? $params['lng'] : $origLabel['lng'];
            $info['address'] = (null !== $params['address']) ? $params['address'] : $origLabel['address'];
            if ('' === $info['placeId'] || null === $info['placeId']) {
                unset($info['placeId']);
            }
            if ('' === $info['reference'] || null === $info['reference']) {
                unset($info['reference']);
            }
            if ('' === $info['lat'] || null === $info['lat']) {
                unset($info['lat']);
            }
            if ('' === $info['lng'] || null === $info['lng']) {
                unset($info['lng']);
            }
            if ('' === $info['address'] || null === $info['address']) {
                unset($info['address']);
            }
            $label['info'] = json_encode($info);
        }

        // check tag exist
        if ($this->CheckTagExsit($params['id'], $params['name'], $info['placeId'], $type)) {
            $this->SetError(PHOTOSTATION_TAG_HAS_EXIST);
            goto End;
        }

        // database query
        if (false === $this->UpdateTag($params['id'], $params['name'], $label['info'])) {
            $this->SetError(PHOTOSTATION_TAG_EDIT_FAIL);
            goto End;
        }

    End:
        return;
    }

    private function Delete()
    {
        // check permmision
        if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
            $this->SetError(PHOTOSTATION_TAG_ACCESS_DENY);
            goto End;
        }

        if (false === ($params = $this->GetParams_Info())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        foreach ($params['id'] as $id) {
            SYNOPHOTO_LABEL_UTIL_DeleteLabel($id);
        }
    End:
        return;
    }

	private function SearchExistGeoTag($query)
	{
		$escape = PHOTO_DB_GetEscape();
		$sqlParam = array();

		$sql = "SELECT * FROM photo_label WHERE category = 1 AND name LIKE ? $escape";
		$sqlParam[] = '%' . PHOTO_DB_EscapForLike($query) . '%';

		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $sql, $sqlParam);
		$places = array();
		while (false !== ($row = PHOTO_DB_FetchRow($db_result))) {
			$info = json_decode($row['info'], true);
			$item = array();
			$item['name'] = $row['name'];
			$item['tagId'] = $row['id'];
			$item['placeId'] = '';
			$item['address'] = '';
			$item['gps'] = null;
			if ($info && '' !== $info['placeId']) {
				$item['placeId'] = $info['placeId'];
				$item['address'] = $info['address'];
				$item['gps'] = array('lat' => $info['lat'], 'lng' => $info['lng']);
			}
			$places[] = $item;
		}
		return $places;
	}

	private function SearchPlace()
	{
		// check permmision
		if (!$this->CheckAtLeastOneAlbumManageable()) {
			$this->SetError(PHOTOSTATION_TAG_ACCESS_DENY);
			goto End;
		}
		if (false === ($params = $this->GetParams_SearchPlace())) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			goto End;
		}

		$query = escapeshellarg($params['query']);
		$location = escapeshellarg($params['location']);
		$radius = escapeshellarg($params['radius']);
		$language = escapeshellarg($_SESSION[SYNOPHOTO_ADMIN_USER]['lang']);

		$phppath = '/var/packages/PhotoStation/target/photo_scripts/tag_place_search.php';

		$cmd = '/usr/syno/bin/php -n -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so -d extension=curl.so'.
			" $phppath -q $query -l $location -r $radius -n $language";


		@exec($cmd, $output, $ret);
		if (0 !== $ret) {
			$this->SetError(PHOTOSTATION_TAG_SEARCH_FAIL);
			goto End;
		}

		$json = json_decode(implode('', $output), true);

		$finalPlaces = array();
		$searchPlaces = array();
		$existPlace = array();

		if (is_array($json['results'])) {
			foreach ($json['results'] as $place) {
				$item = array();
				$item['address'] = $place['formatted_address'];
				$item['gps'] = $place['geometry']['location'];
				$item['placeId'] = $place['id'];
				$item['name'] = $place['name'];
				$item['tagId'] = -1;
				$searchPlaces[] = $item;
			}
		}
		$existPlace = $this->SearchExistGeoTag($params['query']);
		$resp['existPlaces'] = $existPlace;
		$resp['searchPlaces'] = $searchPlaces;

		$this->SetResponse($resp);
	End:
		return;
	}
}

$api = new TagAPI();
$api->Run();


?>
