<?php
/* Copyright (c) 2000-2012 Synology Inc. All rights reserved. */
require_once 'query.inc.php';

class QueryAPI extends WebAPI
{
	public function __construct()
	{
		parent::__construct(SZ_QUERY_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		if (!strcasecmp($this->method, "query")) {
			$this->Query();
		}
	}

	public static function CheckAPIDescription($apiDesc)
	{
		if (!is_string($apiDesc[SZK_API_PATH]) || !is_int($apiDesc[SZK_API_MIN_VERSION]) || !is_int($apiDesc[SZK_API_MAX_VERSION])) {
			return false;
		}

		return true;
	}

	public static function GetAPIDescriptions()
	{
		$allApiDescs = array();
		$apiFiles = glob(CONF_API_DESCRIPTION_DIR.'/*.api', GLOB_MARK);
		foreach ($apiFiles as $file) {
			$jsonString = file_get_contents($file);
			$apiDescs = json_decode($jsonString, true);
			foreach ($apiDescs as $apiName => $apiDesc) {
				if (!self::CheckAPIDescription($apiDesc)) {
					WebAPIUtil::Log("API desc error. api=$apiName, desc=$apiDesc");
					continue;
				}

				$allApiDescs[$apiName][SZK_API_PATH] = $apiDesc[SZK_API_PATH];
				$allApiDescs[$apiName][SZK_API_MIN_VERSION] = $apiDesc[SZK_API_MIN_VERSION];
				$allApiDescs[$apiName][SZK_API_MAX_VERSION] = $apiDesc[SZK_API_MAX_VERSION];
			}
		}

		return $allApiDescs;
	}

	public function Query()
	{
		$allApiDescs = self::GetAPIDescriptions();
		$queryedApiDescs = array();

		if (!isset($_REQUEST['query']) || !strcasecmp($_REQUEST['query'], 'all')) {
			$this->SetResponse($allApiDescs);
			return;
		}

		$queries = WebAPIUtil::ParseToArray($_REQUEST['query'], ",");
		foreach ($queries as $query) {
			$isPrefix = (0 === substr_compare($query, '.', -1, 1)); // end with '.'
			if ($isPrefix) {
				foreach ($allApiDescs as $apiName => $apiDesc) {
					if (!strncmp($apiName, $query, strlen($query))) {
						$queryedApiDescs[$apiName] = $apiDesc;
					}
				}
			} else {
				if (isset($allApiDescs[$query])) {
					$queryedApiDescs[$query] = $allApiDescs[$query];
				}
			}
		}

		if (empty($queryedApiDescs)) {
			// convert empty array to empty object for json output
			$queryedApiDescs = json_decode('{}');
		}

		$this->SetResponse($queryedApiDescs);

		return;
	}
}

$api = new QueryAPI();
$api->Run();
