<?PHP

ini_set("session.use_only_cookies", 0);
set_time_limit(0);
session_cache_limiter("must-revalidate");

if (!session_id()) {
	session_start();
}

require_once('download.inc.php');

class DownloadAPI extends WebAPI
{
	function __construct()
	{
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache();
		if (!strcasecmp($this->method, "getphoto")) {
			$this->GetPhoto();
		}
		if (!strcasecmp($this->method, "getvideo")) {
			$this->GetVideo();
		}
		if (!strcasecmp($this->method, "getitem")) {
			$this->GetItem();
		}
	}

	private function GetPhoto()
	{
		$ret = false;
		if ('on' !== csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_orig')) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_ACCESS_DENY);
			goto End;
		}
		/* return when lack of params */
		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_BAD_PARAMS);
			goto End;
		}

		/* check params */
		$id = $_REQUEST['id'];
		$id_arr = explode('_', $id);
		if ('photo' !== $id_arr[0] || 3 !== count($id_arr)) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_BAD_PARAMS);
			goto End;
		}

		/* start to construct photo path from the given id */
		$albumName = @pack('H*', $id_arr[1]);
		$fileName = @pack('H*', $id_arr[2]);
		$dir = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName;
		$path = $dir . "/" . $fileName;

		/* check access right */
		if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName) || !file_exists($path)) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_ACCESS_DENY);
			goto End;
		}
		session_write_close();

		/* set mime type */
		$mime = $this->SYNOPHOTO_CONVERT_GetPhotoMimeType($path);

		if (isset($_REQUEST['download']) && $_REQUEST['download'] == true) {
			header('Content-Disposition: attachment; filename="' . $this->GetDownloadName($fileName) . '"');
		}

		/* output binary */
		@header("Content-Type: $mime");
		if (!($fd = @fopen($path, 'rb'))) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_ACCESS_DENY);
			goto End;
		}
		$fsize = filesize($path);
		$content = fread($fd, $fsize);
		fclose($fd);
		echo $content;
		flush();
		exit;

		End:
			return $ret;
	}

	private function GetVideo()
	{
		$ret = false;

		/* return when lack of params */
		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_BAD_PARAMS);
			goto End;
		}

		/* check params */
		$id = $_REQUEST['id'];
		$id_arr = explode('_', $id);
		if ('video' !== $id_arr[0] || 3 !== count($id_arr)) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_BAD_PARAMS);
			goto End;
		}

		$quality = isset($_REQUEST['quality_id']) ? $_REQUEST['quality_id'] : 'original';

		/* start to construct video path from the given id */
		$albumName = @pack('H*', $id_arr[1]);
		$fileName = @pack('H*', $id_arr[2]);
		$path = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName . "/" . $fileName;
		$path_parts = pathinfo($path);

		if ('original' !== $quality) {
			$path = @pack('H*', $quality);
		} else {
			if (!in_array(strtolower($path_parts['extension']), array('flv', 'f4v')) &&
				'on' !== csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_video_download', 'photo_config')) {
				//do not check allow_video_download when asking flv & f4v
				$this->SetError(PHOTOSTATION_DOWNLOAD_ACCESS_DENY);
				goto End;
			}
		}

		/* check access right */
		if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName) || !file_exists($path)) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_ACCESS_DENY);
			goto End;
		}
		session_write_close();

		/* set mime type */
		$mime = $this->SYNOPHOTO_CONVERT_GetVideoMimeType($path, 'application/octet-stream');

		// check last-modified value
		$lastModified = $this->GetLastModified($path);
		if ($lastModified) {
			if ($this->CheckLastModified($lastModified)) {
				@header("HTTP/1.1 304 Not Modified");
				return;
			} else {
				@header("Last-Modified: " . $lastModified);
			}
		}
		$contentDisp = 'inline';
		if (isset($_REQUEST['download']) && $_REQUEST['download'] == true) {
			$mime = 'application/octet-stream';
			$contentDisp = 'attachment';
			@header("X-Download-Options: noopen");
		}
		@header("Content-Type: $mime");
		@header("Cache-Control: max-age=".(3600*24*7));
		@header("Content-Disposition: $contentDisp; filename=\"" . $this->GetDownloadName($fileName) . '"');

		$this->SYNOPHOTO_CONVERT_Rrange_Download($path);
		exit;

		End:
			return $ret;
	}

	private function GetItem()
	{
		$ret = false;
		if ('on' !== csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_album_download', 'photo_config')) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_ACCESS_DENY);
			goto End;
		}

		/* return when lack of param */
		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_BAD_PARAMS);
			goto End;
		}

		// zip the files from a specific album
		$albumid = isset($_REQUEST['album_id']) ? $_REQUEST['album_id'] : ''; // ex: album_3131312f323232
		$arr = explode('_', $albumid); // ["album", "3131312f323232"]
		$albumPrefix = '' === $albumid ? '' : @pack('H*', $arr[1]); // "111/222"
		$zipPrefix = dirname($albumPrefix); // "111"

		if ('' === $albumid) {
			$ret = @chdir(SYNOPHOTO_SERVICE_DIR);
		} else {
			$ret = @chdir(dirname(SYNOPHOTO_SERVICE_DIR . "/" . $albumPrefix)); // chdir to "111"
		}
		if (!$ret) {
			$this->SetError(PHOTOSTATION_DOWNLOAD_CHDIR_ERROR);
			goto End;
		}

		/* src is the target files which we are going to make a zip file */
		$src = '';
		$emptyAlbumList = '';
		$ids = explode(',', $_REQUEST['id']);
		foreach ($ids as $idStr) {
			$id = explode('_', $idStr);
			$sharename = @pack('H*', $id[1]);
			$filename = @pack('H*', $id[2]);

			if ('album' === $id[0]) {
				$path = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $sharename;
			} elseif ('photo' === $id[0] || 'video' === $id[0]) {
				$path = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $sharename . "/" . $filename;
			} else {
				continue;
			}

			if (!csSYNOPhotoMisc::CheckAlbumAccessible($sharename) || !file_exists($path)) {
				continue;
			}
			session_write_close();

			$zipPath = preg_replace('/^' . preg_quote($zipPrefix . '/', '/') . '/', '', $sharename);
			$emptyAlbumList = $emptyAlbumList . "'$zipPath' ";
			if ('album' === $id[0]) {
				$src .= $this->SYNOPHOTO_DOWNLOAD_GetDownloadList($sharename, $zipPath) . "\n";
			} else {
				if ('/' === $sharename) {
					$src .= $filename . "\n";
				} else {
					$src .= $zipPath . "/" . $filename . "\n";
				}
			}
		}

		$basename = '' === $albumid ? 'data' : basename($albumPrefix);
		$this->SYNOPHOTO_DOWNLOAD_PrintHeaders($basename . '.zip', true);

		$src = trim($src);
		if (empty($src)) {
			if (empty($emptyAlbumList)) {
				$this->SetError(PHOTOSTATION_DOWNLOAD_ACCESS_DENY);
			} else {
				passthru("/usr/syno/bin/zip -q -G -0 - " . $emptyAlbumList . " -x@" . SYNOPHOTO_INCLUDE_DIR . "/exclude.txt");
			}
		} else {
			$zipFileList = '/tmp/synophoto_download_list_'.session_id().'_'.time().'_'.rand();
			@touch($zipFileList);
			@file_put_contents($zipFileList, $src);
			$cmd = "/usr/syno/bin/zip -q -G -r -0 -@ - -x@" . SYNOPHOTO_INCLUDE_DIR . "/exclude.txt < $zipFileList";
			passthru($cmd);
			@unlink($zipFileList);
		}

		exit;

		End:
			return $ret;
	}

	private function SYNOPHOTO_CONVERT_GetPhotoMimeType($path)
	{
		global $SYNOPHOTO_ALLOW_PICT_NAMES_MIME;

		$path = strtolower($path);
		$path_parts = pathinfo($path);
		$extension = $path_parts['extension'];

		if (array_key_exists($extension, $SYNOPHOTO_ALLOW_PICT_NAMES_MIME)) {
			return $SYNOPHOTO_ALLOW_PICT_NAMES_MIME[$extension];
		} else {
			return "image/x-" . strtolower($extension);
		}
	}

	private function SYNOPHOTO_CONVERT_GetVideoMimeType($path, $default)
	{
		global $SYNOPHOTO_VIDEO_MIME;

		$path = strtolower($path);
		$path_parts = pathinfo($path);
		$extension = $path_parts['extension'];
		if (array_key_exists($extension, $SYNOPHOTO_VIDEO_MIME)) {
			return $SYNOPHOTO_VIDEO_MIME[$extension];
		}
		return $default;
	}

	private function SYNOPHOTO_DOWNLOAD_GetDownloadList($album_name, $zipPath)
	{
		$currPath = getcwd();
		@chdir(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $album_name);
		$result = '';
		foreach (glob('{,.}*', GLOB_BRACE) as $file) {
			if (is_dir($file)) {
				if ($file == SYNOPHOTO_EADIR || $file == '.' || $file == '..') {
					continue;
				}
				if (!csSYNOPhotoMisc::CheckAlbumAccessible($album_name . "/" . $file)) {
					continue;
				}
				$result = $result . $zipPath . "/" . $file . "\n";
			} else {
				if ($file == '.' || $file == '..') {
					continue;
				}
				$result = $result . $zipPath . "/" . $file . "\n";
			}
		}
		@chdir($currPath);
		return $result;
	}

	private function SYNOPHOTO_DOWNLOAD_PrintHeaders($filename, $force_filename)
	{
		header('Content-Type: application/force-download');
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Pragma: public");
		if ($force_filename) {
			header('Content-Disposition: attachment; filename="' . $this->GetDownloadName($filename) . '"');
		} else {
			header('Content-Disposition: attachment');
		}
		header("X-Download-Options: noopen");
	}

	private function SYNOPHOTO_CONVERT_Rrange_Download($file)
	{
		$fp = @fopen($file, 'rb');
		if (false == $fp) {
			return false;
		}

		$size   = filesize($file); // File size
		$length = $size;		   // Content length
		$start  = 0;			   // Start byte
		$end	= $size - 1;	   // End byte
		// Now that we've gotten so far without errors we send the accept range header
		/* At the moment we only support single ranges.
		 * Multiple ranges requires some more work to ensure it works correctly
		 * and comply with the spesifications: http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.2
		 *
		 * Multirange support annouces itself with:
		 * header('Accept-Ranges: bytes');
		 *
		 * Multirange content must be sent with multipart/byteranges mediatype,
		 * (mediatype = mimetype)
		 * as well as a boundry header to indicate the various chunks of data.
		 */
		//header("Accept-Ranges: 0-$length");
		header('Accept-Ranges: bytes');
		// multipart/byteranges
		// http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.2
		if (isset($_SERVER['HTTP_RANGE'])) {
			$c_start = $start;
			$c_end   = $end;
			// Extract the range string
			list(, $range) = explode('=', $_SERVER['HTTP_RANGE'], 2);
			// Make sure the client hasn't sent us a multibyte range
			if (strpos($range, ',') !== false) {

				// (?) Shoud this be issued here, or should the first
				// range be used? Or should the header be ignored and
				// we output the whole content?
				header('HTTP/1.1 416 Requested Range Not Satisfiable');
				header("Content-Range: bytes $start-$end/$size");
				// (?) Echo some info to the client?
				exit;
			}
			// If the range starts with an '-' we start from the beginning
			// If not, we forward the file pointer
			// And make sure to get the end byte if spesified
			if ($range{0} == '-') {

				// The n-number of the last bytes is requested
				$c_start = $size - substr($range, 1);
			} else {

				$range  = explode('-', $range);
				$c_start = $range[0];
				$c_end   = (isset($range[1]) && is_numeric($range[1])) ? $range[1] : $size;
			}
			/* Check the range and make sure it's treated according to the specs.
			 * http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html
			 */
			// End bytes can not be larger than $end.
			$c_end = ($c_end > $end) ? $end : $c_end;
			// Validate the requested range and return an error if it's not correct.
			if ($c_start > $c_end || $c_start > $size - 1 || $c_end >= $size) {

				header('HTTP/1.1 416 Requested Range Not Satisfiable');
				header("Content-Range: bytes $start-$end/$size");
				// (?) Echo some info to the client?
				exit;
			}
			$start  = $c_start;
			$end	= $c_end;
			$length = $end - $start + 1; // Calculate new content length
			fseek($fp, $start);
			header('HTTP/1.1 206 Partial Content');
		}
		// Notify the client the byte range we'll be outputting
		header("Content-Range: bytes $start-$end/$size");
		header("Content-Length: $length");

		// Start buffered download
		$buffer = 1024 * 8;
		while (!feof($fp) && ($p = ftell($fp)) <= $end) {

			if ($p + $buffer > $end) {

				// In case we're only outputtin a chunk, make sure we don't
				// read past the length
				$buffer = $end - $p + 1;
			}

			echo fread($fp, $buffer);
			flush(); // Free up memory. Otherwise large files will trigger PHP's memory limit.
		}
		fclose($fp);
	}

	private function GetLastModified($thumbPath)
	{
		$filest = @stat($thumbPath);

		if ($filest !== false) {
			$lastModified = gmdate('D, d M Y H:i:s', $filest[9]) . ' GMT';
			return $lastModified;
		} else {
			return false;
		}
	}

	private function CheckLastModified($lastModified)
	{
		if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
			$ims = preg_replace('/;.*$/', '', $_SERVER['HTTP_IF_MODIFIED_SINCE'] );
			if ($ims === $lastModified) {
				return true;
			}
		}

		return false;
	}

	private function GetDownloadName($filename)
	{
		if ($this->IsBrowserIE()) {
			return urlencode($filename);
		} else {
			return addslashes($filename);
		}
	}

	private function IsBrowserIE()
	{
		if (isset($_SERVER['HTTP_USER_AGENT'])) {
			if (preg_match('/MSIE/i', $_SERVER['HTTP_USER_AGENT'])) {
				return true;
			}
		}

		return false;
	}
}

$api = new DownloadAPI();
$api->Run();
