<?php

require_once('category.inc.php');
require_once('albumutil.php');

class CategoryAPI extends WebAPI {
    function __construct() {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process() {
        if (!strcasecmp($this->method, "list")) {
			session_write_close();
            $this->CategoryList();
        } elseif (!strcasecmp($this->method, "getinfo")) {
			session_write_close();
            $this->GetInfo();
        } elseif (!strcasecmp($this->method, "listitem")) {
            csSYNOPhotoDB::GetDBInstance()->SetSessionCache();
			session_write_close();
            $this->ListItem();
        } else {
            csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
            csSYNOPhotoMisc::CheckSessionTimeOut();

            if (!strcasecmp($this->method, "create")) {
                $this->Create();
            } elseif (!strcasecmp($this->method, "delete")) {
                $this->Delete();
            } elseif (!strcasecmp($this->method, "edit")) {
                $this->Edit();
            } elseif (!strcasecmp($this->method, "arrangecategory")) {
                $this->ArrangeCategory();
            } elseif (!strcasecmp($this->method, "additem")) {
                $this->AddItem();
            } elseif (!strcasecmp($this->method, "removeitem")) {
                $this->RemoveItem();
            } elseif (!strcasecmp($this->method, "arrangeitem")) {
                $this->ArrangeItem();
            }
        }
    }

    private function BooleanUniform($data) {
        if (true === $data || 't' === $data) {
            return true;
        } elseif (false === $data || 'f' === $data) {
            return false;
        }
        return false;
    }

    private function GetCategoryDatabaseID($data) {
        $arr = explode('category_', $data);
        $id = $arr[1];

        if (empty($id)) {
            return false;
        }
        if (!is_numeric($id)) {
            return false;
        }
        return $id;
    }

    private function CheckItemID($data) {
        $items = explode(',', $data);
        foreach ($items as $item) {
            $arr = explode('_', $item);
            if (!in_array($arr[0], array('album', 'tag', 'smart'))) {
                return false;
            }
        }
        return $items;
    }

    private function CheckOffsetLimit($offset, $limit) {
        if (!is_numeric($offset) || !is_numeric($limit)) {
            return false;
        }
        if (0 > (int)$offset || -1 > (int)$limit) {
            return false;
        }
        return true;
    }

    private function IsAccessible($id) {
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        $hidden = csSYNOPhotoDB::GetDBInstance()->IsCategoryAccessible($id);
        if (false === $isAdmin && true === $hidden) {
            return false;
        }
        return true;
    }

    private function GetItemID($type, $id) {
        switch ($type) {
        case 'album':
            $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('sharename', 'photo_share', 'shareid', $id);
            $albumID = bin2hex($row['sharename']);
            $itemID = "album_{$albumID}";
            break;
        case 'tag':
            $itemID = "tag_{$id}";
            break;
        case 'smart':
            $itemID = "smart_{$id}";
            break;
        default:
            return false;
            break;
        }
        return $itemID;
    }

    private function GetItemName($itemID) {
        $arr = explode('_', $itemID );
        if (2 != count($arr)) {
            return false;
        }
        if (!in_array($arr[0], array('album', 'smart', 'tag'))) {
            return false;
        }
        switch ($arr[0]) {
        case 'album':
            $name = @pack('H*', $arr[1]);
            break;
        case 'smart':
            $name = @pack('H*', $arr[1]);
            break;
        case 'tag':
            $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('name', 'photo_label', 'id', $arr[1]);
            $name = $row['name'];
            break;
        default:
            break;
        }
        return $name;
    }

    private function CategoryList() {
        if (!isset($_REQUEST['offset']) || !isset($_REQUEST['limit'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        if (!$this->CheckOffsetLimit($_REQUEST['offset'], $_REQUEST['limit'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
            
        // check if admin
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

        // database query
        $dbCategories = array();
        $dbCategories = csSYNOPhotoDB::GetDBInstance()->ListCategory($_REQUEST['offset'], $_REQUEST['limit'], $isAdmin);

        // form to webapi format
        $categories = array();
        foreach ($dbCategories as $dbCategory) {
            $category['id'] = 'category_'.$dbCategory['id'];
            $category['name'] = $dbCategory['name'];
            $category['hidden'] = $this->BooleanUniform($dbCategory['hidden']);
            array_push($categories, $category);
        }

        $resp['total'] = (int)csSYNOPhotoDB::GetDBInstance()->GetTotalCategory($isAdmin);
        $offset = (0 > $_REQUEST['limit']) ? $resp['total'] : (int)($_REQUEST['offset'] + $_REQUEST['limit']);
        $resp['offset'] = ($offset >  $resp['total']) ?  $resp['total'] : $offset;
        $resp['categories'] = $categories;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function GetInfo() {
        if (!isset($_REQUEST['id'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get and check category id
        $id = $this->GetCategoryDatabaseID($_REQUEST['id']);
        if (false === $id) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }

        // check accessible
        if (!$this->IsAccessible($id)) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        // datebase query
        $dbCategory = csSYNOPhotoDB::GetDBInstance()->GetCategory($id);
        if (false === $dbCategory) {
            $this->SetError(PHOTOSTATION_CATEGORY_GETINFO_FAIL);
            goto End;
        }
        
        // form to webapi format
        $categories = array();
        $category['id'] = 'category_'.$dbCategory['id'];
        $category['name'] = $dbCategory['name'];
        $category['hidden'] = $this->BooleanUniform($dbCategory['hidden']);
        $category['home'] = $category['id'] === csSYNOPhotoMisc::GetConfigDB("album", "home_category", "photo_config");
        array_push($categories, $category);

        $resp['categories'] = $categories;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function Create() {
        // check if admin
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (!$isAdmin) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        if (!isset($_REQUEST['name']) || '' === trim($_REQUEST['name'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        $hidden = isset($_REQUEST['hidden']) ? $_REQUEST['hidden'] : 'false';
        if (!in_array($hidden, array('true', 'false'))) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // database query
        $dbHidden = ('true' === $hidden) ? 't' : 'f';
        if (!($createID = csSYNOPhotoDB::GetDBInstance()->CreateCategory($_REQUEST['name'], $dbHidden))) {
            $this->SetError(PHOTOSTATION_CATEGORY_CREATE_FAIL);
            goto End;
        }

        $resp['id'] = 'category_'.$createID;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function Delete() {
        // check if admin
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (!$isAdmin) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        if (!isset($_REQUEST['id'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get and check category id
        $id = $this->GetCategoryDatabaseID($_REQUEST['id']);
        if (!$id) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }

        // database query
        if (!csSYNOPhotoDB::GetDBInstance()->DeleteCategory($id)) {
            $this->SetError(PHOTOSTATION_CATEGORY_DELETE_FAIL);
            goto End;
        }

        $homeVal = csSYNOPhotoMisc::GetConfigDB("album", "home_category", "photo_config");
        if ($homeVal === $_REQUEST['id']) {
            csSYNOPhotoMisc::UpdateConfigDB("album", "home_category", '', "photo_config");
        }
        $this->SetResponse($resp);
    End:
        return;
    }

    private function Edit() {
        // check if admin
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (!$isAdmin) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        if (!isset($_REQUEST['id'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get and check category id
        $id = $this->GetCategoryDatabaseID($_REQUEST['id']);
        if (!$id) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }

        $name = isset($_REQUEST['name']) ? trim($_REQUEST['name']) : false;
        $hidden = isset($_REQUEST['hidden']) ? $_REQUEST['hidden'] : 'default';
        if (!in_array($hidden, array('true', 'false', 'default')) || '' === $name) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // database query
        $dbHidden = ('true' === $hidden) ? 't' : (('false' === $hidden) ? 'f' : 'default');
        if (!csSYNOPhotoDB::GetDBInstance()->EditCategory($id, $name, $dbHidden)) {
            $this->SetError(PHOTOSTATION_CATEGORY_EDIT_FAIL);
            goto End;
        }

        $setHome = isset($_REQUEST['home']) ? 'true' === $_REQUEST['home'] : false;
        $homeVal = csSYNOPhotoMisc::GetConfigDB("album", "home_category", "photo_config");
        if ($setHome) {
            csSYNOPhotoMisc::UpdateConfigDB("album", "home_category", $_REQUEST['id'], "photo_config");
        } elseif ($homeVal === $_REQUEST['id']) {
            csSYNOPhotoMisc::UpdateConfigDB("album", "home_category", '', "photo_config");
        }
        $this->SetResponse($resp);
    End:
        return;
    }

    private function ArrangeCategory() {
        // check if admin
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (!$isAdmin) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        if (!isset($_REQUEST['offset']) || !isset($_REQUEST['limit']) || !isset($_REQUEST['category_id'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        if (!$this->CheckOffsetLimit($_REQUEST['offset'], $_REQUEST['limit'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get and check category id
        $ids = array();
        $categoryIDs = array();
        $categoryIDs = explode(',', $_REQUEST['category_id']);
        foreach ($categoryIDs as $categoryID) {
            if (false === ($id = $this->GetCategoryDatabaseID($categoryID))) {
                $this->SetError(WEBAPI_ERR_BAD_REQUEST);
                goto End;
            }
            array_push($ids, $id);
        }

        // database query
        if (!csSYNOPhotoDB::GetDBInstance()->ArrangeCategory($ids, $_REQUEST['offset'], $_REQUEST['limit'])) {
            $this->SetError(PHOTOSTATION_CATEGORY_ARRANGE_FAIL);
            goto End;
        }

        $this->SetResponse($resp);
    End:
        return;

    }

    private function AddItem() {
        // check if admin
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (!$isAdmin) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        if (!isset($_REQUEST['id']) || !isset($_REQUEST['item_id'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get and check category id
        $id = $this->GetCategoryDatabaseID($_REQUEST['id']);
        if (!$id) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }
        // check item id
        $itemIDs = $this->CheckItemID($_REQUEST['item_id']);
        if (!$itemIDs) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }

        if (!csSYNOPhotoDB::GetDBInstance()->AddCategoryItem($id, $itemIDs)) {
            $this->SetError(PHOTOSTATION_CATEGORY_ADD_ITEM_FAIL);
            goto End;
        }

        $this->SetResponse($resp);
    End:
        return;
    }

    private function IsAlbumCommentalb($sharePath) {
        $arr = explode('/', $sharePath);
        $level1ShareName = $arr[0];
        return isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['commentable_album'][$level1ShareName]);
    }

    private function FormAlbumInfo($itemID)
    {
        $query = "select * from photo_share where shareid=?";
        $sqlParam = array($itemID);
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
        if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
        if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        $info['sharepath'] = $row['sharename'];
        $info['name'] = basename($row['sharename']);
        $info['title'] = empty($row['title']) ? $info['name'] : $row['title'];
        $info['description'] = $row['description'];
        $info['hits'] = $row['hits'];
        $info['allow_comment'] = $this->IsAlbumCommentalb($row['sharename']);
        if (PHOTO_DB_IsTrue($row['public'])) {
            $albumPermission = 'public';
        } else {
            $albumPermission = empty($row['password']) ? 'private' : 'password';
        }
        $info['type'] = $albumPermission;
        return $info;
    }

    private function FormAdditional($type, $additional, $itemID)
    {
        if ('album' === $type && in_array('album_permission', $additional)) {
            $arr = explode('album_', $itemID);
            if (2 === count($arr)) {
                $albumName = @pack('H*', $arr[1]);
                $data['album_permission'] = AlbumAPIUtil::GetAlbumPermission($albumName);
            }
        }
        return $data;
    }

    private function IsAlbumPassword($albumName)
    {
        $query = 'SELECT * FROM photo_share WHERE sharename=?';
        $sqlParam = array($albumName);
        if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
        if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        if (false == PHOTO_DB_IsTrue($row['public']) && !empty($row['password'])) {
            return true;
        }
        return false;
    }

    private function ListItem() {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['offset']) || !isset($_REQUEST['limit'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        $additionalParams = explode(',', $_REQUEST['additional']);
        $needThumbSize = in_array('thumb_size', $additionalParams);

        if (!$this->CheckOffsetLimit($_REQUEST['offset'], $_REQUEST['limit'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get and check category id
        $id = $this->GetCategoryDatabaseID($_REQUEST['id']);
        if (!$id) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }

        // check accessible
        if (!$this->IsAccessible($id)) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        // database query
        $dbItems = csSYNOPhotoDB::GetDBInstance()->ListCategoryItem($id, $_REQUEST['offset'], $_REQUEST['limit']);
        if (false === $dbItems) {
            $this->SetError(PHOTOSTATION_CATEGORY_LIST_ITEM_FAIL);
            goto End;
        }

        // form to webapi format
        $items = array();
        $denyCount = 0;
        foreach ($dbItems as $dbItem) {
            unset($item);
            if ('album' === $dbItem['type']) {
                $typeID = $dbItem['album_id'];
            } elseif ('tag' === $dbItem['type']) {
                $typeID = $dbItem['tag_id'];
            } elseif ('smart' === $dbItem['type']) {
                $typeID = $dbItem['smart_id'];
            }
            if (false === ($itemID = $this->GetItemID($dbItem['type'], $typeID))) {
                continue;
            }

            // private can't show
            if ('album' === $dbItem['type']) {
                $arr = explode('album_', $itemID);
                $albumName = @pack('H*', $arr[1]);
                if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName) && !$this->IsAlbumPassword($albumName)) {
                    $denyCount++;
                    continue;
                }
            }
            $item['id'] = $itemID;
            $item['type'] = $dbItem['type'];
            $item['name'] = $this->GetItemName($itemID);
            $additional = $this->FormAdditional($dbItem['type'], $additionalParams, $itemID);

			$coverPath = '';
            if ('album' === $dbItem['type']) {
                $arr = explode('album_', $itemID);
                if (2 === count($arr)) {
                    $albumName = @pack('H*', $arr[1]);
                    $result = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($albumName);

					$coverPath = $result['coverPath'];
                }
                $item['info'] = $this->FormAlbumInfo($typeID);
                if (null !== $additional) {
                    $item['additional']['album_permission'] = $additional['album_permission'];
                }
            } elseif ('tag' === $dbItem['type']) {
                $arr = explode('tag_', $itemID);
                if (2 === count($arr)) {
                    $result = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumCover($arr[1]);

					$coverPath = $result['coverPath'];
                }
            } elseif ('smart' === $dbItem['type']) {
                $arr = explode('smart_', $itemID);
                if (2 === count($arr)) {
                    $smartName = @pack('H*', $arr[1]);
                    $album = SmartAlbum::GetCoverOfSmartAlbumByName($smartName);

					$coverPath = '';
					if ($album['success']) {
						$coverPath = $album['cover']['path'];
					}
                }
            }
			AlbumAPIUtil::FillThumbStatus($item, $coverPath, $needThumbSize, false);
            array_push($items, $item);
        }

        // fixme
        $resp['total'] = (int)csSYNOPhotoDB::GetDBInstance()->GetTotalCategoryItem($id) - $denyCount;
        $offset = (0 > (int)$_REQUEST['limit']) ? $resp['total'] : (int)($_REQUEST['offset'] + $_REQUEST['limit']);
        $resp['offset'] = ($offset >  $resp['total']) ?  $resp['total'] : $offset;
        $resp['items'] = $items;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function RemoveItem() {
        // check if admin
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (!$isAdmin) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        if (!isset($_REQUEST['id']) || !isset($_REQUEST['item_id'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get and check category id
        $id = $this->GetCategoryDatabaseID($_REQUEST['id']);
        if (!$id) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }
        // check item id
        $itemIDs = $this->CheckItemID($_REQUEST['item_id']);
        if (!$itemIDs) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }

        // database query
        if (!csSYNOPhotoDB::GetDBInstance()->RemoveCategoryItem($id, $itemIDs)) {
            $this->SetError(PHOTOSTATION_CATEGORY_REMOVE_ITEM_FAIL);
            goto End;
        }


        $this->SetResponse($resp);
    End:
        return;
    }

    private function ArrangeItem() {
        // check if admin
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (!$isAdmin) {
            $this->SetError(PHOTOSTATION_CATEGORY_ACCESS_DENY);
            goto End;
        }

        if (!isset($_REQUEST['id']) || !isset($_REQUEST['offset']) || !isset($_REQUEST['limit'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        if (!$this->CheckOffsetLimit($_REQUEST['offset'], $_REQUEST['limit'])) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // get and check category id
        $id = $this->GetCategoryDatabaseID($_REQUEST['id']);
        if (!$id) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }
        // check item id
        $itemIDs = $this->CheckItemID($_REQUEST['item_id']);
        if (!$itemIDs) {
            $this->SetError(PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT);
            goto End;
        }

        // database query
        if (!csSYNOPhotoDB::GetDBInstance()->ArrangeCategoryItem($id, $itemIDs, $_REQUEST['offset'], $_REQUEST['limit'])) {
            $this->SetError(PHOTOSTATION_CATEGORY_ARRANGE_ITEM_FAIL);
            goto End;
        }

        $this->SetResponse($resp);
    End:
        return;
    }
}

$api = new CategoryAPI();
$api->Run();

?>
