<?php
require_once('include/syno_conf.php');
require_once('include/timeline_utils.php');

$pkg_default_conf = csSYNOPhotoMisc::GetConfigFile(SYNO_PKG_DEFAULT_CONF, 'support_timeline');
if('yes' !== $pkg_default_conf['support_timeline'] || csSYNOPhotoMisc::GetConfigDB("photo", "disable_timeline", "photo_config") == "on") {
	header("Location: ".SYNOPHOTO_URL_PREFIX."/photo");
	exit;
}

$dsmVersion = csSYNOPhotoMisc::GetDsmVersion();
$packageVersion = csSYNOPhotoMisc::GetPackageVersion();
$smarty->assign('DSM_VERSION', '?v='.$dsmVersion);
$smarty->assign('PACKAGE_VERSION', '?v='.$packageVersion);

$ln = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
$smarty->assign('LAN_PARAM', 'ln='.$ln);

csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

$title =  htmlspecialchars(csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'photo_page_title'));
if($title == NULL || $title == "") {
	$title = __('photo_str_ap_name');
}

$showTimeBy = csSYNOPhotoDB::GetDBInstance()->GetConfig("timeline", "timeline_show_time_by");
if ($showTimeBy == null || $showTimeBy == '') {
	$showTimeBy = 0;
}
$_SESSION[SYNOPHOTO_ADMIN_USER]['timeline_photo_show_time_by'] = $SYNOPHOTO_DB_TIME_FIELD['photo'][$showTimeBy];
$_SESSION[SYNOPHOTO_ADMIN_USER]['timeline_video_show_time_by'] = $SYNOPHOTO_DB_TIME_FIELD['video'][$showTimeBy];

$labels = SYNOPHOTO_LABEL_UTIL_GetAllLabel();

$labelItemData = SYNOPHOTO_TIMELINE_UTIL_GetLabelItemData();

//js global variables
$userType = csSYNOPhotoMisc::GetUserType();
$isDemoMode = 'false';
if ('yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['enable_demomode']) {
	$isDemoMode = 'true';
}

$defaultScale = csSYNOPhotoDB::GetDBInstance()->GetConfig("timeline", "timeline_default_scale");
if ($defaultScale == null || $defaultScale == '') {
	$defaultScale = 1;
}

$gpsData = SYNOPHOTO_GPS_UTIL_GetGPSDefLatLng();

$filter_nonConfirm = 'false';
if ('on' == csSYNOPhotoMisc::GetConfigDB("timeline", "timeline_filter_nonConfirm", 'photo_config')) {
	$filter_nonConfirm = 'true';
}

$def['gUserType'] = $userType;
$def['gIsDemoMode'] = $isDemoMode;
$def['gDefaultScale'] = $defaultScale;
$def['gShowTimeBy'] = $showTimeBy;
$def['gFilterNonConFirm'] = $filter_nonConfirm;
$def['gAvailableYears'] = json_encode($availableYears);
$def['gLabelItemData'] = json_encode($labelItemData);
$def['gLanguage'] = json_encode($ln);
$def['g_gps_def'] = json_encode($gpsData);

$smarty->assign('WELCOME_TITLE', csSYNOPhotoMisc::GetWelcomeText());
$smarty->assign('HEADER_LINK_ARRAY', csSYNOPhotoMisc::GetTopHeaderLinkArray());
$smarty->assign('DEF',$def);
$smarty->assign('USER_TYPE', $userType);
$smarty->assign('PAGE_TITLE', $title);
$smarty->assign('SYNOTHEME_REQUEST_FILE', SYNOTHEME_REQUEST_FILE);
$smarty->assign('STR_SETTING', __('photo_str_management'));
$smarty->assign('STR_SETTING', __('photo_str_management'));
$smarty->assign('STR_COMMENT', __('photo_str_comment'));
$smarty->assign('STR_ADD_COMMENT', __('photo_str_comment_add'));
$smarty->assign('STR_PERSON_LABEL', __('photo_str_person_label'));
$smarty->assign('STR_PLACE_LABEL', __('photo_str_place_label'));
$smarty->assign('STR_GENERAL_LABEL', __('photo_str_general_label'));
$smarty->assign('STR_NO_LABEL', __('photo_str_no_label'));

$smarty->assign('perosnLabelList', $labels[0]);
$smarty->assign('placeLabelList', $labels[1]);
$smarty->assign('generalLabelList', $labels[2]);

$smarty->display('timeline.tpl');

?>
