<?php
require_once("include/syno_conf.php");

// redirect old link to new photo station
if (isset($_GET['dir']) && isset($_GET['name'])) {
	$albums = split('/', @pack('H*', $_GET['dir']));
	$albumtoken = 'Albums';
	$fullpath = '';
	foreach ($albums as $name) {
		$album = bin2hex($name);
		$fullpath .= $album;
		$phototoken = 'photo_' . $fullpath . '_' . $_GET['name'];
		$videotoken = 'video_' . $fullpath . '_' . $_GET['name'];
		$albumtoken = $albumtoken . '/album_' . $fullpath;
		$fullpath .= '2f';
	}
	$info = pathinfo(@pack('H*', $_GET['name']));
	if (in_array(strtolower($info['extension']), $SYNOPHOTO_ALLOW_PICT_NAMES_EXT)) {
		$token = $albumtoken . '/' . $phototoken;
	} else {
		$token = $albumtoken . '/' . $videotoken;
	}
	header("Location: index.php#$token");
} else {
	header("Location: index.php");
}

if (!isSet($_GET['dir']) || !isSet($_GET['name'])) {
	header("Location: index.php");
	exit;
}
csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
$albumName = @pack('H*', $_GET['dir']);
$name = @pack('H*', $_GET['name']);
$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$name}";
$prefixUrl = csSYNOPhotoMisc::GetServerHost() . SYNOPHOTO_URL_PREFIX;
$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
$currentType = 'album';
if (!$photoInfo) {
	$videoInfo = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($photoPath);
	if (!$videoInfo) {
		$_GET['name'] = "";
	}
	$currentType = 'movie';
}
$currentUrl .= $prefixUrl .'/photo/photo_one.php?dir='.$_GET['dir'].'&name='.$_GET['name'];
$photoUrl = $prefixUrl . '/photo/convert.php?dir='.$_GET['dir'].'&name='.$_GET['name'].'&type=0';

$script =
	"var gIsAdmin=false;var gIsAllowOrig=false;var gIsAllowVideoDownload=false;var gIsBlogEnable=false;var gIsFaceRecogEnable=false;".
	"var gIsVirtual=false;var gUserType=0;var gAllowGuestFbUpload=false;var gDisableShare=false;var gDisableRightButton=false;".
	"var gSocialNetworkList = ".json_encode(SocialNetwork::ReadList())."; var gIsManager=false;";

if(strstr($_SERVER['HTTP_REFERER'], "virtual_album=")) {
	$posi = strripos($_SERVER['HTTP_REFERER'], "virtual_album=");
	$type = (int)substr($_SERVER['HTTP_REFERER'], $posi + 14, 1);
	$rssLink = 'rss.php?virtual_album='.$type;
	if ($type >=4 && $type <= 6) {
		$label = null;
		$posi = strripos($_SERVER['HTTP_REFERER'], "&id=");
		$labelId = intval(substr($_SERVER['HTTP_REFERER'], $posi + 4));
		if (-1 !== $labelId && false === ($label = SYNOPHOTO_LABEL_UTIL_GetLabelById($labelId))) {
			header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/index.php");
			exit;
		}
		$rssLink = 'rss.php?virtual_album='.$type.'&id='.$labelId;
	}

	$pathLinkArray = csSYNOPhotoBrowse::GetBrowseInstance()->GetPathLinkArray('', $type, false, ($labelId === -1) ? -1 : $label);
	$photoData = csSYNOPhotoBrowse::GetBrowseInstance()->prepareVirtualAlbumThumbList($type, $_GET['current_key'], $labelId);

	$smarty->assign('IS_VIRTUAL', true);
	$script .= 'gIsVirtual=true;';
} else if (strstr($_SERVER['HTTP_REFERER'], "smart_album=")) {
	$posi = strripos($_SERVER['HTTP_REFERER'], "smart_album=");
	$posi2 = strripos($_SERVER['HTTP_REFERER'], "&");
	$paramLength = strlen("smart_album=");
	$type = substr($_SERVER['HTTP_REFERER'], $posi + $paramLength, $posi2 > 0 ?
				   $posi2 - $posi - $paramLength : strlen($_SERVER['HTTP_REFERER']) - $posi - $paramLength);
	$rssLink = 'rss.php?smart_album='.$type;

	$pathLinkArray = csSYNOPhotoBrowse::GetBrowseInstance()->GetPathLinkArray(@pack('H*', $type), -1, false, null, true);

	$photoData = csSYNOPhotoBrowse::GetBrowseInstance()->prepareSmartAlbumItemList(@pack('H*', $type), $_GET['name'], $_GET['dir']);

	$smarty->assign('IS_VIRTUAL', true);
	$script .= 'gIsVirtual=true;';
} else {
	csSYNOPhotoMisc::CheckAlbumAccessible($albumName = @pack('H*', $_GET['dir']), 1);

	csSYNOPhotoBrowse::GetBrowseInstance()->SetSortTypeOrder($albumName);

	$albumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);

	$pathLinkArray = csSYNOPhotoBrowse::GetBrowseInstance()->GetPathLinkArray($albumName);

	$script .= "var gCurrentAlbum=".json_encode($albumName).";";
	$script .= "var gAlbumNameH='".$_GET['dir']."';";


	$photoData = csSYNOPhotoBrowse::GetBrowseInstance()->prepareThumbListAll($albumName, $name, false);

	$rssLink = 'rss.php?dir='.$_GET['dir'];
}
$script .= "var gAlbumName='". $albumName . "';";

$userType = csSYNOPhotoMisc::GetUserType();
$script .= "gUserType=$userType;";
if (2 == $userType) {
	$smarty->assign('IS_ADMIN', true);
	$script .= 'gIsAdmin=true;';
}

if (csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
	$smarty->assign('IS_MANAGER', true);
	$script .= 'gIsManager=true;';
}
if (csSYNOPhotoMisc::IsBlogEnabled()) {
	$script .= 'gIsBlogEnable=true;';
	$smarty->assign('IS_BLOG_ENABLE', true);
}

if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runfacerecognition']) &&
	'yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runfacerecognition'] &&
	false === strstr($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg']['unique'], '88f628')) {
	$script .= 'gIsFaceRecogEnable=true;';
}

$dsmVersion = csSYNOPhotoMisc::GetDsmVersion();
$packageVersion = csSYNOPhotoMisc::GetPackageVersion();
$smarty->assign('DSM_VERSION', '?v='.$dsmVersion);
$smarty->assign('PACKAGE_VERSION', '?v='.$packageVersion);

$lang = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
$smarty->assign('LAN_PARAM', "ln=$lang");

$title =  csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'photo_page_title');
if($title == NULL || $title == '') {
	$title = __(photo_str_ap_name);
}

$gpsData = SYNOPHOTO_GPS_UTIL_GetGPSDefLatLng();
$script .= "g_gps_def=".json_encode($gpsData).";";

if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_orig') == 'on') {
	$smarty->assign('ALLOW_ORIG', true);
	$script .= 'gIsAllowOrig=true;';
}
if (csSYNOPhotoMisc::GetConfigDB('photo', 'allow_video_download', 'photo_config')) {
	$smarty->assign('ALLOW_VIDEO_DOWNLOAD', true);
	$script .= 'gIsAllowVideoDownload=true;';
}

if ('on' == csSYNOPhotoMisc::GetConfigDB("photo", "allow_guest_fb_upload", "photo_config")) {
	$script .= 'gAllowGuestFbUpload=true;';
}

if ('on' == csSYNOPhotoMisc::GetConfigDB("photo", "disable_share", "photo_config")) {
	$script .= 'gDisableShare=true;';
}

if ('on' == csSYNOPhotoMisc::GetConfigDB("photo", "disable_right_button", "photo_config")) {
	$script .= 'gDisableRightButton=true;';
}

$script .= 'var gIsDemoMode = false;';
if ('yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['enable_demomode']) {
	$script .= 'gIsDemoMode = true;';
	$isDemoMode = true;
}

$rssForCooliris = $rssLink.'&for_cooliris=true';

$show_bkg_img = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['theme']['show_bkg_img'];
if ($show_bkg_img && '1' == $show_bkg_img && file_exists(SYNOTHEME_BKG_SYNO_FILE)) {
	$smarty->assign('BKG_CHANGE',  @filemtime(SYNOTHEME_BKG_SYNO_FILE));
} else if ($show_bkg_img && '2' == $show_bkg_img && file_exists(SYNOTHEME_BKG_CUSTOM_FILE)) {
	$smarty->assign('BKG_CHANGE',  @filemtime(SYNOTHEME_BKG_CUSTOM_FILE));
} else if ($show_bkg_img && '3' == $show_bkg_img) {
	$smarty->assign('BKG_CHANGE', '0');
} else {
	$smarty->assign('BKG_CHANGE',  rand());
}


if ($photoInfo['description'] == '' && isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
	$smarty->assign('ADD_DESC_CLASS', 'empty-desc');
} else {
	$smarty->assign('ADD_DESC_CLASS', '');
}

$smarty->assign('IS_VIDEO', ($currentType == 'movie'));

$smarty->assign('init_main_img_src', "./convert.php?type=0&v=0&name=".$_GET['name']."&dir=".$_GET['dir']);

$smarty->assign('PHOTO_META_DESC', __(photo_str_meta_desc));
$smarty->assign('PHOTO_META_KEYWORD', __(photo_str_meta_keyword));
$smarty->assign('PHOTO_STATION_TITLE', $title);

$smarty->assign('WELCOME_TITLE', csSYNOPhotoMisc::GetWelcomeText());
$smarty->assign('HEADER_LINK_ARRAY', csSYNOPhotoMisc::GetTopHeaderLinkArray());

$script .="var gPathLink=".json_encode($pathLinkArray)."; ";
$smarty->assign('ALBUM_TITLE', $albumTitle);
$smarty->assign('ALBUM_DESC', $albumDesc);

$smarty->assign('STR_INFORMATION', __(photo_str_photoalbum_info));
$smarty->assign('STR_LABEL_ADD', __('photo_str_add'));
$smarty->assign('STR_ADD_LABELS', __('photo_str_add_label'));
$smarty->assign('STR_GENERAL_LABEL', __('photo_str_general_label'));
$smarty->assign('STR_PLACE_LABEL', __('photo_str_place_label'));
$smarty->assign('STR_PERSON_LABEL', __('photo_str_person_label'));

$smarty->assign('STR_SLIDESHOW', __(photo_str_slideshow));
$smarty->assign('STR_MAP', __(photo_str_map));
$smarty->assign('STR_SHARE', __(photo_str_share));
$smarty->assign('STR_EDIT', __(photo_str_edit));
$smarty->assign('STR_FULLSIZE', __(photo_str_click_get_origin));
$smarty->assign('STR_ADD_COMMENT', __(photo_str_comment_add));
$smarty->assign('STR_COMMENT', __(photo_str_comment));
$smarty->assign('STR_QUALITY', __(photo_str_video_quality));

$smarty->assign('STR_FUNC_COVER', __(photo_str_setcover));
$smarty->assign('STR_FUNC_ROTATE', __(photo_str_rotate));
if (!$isDemoMode) {
	$smarty->assign('STR_FUNC_DELETE', __(photo_str_deleteuser));
} else {
	$smarty->assign('STR_FUNC_DELETE', __(photo_str_error_demo));
}

$smarty->assign('STR_DOWNLOAD', __(photo_str_btnDownload));
$smarty->assign('STR_FILENAME', __(photo_str_sort_type_filename));
$smarty->assign('STR_NO_ITEM', __(photo_str_no_item));

$smarty->assign('SCRIPT_NEED', $script);
$smarty->assign('SYNOTHEME_REQUEST_FILE', SYNOTHEME_REQUEST_FILE);
$smarty->assign('PREPARE_DATA', $photoData);
$smarty->assign('RSS_URL', $rssLink);
$smarty->assign('RSS_COOLIRIS', $rssForCooliris);
$smarty->assign('CURRENT_TYPE', $currentType);
$smarty->assign('CURRENT_TITLE', $photoInfo['title'] ? htmlspecialchars($photoInfo['title']) : htmlspecialchars($photoInfo['name']));
$smarty->assign('CURRENT_DESC', $photoInfo['description'] ? htmlspecialchars($photoInfo['description']) : '');
$smarty->assign('CURRENT_IMAGE_URL', $photoUrl ? $photoUrl : "");
$smarty->assign('CURRENT_URL', $currentUrl);

$smarty->display('photo/photo_one.tpl');

?>
