<?php
require_once("include/syno_conf.php");

if ($_GET['action'] == "logout") {
	unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
	if ($_GET['redirect'] == "photo") {
		header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/index.php");
	} else {
		header("Location: ".SYNOPHOTO_URL_PREFIX."/blog/index.php");
	}
	exit;
}

if ($_POST['action'] == "login") {
	$commend = "/usr/syno/bin/synoautoblock --deny \"".$_SERVER['REMOTE_ADDR']."\"";
	@system($commend, $retval);
	$commend = "";
	if ($retval == 1) {
		$login_result['success'] = 'login_noprivilege';
	//if username is ADMIN
	} else if (strtoupper($_POST['username']) == "ADMIN" || strtoupper($_POST['username']) == strtoupper(SYNOPHOTO_ADMIN_NAME)) {
		if(SYNOPHOTO_LOGIN_ValidateAdmin()) {
			$login_result['success'] = TRUE;
			$commend = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
		} else {
			$login_result['success'] = 'login_error';
			$commend = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
		}
	//user is not admin
	} else {
		if ("0" == $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['global']['account_system'] || 'root' != SYNOPHOTO_ADMIN_USER){
			$ret = SYNOPHOTO_LOGIN_ValidateUser();
		} else {
			//DSM account system and not personal photo station
			$ret = SYNOPHOTO_LOGIN_ValidateDsmUser();
		}

		if($ret == -1) {
			$login_result['success'] = 'disable_account';
		} else if($ret == 1) {
			$login_result['success'] = TRUE;
			$commend = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
		} else {
			$login_result['success'] = 'login_error';
			$login_result['not_photo_user'] = ($ret == -2);
			$commend = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
		}
	}

	if ($commend != "") {
		putenv('SYNOAUTOBLOCK_SERVICE=Photo Station');
		@system($commend, $retval);
		putenv('SYNOAUTOBLOCK_SERVICE');
	}

	$login_result['run_photo'] = csSYNOPhotoMisc::checkServiceEnabled() && file_exists(SYNOPHOTO_SERVICE_DIR);
	$login_result['has_photo_root_path'] = (SYNOPHOTO_SERVICE_REAL_DIR != false);
	echo json_encode($login_result);
}
function SYNOPHOTO_LOGIN_Is_DSM()
{
	$result = csSYNOPhotoMisc::GetConfigDB("global", "account_system", "photo_config");
	if ($result == null || $result == "") {
		$result = "0";
	}
	return ($result == "0") ? FALSE : TRUE;
}

function SYNOPHOTO_LOGIN_ValidateAdmin()
{
	$user = ('root' == SYNOPHOTO_ADMIN_USER)? 'admin':SYNOPHOTO_ADMIN_NAME;
	$command = "/usr/syno/bin/synoauth ".escapeshellarg($user)." ".escapeshellarg($_POST['passwd']);
	@system($command, $retval);

	if (0 == $retval) {
		unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
		session_start();

		csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
		SYNOPHOTO_LOGIN_AddLog($_POST['username'], true);
		return 1;
	}
	SYNOPHOTO_LOGIN_AddLog($_POST['username'], false);
	return 0;
}

function SYNOPHOTO_LOGIN_ValidateDsmUser()
{
	$command = "/usr/syno/bin/synophoto_dsm_user --auth ".escapeshellarg($_POST['username'])." ".escapeshellarg($_POST['passwd']);
	@system($command, $auth_retval);

	$user_info = array();
	if (0 == $auth_retval) {
		$command = "/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($_POST['username']);
		@exec($command, $pUser, $retval);
		$user_info = SYNOPHOTO_LOGIN_USERDATA_PARSER($pUser);
	} else {
		SYNOPHOTO_LOGIN_AddLog($_POST['username'], false);
		return 0;
	}

	if ($user_info) {
		unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
		session_start();

		csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = $user_info[2];
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $user_info[0];
		$_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] = true;
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = $user_info['groups'];

		if ($user_info[10]) {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
		}
		SYNOPHOTO_LOGIN_AddLog($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'], true);
		return 1;
	}
	SYNOPHOTO_LOGIN_AddLog($_POST['username'], false);
	return 0;
}


function SYNOPHOTO_LOGIN_USERDATA_PARSER($pUser)
{
	global $SYNOPHOTO_DSM_USER_INFO;
	$result = array();
	if (!is_array($pUser)) {
		return null;
	}
	$i = 0;
	$groups = array();
	foreach ($pUser as $item) {
		if (preg_match('/\((\d+)\)/', $item, $match)) {
			$groups[] = $match[1];
		}

		if (!preg_match('/(^\w+\s?\w+)\s*\:/', $item, $match) || !preg_match('/\[(.*)\]/', $item, $match_val)) {
			continue;
		}

		if (false !== $index = array_search($match[1], $SYNOPHOTO_DSM_USER_INFO)) { // $key = 2;
			$result[$index] = $match_val[1];
		}
	}
	$result['groups'] = implode(',', $groups);
	return $result;
}



function SYNOPHOTO_LOGIN_ValidateUser()
{
	$escape = PHOTO_DB_GetEscape();
	$query_usr = "Select count(*) from photo_user where lower(username) like ? $escape";
	$sqlParam = array(PHOTO_DB_EscapForLike(strtolower($_POST['username'])));
	$count = PHOTO_DB_QueryCount($GLOBALS['dbconn_photo'], $query_usr, $sqlParam);

	if ($count == 0) {
		// user is not photo station user
		return -2;
	}

	$query = "Select * from photo_user where lower(username) like ? $escape and password = '".md5($_POST['passwd'])."'";
	$sqlParam = array(PHOTO_DB_EscapForLike(strtolower($_POST['username'])));
	$result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$user_info = PHOTO_DB_FetchRow($result);
	if ($user_info) {
		if(PHOTO_DB_ConvertBool($user_info[4]) == 't') {
			//disabled
			return -1;
		}

		unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
		session_start();

		csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = $user_info[0];
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $user_info[1];
		$_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] = false;

		/* set user's belonging groups */
		$query = "SELECT groupid FROM " . PHOTO_USER_GROUP_TABLE . " WHERE userid = $user_info[0]";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = '';
		$groups = array();
		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$groups[] = $row['groupid'];
		}
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = implode(',', $groups);

		if (PHOTO_DB_ConvertBool($user_info[6]) == 't') {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
		}
		SYNOPHOTO_LOGIN_AddLog($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'], true);
		return 1;
	}
	SYNOPHOTO_LOGIN_AddLog($_POST['username'], false);
	return 0;
}

function SYNOPHOTO_LOGIN_AddLog($username, $success)
{
	$ip = $_SERVER['REMOTE_ADDR'];
	$conf = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, 'enable_demomode');
	if ('yes' == $conf['enable_demomode']) {
		$ip = 'xxx.xxx.xxx.xxx';
	}

	if ($success) {
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($username." logged in from "."[".$ip."]", "t", strtolower($username));
		return;
	}
	csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($username." failed to login from "."[".$ip."]", "f", strtolower($username));
}
?>
