<?php
require_once('gps_util.php');
/*!
 * thumb list operation
 */
class csSYNOPhotoThumb {
	/*! reference to a self instance */
	private static $instance = null;
	/*!
	 * Get a exist instance
	 */
	static function GetThumbInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get thumb info for specified photo
	 *
	 * \param $item array with photo info
	 *	- path: photo file path
	 *	- resolutionx: photo width
	 *	- resolutiony: photo height
	 *	- version: photo orientation
	 * \return array with thumb info
	 *	- cover: cover info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *  - bigThumb: big thumb info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *	- link: link to view the photo
	 */
	function GetThumbInfo($item)
	{
		$isPhotoFile = csSYNOPhotoMisc::IsPhotoFile($item['path']);
		if (!$isPhotoFile) {
			return array();
		}
		$result['GPSInfo'] = json_decode($item['gps']);
		$result['path'] = $item['path'];
		$result['showTitle'] = $item['title'];
		$result['title'] = $item['title'];
		$result['desc'] = $item['description'];
		$result['resolutionx'] = $item['resolutionx'];
		$result['resolutiony'] = $item['resolutiony'];
		$result['timetaken'] = $item['timetaken'];
		$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBSMALL, $item['resolutionx'], $item['resolutiony'], $item['version']);
		$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBMEDIUM, $item['resolutionx'], $item['resolutiony'], $item['version']);
		$result['bigThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBBIG, $item['resolutionx'], $item['resolutiony'], $item['version']);
		$result['largeThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBLARGE, $item['resolutionx'], $item['resolutiony'], $item['version']);
		$result['xLargeThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBXLARGE, $item['resolutionx'], $item['resolutiony'], $item['version']);
		$result['isCommentable'] = csSYNOPhotoBrowse::GetBrowseInstance()->isFileCommentable($item['path']);
		return $result;
	}
		/*!
	 * Get thumb info for specified video
	 *
	 * \param $item array with video info
	 *	- path: video file path
	 *	- resolutionx: video width
	 *	- resolutiony: video height
	 *
	 * \return array with thumb info
	 *	- cover: cover info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *  - bigThumb: big thumb info returned by csSYNOPhotoMisc::GetThumbInfoFromFullPath()
	 *	- link: link to view the photo
	 */
	function GetVideoThumbInfo($item)
	{
		// charlie temp - maybe need to check if video extension name ex '.rm' is valid
		$result['path'] = $item['path'];

		$customTitleDesc = csSYNOPhotoDB::GetDBInstance()->GetVideoCustomizedTitleDescription($item['path']);
		if (empty($customTitleDesc['title'])) {
			$result['showTitle'] = $item['title'];
		} else {
			$result['showTitle'] = $customTitleDesc['title'];
		}
		$result['GPSInfo'] = json_decode($item['gps']);
		$result['title'] = $customTitleDesc['title'];
		$result['desc'] = $customTitleDesc['description'];
		$result['resolutionx'] = $item['resolutionx'];
		$result['resolutiony'] = $item['resolutiony'];
		$result['cover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBSMALL, $item['resolutionx'], $item['resolutiony']);
		$result['bigCover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBMEDIUM, $item['resolutionx'], $item['resolutiony']);
		$result['bigThumb'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBBIG, $item['resolutionx'], $item['resolutiony']);
		$result['largeThumb'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBLARGE, $item['resolutionx'], $item['resolutiony']);
		$result['xLargeThumb'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($item['path'], SYNOPHOTO_THUMBXLARGE, $item['resolutionx'], $item['resolutiony']);

		$result['videos'] = csSYNOPhotoMisc::GetConvertedVideosFileInfoFromFullPath($item['path']);
		$result['video'] = $result['videos'][0];
		$result['isCommentable'] = csSYNOPhotoBrowse::GetBrowseInstance()->isFileCommentable($item['path']);

		return $result;
	}
	/*!
	 * edit photo or video property
	 *
	 * \param $path file path
	 * \param $itemType idenfity photo or video
	 * \param $title item's new title
	 * \param $description item's new description
	 */
	function EditItemProperty($path, $itemType, $title, $description)
	{
		$realPath = $path;
		$result = false;
		$path = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		if (SYNOPHOTO_ITEM_TYPE_PHOTO == $itemType) {
			$result = csSYNOPhotoDB::GetDBInstance()->UpdatePhotoProperty($path, $title, $description, $realPath);
			if ($result) {
				//flush photo dbcacher cache since data had been changed
				unset($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID]);
			}
		} else if (SYNOPHOTO_ITEM_TYPE_VIDEO == $itemType) {
			$result = csSYNOPhotoDB::GetDBInstance()->UpdateVideoProperty($path, $title, $description);
				if ($result) {
				//flush video dbcacher cache since data had been changed
				unset($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID]);
			}
		}

		return $result;
	}
}
?>
