<?php
require_once('synophoto_mobile_conf.php');
require_once(SYNOPHOTO_INCLUDE_DB);

function SYNOPHOTO_LABEL_UTIL_GetAllLabel($forceStatusConfirm = false)
{
	$tag = array();
	$tag[IDX_LABEL_ALBUM_PERSON] = array();//person
	$tag[IDX_LABEL_ALBUM_PLACE] = array();//place
	$tag[IDX_LABEL_ALBUM_GENERAL] = array();//general

	$needFilterNonConfirm = $forceStatusConfirm;
	$filterCondi = ($needFilterNonConfirm) ? " WHERE status='t' " : '';

	$sqlParam = array();
	if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && !$needFilterNonConfirm) {
		$query = 'SELECT * FROM photo_label;';
	} else {
		$query = 'select distinct photo_label.id as id, photo_label.name as name, photo_label.info as info, category from photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id LEFT JOIN photo_label ON photo_image_label.label_id=photo_label.id '.$filterCondi;
		$videoQuery = 'select distinct photo_label.id as id, photo_label.name as name, photo_label.info as info, category from photo_video_label LEFT JOIN video ON photo_video_label.video_path=video.path LEFT JOIN photo_label ON photo_video_label.label_id=photo_label.id ';

		if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$operator = ($needFilterNonConfirm) ? ' AND ' : 'WHERE';
			$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
			if(count($albumCondition['albumCond']) > 0) {
				$query .= " $operator (".implode(' OR ', $albumCondition['albumCond']).' )';
				$videoQuery .= ' WHERE ('.implode(' OR ', $albumCondition['albumCond']).' )';
				$sqlParam = $albumCondition['sqlParam'];
			} else {
				return $tag;
			}
		}
	}

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	while (false !== ($row = $db_result->fetch())) {
		if (empty($row['name'])) {
			continue;
		}
		$tag[$row['category']][] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
	}
	if (isSet($videoQuery)) {
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $videoQuery, $sqlParam);
		while (false !== ($row = $db_result->fetch())) {
			$find = false;
			foreach($tag[$row['category']] as $item){
				if ($item['id'] == $row['id']){
					$find = true;
				}
			}
			if (!$find) {
				$tag[$row['category']][] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
			}
		}
	}

	usort($tag[IDX_LABEL_ALBUM_PERSON], 'SYNOPHOTO_LABEL_UTIL_SortLabel');
	usort($tag[IDX_LABEL_ALBUM_PLACE], 'SYNOPHOTO_LABEL_UTIL_SortLabel');
	usort($tag[IDX_LABEL_ALBUM_GENERAL], 'SYNOPHOTO_LABEL_UTIL_SortLabel');
	return $tag;
}

function SYNOPHOTO_LABEL_UTIL_SortLabel($a, $b)
{
	return strnatcasecmp($a['name'], $b['name']);
}

function SYNOPHOTO_LABEL_UTIL_GetLabelItem($row)
{
	$item = array();
	$item['id'] = $row['id'];
	$item['name'] = $row['name'];
	$item['display_name'] = htmlspecialchars($row['name'],ENT_QUOTES);
	$item['info'] = $row['info'];
	return $item;
}

?>
