<?php
require_once('../include/synophoto_mobile_conf.php');
require_once('../include/send_mail.php');

function PostNewComment($filePath, $itemType, $name, $mail, $comment)
{
	$result = array();
	$result['success'] = csSYNOPhotoBrowse::GetBrowseInstance()->AddNewComment($filePath, $itemType, $name, $mail, $comment);

	if ($result['success']) {
		// send notification mail to admin
		$fileName = basename($filePath);
		$dir = (false !== strpos($filePath, SYNOPHOTO_SERVICE_DIR)) ? SYNOPHOTO_SERVICE_DIR.'/' : SYNOPHOTO_SERVICE_REAL_DIR.'/';
		$dir = substr($filePath, strlen($dir), strlen($filePath) - strlen($dir) - strlen($fileName) - 1);
		SYNOPHOTO_SEND_MAIL_SendCommentMailToAdmin($dir, $fileName, $name, $mail, $comment);
	}
	return $result;
}

function EditProperty($path, $itemType, $title, $description)
{
	$result = array();
	$result['success'] = csSYNOPhotoThumb::GetThumbInstance()->EditItemProperty($path, $itemType, $title, $description);
	return $result;
}

function EditAlbumProperty($shareName, $title, $description, $albumPersmission, $password)
{
	$result = array();
	$result['success'] = csSYNOPhotoAlbum::GetAlbumInstance()->EditAlbumProperty($shareName, $title, $description, $albumPersmission, $password);

	return $result;
}

function DispatchAction($action)
{
	$result = array();
	switch ($action) {
		case 'post_comment':
			if (isSet($_REQUEST['filePath']) && isSet($_REQUEST['itemType']) && isSet($_REQUEST['name']) && isSet($_REQUEST['mail']) && isSet($_REQUEST['comment'])) {
				$result = PostNewComment($_REQUEST['filePath'], $_REQUEST['itemType'], $_REQUEST['name'], $_REQUEST['mail'], $_REQUEST['comment']);
			}
			break;
		case 'edit_property':
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) || isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
				if (isSet($_REQUEST['itemType']) && SYNOPHOTO_ITEM_TYPE_ALBUM != $_REQUEST['itemType'] && isSet($_REQUEST['title']) && isSet($_REQUEST['description']) && isSet($_REQUEST['filePath'])) {
					$result = EditProperty($_REQUEST['filePath'], $_REQUEST['itemType'], $_REQUEST['title'], $_REQUEST['description']);
				} else if (isSet($_REQUEST['itemType']) && SYNOPHOTO_ITEM_TYPE_ALBUM == $_REQUEST['itemType'] && isSet($_REQUEST['title']) && isSet($_REQUEST['description']) && isSet($_REQUEST['albumPermission']) && isSet($_REQUEST['shareName'])) {
					$password = (isSet($_REQUEST['passwd']))?$_REQUEST['passwd']:null;
					$albumPermission = (int) $_REQUEST['albumPermission'];
					$result = EditAlbumProperty($_REQUEST['shareName'], $_REQUEST['title'], $_REQUEST['description'], $albumPermission, $password);
				} else {
					$result['success'] = 'error_bad_parameter';
				}
			} else {
				$result['success'] = 'error_not_login';
			}
			break;

		default:
			break;
	}
	return $result;
}

$action = isSet($_REQUEST['action']) ? $_REQUEST['action'] : '';
echo json_encode(DispatchAction($action));

?>