<?php

class SYNOPhotoEA
{
	const SYNO_PHOTO_PREFIX = 'SYNOPHOTO_';
	const SYNO_PHOTO_PREFIX_OLD = 'SYNOPHOTO:';
	const USE_OLD_PREFIX = true;
	const SYNO_EA_DIR = '@eaDir';
	const FILE_ALBUM_COVER = 'ALBUM.cover';
	const FILE_ALBUM_SORT = 'ALBUM.sort';
	const FILE_ALBUM_FBSYNC = 'ALBUM.fbsync';
	const FILE_TITLE = 'TITLE';
	const FILE_DESC = 'DESC';
	const FILE_PUBLIC = 'PUBLIC';
	const FILE_FILM_FLV = 'FILM.flv';
	const FILE_FILM_FAIL = 'FILM.fail';
	const FILE_FILM_H_MP4 = 'FILM_H.mp4';
	const FILE_FILM_M_MP4 = 'FILM_M.mp4';
	const FILE_FILM_L_MP4 = 'FILM_L.mp4';
	const FILE_FILM_MOBILE_MP4 = 'FILM_MOBILE.mp4';
	const FILE_FILM_MOBILE_IPHONE = 'FILM_MOBILE_IPHONE';
	const FILE_FILM_MOBILE_ANDROID = 'FILM_MOBILE_ANDROID';
	const FILE_FILM_H264_MP4 = 'FILM_H264.mp4';
	const FILE_FILM_MPEG4_MP4 = 'FILM_MPEG4.mp4';
	const FILE_FILM_CONVERT_MPEG4_MP4 = 'FILM_CONVERT_MPEG4.mp4';
	const FILE_FILM_CONVERT_MPEG4_FAIL = 'FILM_CONVERT_MPEG4.fail';
	const FILE_GPS = 'GPS';
	const FILE_THUMB_XL = 'THUMB_XL.jpg';
	const FILE_THUMB_L = 'THUMB_L.jpg';
	const FILE_THUMB_B = 'THUMB_B.jpg';
	const FILE_THUMB_M = 'THUMB_M.jpg';
	const FILE_THUMB_S = 'THUMB_S.jpg';
	const FILE_THUMB_B_FAIL = 'THUMB_B.fail';
	const FILE_THUMB_S_FAIL = 'THUMB_S.fail';
	const OLD_EADIR_PREFIX_DSM_VERSION = 3734;

	/**
	 * Get thumbnail filename by thumbnail type.
	 *
	 * @param string
	 *   Thumbnail type.
	 * @param bool
	 *   Use old style prefix or not.
	 *
	 * @return string
	 *   Return thumbnail filename.
	 */
	public static function getFilename($type, $useOldStyle = false)
	{
		$prefix = ($useOldStyle) ? self::SYNO_PHOTO_PREFIX_OLD : self::SYNO_PHOTO_PREFIX;

		return sprintf("%s%s", $prefix, $type);
	}
	/**
	 * Get full path of file in ea dir by original file path and ea file type.
	 *
	 * @param string
	 *   File path of original file.
	 * @param string
	 *   EA file type.
	 *
	 * @return string
	 *   Return ea file full path.
	 */
	public static function getFilePath($path, $type)
	{
		$eaDirPath = self::getEADirPath($path);
		$eaFilename = self::getFilename($type);

		return sprintf("%s/%s", $eaDirPath, $eaFilename);
	}

	/**
	 * Get full path of file in ea dir by dir and filename of original file.
	 *
	 * @param string
	 *   Dir path of original file.
	 * @param string
	 *   Filename of original file.
	 * @param string
	 *   EA file type.
	 *
	 * @return string
	 *   Return ea file full path.
	 */
	public static function getFilePathByDirFile($dir, $filename, $type)
	{
		$eaDirPath = self::getEADirPathByDirFile($dir, $filename);
		$eaFilename = self::getFilename($type);

		return sprintf("%s/%s", $eaDirPath, $eaFilename);
	}

	/**
	 * Get EA directory of specified file/dir.
	 * For example, /volume2/share3/dir/file1
	 * => /volume2/share3/dir/SYNO_EA_DIR/file
	 *
	 * @param string
	 *   File/dir path.
	 *
	 * @return string
	 *   Return ea dir path of input file/dir.
	 */
	public static function getEADirPath($path)
	{
		$path = preg_replace('/\/+$/', '', $path); // remove trailing slash ('/')
		$pos = strrpos($path, '/');
		$dir = substr($path, 0, $pos);
		$file = substr($path, $pos + 1);

		return self::getEADirPathByDirFile($dir, $file);
	}

	/**
	 * Get EA directory of specified file/dir.
	 * For example, /volume2/share3/dir/file1
	 * => /volume2/share3/dir/SYNO_EA_DIR/file
	 *
	 * @param string
	 *   Dir path of original file.
	 * @param string
	 *   Filename of original file.
	 *
	 * @return string
	 *   Return ea dir path.
	 */
	public static function getEADirPathByDirFile($dir, $filename)
	{
		return sprintf("%s/%s/%s", $dir, self::SYNO_EA_DIR, $filename);
	}

	/**
	 * Create EA directory of specified file/dir.
	 * Will create parent @eaDir dir if not exists.
	 *
	 * @param string
	 *   Original file/dir path.
	 * @param string
	 *   Set ea dir path in this variable.
	 *
	 * @return bool
	 *   Return true if mkdir succeeded.
	 */
	public static function createEADir($path, &$eaDir)
	{
		$eaDir = self::getEADirPath($path);

		if (is_dir($eaDir)) {
			// ea dir already exists
			return true;
		}

		if (!is_dir(dirname($eaDir))) {
			@mkdir(dirname($eaDir), 0777);
		}

		return @mkdir($eaDir, 0777);
	}

	/**
	 * Given base dir and filename list,
	 * check if dir/filename[i] exists.
	 * When one of the files exists, return true and set path to the combined result.
	 * When none of the files exist, return false.
	 *
	 * @param string
	 *   Base dir path.
	 * @param array
	 *   Filename list to check.
	 * @param string
	 *   Set full path if exists.
	 *
	 * @return bool
	 *   Return true if file exists, else return false.
	 */
	public static function checkPathExists($dir, array $files, &$path)
	{
		foreach ($files as $item) {
			$combined = sprintf("%s/%s", $dir, $item);
			if (file_exists($combined)) {
				$path = $combined;
				return true;
			}
		}
		return false;
	}

	/**
	 * Check file in ea dir use new style prefix first, then old style.
	 * Return true and set existed path in $eaPath.
	 * Return false when neither file exists.
	 *
	 * @param string
	 *   File path of original file.
	 * @param string
	 *   EA file type.
	 * @param string
	 *   Return existed ea file path
	 *
	 * @return string
	 *   Return true when ea file found, otherwise return false.
	 */
	public static function checkFilePath($path, $type, &$eaPath)
	{
		return self::checkPathExists(
			self::getEADirPath($path),
			array(self::getFilename($type), self::getFilename($type, self::USE_OLD_PREFIX)),
			$eaPath
		);
	}

	/**
	 * Check file in ea dir use new style prefix first, then old style.
	 * Return true and set existed path in $eaPath.
	 * Return false when neither file exists.
	 *
	 * @param string
	 *   Dir path of original file.
	 * @param string
	 *   Filename of original file.
	 * @param string
	 *   EA file type.
	 * @param string
	 *   Return existed ea file path
	 *
	 * @return string
	 *   Return true when ea file found, otherwise return false.
	 */
	public static function checkFilePathByDirFile($dir, $file, $type, &$eaPath)
	{
		return self::checkPathExists(
			self::getEADirPathByDirFile($dir, $file),
			array(self::getFilename($type), self::getFilename($type, self::USE_OLD_PREFIX)),
			$eaPath
		);
	}
}
