<?php
require_once('../include/synophoto_mobile_conf.php');

$albumName = @pack('H*', $_GET['dir']);
$password = $_GET['password'];
$checkResult = csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($albumName, $password);

if (true !== $checkResult) {
	switch ($checkResult) {
		case "error_need_album_password":
			echo json_encode(array(
				'error' => $checkResult,
				'confirm' => __('photo_str_password_protected')
			));
			break;
		case "error_invalid_album_password":
			echo json_encode(array(
				'error' => $checkResult,
				'confirm' => __('photo_str_password_error')
			));
			break;
		case "error_no_permission":
		default:
			header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/m/");
	}
	exit;
}

$offset = 0;
$length = PHOTOS_PER_LOAD;

if (isSet($_GET['offset']) && is_numeric($_GET['offset'])) {
	$offset = $_GET['offset'];
}
if (isSet($_GET['length']) && is_numeric($_GET['length'])) {
	$length = $_GET['length'];
}

$photos = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbList($albumName, $offset, $length);
echo json_encode($photos);
?>
