<?php

$type = (array_key_exists('type', $_POST)) ? $_POST['type'] : null;
require_once('syno_conf.php');
require_once 'SYNOPhotoEA.php';
$file = (array_key_exists('file', $_FILES)) ? $_FILES['file'] : null;
$action = (array_key_exists('action', $_POST)) ? $_POST['action'] : null;

if (isset($_GET['action']) && $_GET['action'] == "personal_img_upload") {
	$action = "personal_img_upload";
}

if ('bkg_upload_from_photo' == $action) {
	echo SYNOTHEME_IMAGE_UPLOAD_FROM_PHOTO($type);
	exit;
}

if (NULL == $file){
	$result['success'] = FALSE;
	$result['message'] = 'No file';
	return json_encode($result);
	exit;
}

if ('logo_upload' == $action) {
	echo SYNOTHEME_IMAGE_UPLOAD($file, SYNOTHEME_LOGO_CUSTOM_PREVIEW_FILE, SYNOTHEME_LOGO_SIZE_LIMIT);
	exit;
}

if ('banner_upload' == $action) {
	echo SYNOTHEME_IMAGE_UPLOAD($file, SYNOTHEME_BANNER_CUSTOM_PREVIEW_FILE, SYNOTHEME_BKG_SIZE_LIMIT);
	exit;
}

if ('bkg_upload' == $action) {
	echo SYNOTHEME_IMAGE_UPLOAD($file, SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE, SYNOTHEME_BKG_SIZE_LIMIT);
	exit;
}

if ('personal_img_upload' == $action) {
	echo SYNOTHEME_IMAGE_UPLOAD($file, SYNOTHEME_PERSONAL_IMG_FILE, SYNOTHEME_LOGO_SIZE_LIMIT);
	exit;
}



function SYNOTHEME_IMAGE_UPLOAD_FROM_PHOTO($type)
{
	$result['type'] = $type;
	if ('blog' === $type) {
		$post_dir = htmlspecialchars_decode($_POST['dir']);
		$post_name = htmlspecialchars_decode($_POST['name']);
		$source = SYNOPHOTO_SERVICE_REAL_DIR .'/'. $post_dir .'/'. $post_name;
		$dest = SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE;
	} else {
		$id_arr = split('_', $_POST['id']);
		$albumName = @pack('H*', $id_arr[1]);
		$post_name = @pack('H*', $id_arr[2]);
		$post_dir = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName;
		$source = $post_dir .'/'. $post_name;
		$dest = SYNOTHEME_BKG_PS_PREVIEW_FILE;
	}

	$u_agent = $_SERVER['HTTP_USER_AGENT'];
	$thumb_src = '';
	SYNOPhotoEA::checkFilePathByDirFile($post_dir, $post_name, SYNOPhotoEA::FILE_THUMB_M, $thumb_src);

	if (!file_exists($source)) {
		$result['success'] = FALSE;
		$result['message'] = __(photo_str_man_album_access);
		return json_encode($result);
	}


	// extention limit
	if (NULL == SYNOBLOG_GET_HEADER_PIC_Get_Mime_Type($post_name)) {
		$result['success'] = FALSE;
		$result['message'] = __(photo_str_file_error_format);
		return json_encode($result);
	}

	$dir = dirname($dest);
	if (!file_exists($dir)) {
		@mkdir($dir);
		@chmod($dir, 0777);
	}

	$imageInfo = @getImageSize($source);
	$oldBrowser = (preg_match('/MSIE/i',$u_agent) || preg_match('/Firefox\/3/i', $u_agent));
	$result['success'] = @copy ($source, $dest);
	if (1920 < min($imageInfo[0], $imageInfo[1]) && $oldBrowser && !strstr($imageInfo['mime'], 'gif')) {
		$result['success'] = csSYNOPhotoMisc::ResizePhoto($dest, $dest."_tmp.jpg");
		@rename($dest."_tmp.jpg", $dest);
	}

	if (false == $result['success']) {
		$result['message'] = __(photo_str_open_error);
		return json_encode($result);
	}

	if (file_exists($thumb_src)) {
		@copy($thumb_src, $dest . "_big.jpg");
	} else {
		@copy($dest, $dest . "_big.jpg");
	}
	csSYNOPhotoMisc::ResizePhoto($dest. "_big.jpg", $dest . "_big.jpg", 152, 112);

	if (false == csSYNOPhotoMisc::ResizePhoto($dest . "_big.jpg", $dest . ".jpg", 96, 71)) {
		@copy($dest . "_big.jpg", $dest . ".jpg");
	}

	return json_encode($result);

}

function SYNOTHEME_IMAGE_UPLOAD($file ,$dest, $size_limit)
{
	$u_agent = $_SERVER['HTTP_USER_AGENT'];

	// extention limit
	if (NULL == SYNOBLOG_GET_HEADER_PIC_Get_Mime_Type($file['name'])) {
		$result['success'] = FALSE;
		$result['message'] = __(photo_str_file_error_format);
		return json_encode($result);
	}

	$dir = dirname($dest);
	if (!file_exists($dir)) {
		@mkdir($dir);
		@chmod($dir, 0777);
	}

	if (move_uploaded_file ($file['tmp_name'], $dest)) {
		$result['success'] = TRUE;
		$result['file'] = $file['name'];
	} else {
		$result['success'] = FALSE;
		$result['message'] = __(photo_str_man_album_access);
		return json_encode($result);
	}

	if (NULL == SYNOBLOG_GET_HEADER_PIC_Get_Mime_Type($dest)) {
		$result['success'] = FALSE;
		$result['message'] = __(photo_str_file_error_format);
		return json_encode($result);
	}

	if (!file_exists($dest)) {
		$result['success'] = FALSE;
		$result['message'] = __(photo_str_man_album_access);
		return json_encode($result);
	}

	$imageInfo = @getImageSize($dest);

	if ($dest == SYNOTHEME_BANNER_CUSTOM_PREVIEW_FILE) {
		$result['success'] = TRUE;
		$result['height'] = $imageInfo[1];
		return json_encode($result);
	}

	$oldBrowser = (preg_match('/MSIE/i',$u_agent) || preg_match('/Firefox\/3/i', $u_agent));
	if (1920 < min($imageInfo[0], $imageInfo[1]) && $oldBrowser && !strstr($imageInfo['mime'], 'gif')) {
		if (csSYNOPhotoMisc::ResizePhoto($dest, $dest."_tmp.jpg")) {
			rename($dest."_tmp.jpg",$dest);
		}
	}

	if (!strstr($imageInfo['mime'], 'gif')) {
		$command = "/usr/syno/bin/convert -size 152x112 -thumbnail 152x112 -quality 70 -colorspace RGB -unsharp 0.5x0.5+1.25+0.0 ";
		$command .= $dest . " " . $dest . "_big.jpg";
		@system($command, $retval);
		if (0 != $retval) {
			@copy($dest, $dest . "_big.jpg");
		}
		csSYNOPhotoMisc::ResizePhoto($dest . "_big.jpg", $dest . ".jpg", 96, 71);
	} else { //gif
		@copy($dest, $dest.'.jpg');
		@copy($dest, $dest.'_big.jpg');
	}

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOBLOG_GET_HEADER_PIC_Get_Mime_Type($filename)
{
    $file_types  = array(
        'jpg'   =>  'image/jpeg',
        'jpeg'  =>  'image/jpeg',
        'bmp'   =>  'image/bmp',
        'gif'   =>  'image/gif',
        'png'   =>  'image/png'
    );

	if (file_exists($filename)) {
		$image_info = getimagesize($filename);
		if (in_array($image_info['mime'], $file_types)) {
			return $image_info['mime'];
		} else {
			return null;
		}
	} else {
		$path_parts = pathinfo($filename);
		$extension = strtolower($path_parts['extension']);

		if(array_key_exists($extension, $file_types)) {
			return $file_types[$extension];
		} else {
				return null;
		}
	}
}


?>
