<?php
define('SYNO_CNF_FILE', '/etc/synoinfo.conf');
define('SYNO_DEF_CNF_FILE', '/etc.defaults/synoinfo.conf');
define('SYNO_DEF_VERSION_FILE', '/etc.defaults/VERSION');
define('SYNOPHOTO_ADMIN_PASS', 'hlinak3');
define('SYNO_USER_FILE', '/etc/synouser.conf');

define('SYNOPHOTO_ROOT', dirname(__FILE__).'/..');
define('SMARTY_DIR', SYNOPHOTO_ROOT . '/smarty/');
define('SYNO_PKG_DIR', '/var/packages/PhotoStation');
define('SYNO_PKG_DEFAULT_CONF', SYNO_PKG_DIR.'/target/etc/photo_default.conf');

define('SYNOPHOTO_EADIR', '@eaDir');
define('SYNOPHOTO_RECYCLE_DIR', '#recycle');
define('SYNOPHOTO_LANGS_DIR', SYNOPHOTO_ROOT.'/language');
define('SYNO_PKG_CNF_FILE', SYNO_PKG_DIR.'/etc/settings.conf');
define('SYNOPHOTO_PACKAGE_INFO', SYNO_PKG_DIR.'/INFO');
define('SYNOPHOTO_USER_SORT_ALBUM_SYMBOL', '/');

//personal photo station
if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
	define('SYNOPHOTO_ADMIN_USER', substr(urldecode($matches[0]), 1));
	define('SYNOPHOTO_ADMIN_NAME', substr(urldecode($matches[0]), 2));
	define('SYNOPHOTO_URL_PREFIX', $matches[0]);
	define('SYNOPHOTO_SERVICE_DIR', '/var/services/homes/'.SYNOPHOTO_ADMIN_NAME.'/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR', @readlink('/var/services/homes').'/'.SYNOPHOTO_ADMIN_NAME.'/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PATH', '');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PREFIX', @readlink('/var/services/homes').'/'.SYNOPHOTO_ADMIN_NAME.'/photo/');
	define('SYNO_PERSONAL_CNF_FILE', '/usr/syno/etc/preference/'.SYNOPHOTO_ADMIN_NAME.'/synoinfo.conf');
	define('SYNOTHEME_DIR', '/var/services/blog/'.SYNOPHOTO_ADMIN_NAME);
} else{//photo station
	define('SYNOPHOTO_ADMIN_USER', 'root');
	define('SYNOPHOTO_ADMIN_NAME', 'root');
	define('SYNOPHOTO_URL_PREFIX', '');
	define('SYNOPHOTO_SERVICE_DIR', '/var/services/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR', @readlink(SYNOPHOTO_SERVICE_DIR));
	define('SYNOPHOTO_SERVICE_REAL_DIR_PATH', @readlink(SYNOPHOTO_SERVICE_DIR).'/');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PREFIX', '');
	define('SYNOTHEME_DIR', '/var/services/blog');
}

define('SYNOPHOTO_IMAGES_DIR_FULL', SYNOPHOTO_ROOT . '/images');
define('SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY', SYNOPHOTO_URL_PREFIX.'/photo/images/White/album_cover_empty.png');
define('SYNOPHOTO_IMG_EMPTY_FILE_PATH_HIGH_QUALITY', SYNOPHOTO_IMAGES_DIR_FULL . '/White/album_cover_empty.png');
define('SYNOPHOTO_IMG_EMPTY_ALBUM_ICON', SYNOPHOTO_URL_PREFIX.'/photo/images/White/icon_empty.png');
define('SYNOPHOTO_IMG_PASSWORD', SYNOPHOTO_URL_PREFIX.'/photo/images/album_cover_password.png');
define('SYNOPHOTO_IMG_PASSWORD_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/album_cover_password.png');
define('SYNOPHOTO_IMG_BROKEN', SYNOPHOTO_URL_PREFIX.'/photo/images/broken.png');
define('SYNOPHOTO_IMG_BROKEN_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/broken.png');
define('SYNOPHOTO_IMG_THUMB', SYNOPHOTO_URL_PREFIX.'/photo/images/thumb_white.gif');
define('SYNOPHOTO_IMG_THUMB_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/thumb_white.gif');
define('SYNOPHOTO_IMG_THUMB_BLACK', SYNOPHOTO_URL_PREFIX.'/photo/images/thumb_black.gif');
define('SYNOPHOTO_IMG_THUMB_BLACK_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/thumb_black.gif');
define('SYNOPHOTO_IMG_FULL_BIG', SYNOPHOTO_URL_PREFIX.'/photo/images/full_big.jpg');
define('SYNOPHOTO_IMG_FULL_BIG_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/full_big.gif');
define('SYNOPHOTO_IMG_FULL', SYNOPHOTO_URL_PREFIX.'/photo/images/full.gif');
define('SYNOPHOTO_IMG_FULL_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/full.gif');
define('SYNOPHOTO_IMG_MOVIE', SYNOPHOTO_URL_PREFIX.'/photo/images/movie.png');
define('SYNOPHOTO_IMG_MOVIE_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/movie.png');

define('SYNOBLOG_IMAGES_PROTECTED_ICON', SYNOPHOTO_URL_PREFIX.'/photo/images/icon_password.png');
define('SYNOBLOG_IMAGES_ERROR_ICON', SYNOPHOTO_URL_PREFIX.'/photo/images/error_icon.png');
define('SYNOBLOG_IMAGES_RIGHT_ARROW', SYNOPHOTO_URL_PREFIX.'/photo/images/right_arrow.gif');
define('SYNOPHOTO_IMG_DEFAULT_PERSONAL', 'images/White/defalut_image.png');
define('SYNOPHOTO_IMG_DEFAULT_PERSONAL_BLACK', 'images/Black/defalut_image.png');

define('SYNOPHOTO_PATH_DISPLAY_MAX', 16);
define('SYNOPHOTO_RSRV_DISK_SPACE', 104857600);	//100*1024*1024 bytes = 100M

define('SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE', 136);

define('SYNOPHOTO_THUMBSMALL_WIDTH', 120);
define('SYNOPHOTO_THUMBSMALL_HEIGHT', 120);
define('SYNOPHOTO_THUMBMEDIUM_WIDTH', 320);
define('SYNOPHOTO_THUMBMEDIUM_HEIGHT', 320);
define('SYNOPHOTO_THUMBBIG_WIDTH', 640);
define('SYNOPHOTO_THUMBBIG_HEIGHT', 640);
define('SYNOPHOTO_THUMBLARGE_WIDTH', 800);
define('SYNOPHOTO_THUMBLARGE_HEIGHT', 800);
define('SYNOPHOTO_THUMBXLARGE_WIDTH', 1280);
define('SYNOPHOTO_THUMBXLARGE_HEIGHT', 1280);

define('SYNOPHOTO_MAX_LOG_TO_KEEP', 1000);
define('SYNOPHOTO_REC_TO_DEL', 100);

define('SEARCH_RESULT_PER_LOAD', 30);

define('SYNO_EXIFTOOL_FILE', '/usr/syno/bin/exiv2');

define('SYNOPHOTO_THUMBSMALL', 0);
define('SYNOPHOTO_THUMBBIG', 1);
define('SYNOPHOTO_THUMBMEDIUM', 4);
define('SYNOPHOTO_THUMBLARGE', 5);
define('SYNOPHOTO_THUMBXLARGE', 12);

define('SYNOPHOTO_UNCONFIRM_TAG_ID', 'tag_unconfirm');

//item type definition, sync with mobile devide code
define('SYNOPHOTO_ITEM_TYPE_ALBUM', 0);
define('SYNOPHOTO_ITEM_TYPE_PHOTO', 1);
define('SYNOPHOTO_ITEM_TYPE_VIDEO', 2);

define('SYNOPHOTO_INCLUDE_DIR', SYNOPHOTO_ROOT.'/include');
define('SYNOPHOTO_INCLUDE_DB', SYNOPHOTO_INCLUDE_DIR.'/syno_db.php');
define('SYNOPHOTO_INCLUDE_MIME_MAIL', SYNOPHOTO_INCLUDE_DIR.'/mime_mail.php');
define('SYNOPHOTO_INCLUDE_SEND_MAIL', SYNOPHOTO_INCLUDE_DIR.'/send_mail.php');
define('SYNOPHOTO_INCLUDE_EA', SYNOPHOTO_INCLUDE_DIR.'/SYNOPhotoEA.php');
define('SYNOPHOTO_INCLUDE_GPS_UTIL', SYNOPHOTO_INCLUDE_DIR.'/photo/gps_util.php');
define('SYNOPHOTO_INCLUDE_LABEL_UTIL', SYNOPHOTO_INCLUDE_DIR.'/photo/label_util.php');
define('SYNOPHOTO_INCLUDE_ALBUM_UTIL', SYNOPHOTO_INCLUDE_DIR.'/photo/album_util.php');
define('SYNOBLOG_INCLUDE_ARTICLE', SYNOPHOTO_INCLUDE_DIR.'/blog/article.php');
define('SYNOBLOG_INCLUDE_MODULE', SYNOPHOTO_INCLUDE_DIR.'/blog/module.php');
define('SYNOBLOG_INCLUDE_LABEL', SYNOPHOTO_INCLUDE_DIR.'/blog/label.php');
define('SYNOBLOG_INCLUDE_COMMENT', SYNOPHOTO_INCLUDE_DIR.'/blog/comment.php');
define('SYNOBLOG_INCLUDE_AUTOSAVE', SYNOPHOTO_INCLUDE_DIR.'/blog/autosave.php');
define('SYNOPHOTO_ADMIN_DIR', SYNOPHOTO_ROOT.'/admin');
define('SYNOPHOTO_ADMIN_ACCESS_RIGHT', SYNOPHOTO_ADMIN_DIR.'/access_right.php');


define('SYNOPHOTO_TEMPLATE_DIR', SYNOPHOTO_ROOT.'/template');

define('SYNOBLOG_IMAGE_DIR', 'Blog Images');
//ARTICLE_PRIVILEGE
define('SYNOBLOG_ARTICLE_PRIVILEGE_PUBLIC', '0');
define('SYNOBLOG_ARTICLE_PRIVILEGE_USER', '1');
define('SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN', '2');
define('SYNOBLOG_ARTICLE_PRIVILEGE_PASSWD', '3');

define('SYNOBLOG_MODULES_DIR', SYNOPHOTO_ROOT.'/blog/modules');

// Blog Backup
define('SYNOPHOTO_BACKUP_PROGRESS_FILE', '/tmp/synoblog_backup.prog');
define('SYNOPHOTO_BACKUP_PID_FILE', '/tmp/synoblog_backup.pid');
define('SYNOPHOTO_BACKUP_TAR_FILE', 'synoblog_backup.tar.gz');
define('SYNOPHOTO_BACKUP_FINAL_FILE', 'synoblog.backup');
define('SYNOPHOTO_BACKUP_DUMP_FILE', 'synoblog_backup.dump');
define('SYNOPHOTO_BACKUP_TIME_FILE', 'synoblog_backup_time.txt');
define('SYNOPHOTO_BACKUP_SCHEMA_VERSION', '1.0');

// Theme
if ($type == 'blog') {
	define('SYNOTHEME_LOGO_CUSTOM_FILE',SYNOTHEME_DIR .'/blog_custom_logo.png');
	define('SYNOTHEME_LOGO_CUSTOM_PREVIEW_FILE',SYNOTHEME_DIR .'/blog_custom_preview_logo.png');
	define('SYNOTHEME_BANNER_CUSTOM_FILE',SYNOTHEME_DIR .'/blog_custom_banner.png');
	define('SYNOTHEME_BANNER_CUSTOM_PREVIEW_FILE',SYNOTHEME_DIR .'/blog_custom_preview_banner.png');
	define('SYNOTHEME_BKG_SYNO_FILE',SYNOTHEME_DIR . '/blog_bkg_syno.png');
	define('SYNOTHEME_BKG_CUSTOM_FILE',SYNOTHEME_DIR .'/blog_bkg_custom.jpg');
	define('SYNOTHEME_BKG_CUSTOM_THUMB_FILE',SYNOTHEME_DIR .'/blog_bkg_custom.jpg.jpg');
	define('SYNOTHEME_BKG_CUSTOM_THUMB_BIG_FILE',SYNOTHEME_DIR .'/blog_bkg_custom.jpg_big.jpg');
	define('SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE',SYNOTHEME_DIR .'/blog_bkg_custom_preview.png');
	define('SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_FILE',SYNOTHEME_DIR .'/blog_bkg_custom_preview.png.jpg');
	define('SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_BIG_FILE',SYNOTHEME_DIR .'/blog_bkg_custom_preview.png_big.jpg');
	define('SYNOTHEME_BKG_CUSTOM_TEMP_FILE',SYNOTHEME_DIR .'/blog_bkg_custom_temp.png');
	define('SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_FILE',SYNOTHEME_DIR .'/blog_bkg_custom_temp.png.jpg');
	define('SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_BIG_FILE',SYNOTHEME_DIR .'/blog_bkg_custom_temp.png_big.jpg');
	define('SYNOTHEME_CSS_CUSTOM_FILE',SYNOTHEME_DIR .'/blog_custom.css');
	define('SYNOTHEME_CSS_CUSTOM_EDIT_FILE',SYNOTHEME_DIR .'/blog_custom_edit.css');
} else {
	define('SYNOTHEME_LOGO_CUSTOM_FILE',SYNOTHEME_DIR .'/photo_custom_logo.png');
	define('SYNOTHEME_LOGO_CUSTOM_PREVIEW_FILE',SYNOTHEME_DIR .'/photo_custom_preview_logo.png');
	define('SYNOTHEME_BKG_SYNO_FILE',SYNOTHEME_DIR . '/photo_bkg_syno.png');
	define('SYNOTHEME_BKG_PS_FILE',SYNOTHEME_DIR .'/photo_bkg_ps.jpg');
	define('SYNOTHEME_BKG_PS_PREVIEW_FILE',SYNOTHEME_DIR .'/photo_bkg_ps_preview.jpg');
	define('SYNOTHEME_BKG_CUSTOM_FILE',SYNOTHEME_DIR .'/photo_bkg_custom.jpg');
	define('SYNOTHEME_BKG_CUSTOM_THUMB_FILE',SYNOTHEME_DIR .'/photo_bkg_custom.jpg.jpg');
	define('SYNOTHEME_BKG_CUSTOM_THUMB_BIG_FILE',SYNOTHEME_DIR .'/photo_bkg_custom.jpg_big.jpg');
	define('SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE',SYNOTHEME_DIR .'/photo_bkg_custom_preview.png');
	define('SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_FILE',SYNOTHEME_DIR .'/photo_bkg_custom_preview.png.jpg');
	define('SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_BIG_FILE',SYNOTHEME_DIR .'/photo_bkg_custom_preview.png_big.jpg');
	define('SYNOTHEME_BKG_CUSTOM_TEMP_FILE',SYNOTHEME_DIR .'/photo_bkg_custom_temp.png');
	define('SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_FILE',SYNOTHEME_DIR .'/photo_bkg_custom_temp.png.jpg');
	define('SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_BIG_FILE',SYNOTHEME_DIR .'/photo_bkg_custom_temp.png_big.jpg');
	define('SYNOTHEME_CSS_CUSTOM_FILE',SYNOTHEME_DIR .'/photo_custom.css');
	define('SYNOTHEME_CSS_CUSTOM_EDIT_FILE',SYNOTHEME_DIR .'/photo_custom_edit.css');
	define('SYNOTHEME_PERSONAL_IMG_FILE',SYNOTHEME_DIR .'/photo_personal_img.png');
}
define('SYNOTHEME_BKG_DEFAULT_FILE',SYNOPHOTO_IMAGES_DIR_FULL .'/theme/01.jpg');
define('SYNOTHEME_BKG_DEFAULT_THUMB_FILE_URL','/photo/images/01.jpg');
define('SYNOTHEME_REQUEST_FILE',SYNOPHOTO_URL_PREFIX . '/photo/include/synotheme.php');
define('SYNOTHEME_SERVER_SITE', 'http://update.synology.com/PhotoStation/FaceBook/ps5');
define('SYNOTHEME_SPACER_FILE',SYNOPHOTO_IMAGES_DIR_FULL .'/spacer.gif');
define('SYNOTHEME_SPACER_URL','/photo/images/spacer.gif');
define('SYNOTHEME_LOGO_SIZE_LIMIT', '512000');
define('SYNOTHEME_BKG_SIZE_LIMIT', '1048576');

// Facebook
define('SYNOPHOTO_FB_UPLOAD_PROGRESS_FILE', '/tmp/synophoto_fb_upload.prog');
define('SYNOPHOTO_FB_API_ID', '178470495541647');
define('SYNOPHOTO_FB_SECRET', 'd7004c60c95075ed1115e6606e182203');

define('SYNOPHOTO_FB_UTILS', SYNOPHOTO_ROOT.'/facebook/fbutils.php');
define('SYNOPHOTO_FB_SDK', SYNOPHOTO_ROOT.'/facebook/php-sdk/src/facebook.php');

define('SYNOPHOTO_FB_SYNCING_FILE', '/tmp/fbsyncing');
define('SYNOPHOTO_FB_REGULAR_SYNC_CONF', '/var/services/blog/fb_allow_regular_sync.conf');

define('SYNOPHOTO_PICASA_UPLOAD_PROGRESS_FILE', '/tmp/synophoto_picasa_upload.prog');

define('SYNOPHOTO_FACE_RECOG_TOOL', '/usr/syno/bin/facerecognition');
define('SYNOPHOTO_DAEMON_QUEUE', '/var/spool/photostation.queue');
define('SYNOPHOTO_DAEMON_QUEUE_TMP', '/var/spool/photostation.queue.tmp');

define('SYNOPHOTO_DAEMON', '/usr/syno/bin/photostationd');

define('SYNOPHOTO_INDEX_QUEUE', '/var/spool/syno_indexing_queue');
define('SYNOPHOTO_INDEX_QUEUE_TMP', '/var/spool/syno_indexing_queue.tmp');


$SYNOTHEME_CONFIG = array(
	"photo" => array(
		"White" => array(
			"v6_template"	    => "White",
			"v6_transparent"    => "70",
			"v6_show_bkg_img"   => "0",
			"v6_bkg_color"	    => "ffffff",
			"v6_font_color"	    => "505A64",
			"v6_logo"	    => "1",
			"v6_hl_color"	    => "00bfff",
			"v6_sec_color"	    => "78828c"
		),
		"Black" => array(
			"v6_template"	    => "Black",
			'v6_bkg_color'	    => '232323',
			'v6_font_color'	    => 'BEC3C8',
			'v6_sec_color'	    => 'A0A5AA',
			'v6_hl_color'	    => '00bfff',
			'v6_logo'	    => '1',
			'v6_show_bkg'	    => '0',
			'v6_show_bkg_img'   => '0',
		)
	),
	"blog" => array(
		"White" => array(
			"template"              => "White",
			"transparent"   => "70",
			"show_bkg_img"  => "3",
			"bkg_color"             => "8ab8e6",
			"font_color"    => "0077cc",
			"logo"          => "1",
			"banner"                => "1"
		)
	)
);

$SYNOPHOTO_DSM_USER_INFO = array(
	'User Name', 'User Type', 'User uid', 'User gid',
	'Fullname', 'User Dir', 'User Shell', 'Expired',
	'User Mail', 'Alloc Size', 'AdminGroup'
);

$SYNOPHOTO_ALLOW_PICT_NAMES_EXT = array(
	'jpg', 'jpeg', 'jpe', 'bmp', 'gif', 'png', 'tiff', 'tif',
	// Camera raw files
	"arw", "srf", "sr2", // Sony
	"dcr", "k25", "kdc", // Kodak
	"cr2","crw",// Canon
	"nef", // nikon
	"mrw", // Minolta
	"ptx", "pef",// Pentax
	"raf", // Fuji
	"3fr", // Hasselblad
	"erf", // (Epson)
	"mef", // (Mamiya)
	"mos", // (Leaf)
	"orf", // (Olympus),
	"rw2", // (Panasonic)
	"dng", // Adobe Digital Negative
	"x3f", // Sigma Raw Image
	"raw"  // Panasonic
);
$SYNOPHOTO_ALLOW_ORIG_NAMES_EXT = array('gif');

$SYNOPHOTO_ALLOW_FILM_NAMES_EXT = array(
	"mpg", "mpeg", "avi", "wmv", "asf", "mov", "flv", "f4v",
	"3gp", "3g2",  "mp4", "m4v", "qt", "divx", "xvid",
	"dat", "m2ts", "m2t", "mts"
);

$SYNOPHOTO_DB_TIME_FIELD = array(
	'photo' => array('timetaken', 'create_time'),
	'video' => array('mdate', 'date')
);

// BLOG MODULES
$SYNOPHOTO_BLOG_MODULES[0]['name'] = 'article_collection';
$SYNOPHOTO_BLOG_MODULES[0]['provide_setting'] = 'f';
$SYNOPHOTO_BLOG_MODULES[1]['name'] = 'friend_link';
$SYNOPHOTO_BLOG_MODULES[1]['provide_setting'] = 't';
$SYNOPHOTO_BLOG_MODULES[2]['name'] = 'google_ad';
$SYNOPHOTO_BLOG_MODULES[2]['provide_setting'] = 't';
$SYNOPHOTO_BLOG_MODULES[3]['name'] = 'label_cloud';
$SYNOPHOTO_BLOG_MODULES[3]['provide_setting'] = 'f';
$SYNOPHOTO_BLOG_MODULES[4]['name'] = 'personal_information';
$SYNOPHOTO_BLOG_MODULES[4]['provide_setting'] = 't';
$SYNOPHOTO_BLOG_MODULES[5]['name'] = 'photo_slide';
$SYNOPHOTO_BLOG_MODULES[5]['provide_setting'] = 't';
$SYNOPHOTO_BLOG_MODULES[6]['name'] = 'recent_article';
$SYNOPHOTO_BLOG_MODULES[6]['provide_setting'] = 't';
$SYNOPHOTO_BLOG_MODULES[7]['name'] = 'recent_comment';
$SYNOPHOTO_BLOG_MODULES[7]['provide_setting'] = 't';
$SYNOPHOTO_BLOG_MODULES[8]['name'] = 'search';
$SYNOPHOTO_BLOG_MODULES[8]['provide_setting'] = 'f';
$SYNOPHOTO_BLOG_MODULES[9]['name'] = 'statistical_data';
$SYNOPHOTO_BLOG_MODULES[9]['provide_setting'] = 'f';
$SYNOPHOTO_BLOG_MODULES[10]['name'] = 'calendar';
$SYNOPHOTO_BLOG_MODULES[10]['provide_setting'] = 'f';
