<?php
require_once('synophoto_csDBCacher.php');
/*!
 * database operation
 */
class csSYNOPhotoDB {
	/*! cache life time (seconds)*/
	public $CACHE_LIFETIME = 300;
	/*! db connection handler */
	public $_dbh;
	/*! db cacher handler */
	private $_dbCacher;
	/*! db cacher handler for mediaserver DB*/
	private $_dbCacherMedia;
	/*! db escape string for like */
	public $escapeStr = '';
	public $db_type = '';
	public static $current_admin = '';
	/*! reference to a self instance */
	private static $instance = null;
	/*!
	 * Constructor
	 */
	function __construct()
	{
		if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
			$user = substr(urldecode($matches[0]), 2);
			$user_photo_db = "/var/services/homes/{$user}/photo/.SYNOPPSDB";
			$user_media_db = "/var/services/homes/{$user}/photo/.SYNOPPSDB";
			if(!file_exists($user_photo_db) || !file_exists($user_media_db)){
				header("Location: /photo/report.php?nosrv=true&msgkey=photo_str_service_disabled");
				exit;
			}
			try{
				$this->_dbh = new PDO("sqlite:{$user_photo_db}");
				$this->_dbh->exec('PRAGMA case_sensitive_like=1');
				$this->_dbh->exec('PRAGMA foreign_keys=ON');
				$this->escapeStr = " ESCAPE '\'";
				self::$current_admin = $user;
			} catch (PDOException $e) {
				die($e->getMessage());
			}
		} else {
			try{
				$this->_dbh = new PDO('pgsql:dbname=photo', 'admin', '',
					array(PDO::ATTR_PERSISTENT => false, PDO::ATTR_EMULATE_PREPARES => true));
				self::$current_admin = 'root';

			} catch (PDOException $e) {
				die($e->getMessage());
			}
		}

		$this->_dbCacher = new DBCacher($this->_dbh, false, self::$current_admin);
		$this->_dbCacherMedia = new DBCacher($this->_dbh, true, self::$current_admin);

		$GLOBALS['dbconn_photo'] = $this->_dbh;

		$this->SetSessionSystemConfigsFromFile();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'] = array();

		$this->db_type = $this->_dbh->getAttribute(constant("PDO::ATTR_DRIVER_NAME"));
	}
	/*!
	 * close db connection
	 */
	function __destruct()
	{
		$this->_dbh = null;
	}
	/*!
	 * Get a exist instance
	 */
	static function GetDBInstance()
	{
		$admin_name = preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches) ? substr(urldecode($matches[0]), 2) : 'root';
		if (null === self::$instance || $admin_name != self::$current_admin) {
			self::$instance = null;
			self::$instance = new self;
			self::$current_admin = $admin_name;
		}
		return self::$instance;
	}
	/*!
	 * escape string for like/ilike sql op
	 * \param $param string to escape
	 * \return escaped string
	 */
	static function EscapeLikeParam($param)
	{
		$param = str_replace('\\', '\\\\', $param);
		$param = str_replace('_', '\\_', $param);
		$param = str_replace('%', '\\%', $param);
		return $param;
	}
	/*!
	 * escape string when insert or update to db
	 * \param $param string to escape
	 * \return escaped string
	 */
	function EscapeParam($param)
	{
		if ('sqlite' == $this->db_type) {
			return sqlite_escape_string($param);
		}
		return pg_escape_string($param);
	}

    private function EscapeArray($arr)
    {
        $ret = array();
        foreach ($arr as $data) {
            array_push($ret, $this->EscapeParam($data));
        }
        return $ret;
    }

    private function ConvertItemID($itemID)
    {
        $arr = explode('_', $itemID );
        if (2 != count($arr)) {
            return false;
        }
        if (!in_array($arr[0], array('album', 'smart', 'tag'))) {
            return false;
        }
        $ret = array();
        $ret['type'] = $arr[0];
        switch ($arr[0]) {
            case 'album':
                $shareName = @pack('H*', $arr[1]);
                if (false === ($row = $this->GetFieldByKeyValue('shareid', 'photo_share', 'sharename', $shareName))) {
                    return false;
                }
                $ret['id'] = $row['shareid'];
                break;
            case 'smart':
                $ret['id'] = $arr[1];
                break;
            case 'tag':
                $ret['id'] = $arr[1];
                break;
            default:
                return false;
                break;
        }
        return $ret;
    }

    public function IsCategoryAccessible($categoryID)
    {
        $ret = false;

        $row = $this->GetFieldByKeyValue('hidden', 'category', 'id', $categoryID);
        if (true === $row['hidden'] || 't' === $row['hidden']) {
            $ret = true;
        } elseif (false === $row['hidden'] || 'f' === $row['hidden']) {
            $ret = false;
        }

        return $ret;
    }

    private function IsItemsBelongToCateogyID($categoryID, $itemIDs)
    {
        if (empty($categoryID) || 0 === count($itemIDs)) {
            return false;
        }

        $albumIDs = $smartIDs = $tagIDs = array();
        foreach ($itemIDs as $item) {
            $data = $this->ConvertItemID($item);
            $type = $data['type'];
            $id = $data['id'];
            if ('album' === $type) {
                array_push($albumIDs, $id);
            } elseif ('tag' === $type) {
                 array_push($tagIDs, $id);
            } elseif ('smart' === $type) {
                 array_push($smartIDs, $id);
            }
        }
        $idCondition = array();
        if (0 != count($albumIDs)) {
            $albumString = '\''.implode('\',\'', $albumIDs).'\'';
            $albumCondition = "(album_id IN ({$albumString}))";
            array_push($idCondition, $albumCondition);
        }
        if (0 != count($tagIDs)) {
            $tagString = '\''.implode('\',\'', $tagIDs).'\'';
            $tagCondition = "(tag_id IN ({$tagString}))";
            array_push($idCondition, $tagCondition);
        }
        if (0 != count($smartIDs)) {
            $smartString = '\''.implode('\',\'', $smartIDs).'\'';
            $smartCondition = "(smart_id IN ({$smartString}))";
            array_push($idCondition, $smartCondition);
        }
        $conditionString = implode(' OR ', $idCondition);

        $query = "SELECT count(id) FROM category_items WHERE category_id={$categoryID} AND ({$conditionString})";
        $dbResult = $this->_dbh->query($query);
        $row = $dbResult->fetch();
        if ($row[0] != count($itemIDs)) {
            return false;
        }
        return true;
    }

	private function ReadSmartAlbumFile()
	{
        if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
            $user = substr(urldecode($matches[0]), 2);
            $smartAlbumFile = '/var/services/homes/'.$user.'/photo/@eaDir/smart_album.json';
        } else {    
            $smartAlbumFile = '/var/services/photo/@eaDir/smart_album.json';
        }

		//test whether smart album file config exist or not
		if (!@file_exists($smartAlbumFile)) {
			return null;
		}

		//get contents from smart album config file
		if (!$smartAlbumJsonStr = @file_get_contents($smartAlbumFile)) {
			return null;
		}

		//parse contents
		if (!$smartAlbumList = json_decode($smartAlbumJsonStr, true)) {
			return null;
		}

		return $smartAlbumList;
    }

    private function IsCategoryItemExist($type, $id)
    {
        switch ($type) {
            case 'album':
                $name = @pack('H*', $arr[1]);
                $row = $this->GetFieldByKeyValue('count(shareid)', 'photo_share', 'shareid', $id);
                if (1 !== (int)$row[0]) {
                    return false;
                }
                break;
            case 'smart':
                $name = @pack('H*', $id);
                $result = $this->ReadSmartAlbumFile();
                if (!isset($result['smart_albums'][$name])) {
                    return false;
                }
                break;
            case 'tag':
                $row = $this->GetFieldByKeyValue('count(id)', 'photo_label', 'id', $id);
                if (1 !== (int)$row[0]) {
                    return false;
                }
                break;
            default:
                return false;
                break;
        }
        return true;
    }

    public function GetTotalCategory($isAdmin = false)
    {
        if (false === $isAdmin) {
            $condition = "WHERE hidden='f'";
        }
        $query = "SELECT count(id) FROM category {$condition}";
        $dbResult = $this->_dbh->query($query);
        $row = $dbResult->fetch();
        return $row[0];
    }

    public function GetTotalCategoryItem($categoryID)
    {
        $query = "SELECT count(id) FROM category_items WHERE category_id={$categoryID}";
        $dbResult = $this->_dbh->query($query);
        $row = $dbResult->fetch();

        return $row[0];
    }

    public function GetFieldByKeyValue($field, $table, $key = false, $keyValue = false)
    {
        if (empty($field) || empty($table)) {
            return false;
        }

        $keyValue = $this->EscapeParam($keyValue);
        if (false !== $key && false !== $keyValue) {
            $query = "SELECT {$field} FROM {$table} WHERE {$key}='{$keyValue}'";
        } else {
            $query = "SELECT {$field} FROM {$table}";
        }
        $dbResult = $this->_dbh->query($query);
        $row = $dbResult->fetch();
        return $row;
    }

    public function ListCategory($offset = false, $limit = false, $isAdmin = false)
    {
        if (false === $isAdmin) {
            $condition = "WHERE hidden='f'";
        }

        if (false === $offset || false === $limit) {
            $query = "SELECT * FROM category {$condition} ORDER BY order_number";
        } else {
            $limitCond = (0 > (int)$limit) ? '' : "LIMIT {$limit}";
            $query = "SELECT * FROM category {$condition} ORDER BY order_number ASC {$limitCond} OFFSET {$offset}";
        }
        $dbResult = $this->_dbh->query($query);

        $result = array();
        while($row = $dbResult->fetch()) {
            array_push($result, $row);
		}
        return $result;
    }

    public function GetCategory($categoryID)
    {
        if (empty($categoryID)) {
            return false;
        }

        $query = "SELECT * FROM category WHERE id={$categoryID}";
        $dbResult = $this->_dbh->query($query);
        $row = $dbResult->fetch();
        if (false === $row) {
            return false;
        }
        return $row;
    }

    public function CreateCategory($categoryName, $hidden = 'f')
    {
        if (empty($categoryName)) {
            return false;
        }

        // get max order number
        $row = $this->GetFieldByKeyValue('max(order_number)', 'category');
        $newOrderNumber = $row[0]+1;

        // insert to category
        $create_date = date("Y-m-d G:i:s");
        $modify_date = date("Y-m-d G:i:s");
        $categoryName = $this->EscapeParam($categoryName);
        $query = "INSERT INTO category (name, hidden, order_number, create_date, modify_date) VALUES ('{$categoryName}', '{$hidden}', {$newOrderNumber}, '{$create_date}', '{$modify_date}')";
        $dbResult = $this->_dbh->prepare($query);
        if (false === $dbResult->execute()) {
            return false;
        }

        // get inserted category id
        $query = "SELECT id FROM category WHERE name='{$categoryName}' AND create_date='{$create_date}'";
        $dbResult = $this->_dbh->prepare($query);
        if (false === $dbResult->execute()) {
            return false;
        }
        $row = $dbResult->fetch();
        if (empty($row['id'])) {
            return false;
        }

        return $row['id'];
    }

    public function DeleteCategory($categoryID)
    {
        if (empty($categoryID)) {
            return false;
        }

        // check category id
        if (false === $this->GetCategory($categoryID)) {
            return false;
        }

        // delete
        $query = "DELETE FROM category WHERE id={$categoryID}";
        $dbResult = $this->_dbh->prepare($query);
        if (false === $dbResult->execute()) {
            return false;
        }
        return true;
    }

    public function EditCategory($categoryID, $name = false, $hidden = 'default')
    {
        if (empty($categoryID)) {
            return false;
        }

        // check category id
        if (false === $this->GetCategory($categoryID)) {
            return false;
        }

        if (false === $name && 'default' === $hidden) {
            return true;
        }

        $updateArr = array();
        if (false !== $name) {
            $name = $this->EscapeParam($name);
            $nameUpdate = "name='{$name}'";
            array_push($updateArr, $nameUpdate);
        }
        if ('default' !== $hidden) {
            $hiddenUpdate = "hidden='{$hidden}'";
            array_push($updateArr, $hiddenUpdate);
        }
        $updateValue = implode(',', $updateArr);
        $modify_date = date("Y-m-d G:i:s");
        $query = "UPDATE category SET {$updateValue}, modify_date='{$modify_date}' WHERE id={$categoryID}";
        if (false === ($dbResult = $this->_dbh->query($query))) {
            return false;
        }
        return true;
    }

    /*
     *  @params - $catgegoryIDs [array]
     */
    public function ArrangeCategory($catgegoryIDs, $offset, $limit)
    {
        if (0 === count($catgegoryIDs) || !isset($offset) || !isset($limit)) {
            return false;
        }
        if ($limit != count($catgegoryIDs)) {
            return false;
        }
        $row = $this->GetFieldByKeyValue('count(id)', 'category');
        if ($row[0] < ($offset + $limit)) {
            return false;
        }
        
        // check category ids
        $idString = implode(',', $catgegoryIDs);
        $query = "SELECT count(id) FROM category WHERE id IN ({$idString})";
        if (false === ($dbResult = $this->_dbh->query($query))) {
            return false;
        }
        $row = $dbResult->fetch();
        if ($row[0] != count($catgegoryIDs)) {
            return false;
        }

        // get start order number
        $query = "SELECT order_number FROM category ORDER BY order_number ASC LIMIT 1 OFFSET {$offset}";
        if (false === ($dbResult = $this->_dbh->query($query))) {
            return false;
        }
        $row = $dbResult->fetch();
        $fillOrderStart = $row['order_number'];

        // expect fill order number
        $fillOrderNumber = array();
        $order = $fillOrderStart;
        for ($i = 0; $i < $limit; $i++) {
            array_push($fillOrderNumber, (int)$order);
            $order++;
        }

        // get not changed order number
        $idString = implode(',', $catgegoryIDs);
        $query = "SELECT order_number FROM category WHERE id NOT IN ({$idString})";
        if (false === ($dbResult = $this->_dbh->query($query))) {
            return false;
        }
        $notChangedOrderNumber = array();
        while($row = $dbResult->fetch()) {
            array_push($notChangedOrderNumber, (int)$row['order_number']);
		}

        // check order confict
        foreach ($fillOrderNumber as $fill) {
            foreach ($notChangedOrderNumber as $notChanged) {
                if ($fill === $notChanged) {
                    return false;
                }
            }
        }

        // update order number for changed
        $order = $fillOrderStart;
        foreach ($catgegoryIDs as $id) {
            $query = "UPDATE category SET order_number={$order} WHERE id={$id}";
            if (false === ($dbResult = $this->_dbh->query($query))) {
                return false;
            }
            $order++;
        }

        return true;
    }

    /* 
     *  @params - $categoryID [string]
     *            $itemIDs [array]
     */
    public function AddCategoryItem($categoryID, $itemIDs)
    {
        if (empty($categoryID) || (0 === count($itemIDs))) {
            return false;
        }

        // check category id
        if (false === $this->GetCategory($categoryID)) {
            return false;
        }

        // get order number
        if (false === ($row = $this->GetFieldByKeyValue('max(order_number)', 'category_items', 'category_id', $categoryID))) {
            return false;
        }
        $newOrderNumber = $row[0] + 1;

        // insert items to category
        $failCount = 0;
        foreach ($itemIDs as $item) {
            // check item id
            $data = $this->ConvertItemID($item);
            if (false === $this->IsCategoryItemExist($data['type'], $data['id'])) {
                $failCount++;
                continue;
            }

            // get item type and id
            $data = $this->ConvertItemID($item);
            $type = $data['type'];
            $id = $data['id'];

            // insert to category_item table
            if ('album' === $type) {
                $query = "INSERT INTO category_items (category_id, type, order_number, album_id) VALUES ({$categoryID}, '{$type}', {$newOrderNumber}, {$id})";
            } elseif ('tag' === $type) {
                $query = "INSERT INTO category_items (category_id, type, order_number, tag_id) VALUES ({$categoryID}, '{$type}', {$newOrderNumber}, {$id})";
            } elseif ('smart' === $type) {
                $query = "INSERT INTO category_items (category_id, type, order_number, smart_id) VALUES ({$categoryID}, '{$type}', {$newOrderNumber}, '{$id}')";
            }

            $dbResult = $this->_dbh->prepare($query);
            if (false === $dbResult->execute()) {
                $failCount++;
                continue;
            }

            $newOrderNumber++;
        }
        if ($failCount === count($itemIDs)) {
            return false;
        }

        // update modify date in category table
        $modify_date = date("Y-m-d G:i:s");
        $query = "UPDATE category SET modify_date='{$modify_date}' WHERE id={$categoryID}";
        $dbResult = $this->_dbh->prepare($query);
        if (false === $dbResult->execute()) {
            return false;
        }

        return true;
    }

    public function RemoveCategoryItem($categoryID, $itemIDs)
    {
        if (empty($categoryID) || (0 === count($itemIDs))) {
            return false;
        }

        // check category id
        if (false === $this->GetCategory($categoryID)) {
            return false;
        }

        foreach ($itemIDs as $itemID) {
            $data = $this->ConvertItemID($itemID);
            $type = $data['type'];
            $id = $data['id'];
            $query = "DELETE FROM category_items WHERE category_id={$categoryID} AND {$type}_id='{$id}'";
            if (false === ($dbResult = $this->_dbh->query($query))) {
                return false;
            }
        }

        return true;
    }

    public function ArrangeCategoryItem($categoryID, $itemIDs, $offset, $limit)
    {
        if (!isset($categoryID) || 0 === count($itemIDs) || !isset($offset) || !isset($limit)) {
            return false;
        }
        if ($limit != count($itemIDs)) {
            return false;
        }

        // check category id
        if (false === $this->GetCategory($categoryID)) {
            return false;
        }
        // check item id
        if (false === $this->IsItemsBelongToCateogyID($categoryID, $itemIDs)) {
            return false;
        }
        $row = $this->GetFieldByKeyValue('count(id)', 'category_items', 'category_id', $categoryID);
        if ($row[0] < ($offset + $limit)) {
            return false;
        }

        // get start order number
        $query = "SELECT order_number FROM category_items WHERE category_id={$categoryID} ORDER BY order_number ASC LIMIT 1 OFFSET {$offset}";
        if (false === $dbResult = $this->_dbh->query($query)) {
            return false;
        }
        $row = $dbResult->fetch();
        $fillOrderStart = $row['order_number'];

        // expect fill order number
        $fillOrderNumber = array();
        $order = $fillOrderStart;
        for ($i = 0; $i < $limit; $i++) {
            array_push($fillOrderNumber, $order);
            $order++;
        }

        // get not changed order number
        $albumIDs = $smartIDs = $tagIDs = array();
        foreach ($itemIDs as $item) {
            $data = $this->ConvertItemID($item);
            $type = $data['type'];
            $id = $data['id'];
            if ('album' === $type) {
                array_push($albumIDs, $id);
            } elseif ('tag' === $type) {
                 array_push($tagIDs, $id);
            } elseif ('smart' === $type) {
                 array_push($smartIDs, $id);
            }
        }
        $idCondition = array();
        if (0 != count($albumIDs)) {
            $albumString = '\''.implode('\',\'', $albumIDs).'\'';
            $albumCondition = "(album_id NOT IN ({$albumString}) OR album_id is null)";
            array_push($idCondition, $albumCondition);
        }
        if (0 != count($tagIDs)) {
            $tagString = '\''.implode('\',\'', $tagIDs).'\'';
            $tagCondition = "(tag_id NOT IN ({$tagString}) OR tag_id is null)";
            array_push($idCondition, $tagCondition);
        }
        if (0 != count($smartIDs)) {
            $smartString = '\''.implode('\',\'', $smartIDs).'\'';
            $smartCondition = "(smart_id NOT IN ({$smartString}) OR smart_id is null)";
            array_push($idCondition, $smartCondition);
        }
        $conditionString = implode(' AND ', $idCondition);
        $query = "SELECT order_number FROM category_items WHERE category_id={$categoryID} AND {$conditionString}";
        if (false === $dbResult = $this->_dbh->query($query)) {
            return false;
        }
        $notChangedOrderNumber = array();
        while($row = $dbResult->fetch()) {
            array_push($notChangedOrderNumber, $row['order_number']);
		}

        // check order confict
        foreach ($fillOrderNumber as $fill) {
            foreach ($notChangedOrderNumber as $notChanged) {
                if ($fill === $notChanged) {
                    return false;
                }
            }
        }

        // update order number for changed
        $order = $fillOrderStart;
        foreach ($itemIDs as $itemID) {
            $data = $this->ConvertItemID($itemID);
            $type = $data['type'];
            $id = $data['id'];
            $query = "UPDATE category_items SET order_number={$order} WHERE category_id={$categoryID} AND {$type}_id='{$id}'";
            if (false === ($dbResult = $this->_dbh->query($query))) {
                return false;
            }
            $order++;
        }
              
        return true;
    }

    public function ListCategoryItem($categoryID, $offset, $limit)
    {
        if (empty($categoryID) || !isset($offset) || !isset($limit)) {
            return false;
        }

        // check category id
        if (false === $this->GetCategory($categoryID)) {
            return false;
        }

        $limitCond = (0 > (int)$limit) ? '' : "LIMIT $limit";
        $query = "SELECT * FROM category_items WHERE category_id={$categoryID} ORDER BY order_number ASC {$limitCond} OFFSET $offset";
        if (false === ($dbResult = $this->_dbh->query($query))) {
            return false;
        }
        $result = array();
        while($row = $dbResult->fetch()) {
            $type = $row['type'];
            if ('album' === $type) {
                $id = $row['album_id'];
            } elseif ('tag' === $type) {
                $id = $row['tag_id'];
            } elseif ('smart' === $type) {
                $id = $row['smart_id'];
            }
            // if item id not exist, delete it
            if (false === $this->IsCategoryItemExist($type, $id)) {
                $query = "DELETE FROM category_items WHERE category_id={$categoryID} AND {$type}_id='{$id}'";
                if (false === ($dbResult = $this->_dbh->query($query))) {
                    return false;
                }
                continue;
            }
            array_push($result, $row);
		}

        return $result;
    }



	/*!
	 * dump photo_config scheme from db
	 *
	 * \return array with data from scheme 'photo_config'
	 */
	private function GetConfigsFromDB()
	{
		$query = 'SELECT * FROM photo_config';
		$dbResult = $this->_dbh->query($query);
		$result = $dbResult->fetchAll();
		if (false === $result) {
			return array();
		}
		return $result;
	}
	/*!
	 * Get accessible album list from db
	 *
	 * \param $userID logined username
	 * \param $noRightCheck true for get all albums
	 * \return array with data from scheme 'photo_share'
	 */
	private function GetAlbumsFromDB($userID, $noRightCheck)
	{
		$sqlParam = array();
		$sqlParamCount = 0;

		/* prepare permission condition */
		$permConditionClause = '';
		if (!$noRightCheck) {
			$permConditionClause = "public='t' OR password <> ''";
			if (!empty($userID)) {
				$permConditionClause .= ' OR shareid IN (SELECT shareid FROM '.PHOTO_ACCESS_RIGHT_TABLE.' WHERE userid=?)';
				$sqlParam[$sqlParamCount++] = $userID;
			}
		}

		/* query first level albums */
		$whereClause = "WHERE is_subdir='f'";
		if (strlen($permConditionClause)) {
			/* sql param already append to $sqlParam */
			$whereClause .= " AND ({$permConditionClause})";
		}
		$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$rootAlbums = $dbResult->fetchAll();
		if (false === $rootAlbums) {
			return array();
		}

		/* query second level albums accroding to accessible first level albums */
		$secondLevelAlbums = array();
		$whereClause = "WHERE is_subdir='t' AND sharename NOT LIKE '%/%/%'";
		if (strlen($permConditionClause)) {
			/* sql param already append to $sqlParam */
			$whereClause .= " AND ({$permConditionClause})";
		}
		$whereClause .=  " AND sharename LIKE ? {$this->escapeStr}";
		$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		foreach ($rootAlbums as $key => $item) {
			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (csSYNOPhotoMisc::isSkipPhotoDev(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$item['sharename'], $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])) {
				unset($rootAlbums[$key]);
				continue;
			}

			$item['sharename'] = self::EscapeLikeParam($item['sharename']);
			$sqlParam[$sqlParamCount] = "{$item['sharename']}/%";
			$dbResult->execute($sqlParam);
			$result = $dbResult->fetchAll();
			if (false !== $result) {
				// skip photo in remote mount (cifs) or read-only mount (iso9660)
				foreach ($result as $key => $item) {
					if (csSYNOPhotoMisc::isSkipPhotoDev(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$item['sharename'], $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])) {
						unset($result[$key]);
					}
				}
				$secondLevelAlbums = array_merge($secondLevelAlbums, $result);
			}
		}

		$result = array_merge($rootAlbums, $secondLevelAlbums);

		$query = "SELECT * FROM photo_share where password <> '' and is_subdir = 't' AND sharename NOT LIKE '%/%/%' ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute();
		$passwordAlbums = $dbResult->fetchAll();
		foreach ($passwordAlbums as $item) {
			if (!in_array($item, $result)) {
				$result[] = $item;
			}
		}
		return $result;
	}

	/*!
	 * Get accessible album list from db for a group id
	 *
	 * \param $groupID logined user's group
	 * \param $noRightCheck true for get all albums
	 * \return array with data from scheme 'photo_share'
	 */
	private function GetAlbumsFromDBForGroup($groupID, $noRightCheck)
	{
		$sqlParam = array();
		$sqlParamCount = 0;

		/* prepare permission condition */
		$permConditionClause = '';
		if (!$noRightCheck) {
			$permConditionClause = "public='t' OR password <> ''";
			if (!empty($groupID)) {
				$permConditionClause .= ' OR shareid IN (SELECT shareid FROM '.PHOTO_GROUP_PERMISSION_TABLE.' WHERE groupid=? AND permission & 1 <> 0)';
				$sqlParam[$sqlParamCount++] = $groupID;
			}
		}

		/* query first level albums */
		$whereClause = "WHERE is_subdir='f' AND sharename <> '/'";
		if (strlen($permConditionClause)) {
			/* sql param already append to $sqlParam */
			$whereClause .= " AND ({$permConditionClause})";
		}
		$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$rootAlbums = $dbResult->fetchAll();
		if (false === $rootAlbums) {
			return array();
		}

		/* query second level albums accroding to accessible first level albums */
		$secondLevelAlbums = array();
		$whereClause = "WHERE is_subdir='t' AND sharename NOT LIKE '%/%/%'";
		if (strlen($permConditionClause)) {
			/* sql param already append to $sqlParam */
			$whereClause .= " AND ({$permConditionClause})";
		}
		$whereClause .=  " AND sharename LIKE ? {$this->escapeStr}";
		$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		foreach ($rootAlbums as $key => $item) {
			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (csSYNOPhotoMisc::isSkipPhotoDev(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$item['sharename'], $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])) {
				unset($rootAlbums[$key]);
				continue;
			}

			$item['sharename'] = self::EscapeLikeParam($item['sharename']);
			$sqlParam[$sqlParamCount] = "{$item['sharename']}/%";
			$dbResult->execute($sqlParam);
			$result = $dbResult->fetchAll();
			if (false !== $result) {
				// skip photo in remote mount (cifs) or read-only mount (iso9660)
				foreach ($result as $key => $item) {
					if (csSYNOPhotoMisc::isSkipPhotoDev(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$item['sharename'], $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])) {
						unset($result[$key]);
					}
				}
				$secondLevelAlbums = array_merge($secondLevelAlbums, $result);
			}
		}

		$result = array_merge($rootAlbums, $secondLevelAlbums);

		$query = "SELECT * FROM photo_share where password <> '' and is_subdir = 't' AND sharename NOT LIKE '%/%/%' ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute();
		$passwordAlbums = $dbResult->fetchAll();
		foreach ($passwordAlbums as $item) {
			if (!in_array($item, $result)) {
				$result[] = $item;
			}
		}
		return $result;
	}
	/*!
	 * Get uploadable level 1,2 albums for non-admin user
	 *
	 * \param $userID non-admin user's userID
	 * \return array with uploadalbe album
	 */
	private function GetUploadableAlbums($userID)
	{
		$result = array();
		if (empty($userID)) {
			return $result;
		}

		$query = "Select sharename from photo_share where shareid in (select shareid from " . PHOTO_UPLOAD_RIGHT_TABLE . " where userid = ".$userID.") AND sharename NOT LIKE '%/%/%' order by sharename asc";
		$db_result = $this->_dbh->query($query);

		while($row = $db_result->fetch()) {
			$result[$row[0]] = 1;
		}

		return $result;
	}
	/*!
	 * Get uploadable level 1,2 albums for groups
	 *
	 * \param $groupID user's groupID
	 * \return array with uploadalbe album
	 */
	private function GetUploadableAlbumsForGroup($groupID)
	{
		$result = array();
		if (empty($groupID)) {
			return $result;
		}

		$query = "SELECT sharename FROM photo_share WHERE shareid IN (SELECT shareid FROM " . PHOTO_GROUP_PERMISSION_TABLE . " WHERE groupid = " . $groupID . " AND permission & 2 <> 0) AND sharename NOT LIKE '%/%/%' ORDER BY sharename ASC";
		$db_result = $this->_dbh->query($query);

		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$result[$row[0]] = 1;
		}
		return $result;
	}
	/*!
	 * Get manageable level 1,2 albums for non-admin user
	 *
	 * \param $userID non-admin user's userID
	 * \return array with manageable album
	 */
	private function GetManageableAlbums($userID)
	{
		$result = array();
		if (empty($userID)) {
			return $result;
		}

		$query = "SELECT sharename FROM photo_share WHERE shareid IN (SELECT shareid FROM " . PHOTO_MANAGE_RIGHT_TABLE . " WHERE userid = ".$userID.") AND sharename NOT LIKE '%/%/%' ORDER BY sharename ASC";
		$db_result = $this->_dbh->query($query);

		while ($row = $db_result->fetch()) {
			$result[$row[0]] = 1;
		}

		return $result;
	}
	/*!
	 * Get manageable level 1,2 albums for group
	 *
	 * \param $groupID user's groupID
	 * \return array with manageable album
	 */
	private function GetManageableAlbumsForGroup($groupID)
	{
		$result = array();
		if (empty($groupID)) {
			return $result;
		}

		$query = "SELECT sharename FROM photo_share WHERE shareid IN (SELECT shareid FROM " . PHOTO_GROUP_PERMISSION_TABLE . " WHERE groupid = " . $groupID . " AND permission & 4 <> 0) AND sharename NOT LIKE '%/%/%' ORDER BY sharename ASC";
		$db_result = $this->_dbh->query($query);

		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$result[$row[0]] = 1;
		}

		return $result;
	}
	/*!
	 * Cache system config files in session data
	 */
	function SetSessionSystemConfigsFromFile()
	{
		$requiredConfKeys = 'language|userHomeEnable|unique|'
							.'supplang|eventsmtp|eventmail1|eventmail2|ddns_update|ddns_select|albumdefpublic|enable_demomode';
		$pkgRequireKey = 'runpersonalphotostation|albumdefpublic|external_host_ip|external_port_photo_https|external_port_photo_http|runfacerecognition';
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg'] = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, $requiredConfKeys);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg'] = csSYNOPhotoMisc::GetConfigFile(SYNO_DEF_CNF_FILE, $requiredConfKeys);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg'] = csSYNOPhotoMisc::GetConfigFile(SYNO_PKG_CNF_FILE, $pkgRequireKey);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['dsmCfg']['buildnumber'] = csSYNOPhotoMisc::GetDsmVersion();
		if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
			$command = '/usr/syno/bin/synogetkeyvalue '.escapeshellarg(SYNO_PERSONAL_CNF_FILE).' runpersonalphotostation';
			$ret = @exec($command);
			$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation'] = $ret;

			$command = '/usr/syno/bin/synogetkeyvalue '.escapeshellarg(SYNO_PERSONAL_CNF_FILE).' albumdefpublic';
			$ret = @exec($command);
			$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['albumdefpublic'] = $ret;
		}
	}
	/*!
	 * Cache album/photo sort type/order in session data
	 * \param $sortType sort type
	 *	- 1: by taken time
	 *	- 2: by create time
	 *	- default: by name
	 * \param $sortOrder sort order
	 *	- 1: descending  sort
	 *	- default: ascending sort
	 */
	function SetSessionSortMethod($sortType, $sortOrder)
	{
		$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_by_preference'] = false;
		switch ($sortType) {
			case '1':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'timetaken';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video'] = "date";
				break;
			case '2':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'create_time';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video'] = "date";
				break;
			case '3':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_by_preference'] = true;
				break;
			default:
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'name';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video'] = "path";
		}

		switch ($sortOrder) {
			case '1':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] = 'desc';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_front'] = '>';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_back'] = '<';
				break;
			default:
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] = 'asc';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_front'] = '<';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_back'] = '>';
		}
	}
	/*!
	 * cache frequent access data
	 *
	 * \param $isForced force to refresh cache or not
	 */
	function SetSessionCache($isForced = false)
	{
		/*
		 * accessible_album, accessible_subdir: accessible level 1,2 albums.
		 * uploadable_album: level 1,2 uploadable albums when login user is not admin
		 * accessed_albums: set by AddHitTimes(), accessed albums
		 * photoNum_cache[albumName]: set by GetNumberOfPhotos(), the number of accessed albums' photos
		 * list_cache[albumName]: the browsed thumb list (including subdir and photos)
		 * list_video_cache[albumName]: the video's path of the $albumName album
		 * **function controlled** photo_config[key]=value: set by GetConfigsFromDB() in GetConfig() on demand, photo_config scheme from DB
		 * **reset each load** system_config[key]=value: set by SetSessionSystemConfigsFromFile(), from /etc[.default]/synoinfo.conf
		 */

		/* ensure every cache container is exist */
		$sessionInitField = array('accessible_album', 'accessible_subdir', 'photo_config', 'list_cache', 'manageable_album',
								  'system_config', 'accessed_albums', 'photoNum_cache',
								  'list_video_cache', 'uploadable_album', 'commentable_album', 'use_dsm_account', 'albumQueryCondition');
		foreach ($sessionInitField as $field) {
			if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER][$field])) {
				$_SESSION[SYNOPHOTO_ADMIN_USER][$field] = array();
			}
		}

		/* compatible for desktop edition */
		if (!count($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']) || !is_array($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][array_rand($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'])])) {
			$isForced = true;
		}

		/* cache still fresh */
		if (!$isForced && isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp'] > (time() - $this->CACHE_LIFETIME)) {
			return;
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition'] = array();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'] = csSYNOPhotoMisc::getSkipPhotoDev();

		/* flush non-function controlled cache */
		$sessionStaleField = array('accessible_album', 'accessible_subdir', 'photoNum_cache', 'list_cache', 'list_video_cache', 'uploadable_album', 'commentable_album', 'manageable_album');
		foreach ($sessionStaleField as $field) {
			$_SESSION[SYNOPHOTO_ADMIN_USER][$field] = array();
		}

		/* cache accessible albums/sub-albums */
		$userID = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) ? $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] : '';
		$isAdmin = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
		$albums = $this->GetAlbumsFromDB($userID, $isAdmin);

		$groups = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid']) ? explode(',', $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid']) : array();
		foreach ($groups as $groupID) {
			$albums = array_merge($albums, $this->GetAlbumsFromDBForGroup($groupID, $isAdmin));
		}

		foreach ($albums as $item) {
			$item['public'] = PHOTO_DB_ConvertBool($item['public']);
			$item['is_subdir'] = PHOTO_DB_ConvertBool($item['is_subdir']);
			if ('t' == $item['is_subdir']) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$item['sharename']] = $item;
				if ($isAdmin) {
					$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$item['sharename']] = $item['password'];
				}
			} else {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$item['sharename']] = $item;
				if ($isAdmin) {
					$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$item['sharename']] = $item['password'];
				}
			}
		}

		/* cache commentable level 1 albums */
		foreach ($albums as $item) {
			if (('f' == $item['is_subdir'] || false == $item['is_subdir']) && ('t' == $item['comment'] || true === $item['comment'])) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['commentable_album'][$item['sharename']] = true;
			}
		}

		/* cache uploadable albums */
		if (!$isAdmin && !empty($userID)) {
			$uploadableAlbums = $this->GetUploadableAlbums($userID);

			$groups = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid']) ? explode(',', $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid']) : array();
			foreach ($groups as $groupID) {
				$uploadableAlbums = $uploadableAlbums + $this->GetUploadableAlbumsForGroup($groupID);
			}

			foreach (array_keys($uploadableAlbums) as $albumName) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album'][$albumName] = 1;
			}
		}

		/* cache manageable albums */
		if (!$isAdmin && !empty($userID)) {
			$manageableAlbums = $this->GetManageableAlbums($userID);

			$groups = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid']) ? explode(',', $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid']) : array();
			foreach ($groups as $groupID) {
				$manageableAlbums = $manageableAlbums + $this->GetManageableAlbumsForGroup($groupID);
			}

			foreach (array_keys($manageableAlbums) as $albumName) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['manageable_album'][$albumName] = 1;
			}
		}

		/* set sort property */
		if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'])){
			$this->SetSessionSortMethod($this->GetConfig('album', 'thumb_sort_type'),
									$this->GetConfig('album', 'thumb_sort_order'));
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp'] = time();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] = ($this->GetConfig('global', 'account_system') == 1) ? true : false;
	}
	/*!
	 * Check user exist in db or not
	 *
	 * \param $userId username
	 * \return true for exist
	 */
	function CheckUserExist($userId)
	{
		$query = 'SELECT count(*) FROM photo_user WHERE username=?';
		$sqlParam = array($userId);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$row = $dbResult->fetch();
		return(0 < $row[0]);
	}
	/*!
	 * validate username and password, and then return user info
	 *
	 * \param $username username
	 * \param $password password
	 * \return false when validate failed, otherwise data from scheme 'photo_user'
	 */
	function GetValidateUserInfo($username, $password)
	{
		$query = 'SELECT * FROM photo_user WHERE lower(username)=? AND password=?';
		$sqlParam = array(strtolower($username), md5(addslashes($password)));
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$userInfo = $dbResult->fetch();
		return $userInfo; // false when no matched
	}
	/*!
	 * Validate admin password
	 *
	 * \param $password password
	 * \return the password passed or not
	 */
	function ValidateAdminPassword($password, $user)
	{
		$admin_user = ('root' == $user)? 'admin':$user;
		@system("/usr/syno/bin/synoauth ".escapeshellarg($admin_user)." ".escapeshellarg($_POST['passwd']), $retval);
		return !$retval;
	}
	/*!
	 * Get config value from scheme 'photo_config'
	 *
	 * \param $moduleName module/section name
	 * \param $configKey key name
	 * \return config value
	 */
	function GetConfig($moduleName, $configKey)
	{
		/* cache db scheme on demand */
		if (0 == count($_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'])) {
			$configs = $this->GetConfigsFromDB();
			foreach ($configs as $item) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'][$item['module_name']][$item['config_key']] = $item['config_value'];
			}
		}
		$item = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'];
		if (isSet($item[$moduleName]) && ($item = $item[$moduleName]) && isSet($item[$configKey])) {
			return $item[$configKey];
		}
		return NULL;
	}
	/*!
	 * Get # of comments for specified photo
	 *
	 * \param $photoId photo id in db
	 * \return # of comments
	 */
	function GetNumberOfComments($photoId)
	{
		$query = 'SELECT count(*) FROM photo_comment WHERE photo_id=?';
		$sqlParam = array($photoId);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$row = $dbResult->fetch();
		return $row[0];
	}
	/*!
	 * Get comments for specified photo
	 *
	 * \param $photoId photo id in db
	 * \param $offset # of comments to skip
	 * \param $limit # of comments to get
	 * \return array with data from scheme 'photo_comment'
	 */
	function GetPhotoComments($photoId, $offset = 0, $limit = 'ALL')
	{
		if ('ALL' == $limit && 'sqlite' == $this->db_type) {
			$limit = -1;//for sqlite limit < 0 is equal to no limit
		}

		$query = "SELECT * FROM photo_comment WHERE photo_id=? ORDER BY date desc LIMIT {$limit} OFFSET {$offset}";
		$sqlParam = array($photoId);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$result = $dbResult->fetchAll();
		if (false === $result) {
			return array();
		}
		return $result;
	}
	/*!
	 * Get comments for specified video
	 *
	 * \param $videoPath video file full path
	 * \param $offset # of comments to skip
	 * \param $limit # of comments to get
	 * \return array with data from scheme 'photo_comment'
	 */
	function GetVideoComments($videoPath, $offset = 0, $limit = 'ALL')
	{
		if ('ALL' == $limit && 'sqlite' == $this->db_type) {
			$limit = -1;//for sqlite limit < 0 is equal to no limit
		}

		$query = "SELECT * FROM video_comment WHERE path=? ORDER BY date desc LIMIT {$limit} OFFSET {$offset}";
		$dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$result = $dbResult->fetchAll();
		if (false === $result) {
			return array();
		}
		return $result;
	}
	/*!
	 * Add comment for the photo
	 *
	 * \param $id photo image id
	 * \param $name user name who adding the comment
	 * \param $email email address of whom adding the comment
	 * \param $comment the comment
	 * \return true for adding success
	 */
	function AddPhotoComment($id, $name, $mail, $comment)
	{
		$name = $this->EscapeParam($name);
		$mail = $this->EscapeParam($mail);
		$comment = $this->EscapeParam($comment);

		$query = "Insert into photo_comment (photo_id, name, email, comment, date) ";
		$query = $query."Values ($id, '$name', '$mail', '$comment', '".date('Y-m-d H:i:s')."')";
		$db_result = $this->_dbh->query($query);

		return true;

	}
	/*!
	 * Add comment for the video
	 *
	 * \param $path video path
	 * \param $name user name who adding the comment
	 * \param $email email address of whom adding the comment
	 * \param $comment the comment
	 * \return true for adding success
	 */
	function AddVideoComment($path, $name, $mail, $comment)
	{
		$path = $this->EscapeParam($path);
		$name = $this->EscapeParam($name);
		$mail = $this->EscapeParam($mail);
		$comment = $this->EscapeParam($comment);

		$dPath = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$query = "Insert into video_comment (path, name, email, comment, date) ";
		$query = $query."Values ('$dPath', '$name', '$mail', '$comment', '".date('Y-m-d H:i:s')."')";

		$db_result = $this->_dbh->query($query);

		return true;
	}
	function DeleteComment($type, $id)
	{
		$table = '';
		if ($type == 1) {
			$table = 'photo_comment';
		} else if ($type == 2) {
			$table = 'video_comment';
		}
		$query = "Delete from $table where id =?";
		$sqlParam = array($id);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		return true;
	}
	/*!
	 * Get photo info for specified path
	 *
	 * \param $photoPath photo full path
	 * \return array with data from scheme 'photo_image'
	 */
	function GetPhotoInfo($photoPath)
	{
		$dPath = substr($photoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		/* search db cacher */
		if (is_array($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID])) {
			foreach($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID] as $cacheTuple) {
				if (!is_array($cacheTuple[DBCACHER_TUPLE_DATA])) {
					continue;
				}
				foreach ($cacheTuple[DBCACHER_TUPLE_DATA] as $dbTuple) {
					if ($dPath == $dbTuple['path']) {
						$dbTuple['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$dbTuple['path'];
						// extra info for sorting
						$dbTuple['timetaken'] = $dbTuple['timetaken'];
						$dbTuple['createdate'] = $dbTuple['create_time'];
						return $dbTuple;
					}
				}
			}
		}

		/* not found in cache */
		$query = "SELECT * FROM photo_image WHERE path=?";
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		if ($row = $dbResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
            // extra info for sorting
            $row['timetaken'] = $row['timetaken'];
            $row['createdate'] = $row['create_time'];
		}
		return $row;
	}
	/*!
	 * Get video info for specified path
	 *
	 * \param $videoPath video full path
	 * \return array with data from scheme 'video' of mediaserver DB
	 */
	function GetVideoInfo($videoPath)
	{
		$dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		/* search db cacher */
		if (is_array($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID])) {
			foreach($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID] as $cacheTuple) {
				if (!is_array($cacheTuple[DBCACHER_TUPLE_DATA])) {
					continue;
				}
				foreach ($cacheTuple[DBCACHER_TUPLE_DATA] as $dbTuple) {
					if ($dPath == $dbTuple['path']) {
						$dbTuple['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$dbTuple['path'];
						// extra info for sorting
						$dbTuple['timetaken'] = $dbTuple['mdate'];
						$dbTuple['createdate'] = $dbTuple['date'];
						$dbTuple['name'] = basename($dbTuple['path']);
						return $dbTuple;
					}
				}
			}
		}

		/* not found in cache */
		$query = "SELECT * FROM video WHERE path=?";
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		if ($row = $dbResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
            // extra info for sorting
            $row['timetaken'] = $row['mdate'];
            $row['createdate'] = $row['date'];
            $row['name'] = basename($row['path']);
		}
		return $row;
	}
	/*!
	 * Get video convert info for specified path
	 *
	 * \param $videoPath video full path
	 * \return array with data from scheme 'video' of mediaserver DB
	 */
	function GetVideoConvertInfo($videoPath)
	{
		$dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		/* search db cacher */
		if (is_array($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID])) {
			foreach($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID] as $cacheTuple) {
				if (!is_array($cacheTuple[DBCACHER_TUPLE_DATA])) {
					continue;
				}
				foreach ($cacheTuple[DBCACHER_TUPLE_DATA] as $dbTuple) {
					if ($dPath == $dbTuple['path']) {
						$dbTuple['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$dbTuple['path'];
						return $dbTuple;
					}
				}
			}
		}

		/* not found in cache */
		$query = "SELECT * FROM video_convert WHERE video_path=?";
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
        $rows = array();
		while ($row = $dbResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
            array_push($rows, $row);
		}
		return $rows;
	}

	/*!
	 * Get video's customerized  title and description for specified path
	 *
	 * \param $videoPath video full path
	 * \return array with customzeized title and description
	 */
	function GetVideoCustomizedTitleDescription($videoPath)
	{
		$result['title']='';
		$result['description']='';
		$query = "SELECT title, description FROM video_desc WHERE path=?";
		$dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		if ($row = $dbResult->fetch()) {
			$result['title']=$row[0];
			$result['description']=$row[1];
		}

		return $result;
	}
	/*!
	 * Prepare album photos DB Cache for future use
	 *
	 * \param $albumName alubm name
	 * \param $offset # of photos to skip
	 * \param $length # of photos to prepare
	 * \return prepared db data from scheme 'photo_image'
	 */
	function PrepareAlbumPhotos($albumName, $offset, $limit)
	{
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT * FROM photo_image WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		return $this->_dbCacher->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Prepare album videos DB Cache for future use
	 *
	 * \param $albumName alubm name
	 * \param $offset # of videos to skip
	 * \param $length # of videos to prepare
	 * \return prepared db data from scheme 'video' of mediaserver DB
	 */
	function PrepareAlbumVideos($albumName, $offset, $limit)
	{
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT * FROM video WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		return $this->_dbCacherMedia->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Prepare searched photos DB Cache for future use
	 *
	 * \param $cacheToken search token
	 * \param $offset # of photos to skip
	 * \param $length # of photos to prepare
	 * \return prepared db data from scheme 'photo_image'
	 */
	function PrepareSearchPhotos($statement, $param, $offset, $limit)
	{
		$query = $statement;
		$sqlParam = $param;
		return $this->_dbCacher->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Prepare searched photos DB Cache for future use
	 *
	 * \param $cacheToken search token
	 * \param $offset # of photos to skip
	 * \param $length # of photos to prepare
	 * \return prepared db data from scheme 'photo_image'
	 */
	function PrepareSearchVideos($statement, $param, $offset, $limit)
	{
		$query = $statement;
		$sqlParam = $param;
		return $this->_dbCacherMedia->CacheQuery($query, $sqlParam, $offset, $limit);
	}

	/*!
	 * Get photo, video full path list for specified album
	 *
     * \param $albumName alubm name
     * \param $offset
     * \param $limit
     * \param $sort_by - filename, takendate, createdate
     * \param $sort_direction - asc, desc
     * \return
     *   - list: array with full path list
     *   - totalCount: total count of photo and video
	 */
    function GetAlbumPhotoVideoList($albumName, $offset, $limit, $sort_by, $sort_direction, $removeVideo = false, $removePhoto = false)
    {
        if (!in_array($sort_by, array('filename', 'takendate', 'createdate'))) {
            return false;
        }
        if (!in_array($sort_direction, array('asc', 'desc'))) {
            return false;
        }

        $list['list'] = array();
        $list['totalCount'] = 0;
        if (0 === $limit) {
            return $list;
        }
        $blSelectAll = false;
        if (0 === $offset && -1 === $limit) {
            $blSelectAll = true;
        }
        $sqlParam = array();
        $photoQuery = $videoQuery = '';
        if ('/' === $albumName) {
            $albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH);
        } else {
            $albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}/");
        }
        if (!$removePhoto) {
            $photoQuery = "SELECT path as filename, timetaken as takendate, create_time as createdate, 'photo' as type FROM photo_image ";
            $photoQuery .= "WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr}";
            array_push($sqlParam, "{$albumRealPath}%");
            array_push($sqlParam, "{$albumRealPath}%/%");
        }
        if (!$removeVideo) {
            $videoQuery = "SELECT path as filename, mdate as takendate, date as createdate, 'video' as type FROM video ";
            $videoQuery .= "WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr}";
            array_push($sqlParam, "{$albumRealPath}%");
            array_push($sqlParam, "{$albumRealPath}%/%");
        }
        if ('root' === SYNOPHOTO_ADMIN_USER) {
            $limitCond = (0 > (int)$limit) ? '' : "LIMIT {$limit}";
        } else {
            $limitCond = (0 > (int)$limit) ? 'LIMIT -1' : "LIMIT {$limit}";
        }
        if ('' !== $photoQuery && '' !== $videoQuery) {
            $query = "$photoQuery UNION $videoQuery ORDER BY $sort_by $sort_direction {$limitCond} OFFSET $offset";
            $queryCount = "SELECT COUNT(*) FROM ($photoQuery UNION $videoQuery) AS totalCount";
        } elseif ('' !== $videoQuery && '' === $photoQuery) {
            $query = "$videoQuery ORDER BY $sort_by $sort_direction {$limitCond} OFFSET $offset";
            $queryCount = "SELECT COUNT(*) FROM ($videoQuery) AS totalCount";
		} elseif ('' !== $photoQuery && '' === $videoQuery) {
            $query = "$photoQuery ORDER BY $sort_by $sort_direction {$limitCond} OFFSET $offset";
            $queryCount = "SELECT COUNT(*) FROM ($photoQuery) AS totalCount";
        } else {
            return $list;
        }
        // sql
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
        if (false === $result = $dbResult->fetchAll()) {
            return false;
        }
        foreach ($result as $row) {
            if ('photo' === $row['type']) {
                $type = SYNOPHOTO_ITEM_TYPE_PHOTO;
            } else {
                $type = SYNOPHOTO_ITEM_TYPE_VIDEO;
            }
            $fullPath = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
            $list['list'][$fullPath] = $type;
        }
        // total
        if (!$blSelectAll) {
            $dbResult = $this->_dbh->prepare($queryCount);
            $dbResult->execute($sqlParam);
            $row = $dbResult->fetch();
            $list['totalCount'] = (int)$row[0];
        } else {
            $list['totalCount'] = count($list['list']);
        }
        return $list;
    }

	/*!
	 * Get photo name list for specified album
	 *
	 * \param $albumName alubm name
	 * \return array with name list
	 */
	function GetAlbumPhotoList($albumName)
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName];
		}
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT name, id, title FROM photo_image WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		$list = array();
		$idList = array();
		while (false !== ($row = $dbResult->fetch())) {
			$list[] = $row[0];
			$idList[$row[1]] = $row[0];
			if ('' != $row[2]) {
				$titleList[$row[1]] = $row[2];
			} else {
				$titleList[$row[1]] = $row[0];
			}
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName] = $list;
		return $list;
	}
	/*!
	 * Get video path list for specified album
	 *
	 * \param $albumName alubm name
	 * \return array with path list
	 */
	function GetAlbumVideoList($albumName)
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['list_video_cache'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['list_video_cache'][$albumName];
		}
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT path, id FROM video WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} "
			."ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		$list = array();
		$idList = array();
		while (false !== ($row = $dbResult->fetch())) {
			$list[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			$idList[$row[1]] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['list_video_cache'][$albumName] = $list;
		return $list;
	}

	function GetUncategorizedPhotoList($fieldName = 'path')
	{
		$list = array();
		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH);
		$albumCond = "(path LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr." AND path NOT LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr.") ";
		$sqlParam[] = "{$albumRealPath}%";
		$sqlParam[] = "{$albumRealPath}%/%";
		$query = "SELECT path, id FROM photo_image WHERE {$albumCond}";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while (false !== ($row = $dbResult->fetch())) {
			$list[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[$fieldName];
		}
		return $list;
	}

	function GetUncategorizedVideoList($fieldName = 'path')
	{
		$list = array();
		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH);
		$albumCond = "(path LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr." AND path NOT LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr.") ";
		$sqlParam[] = "{$albumRealPath}%";
		$sqlParam[] = "{$albumRealPath}%/%";
		$query = "SELECT path, id FROM video WHERE {$albumCond}";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while (false !== ($row = $dbResult->fetch())) {
			$list[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[$fieldName];
		}
		return $list;
	}

	/*!
	 * Get most recent photo path list
	 *
	 * \return array with path list
	 */
	function GetMostRecentPhotoList()
	{
		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
		$list = array();

		if (count($albumCondition['albumCond'])) {
			$limit = 20;
			if (($count = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_photo_num') )!= null) {
				$limit = $count;
			}
			$albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);
			$query = "SELECT path FROM photo_image WHERE ({$albumCondition['albumCond']}) ORDER BY create_time desc LIMIT ".$limit;
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($albumCondition['sqlParam']);
			while (false !== ($row = $dbResult->fetch())) {
				$list[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}
		}

		return $list;
	}
	/*!
	 * Get most recent video path list
	 *
	 * \return array with path list
	 */
	function GetMostRecentVideoList()
	{
		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
		$list = array();

		if (count($albumCondition['albumCond'])) {
			$limit = 20;
			if (($count = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_video_num') )!= null) {
				$limit = $count;
			}
			$albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);
			if ($limit == 'all') {
				$query = "SELECT path FROM video WHERE ({$albumCondition['albumCond']}) ORDER BY date desc";
			} else {
				$query = "SELECT path FROM video WHERE ({$albumCondition['albumCond']}) ORDER BY date desc LIMIT ".$limit;
			}
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($albumCondition['sqlParam']);

			while (false !== ($row = $dbResult->fetch())) {
				$list[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}
		}

		return $list;
	}

	function GetMostRecentCommentPhotoList()
	{
		$limit = $this->GetConfig('photo', 'recent_commented_photo_num');
		if (!$limit) {
			$limit = '20';
		}
		$query = 'SELECT photo_id FROM photo_comment ORDER BY date desc';
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute();
		$count = 0;
		$list = array();
		while (false !== ($row = $dbResult->fetch()) && $count < $limit) {
			$query1 = 'SELECT path FROM photo_image WHERE id='.$row['photo_id'];
			$dbResult1 = $this->_dbh->prepare($query1);
			$dbResult1->execute();
			if (false !== ($row1 = $dbResult1->fetch())) {
				$path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row1['path'];
				if (csSYNOPhotoMisc::CheckPathAccessible($path) && false === array_search($path, $list)) {
					$list[] = $path;
					$count++;
				}
			}
		}
		$_SESSION[SYNOPHOTO_ADMIN_USER]['most_recent_comment_cache']['photo'] = $list;
		return $list;
	}

	function GetMostRecentCommentVideoList()
	{
		$limit = $this->GetConfig('photo', 'recent_commented_video_num');
		if (!$limit) {
			$limit = '20';
		}

		$query = 'select path from video_comment order by date desc';
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute();
		$count = 0;
		$list = array();
		while (false !== ($row = $dbResult->fetch()) && $count < $limit) {
			$path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			if (csSYNOPhotoMisc::CheckPathAccessible($path) && false === array_search($path, $list)) {
				$list[] = $path;
				$count++;
			}
		}
		$_SESSION[SYNOPHOTO_ADMIN_USER]['most_recent_comment_cache']['video'] = $list;
		return $list;
	}

	function GetItemListByLabel($labelId, $category)
	{
		$result = array();
		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();

		if (0 == count($albumCondition['albumCond'])) {
			return $result;
		}
		$sqlParam = array();
		$query = "SELECT photo_image.path FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE photo_image_label.label_id=? AND status='t'";
		$sqlParam[] = $labelId;

		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$query .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
			$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
		}
		$query .= ' ORDER BY photo_image.create_time DESC';
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while (false !== ($row = $dbResult->fetch())) {
			if ($row['path']) {
				$result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_PHOTO;
			}
		}

		if (0 == $category) {
			return $result;
		}
		$query = 'SELECT video_path AS path From photo_video_label LEFT JOIN video ON video.path=photo_video_label.video_path WHERE label_id=?';
		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$query .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
		}
		$query .= ' ORDER BY date DESC';
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while (false !== ($row = $dbResult->fetch())) {
			$result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}
		return $result;
	}

	function GetNonConfirmItemList()
	{
		$result = array();

		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			return $result;
		}

		$query = "SELECT photo_image.path FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE status='f' ORDER BY photo_image.create_time DESC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute();
		while (false !== ($row = $dbResult->fetch())) {
			if ($row['path']) {
				$result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_PHOTO;
			}
		}
		return $result;
	}

	function GetCategoryItemList($category)
	{
		$result = array();
		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();

		if (0 == count($albumCondition['albumCond'])) {
			return $result;
		}
		$sqlParam = array();
		$query = "SELECT photo_image.path FROM photo_image_label LEFT JOIN photo_label ON photo_label.id=photo_image_label.label_id LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE category=? AND status='t' ";
		$sqlParam[] = $category;

		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$query .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
			$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
		}
		$query .= ' ORDER BY photo_image.create_time DESC';
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while (false !== ($row = $dbResult->fetch())) {
			if ($row['path']) {
				$result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_PHOTO;
			}
		}

		if (0 == $category) {
			return $result;
		}

		$query = 'SELECT video_path AS path From photo_video_label LEFT JOIN photo_label ON photo_video_label.label_id=photo_label.id LEFT JOIN video ON video.path=photo_video_label.video_path WHERE category=? ';
		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$query .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
		}
		$query .= ' ORDER BY date DESC';
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		while (false !== ($row = $dbResult->fetch())) {
			$result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}
		return $result;
	}

    function GetRecentlyAddCondition($dir, $value, $type)
    {
        $dateKey = ('photo' === $type) ? 'create_time' : 'date';
        $table = ('photo' === $type) ? 'photo_image' : 'video';
        $albumCondition = self::GetAccessibleAlbumQueryConditionByDir($dir);
        $albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);
        $query = "SELECT id FROM {$table} WHERE ({$albumCondition['albumCond']}) ORDER BY {$dateKey} DESC LIMIT {$value}";
        $dbResult = $this->_dbh->prepare($query);
        $dbResult->execute($albumCondition['sqlParam']);
        $idArr = array();
        while (false !== ($row = $dbResult->fetch())) {
            array_push($idArr, $row['id']);
        }
        $idString = '('.implode(',', $idArr).')';
        $sqlCondition = "id IN {$idString}";
        return $sqlCondition;
    }
    
    function GetRecentlyCommentCondition($dir, $value, $type)
    {
        $albumCondition = self::GetAccessibleAlbumQueryConditionByDir($dir);
        $albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);
        if ('photo' === $type) {
            $query = "select photo_image.id as id, photo_image.path as path from photo_comment left join photo_image on photo_image.id=photo_comment.photo_id where ({$albumCondition['albumCond']}) order by photo_comment.date desc";
        } elseif ('video' === $type) {
            $string = $albumCondition['albumCond'];
            $albumCondition['albumCond'] = str_replace("path", "video.path", $string);
            $query = "select video.id as id, video.path as path from video_comment left join video on video.path=video_comment.path where ({$albumCondition['albumCond']}) order by video_comment.date desc";
        }

        $dbResult = $this->_dbh->prepare($query);
        $dbResult->execute($albumCondition['sqlParam']);
        $count = 0;
        $idArr = array();
        while (false !== ($row = $dbResult->fetch())) {
            if ($count === (int)$value) {
                break;
            }
            if (!in_array($row['id'], $idArr)) {
                array_push($idArr, $row['id']);
                $count++;
            }
        }
        $idString = '('.implode(',', $idArr).')';
        $sqlCondition = " id IN {$idString}";
        return $sqlCondition;
    }

    function GetAccessibleAlbumQueryConditionByDir($dir)
    {
        if ($dir) {
            $albumName = @pack('H*', $dir);
            $albumToken = explode('/', $albumName);
            if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
                $albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumName);
                $albumCond[] = "(path LIKE ? {$this->escapeStr}) ";
                $sqlParam[] = "{$albumRealPath}/%";
            } else {
                $albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumName);
                $albumCond[] = "(path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr}) ";
                $sqlParam[] = "{$albumRealPath}/%";
                $sqlParam[] = "{$albumRealPath}/%/%";
                foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'] as $item) {
                    $subDir = strstr($item['sharename'], '/', true);
                    if ($subDir == $albumName) {
                        $albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
                        $albumCond[] = "path LIKE ? {$this->escapeStr}";
                        $sqlParam[] = "{$albumRealPath}/%";
                    }
                }
            }
            $albumCondition['albumCond'] = $albumCond;
            $albumCondition['sqlParam'] = $sqlParam;
        } else {
            $albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
        }
        return $albumCondition;
    }

	/*!
	 * Search photos by conditions, and store result in cache
	 *
	 * \param $moreCond array with search conditions, key as the field name
	 * \return the token of cache store search result
	 */
	function GetSearchToken($condition = array())
	{
		$sqlParam = array();

		/* prepare album condition */
		$albumCond = array();

		if (isSet($condition['dir'])) {
			$albumName = @pack('H*', $condition['dir']);
			$albumToken = explode('/', $albumName);
			if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) || count($albumToken) > 1) {
				$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumName);
				$albumCond[] = "(path LIKE ? {$this->escapeStr}) ";
				$sqlParam[] = "{$albumRealPath}/%";
			} else {
				$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumName);
				$albumCond[] = "(path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr}) ";
				$sqlParam[] = "{$albumRealPath}/%";
				$sqlParam[] = "{$albumRealPath}/%/%";
				foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'] as $item) {
					$subDir = strstr($item['sharename'], '/', true);
					if ($subDir == $albumName) {
						$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
						$albumCond[] = "path LIKE ? {$this->escapeStr}";
						$sqlParam[] = "{$albumRealPath}/%";
					}
				}
			}
		} else {
			$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
			$albumCond = $albumCondition['albumCond'];
			$sqlParam = $albumCondition['sqlParam'];
		}

		/* prepare photo & video conditions */
		$photoCond = array();
		$videoCond = array();
		$videoParam = $sqlParam;
		$photoResult = array();
		$videoResult = array();

		/* keyword condition */
		if (isset($condition['k']) && isset($condition['k_op'])) {
			if ($keywordCondition = self::GetKeywordCondition($condition['k'], $condition['k_op'], array('name', 'title', 'description', 'label_name'))) {
				$photoCond[] = $keywordCondition['cond'];
				$sqlParam = array_merge($sqlParam, $keywordCondition['param']);
			}

			if ($keywordCondition = self::GetKeywordCondition($condition['k'], $condition['k_op'], array('title', 'description', 'label_name'))) {
				$videoCond[] = $keywordCondition['cond'];
				$videoParam = array_merge($videoParam, $keywordCondition['param']);
			}
		}

		/* date condition */
		if (isset($condition['d']) && isset($condition['d_op'])) {
			if ('taken' === $condition['d_op']) {
				$photoCond[] = self::GetDateCondition($condition['d'], 'timetaken');
				$videoCond[] = self::GetDateCondition($condition['d'], 'mdate');
			} elseif ('upload' === $condition['d_op']) {
				$photoCond[] = self::GetDateCondition($condition['d'], 'create_time');
				$videoCond[] = self::GetDateCondition($condition['d'], 'date');
            } elseif ('recently_add' === $condition['d_op']) {
                $photoCond[] = self::GetRecentlyAddCondition($condition['dir'], $condition['d'], 'photo');
                $videoCond[] = self::GetRecentlyAddCondition($condition['dir'], $condition['d'], 'video');
            } elseif ('recently_comment' === $condition['d_op']) {
                $photoCond[] = self::GetRecentlyCommentCondition($condition['dir'], $condition['d'], 'photo');
                $videoCond[] = self::GetRecentlyCommentCondition($condition['dir'], $condition['d'], 'video');
            }
		}

		/* people tag condition */
		if (isset($condition['pt']) && isset($condition['pt_op'])) {
			if ($peopleCondition = self::GetTagCondition($condition['pt'], $condition['pt_op'], 'people')) {
				$photoCond[] = $peopleCondition['cond'];
				$sqlParam = array_merge($sqlParam, $peopleCondition['param']);
			}
		}

		/* geo tag condition */
		if (isset($condition['gt']) && isset($condition['gt_op'])) {
			if ($geoCondition = self::GetTagCondition($condition['gt'], $condition['gt_op'], 'geo')) {
				$photoCond[] = $geoCondition['cond'];
				$sqlParam = array_merge($sqlParam, $geoCondition['param']);
			}

			if ($geoCondition = self::GetTagCondition($condition['gt'], $condition['gt_op'], 'geo', 'video')) {
				$videoCond[] = $geoCondition['cond'];
				$videoParam = array_merge($videoParam, $geoCondition['param']);
			}
		}

		/* desc tag condition */
		if (isset($condition['dt']) && isset($condition['dt_op'])) {
			if ($descCondition = self::GetTagCondition($condition['dt'], $condition['dt_op'], 'desc')) {
				$photoCond[] = $descCondition['cond'];
				$sqlParam = array_merge($sqlParam, $descCondition['param']);
			}

			if ($descCondition = self::GetTagCondition($condition['dt'], $condition['dt_op'], 'desc', 'video')) {
				$videoCond[] = $descCondition['cond'];
				$videoParam = array_merge($videoParam, $descCondition['param']);
			}
		}

		$albumCond = '('.implode(' OR ', $albumCond).')';

		/* photo query */
		if (!empty($albumCond) && count($photoCond)) {
			$cond = array($albumCond, implode(' AND ', $photoCond));
			$cond = implode(' AND ', $cond);

			$cacheQuery = " SELECT * FROM photo_image LEFT JOIN".
				" (SELECT photo_image_label.*, photo_label.name AS label_name FROM photo_image_label LEFT JOIN".
				" photo_label ON photo_label.id = photo_image_label.label_id) photo_image_label".
				" ON photo_image.id = photo_image_label.image_id".
				" WHERE $cond ";
			$query = " SELECT path FROM photo_image LEFT JOIN".
				" (SELECT photo_image_label.*, photo_label.name AS label_name FROM photo_image_label LEFT JOIN".
				" photo_label ON photo_label.id = photo_image_label.label_id) photo_image_label".
				" ON photo_image.id = photo_image_label.image_id".
				" WHERE $cond order by path";

			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);

			while (false !== ($row = $dbResult->fetch())) {
				$photoResult[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}
		} else {
			$cacheQuery = '';
			$sqlParam = array();
		}

		/* video query */
		if (!empty($albumCond) && count($videoCond)) {
			$cond = array($albumCond, implode(' AND ', $videoCond));
			$cond = implode(' AND ', $cond);

			//video descriptions is in "video_desc" table, not in "video" table
			$videoCacheQuery = " SELECT * FROM".
				" (SELECT description, video.* FROM video LEFT JOIN video_desc ON video.path = video_desc.path) video LEFT JOIN". 
				" (SELECT photo_video_label.*, photo_label.name AS label_name FROM photo_video_label LEFT JOIN".
				" photo_label ON photo_label.id = photo_video_label.label_id) photo_video_label ON video.path = photo_video_label.video_path".
				" WHERE $cond";			
			$query = " SELECT path FROM".
				" (SELECT description, video.* FROM video LEFT JOIN video_desc ON video.path = video_desc.path) video LEFT JOIN".
				" (SELECT photo_video_label.*, photo_label.name AS label_name FROM photo_video_label LEFT JOIN".
				" photo_label ON photo_label.id = photo_video_label.label_id) photo_video_label ON video.path = photo_video_label.video_path".
				" WHERE $cond";

			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($videoParam);

			while (false !== ($row = $dbResult->fetch())) {
				$videoResult[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}
		} else {
			$videoCacheQuery = '';
			$videoParam = array();
		}

		/* keep only the latest search result */
        $result['search_result_photo'] = array(
                                   'statement' => $cacheQuery,
                                   'param' => $sqlParam,
                                   'result' => $photoResult);
        $result['search_result_video'] = array(
                                    'statement' => $videoCacheQuery,
                                    'param' => $videoParam,
                                    'result' => $videoResult);
        return $result;
	}

	function GetKeywordCondition($keywordStr, $operator = 'all', $fields = array('title'))
	{
		$param = array();

		if (!is_string($keywordStr) || 0 >= strlen(trim($keywordStr)) || !is_array($fields)) {
			return null;
		}

		$keywords = strtolower(trim($keywordStr));

		if ('all' === $operator || 'any' === $operator) {
			$keywords = array_unique(explode(' ', $keywords));
		} else {
			$keywords = array($keywords);
		}

		foreach ($keywords as &$keyword) {
			if ('' === $keyword) {
				continue;
			}

			$cond = array();

			foreach ($fields as $field) {
				$cond[] = "lower($field) like ? {$this->escapeStr}";
				$value = self::EscapeLikeParam($keyword);
				$param[] = "%{$value}%";
			}

			$keyword = '('.implode(' OR ', $cond).')';
		}

		$separator = '';
		if ('all' === $operator) {
			$separator = ' AND ';
		} else if ('any' === $operator) {
			$separator = ' OR ';
		}

		return array(
			'cond' => '('.implode($separator, $keywords).')',
			'param' => $param
		);
	}

	function GetDateCondition($dateStr, $field = 'timetaken')
	{
		if (!is_string($dateStr) || 0 >= strlen(trim($dateStr))) {
			return '';
		}

		$dates = explode(',' , trim($dateStr));
		$begin = strtotime($dates[0]);
		$end = strtotime($dates[1]);

		if (false === $begin && false === $end) {
			return '';
		} else if (false !== $begin) {
			$cond = "$field >= '".date('Y-m-d', $begin)." 00:00:00'";
			if (false !== $end) {
				$cond .= " AND $field <= '".date('Y-m-d', $end)." 23:59:59'";
			}
		} else {
			$cond = "$field <= '".date('Y-m-d', $end)." 23:59:59'";
		}

		$cond = '('.$cond.')';

		return $cond;
	}

	function GetTagCondition($tagStr, $operator = 'all', $tagType = 'people', $type = 'photo')
	{
		$param = array();

		if (!is_string($tagStr) || 0 >= strlen(trim($tagStr))) {
			return null;
		}

		$tags = explode(',' , trim($tagStr));

		$sqlField = '0';
		if ('geo' === $tagType) {
			$sqlField = '1';
		} else if ('desc' === $tagType) {
			$sqlField = '2';
		}

		if ('photo' === $type) {
			$sqlTemplate =
				"photo_image.id IN (SELECT image_id FROM photo_image_label LEFT JOIN photo_label on label_id = photo_label.id ".
				"WHERE category = '$sqlField' AND label_id = ? )";
		} else {
			$sqlTemplate =
				"video.path IN (SELECT video_path FROM photo_video_label LEFT JOIN photo_label on label_id = photo_label.id ".
				"WHERE category = '$sqlField' AND label_id = ? )";
		}

		//!!! check if every item (label_id) is REAL label_id
		//maybe need another check if every person item (person label_id) is REAL label_id for person label

		foreach ($tags as &$tag) {
			$param[] = self::EscapeParam($tag);
			$tag = $sqlTemplate;
		}

		if ('all' == $operator) {
			$cond = '('.implode(' AND ', $tags).')';
		} else if ('any' == $operator) {
			$cond = '('.implode(' OR ', $tags).')';
		}

		return array(
			'cond' => $cond,
			'param' => $param
		);
	}

	/*!
	 * Get album info by name
	 *
	 * \param $albumName album name
	 * \return array with data from scheme 'photo_share'
	 */
	function GetAlbum($albumName)
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName];
		}
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName];
		}
		// Get Album From DB
		return $this->getPhotoShareByShareName($albumName);
	}


	/*!
	 * Mearge arrays avoid renumbers string numeric keys
	 *
	 * \param $arr1 Array
	 * \param $arr2 Array
	 * \return Array
	 */

	function MergeArrays($arr1,$arr2)
	{
		if (!is_array($arr1)) {
			$arr1 = array();
		}
		if (!is_array($arr2)) {
			$arr2 = array();
		}
		$keys1 = array_keys($arr1);
		$keys2 = array_keys($arr2);
		$keys  = array_merge($keys1,$keys2);
		$vals1 = array_values($arr1);
		$vals2 = array_values($arr2);
		$vals  = array_merge($vals1,$vals2);
		$ret = array();

		foreach($keys as $key)
		{
			list($unused, $val) = each($vals);
			$ret[$key] = $val;
		}

		return $ret;
	}
	/*!
	 * Get albums by conditions
	 *
	 * \param $moreCond array with search conditions, key as the field name
	 * \param $isORCond conditions in $moreCond is concatenate by 'OR' or not
	 * \return array with data from scheme 'photo_share'
	 */
	function GetAlbums($moreCond = array(), $isORCond = false, $dirName='')
	{
		$searchPool = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'];
		if (!isSet($moreCond['is-subdir']) || 'f' == $moreCond['is-subdir'] || false === $moreCond['is-subdir']) {
			$searchPool = $this->MergeArrays($searchPool, $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir']);
		}
		if (isSet($moreCond['is-subdir'])) {
			unset($moreCond['is-subdir']);
		}
		$result = array();
		foreach ($searchPool as $albumName => $item) {
			if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName)) {
				continue;
			}
			$condMatch = array();
			foreach ($moreCond as $key => $value) {
				if (empty($value)) {
					continue;
				}
				if (!is_array($value)) {
					$value = array('op' => '=', 'value' => $value);
				}
				$op = strtoupper($value['op']);
				$value = strtoupper($value['value']);
				switch ($op) {
					case '=':
						$condMatch[] = ($value == strtoupper($item[$key]));
						break;
					case 'PREFIX':
						$condMatch[] = ($value == strtoupper(substr($item[$key], 0, strlen($value))));
						break;
					case 'MIDDLE':
						$condMatch[] = (false !== stristr($item[$key], $value));
						break;
					default: // not supported
						$condMatch[] = false;
				}
			}
			$match = $isORCond ? false !== array_search(true, $condMatch, true) : false === array_search(false, $condMatch, true);
			if ($match) {
				if (!empty($dirName)) {
					$dir = @pack('H*', $dirName);
					$len = strlen($dir);
					/* add this item when $dir is the ancestor directory of the current item */
					if (0 === strncmp($dir, $item['sharename'], $len) && '/' === $item['sharename'][$len]) {
						$result[] = $item;
					}
				} else {
					$result[] = $item;
				}
			}
		}
		return $result;
	}
	/*!
	 * purge stale log accroding to #SYNOPHOTO_MAX_LOG_TO_KEEP
	 *
	 * \return the logid can be used to insert new record
	 */
	private function PurgePhotoLog()
	{
		$query = 'SELECT count(logid) FROM photo_log';
		$dbResult = $this->_dbh->query($query);
		$logRec = $dbResult->fetch();
		/* purge stale log record */
		if ($logRec[0] >= SYNOPHOTO_MAX_LOG_TO_KEEP) {
			$query =  'SELECT create_time FROM photo_log ORDER BY create_time DESC LIMIT 1 OFFSET '.SYNOPHOTO_REC_TO_DEL;
			$dbResult = $this->_dbh->query($query);
			$truncateLog = $dbResult->fetch();
			$query = "DELETE FROM photo_log WHERE create_time < '{$truncateLog[0]}'";
			$this->_dbh->query($query);
		}
		$query = 'SELECT max(logid) FROM photo_log';
		$dbResult = $this->_dbh->query($query);
		$maxLogId = $dbResult->fetch();
		/* rotate to 1 if > PHP_INT_MAX (2147483647) */
		$maxLogId = $maxLogId[0] >= PHP_INT_MAX ? 1 : $maxLogId[0] + 1;
		return $maxLogId;
	}
	/*!
	 * Add a new log record to db
	 *
	 * \param $msg message string to record
	 * \param $isError this log is for error occurred
	 * \param $user logined username
	 */
	function AddPhotoLog($msg, $isError, $user)
	{
		$logId = $this->PurgePhotoLog();
		$query = 'INSERT INTO photo_log VALUES(?, ?, ?, ?, ?)';
		$sqlParam = array($logId, date('Y-m-d H:i:s'), $msg, $isError, $user);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
	}
	/*!
	 * Get language to use by system config
	 *
	 * \return ### format language region code
	 */
	function GetLanguage()
	{
		/* use user-defined language */
		if ('1' == $this->GetConfig('global', 'lang_setting') &&
			'def' != ($lang = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['language']) ) {
			return $lang;
		}
		/* use browser default */
		$matches = array();
		if (isSet($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
			preg_match_all('/([-a-z]+)(;q=([\.0-9]+))?/', strtolower(trim($_SERVER['HTTP_ACCEPT_LANGUAGE'])), $matches, PREG_SET_ORDER);
		}
		$acceptLang = array();
		foreach ($matches as $item) {
			$qvalue = isSet($item[3]) ? $item[3] : 1;
			$acceptLang[$qvalue] = $item[1];
		}
		unset($matches);
		/* sort by qvalue (ref. RFC 2616) */
		krsort($acceptLang, SORT_NUMERIC);
		foreach ($acceptLang as $lang) {
			if (false !== ($lang = csSYNOPhotoMisc::GetMappedLanguage($lang)) &&
				false !== stripos($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg']['supplang'], $lang)) {
				return $lang;
			}
		}
		return 'enu';
	}
	/*!
	 * Update photo's property
	 *
	 * \param $path photo's path
	 * \param $title photo's new title
	 * \param $description photo's new description
	 *
	 */
	function UpdatePhotoProperty($path, $title, $description, $realPath)
	{
		$cmd = sprintf('%s -M"set %s %s" %s', SYNO_EXIFTOOL_FILE, "Xmp.dc.description", str_replace('"', '\"', $description), escapeshellarg($realPath));
		@exec($cmd);
		$cmd = sprintf('%s -M"set %s %s" %s', SYNO_EXIFTOOL_FILE, "Iptc.Application2.Caption", str_replace('"', '\"', $description), escapeshellarg($realPath));
		@exec($cmd);

		$path = $this->EscapeParam($path);
		$title = $this->EscapeParam($title);
		$description = $this->EscapeParam($description);

		$query = "Update photo_image set title = '$title', description = '$description' where path = '$path'";
		$db_result = $this->_dbh->query($query);

		//update mtime of all thumbnails for prevent from re-making thumbnail
		$cmd = sprintf('/usr/syno/bin/synophoto_dsm_user --updatethumbnailmtime %s', escapeshellarg($realPath));
		@exec($cmd);

		return true;
	}
	/*!
	 * Update video property
	 *
	 * \param $path video's path
	 * \param $title video's new title
	 * \param $description video's new description
	 *
	 */
	function UpdateVideoProperty($path, $title, $description)
	{
		$path = $this->EscapeParam($path);
		$title = $this->EscapeParam($title);
		$description = $this->EscapeParam($description);

		$query = "Update video_desc set title = '$title', description = '$description' where path = '$path'";
		$db_result = $this->_dbh->query($query);

		if($db_result->rowCount() < 1) {
			if (empty($title)) {
				$file_name = basename($path);
				$file = substr($file_name, 0, strpos($file_name, "."));
				$title = $this->EscapeParam($file);
			}
			$query = "Insert into video_desc (path, title, description) Values ('$path', '$title', '$description')";
			$this->_dbh->query($query);

		}

		return true;
	}
	/*!
	 * Update album property
	 *
	 * \param $shareName album share name
	 * \param $title album's new title
	 * \param $description album's new description
	 * \param $public album's new is public property 't' for true, 'f' for false
	 *
	 */
	function UpdateAlbumProperty($shareName, $title, $description)
	{
		$shareName = $this->EscapeParam($shareName);
		$title = $this->EscapeParam($title);
		$description = $this->EscapeParam($description);

		$query = "Update photo_share set title = '$title', description = '$description' where sharename = '$shareName'";
		$db_result = $this->_dbh->query($query);

		return true;
	}

	function inheritAlbumPrivilege($parent_shareid, $new_shareid)
	{
		$public = 'f';
		$query = "SELECT public FROM photo_share WHERE shareid=".$parent_shareid;
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if($row = PHOTO_DB_FetchRow($db_result)) {
			$public = PHOTO_DB_ConvertBool($row['public']);
		}

		$query = "Update photo_share set public = '".$public."' where shareid = ".$new_shareid;
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		// Set access Right the same as parent.
		$query = "Select * from ".PHOTO_ACCESS_RIGHT_TABLE." where shareid = ".$parent_shareid;
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while(($row = PHOTO_DB_FetchRow($db_result))) {
			$query = "Insert into ".PHOTO_ACCESS_RIGHT_TABLE." (userid, shareid, create_time) values (".$row[0].", ".$new_shareid.", '".date('Y-m-d H:i:s')."');";
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}

		// Set upload Right the same as parent.
		$query = "Select * from ".PHOTO_UPLOAD_RIGHT_TABLE." where shareid = ".$parent_shareid;
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while(($row = PHOTO_DB_FetchRow($db_result))) {
			$query = "Insert into ".PHOTO_UPLOAD_RIGHT_TABLE." (userid, shareid, create_time) values (".$row[0].", ".$new_shareid.", '".date('Y-m-d H:i:s')."');";
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}

		// Set manage Right the same as parent.
		$query = "SELECT * FROM ".PHOTO_MANAGE_RIGHT_TABLE." WHERE shareid = ".$parent_shareid;
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while (($row = PHOTO_DB_FetchRow($db_result))) {
			$query = "INSERT INTO ".PHOTO_MANAGE_RIGHT_TABLE." (userid, shareid, create_time) VALUES (".$row[0].", ".$new_shareid.", '".date('Y-m-d H:i:s')."');";
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}

		// Set group permission as parent.
		$query = "SELECT * FROM ".PHOTO_GROUP_PERMISSION_TABLE." WHERE shareid = ".$parent_shareid;
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while (($row = PHOTO_DB_FetchRow($db_result))) {
			$query = "INSERT INTO ".PHOTO_GROUP_PERMISSION_TABLE." (groupid, shareid, permission, create_time) VALUES (".$row[0].", ".$new_shareid.", ".$row[2].", '".date('Y-m-d H:i:s')."');";
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}

	}

	function checkVideoConvertOrigRotate($path, $ratio)
	{
		SYNOPhotoEA::getFilePath($path, SYNOPhotoEA::FILE_FILM_H264_MP4, $convert_path);

		$query = 'Select resolutionx, resolutiony From video_convert where convert_file_path=?';
		$sqlParam = array($convert_path);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		if ($row = PHOTO_DB_FetchRow($db_result) && $row['resolutionx'] && $row['resolutiony'] ) {
			if ($row['resolutionx'] / $row['resolutiony'] !== $ratio) {
				return true;
			}
		}
		return false;
	}

	function getPhotoCountByAlbumPath($share_path)
	{
		$path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$share_path;
		$query = "SELECT count(id) FROM photo_image "
				."WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr}";

		$result = $this->_dbh->prepare($query);
		$result->execute(array("$path/%", "$path/%/%"));

		$row = $result->fetch();
		return $row[0];
	}

	function getVideoCountByAlbumPath($share_path)
	{
		$path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$share_path;
		$query = "SELECT count(id) FROM video "
				."WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr}";
		$result = $this->_dbh->prepare($query);
		$result->execute(array("$path/%", "$path/%/%"));

		$row = $result->fetch();
		return $row[0];
	}

	function getPhotoShareByShareName($sharename)
	{
		$query = "SELECT * FROM photo_share WHERE sharename = ?";
		$result = $this->_dbh->prepare($query);
		$result->execute(array($sharename));

		$row = $result->fetch();
		$ret = array();
		foreach ($row as $k => $v) {
			$ret[$k] = $v;
		}
		return $ret;
	}
}
?>
