<?php
/*!
 * browsing operation
 */
class csSYNOPhotoBrowse {
	/*! reference to a self instance */
	private static $instance = null;

	/*!
	 * Get a exist instance
	 */
	static function GetBrowseInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get ordered album list by configuration
	 *
	 * \return sorted album list array
	 */
	private function GetAlbumListByOrderConfig()
	{
		$list = json_decode(csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'order_list'), true);
		if (NULL == $list) {
			$list = array();
		}

		$result = array();
		$albums = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']);

		/* make sure data type is string */
		foreach ($list as &$name) {
			settype($name, 'string');
		}
		foreach ($albums as &$name) {
			settype($name, 'string');
		}
		unset($name);

		foreach ($list as $item) {
			if (in_array($item, $albums, true)) {
				array_push($result, $item);
			}
		}
		foreach ($albums as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}
		return $result;
	}
	/*!
	 * Get ordered uploadable album list by configuration
	 *
	 * \return sorted uploadable album list array
	 */
	private function GetUploadableAlbumListByOrderConfig()
	{
		$list = json_decode(csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'order_list'), true);
		if (NULL == $list) {
			$list = array();
		}
		$result = array();
		$albums = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album']);

		/* make sure data type is string */
		foreach ($list as &$name) {
			settype($name, 'string');
		}
		foreach ($albums as &$name) {
			settype($name, 'string');
		}
		unset($name);

		foreach ($list as $item) {
			if (in_array($item, $albums, true)) {
				array_push($result, $item);
			}
		}
		foreach ($albums as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}
		return $result;
	}

    /*!
     * Get name list of user preference
     *
     * \param $albumName alubm name
	 * \param $dir_list - $key => $type array
	 * 			  $key - share path of album
	 * \param $photo_video_list - $key => $type array
	 * 			  $key - full path of photo, video
     * \return array with name list
	 */
	function GetItemListByPreference_New($albumName, $dir_list, $photo_video_list)
	{
		// get preference order of user setting
        $sort = csSYNOPhotoAlbum::GetAlbumThumbSortType($albumName);
        $user_order_list = array();
        if (!empty($sort['list'])) {
            $user_order_list = $sort['list'];
        }
		// replace '/' using '' in album item
		$user_order_dir_list_trim = array();
		$user_order_photo_video_list = array();
		foreach ($user_order_list as $name) {
			if ('/' === $name[strlen($name)-1]) {
				$trimName = str_replace(SYNOPHOTO_USER_SORT_ALBUM_SYMBOL, '', $name);
				$user_order_dir_list_trim[] = $trimName;
			} else {
				$user_order_photo_video_list[] = $name;
			}
	 	}

		// ==== ordering album ====
		// get folder name of dir list
		$dir_name_list = array();
		foreach ($dir_list as $path => $type) {
			$dir_name_list[basename($path)] =$type;
		}
		// ordering user preference dir
		$dir_preference_name_list = array();
		foreach($user_order_dir_list_trim as $name){
			if (array_key_exists($name, $dir_name_list)) {
				$dir_preference_name_list[$name] = $dir_name_list[$name];
			}
		}
		// rest dir item
		foreach ($dir_name_list as $name => $type) {
			if (!in_array($name, $user_order_dir_list_trim, true)) {
				$dir_preference_name_list[$name] = $type;
			}
		}
		
		// ==== ordering photo, video ====
		//get filename of photo, video list
		$photo_video_name_list = array();
		foreach ($photo_video_list as $path => $type) {
			$photo_video_name_list[basename($path)] =$type;
		}
		// ordering user preference photo, video
		$photo_video_preference_name_list = array();
		foreach($user_order_photo_video_list as $name){
			if (array_key_exists($name, $photo_video_name_list)) {
				$photo_video_preference_name_list[$name] = $photo_video_name_list[$name];
			}
		}
		// rest photo and video item
		foreach ($photo_video_name_list as $name => $type) {
			if (!in_array($name, $user_order_photo_video_list, true)) {
				$photo_video_preference_name_list[$name] = $type;
			}
		}
		// combine album and photo, video
		$result = $dir_preference_name_list + $photo_video_preference_name_list;
        return $result;
	}

	function GetItemListByPreference($albumName, $photoList, $videoList)
	{
		$sort = csSYNOPhotoAlbum::GetAlbumThumbSortType($albumName);
		$list = array();
		if (!empty($sort['list'])) {
			$list = $sort['list'];
		}

		$result = array();
		foreach($list as $item){
			if (in_array($item, $photoList, true) || in_array($item, $videoList, true)) {
				array_push($result, $item);
			}
		}

		foreach ($photoList as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}

		foreach ($videoList as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}
		return $result;
	}
	/*!
	 * Get content name list for a album
	 *
	 * \param $albumName album name
	 * \return array with NAME list for dir & photo
	 * \return array with PATH list for video
	 */
	function GetList($albumName, $removeAlbum = false, $removeVideo = false, $removePhoto = false)
	{
		$dirList = array();
		$photoList = array();
		$videoList = array();
		$itemList = array();
		$unsortedDirList = array();
		$videoNameList = array();
		$sortPhotoViedoTogether = false;
		if ('/' == $albumName) {
			$OrderType = csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'album_order_type');
			if ('1' != $OrderType) {
				$OrderTypeDesc = csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'album_order_type_is_desc');
				if ('1' == $OrderTypeDesc) {
					$albumList = array_reverse(array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']));
				} else {
					$albumList = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']);
				}
			} else {
				$albumList = $this->GetAlbumListByOrderConfig();
			}
            if (false !== ($keyIndex = array_search('/', $albumList))) {
                unset($albumList[$keyIndex]);
            }
			$dirList = $albumList;
		} else {
            if (!$removePhoto) {
                $photoList = csSYNOPhotoDB::GetDBInstance()->GetAlbumPhotoList($albumName);
            }
			if (!$removeVideo) {
				$videoList = csSYNOPhotoDB::GetDBInstance()->GetAlbumVideoList($albumName);
				$videoNameList = csSYNOPhotoMisc::GetVideoNameList($videoList);
			}
			if (!$removeAlbum) {
				$unsortedDirList = csSYNOPhotoMisc::GetSubDir($albumName, true);
			}
			if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] == 'name') {
				$sortPhotoViedoTogether = true;
				$itemList = array_merge($photoList, $videoNameList);
				if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] == 'desc') {
					$dirList = array_reverse(array_keys($unsortedDirList));
					arsort($itemList);
				} else {
					$dirList = array_keys($unsortedDirList);
					asort($itemList);
				}
			} else {
				if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] == 'desc') {
					arsort($unsortedDirList);
				} else {
					asort($unsortedDirList);
				}
				$dirList = array_keys($unsortedDirList);
			}

			if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_by_preference']) {
				$sortPhotoViedoTogether = true;
				$itemList = $this->GetItemListByPreference($albumName, $photoList, $videoNameList);
			}

			if ($sortPhotoViedoTogether) {
				$list = array();
				foreach($dirList as $name) {
					$list[$name] = SYNOPHOTO_ITEM_TYPE_ALBUM;
				}
				foreach($itemList as $name){
					if (csSYNOPhotoMisc::IsPhotoFile($name)) {
						$list[$name] = SYNOPHOTO_ITEM_TYPE_PHOTO;
					} else {
						$name = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$albumName.'/'.$name;
						$list[$name] = SYNOPHOTO_ITEM_TYPE_VIDEO;
					}
				}
				return $list;
			}
		}

		$list = array();
		foreach($dirList as $name) {
			$list[$name] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		}
		foreach($photoList as $name) {
			$list[$name] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		}
		foreach($videoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}
		return $list;
	}
	/*!
	 * Get search result list
	 *
	 * \param $condition conditions for search
	 * \return array with PATH list
	 */
	function GetSearchList($condition, $type=0)
	{
		//to do!!! just a workaround!!!
		//the sql statment now is unable to seperate keyword with "space" (like operator is always "exact")
		$albumCond = array();
		if (isset($condition['k']) && 0 < strlen($condition['k'])) {
			foreach (array('sharename', 'title', 'description') as $field) {
				$albumCond[$field] = array('op' => 'MIDDLE', 'value' => $condition['k']);
			}
		}

		$searchResult = csSYNOPhotoDB::GetDBInstance()->GetSearchToken($condition);
		$photoList = $searchResult['search_result_photo']['result'];
		$videoList = $searchResult['search_result_video']['result'];
		$dirList = csSYNOPhotoDB::GetDBInstance()->GetAlbums($albumCond, ($type==0), $condition['dir']);

		$list = array();
		foreach($dirList as $item) {
			$list[$item['sharename']] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		}
		foreach($photoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		}
		foreach($videoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}
		return $list;
	}
	function GetUncategorizedList()
	{
		$photoList = array();
		$videoList = array();
		$list = array();

		$photoList = csSYNOPhotoDB::GetDBInstance()->GetUncategorizedPhotoList();
		$videoList = csSYNOPhotoDB::GetDBInstance()->GetUncategorizedVideoList();

		foreach($photoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		}
		foreach($videoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}

		return $list;
	}

	/*!
	 * Get most recent item's path list
	 *
	 * \param $source source type of most recent item, 'photo' or 'video'
	 * \return array with PATH list
	 */
	function GetMostRecentList($source, $isRecentComment = false)
	{
		$photoList = array();
		$videoList = array();

		if ('photo' == $source) {
			if (!$isRecentComment) {
				$photoList = csSYNOPhotoDB::GetDBInstance()->GetMostRecentPhotoList();
			} else {
				$photoList = csSYNOPhotoDB::GetDBInstance()->GetMostRecentCommentPhotoList();
			}
		} else if ('video' == $source) {
			if (!$isRecentComment) {
				$videoList = csSYNOPhotoDB::GetDBInstance()->GetMostRecentVideoList();
			} else {
				$videoList = csSYNOPhotoDB::GetDBInstance()->GetMostRecentCommentVideoList();
			}
		}


		$list = array();
		foreach($photoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		}
		foreach($videoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}

		return $list;
	}
	/*!
	 * Get album thumb
	 *
	 * \param $albumName album name
	 * \return array with album thumb info
	 */
	function GetAlbumThumb($albumName, $thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE)
	{
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		$covers = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($albumName);
		$item['bigCover'] = $covers['bigCover'];
		$item['cover'] = $covers['cover'];
		$item['xLargeThumb'] = $covers['xLargeThumb'];

		$item['bigCover']['style'] = csSYNOPhotoMisc::GetThumbStyle($item['bigCover'], $thumbSize);

		return $item;
	}
	/*!
	 * Get photo thumb
	 *
	 * \param $albumName album name
	 * \return array with photo thumb info
	 */
	private function GetPhotoThumb($photoPath, $isForSlideShow=false, $isForSlideModule = false, $thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE, $isOnlyPhotoTableInfo=false)
	{
		$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
        if ($isOnlyPhotoTableInfo) {
            $item = $photoInfo;
        } else {
            $item = csSYNOPhotoThumb::GetThumbInstance()->GetThumbInfo($photoInfo, $isForSlideShow, $isForSlideModule, $thumbSize);
        }
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		return $item;
	}
		/*!
	 * Get video thumb
	 *
	 * \param $albumName album name
	 * \return array with photo thumb info
	 */
	private function GetVideoThumb($videoPath, $isForSlideShow=false, $thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE, $isOnlyVideoTableInfo=false)
	{
		$videoInfo = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($videoPath);
        if ($isOnlyVideoTableInfo) {
            $item = $videoInfo;
        } else {
            $item = csSYNOPhotoThumb::GetThumbInstance()->GetVideoThumbInfo($videoInfo, $isForSlideShow, $thumbSize);
        }
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		return $item;
	}
	/*!
	 * Get album list by offset and length
	 *
	 * \param $offset # of albums to skip
	 * \param $length # of albums to list
	 * \return array with album list info
	 *	- albums: album list info
	 *		- array returned by csSYNOPhotoAlbum::GetAlbumInfo()
	 *		- cover: album cover info
	 *	- albumCount: # of the rest albums
	 */
	function GetAlbumList($offset, $length, $includeVirtual = true)
	{
		$albumList = array();
		$list = $this->GetList('/');
		if (0 == $offset && $includeVirtual) {//page 1
			$albumList = $this->GetVirtualAlbum();
			$smartAlbumList = $this->GetSmartAlbum();

			foreach($smartAlbumList as $smartAlbum) {
				$albumList[] = $smartAlbum;
			}
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['album_order'] = array();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['album_order']['offset'] = $offset;
		$seekOffset = 0;
		foreach($list as $name => $itemType) {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['album_order']['list'][] = $name;
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
					$albumList[] = $this->GetAlbumThumb($name);
				}
			}
			$seekOffset++;
		}
		$result = array();
		$result['albums'] = $albumList;
		$result['albumCount'] = count($list);
		$result['pageIndex'] = $this->GetPageIndex($offset/$length+1, $length, $result['albumCount']);
		return $result;
	}

	function GetAlbumListAll($includeVirtual = false)
	{
		$albumList = array();
		$list = $this->GetList('/');

		if ($includeVirtual) {
			$albumList = $this->GetVirtualAlbum();
			$smartAlbumList = $this->GetSmartAlbum();

			foreach($smartAlbumList as $smartAlbum) {
				$albumList[] = $smartAlbum;
			}
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['album_order'] = array();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['album_order']['offset'] = 0;
		$seekOffset = 0;
		foreach($list as $name => $itemType) {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['album_order']['list'][] = $name;
			if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
				$albumList[] = $this->GetAlbumThumb($name);
			}
		}
		$result = array();
		$result['albums'] = $albumList;
		$result['albumCount'] = count($list);
		return $result;
	}

	function GetLabelAlbumList($categoty, $tags)
	{
		$tagNameList = array();
		foreach ($tags as $tag) {
			$tagNameList[$tag['name']] = $tag['id'];
		}
		uksort($tagNameList, 'strnatcasecmp');
		return $tagNameList;
	}

	function GetLabelAlbumThumbList($page, $length, $category, $labelId, $isDisplayAll, $isForPhotoOne = false)
	{
		$dirList = array();
		$list = array();
		$thumbList = array();
		$photoCount = 0;
		$offset = ($isDisplayAll) ? 0 : ($page - 1) * $length;
		$seekOffset = 0;
		if (null === $labelId) {
			$tags = SYNOPHOTO_LABEL_UTIL_GetAllLabel(true);
			$dirList = $this->GetLabelAlbumList($category, $tags[$category]);
			$list = $dirList;
			$length = ($isDisplayAll) ? count($list) : $length;
			if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && $category == 0 && $offset == 0) {
				$toBeConfirmAlbum = $this->GetLabelAlbumThumb($category, __('photo_str_non_confirm_album'), -1);
				if ($toBeConfirmAlbum) {
					$thumbList[] = $toBeConfirmAlbum;
				}
			}
			foreach($list as $name => $tagId) {
				if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
					$thumbList[] = $this->GetLabelAlbumThumb($category, $name, $tagId);
				}
				$seekOffset++;
			}
		} else {
			if (-1 == $labelId) {
				$list = csSYNOPhotoDB::GetDBInstance()->GetNonConfirmItemList();
			} else {
				$list = csSYNOPhotoDB::GetDBInstance()->GetItemListByLabel($labelId, $category);
			}
			$length = ($isDisplayAll) ? count($list) : $length;
			foreach($list as $path => $itemType) {
				if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
					if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
						$item = $this->GetPhotoThumb($path);
						$photoCount++;
					} else {
						$item = $this->GetVideoThumb($path);
					}
					if ($isForPhotoOne && strstr($item['url'], 'photo_one.php') === false) {
						continue;
					}

					if ($isForPhotoOne && strstr($_SERVER['REQUEST_URI'], $item['url'])) {
						$current_key = $seekOffset;
					}
					$thumbList[] = $item;
				}
				$seekOffset++;
			}
		}
		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = count($dirList);
		$result['videoCount'] = $result['itemCount'] - $result['subAlbumCount'] - $photoCount;
		$result['pageIndex'] = $this->GetPageIndex($offset/$length+1, $length, $result['itemCount']);
		if ($isForPhotoOne) {
			$result['current_key'] = $current_key;
		}
		return $result;
	}

	function GetLabelAlbumCategoryList($category)
	{
		$list = array();
		$thumbList = array();
		$photoCount = 0;
		$list = csSYNOPhotoDB::GetDBInstance()->GetCategoryItemList($category);
		foreach($list as $path => $itemType) {
			if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
				$item = $this->GetPhotoThumb($path);
				$photoCount++;
			} else {
				$item = $this->GetVideoThumb($path);
			}
			if (strstr($item['url'], 'photo_one.php') === false) {
				continue;
			}
			$thumbList[] = $item;
		}
		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		return $result;
	}

	function GetVirtualAlbum()
	{
		$albumList = array();
		$uncategorizedPhotos = $this->GetUncategorizedPhotosAlbumThumb();
		if ($uncategorizedPhotos) {
			$albumList[] = $uncategorizedPhotos;
		}
		if ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_photo')) {
			$mostRecentPhotos = $this->GetMostRecentAlbumThumb('photo');
			if ($mostRecentPhotos) {
				$albumList[] = $mostRecentPhotos;
			}
		}
		if ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_video')) {
			$mostRecentVideos = $this->GetMostRecentAlbumThumb('video');
			if ($mostRecentVideos) {
				$albumList[] = $mostRecentVideos;
			}
		}
		if ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_commented_photo')) {
			$mostRecentCommentPhotos = $this->GetMostRecentAlbumThumb('photo', true);
			if ($mostRecentCommentPhotos) {
				$albumList[] = $mostRecentCommentPhotos;
			}
		}
		if ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_commented_video')) {
			$mostRecentCommentVideos = $this->GetMostRecentAlbumThumb('video', true);
			if ($mostRecentCommentVideos) {
				$albumList[] = $mostRecentCommentVideos;
			}
		}
		$hasPersonAlbum = ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'person_label_album'));
		$hasPlaceAlbum = ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'place_label_album'));
		$hasGeneralAlbum = ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'general_label_album'));

		if ($hasPersonAlbum || $hasPlaceAlbum || $hasGeneralAlbum) {
			$tags = SYNOPHOTO_LABEL_UTIL_GetAllLabel(true);
		}

		if ($hasPersonAlbum && count($tags[0]) > 0) {
			$album = $this->GetLabelAlbumThumbFirst(0, $tags[0]);
			if ($album) {
				$albumList[] = $album;
			}
		}
		if ($hasPlaceAlbum && count($tags[1]) > 0) {
			$album = $this->GetLabelAlbumThumbFirst(1, $tags[1]);
			if ($album) {
				$albumList[] = $album;
			}
		}
		if ($hasGeneralAlbum && count($tags[2]) > 0) {
			$album = $this->GetLabelAlbumThumbFirst(2, $tags[2]);
			if ($album) {
				$albumList[] = $album;
			}
		}
		return $albumList;
	}

	function GetVirtualAlbumThumb($type) {
		$tags = SYNOPHOTO_LABEL_UTIL_GetAllLabel(true);
		switch($type) {
			case 0:
				return $this->GetMostRecentAlbumThumb('photo');
			case 1:
				return $this->GetMostRecentAlbumThumb('video');
			case 2:
				return $this->GetMostRecentAlbumThumb('photo', true);
			case 3:
				return $this->GetMostRecentAlbumThumb('video', true);
			case 4:
				return $this->GetLabelAlbumThumbFirst(0, $tags[0]);
			case 5:
				return $this->GetLabelAlbumThumbFirst(1, $tags[1]);
			case 6:
				return $this->GetLabelAlbumThumbFirst(2, $tags[2]);
		}
	}

	function GetLabelAlbumThumbFirst($category, $tags)
	{
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumInfoFirst($category);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;

		$tagNameList = $this->GetLabelAlbumList($category, $tags);

		$itemList = array();
		foreach ($tagNameList as $id) {
			$itemList = csSYNOPhotoDB::GetDBInstance()->GetItemListByLabel($id, $category);
			if (count($itemList) > 0) {
				break;
			}
		}

		if (empty($itemList)) {
			return null;
		}

		$keys = array_keys($itemList);
		$name = $keys[0];
		$itemType = $itemList[$name];
		if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
			$thumb = $this->GetPhotoThumb($name);
		} else {
			$thumb = $this->GetVideoThumb($name);
		}
		$item['bigCover'] = $thumb['bigCover'];
		$item['bigCover']['style'] = csSYNOPhotoMisc::GetThumbStyle($item['bigCover']);
		return $item;
	}

	function GetLabelAlbumThumb($category, $tagName, $id)
	{
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumInfo($category, $tagName, $id);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		$covers = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumCover($id);
		if (null == $covers && -1 == $id) {
			return false;
		}
		$item['bigCover'] = $covers['bigCover'];
		$item['cover'] = $covers['cover'];
		$item['bigCover']['style'] = csSYNOPhotoMisc::GetThumbStyle($item['bigCover']);

		return $item;
	}

	function GetUncategorizedPhotosAlbumThumb()
	{
		if (2 != csSYNOPhotoMisc::GetUserType()) {
			return null;
		}

		$uncategorizedList = $this->GetUncategorizedList();
		$item['photos'] = count($uncategorizedList);

		if (0 == $item['photos']) {
			return null;
		}

		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		$item['showTitle'] = __(photo_str_non_grouped_items);
		$item['desc'] = str_replace('{%1}', __(photo_str_ap_name)." ", __(photo_str_display_note));
		$item['url'] = 'photo_thumb.php?dir=';
		$item['isUncategorized'] = true;

		$keys = array_keys($uncategorizedList);
		$name = $keys[0];
		$itemType = $uncategorizedList[$name];
		if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
			$thumb = $this->GetPhotoThumb($name);
		} else {
			$thumb = $this->GetVideoThumb($name);
		}

		$item['bigCover'] = $thumb['bigCover'];
		$item['bigCover']['style'] = csSYNOPhotoMisc::GetThumbStyle($item['bigCover']);
		return $item;
	}

	/*!
	 * Get most recent album thumb
	 *
	 * \param $source most recent sorce. Photo or video.
	 * \return array with most recent album thumb info
	 *
	 */
	private function GetMostRecentAlbumThumb($source, $isRecentComment=false)
	{
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetMostRecentAlbumInfo($source, $isRecentComment);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;

		$mostRecentList = $this->GetMostRecentList($source, $isRecentComment);

		$item['photos'] = count($mostRecentList);

		if (0 < $item['photos']) {
			// Set the first photo of most recent album as cover.
			$keys = array_keys($mostRecentList);
			$name = $keys[0];
			$itemType = $mostRecentList[$name];
			if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
				$thumb = $this->GetPhotoThumb($name);
			} else {
				$thumb = $this->GetVideoThumb($name);
			}

			$item['bigCover'] = $thumb['bigCover'];
			$item['bigCover']['style'] = csSYNOPhotoMisc::GetThumbStyle($item['bigCover']);
			return $item;
		} else {
			return null;
		}
	}

	/*!
	 * Get smart album
	 *
	 * \return array with smart album info
	 *
	 */
	function GetSmartAlbum()
	{
		$returnAlbumList = array();

		if (!$smartAlbumList = json_decode(SmartAlbum::ListSmartAlbum(), true)) {
			csSYNOPhotoMisc::Synophoto_Log('Decode failed');
			goto Error;
		}

		if (!$smartAlbumList["success"]) {
			csSYNOPhotoMisc::Synophoto_Log('list smart album failed');
			goto Error;
		}

		$smartAlbums = $smartAlbumList["data"]["albumList"];
		if (!$smartAlbums) {
			goto Error;
		}

		foreach ($smartAlbums as $smartAlbum) {
			if (!strlen($smartAlbum["name"])) {
				continue;
			}

			$item['url'] = 'photo_thumb.php?smart_album='.bin2hex($smartAlbum["name"]);
			$item['dir'] = 's'.((int)$s++);
			$item['name'] = '';
			$item['title'] = $smartAlbum["name"];
			$item['desc'] = $smartAlbum["desc"];
			$item['isPublic'] = true;
			$item['hit'] = 0;
			$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
			$item['dirName'] = '';
			$item['showTitle'] = htmlspecialchars($smartAlbum["name"]);
			$item['uploadable'] = false;
			$item['isVirtual'] = true;
			$item['isLabelVirtual'] = true;

			if ($smartAlbum["cover"]) {
				if ('photo' === $smartAlbum["cover"]['type']) {
					$thumb = $this->GetPhotoThumb($smartAlbum["cover"]['path']);
				} else {
					$thumb = $this->GetVideoThumb($smartAlbum["cover"]['path']);
				}
				$item['bigCover'] = $thumb['bigCover'];
			} else {
				$item['bigCover']['src'] = 'images/White/album_cover_empty.png';
				$item['bigCover']['width'] = 120;
				$item['bigCover']['height'] = 120;
			}
			$item['bigCover']['style'] = csSYNOPhotoMisc::GetThumbStyle($item['bigCover']);

			$returnAlbumList[] = $item;
		}

	Error:
		return $returnAlbumList;
	}

	/*!
	 * Get smart album photo list
	 *
	 * \return array with smart album photo list info
	 *
	 */
	function GetSmartAlbumItemList($smartAlbumName, $page = 1, $length = 0, $isDisplayAll = false,
									$isForPhotoOne = false, $removeFail = false, $isForSlideShow = false)
	{
		$returnItemList = array();

		if ($isDisplayAll) {
			$offset = 0;
			$limit = 0;
		} else {
			$offset = ($page - 1) * $length;
			$limit = $length;
		}

		$data = array(
			"name" => $smartAlbumName,
			"offset" => $offset,
			"limit" => $limit
		);

		if (!$itemListJson = json_decode(SmartAlbum::ListItem(json_encode($data)), true)) {
			csSYNOPhotoMisc::Synophoto_Log('Decode photo list json failed');
			goto Error;
		}

		if (!$itemListJson["success"]) {
			csSYNOPhotoMisc::Synophoto_Log('list photo in smart album failed');
			goto Error;
		}

		$items = $itemListJson["data"]["itemList"];
		if (!is_array($items)) {
			csSYNOPhotoMisc::Synophoto_Log('no photo');
			goto Error;
		}

		$videoCount = 0;
		$thumbList = array();

		foreach($items as $item) {
			if ('photo' === $item['type']) {
				$thumb = $this->GetPhotoThumb($item["path"]);
			} else if ('video' === $item['type']) {
				$thumb = $this->GetVideoThumb($item["path"]);
			} else {
				continue;
			}

			if ($removeFail && false === strstr($thumb['url'], 'photo_one.php') ||
				$isForPhotoOne && false === strstr($thumb['url'], 'photo_one.php')) {
				continue;
			}

			if ($isForSlideShow) {
				$thumb['xLargeThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($thumb['path'], SYNOPHOTO_THUMBXLARGE,
																				  $thumb['resolutionx'], $thumb['resolutiony'], $thumb['version']);
			}

			$thumbList[] = $thumb;

			if ('video' === $item['type']) {
				$videoCount++;
			}
		}

		$returnItemList['items'] = $thumbList;
		$returnItemList['itemCount'] = $itemListJson["data"]["total"];
		$returnItemList['subAlbumCount'] = 0;
		$returnItemList['videoCount'] = $videoCount;
		if ($limit != 0) {
			$returnItemList['pageIndex'] = $this->GetPageIndex($offset / $limit + 1, $limit, $returnItemList['itemCount']);
		}

		if ($isForSlideShow) {
			$returnItemList =
				"<script type=\"text/javascript\">\n".
				"var current_key = 0;\n".
				"g_data = ".json_encode($thumbList).";\n".
				"</script>\n";
		}

	Error:
		return $returnItemList;
	}

	function prepareSmartAlbumItemList($smartAlbumName, $name, $dir)
	{
		$thumbList = $this->GetSmartAlbumItemList($smartAlbumName, 0, 0, true, true);
		$current_key = 0;

		$i = 0;
		foreach($thumbList['items'] as $item) {
			if ("photo_one.php?name=".$name."&dir=".$dir === $item["url"]) {
				$current_key = $i;
				break;
			}
			$i++;
		}

		$result	= "<script type=\"text/javascript\">\n";
		$result .= "g_data = ".json_encode($thumbList['items']).";\n";
		$result .= "var current_key = ".$current_key.";\n";
		$result .= "</script>\n";
		return $result;
	}

	/*!
	 * Get first level uploadable album list
	 *
	 * \return array with first level uploadable album list info
	 *	- albums: first layer uploadable album list info
	 *		- array returned by csSYNOPhotoAlbum::GetAlbumInfo()
	 *		- cover: album cover info
	 */
	function GetUploadableAlbumList()
	{
		$albumList = array();
		$subAlbumList = array();

		if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$isAdmin = true;
		} else {
			$isAdmin = false;
		}

		if ($isAdmin) {
			$rootList = $this->GetAlbumListByOrderConfig();
		} else {
			$rootList = $this->GetUploadableAlbumListByOrderConfig();
		}

		foreach ($rootList as $name) {
			$split = explode("/", $name);
			if (1 < count($split)) {
			/* Skip second level albums */
				continue;
			}
			$item = $this->GetAlbumThumb($name);
			$albumList[] = $item;
		}
		$result = array();
		$result['items'] = $albumList;
		return $result;
	}

    function GetList_new($albumName, $offset, $limit, $sort_by, $sort_direction, $removeAlbum = false, $removeVideo = false, $removePhoto = false)
    {
        // init
        $totalCount = $photo_video_total_count = $dir_total_count = 0;
        $photo_video_offset = $photo_video_limit = 0;
        $photo_video_list = $dir_list = array();
        $list['list'] = array();

		if ('preference' === $sort_by) {
			$offset = 0;
			$limit = -1;
		}

        // get album
        if (!$removeAlbum) {
            $unsortedDirList = csSYNOPhotoMisc::GetDir($albumName, false);

            if ('preference' === $sort_by) {
                $value = csSYNOPhotoMisc::GetConfigDB("album", "album_order_type_is_desc", "photo_config");
                if ("0" === $value) {
                    $folder_sort_direction = 'asc';
                } elseif ("1" === $value) {
                    $folder_sort_direction = 'desc';
                } else {
                    $folder_sort_direction = 'asc';
                }
            } else {
                $folder_sort_direction = $sort_direction;
            }

            // sort album
            if ($folder_sort_direction == 'desc') {
                $result = array_reverse(array_keys($unsortedDirList));
            } else {
                $result = array_keys($unsortedDirList);
            }
            $dir_total_count = count($result);
            // set offset and limit
            if (0 > (int)$limit) {
                $result = array_slice($result, $offset);
            } else {
                $result = array_slice($result, $offset, $limit);
            }
            foreach ($result as $name) {
                $dir_list[$name] = SYNOPHOTO_ITEM_TYPE_ALBUM;
            }
        }

        // get photo, video
        // calculate photo, video offset and limit
        $photo_video_limit = (0 > (int)$limit) ? -1 : ($limit - count($dir_list));
        $photo_video_offset = ($offset <= $dir_total_count) ? 0 : ($offset - $dir_total_count);
        if ('preference' === $sort_by) {
            // get system default sorting
            $sort_by_value = csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'thumb_sort_type');
            $sort_by = ('2' === $sort_by_value) ? 'createdate' : (('1' === $sort_by_value) ? 'takendate' : 'filename');
            $sort_direction_value = csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'thumb_sort_order');
            $sort_direction = ('1' === $sort_direction_value) ? 'desc' : 'asc';
			// get photo, video list
			$photo_video_list = csSYNOPhotoDB::GetDBInstance()->GetAlbumPhotoVideoList($albumName, $photo_video_offset, $photo_video_limit, $sort_by, $sort_direction, $removeVideo, $removePhoto);
			// sort by preference
			$name_list = $this->GetItemListByPreference_New($albumName, $dir_list, $photo_video_list['list']);
			// form to result
			$albumRealPath = ('/' === $albumName) ? SYNOPHOTO_SERVICE_REAL_DIR.'/' : SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/";
			$albumSharePath = ('/' === $albumName) ? '' : $albumName.'/';
			$result = array();
			foreach ($name_list as $name => $type) {
				if (SYNOPHOTO_ITEM_TYPE_ALBUM === $type) {
					$sharePath = $albumSharePath.$name;
					$result[$sharePath] = $type;
				} else {
					$fullPath = $albumRealPath.$name;
					$result[$fullPath] = $type;
				}
			}
			$list['list'] = $result;
			$list['totalCount'] = count($result);
        } else {
            $result = csSYNOPhotoDB::GetDBInstance()->GetAlbumPhotoVideoList($albumName, $photo_video_offset, $photo_video_limit, $sort_by, $sort_direction, $removeVideo, $removePhoto);
			// form to result
			$photo_video_list = $result['list'];
			$photo_video_total_count = $result['totalCount'];
			$list['list'] = $dir_list + $photo_video_list;  // array_merge will lose numeric key
			$list['totalCount'] = $dir_total_count + $photo_video_total_count;
        }
        
        return $list;
    }

	/*!
	 * Get thumb list by, offset, limit, sort by and sort direction
	 *
	 * \param $albumName album name
	 * \param $offset
     * \param $limit
     * \param $sort_by - filename, takendate, createdate, preference
     * \param $sort_direction - asc, desc
	 * \return array with thumb list info
	 *	- items: detailed information of album, photo and video
	 *	- itemCount: total count of album, photo, video
	 */
    function GetThumbList_New($albumName, $offset, $limit, $sort_by, $sort_direction, $removeAlbum = false, $removeVideo = false, $removePhoto = false)
    {
        if (!in_array($sort_by, array('filename', 'takendate', 'createdate', 'preference'))) {
            return false;
        }
        if (!in_array($sort_direction, array('asc', 'desc'))) {
            return false;
        }

        $itemList = array();
        if ('preference' === $sort_by) {
            $list = $this->GetList_new($albumName, 0, -1, $sort_by, $sort_direction, $removeAlbum, $removeVideo, $removePhoto);
            $totalCount = $list['totalCount'];
    
            $seekOffset = 0;
            foreach ($list['list'] as $key => $itemType) {
                unset($item);
                $blSeek = (0 > (int)$limit) ? true : ($seekOffset < $offset + $limit);
                if ($seekOffset < $offset) {
                    $seekOffset++;
                    continue;;
                }
                if (!$blSeek) {
                    break;
                }
                if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
                    $item = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($key);
                    $item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
                } else if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
                    $item = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($key);
                    $item['itemType'] = SYNOPHOTO_ITEM_TYPE_PHOTO;
                } else {
                    $item = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($key);
                    $item['itemType'] = SYNOPHOTO_ITEM_TYPE_VIDEO;
                }
                $itemList[] = $item;
                $seekOffset++;
            }
        } else {
            $list = $this->GetList_new($albumName, $offset, $limit, $sort_by, $sort_direction, $removeAlbum, $removeVideo, $removePhoto);
            $totalCount = $list['totalCount'];
            foreach ($list['list'] as $key => $itemType) {
                unset($item);
                if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
                    $item = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($key);
                    $item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
                } else if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
                    $item = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($key);
                    $item['itemType'] = SYNOPHOTO_ITEM_TYPE_PHOTO;
                } else {
                    $item = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($key);
                    $item['itemType'] = SYNOPHOTO_ITEM_TYPE_VIDEO;
                }
                $itemList[] = $item;
            }
        }
		$result = array();
		$result['items'] = $itemList;
		$result['itemCount'] = $totalCount;
        return $result;
    }

	/*!
	 * Get thumb list by offset and length
	 *
	 * \param $albumName album name
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with thumb list info
	 *	- items: array merged from GetDirThumbs() and GetPicThumbs()
	 *	- subAlbumCount: # of the subAlbums
	 *	- itemCount: # of the thumbs
	 */
	function GetThumbList($albumName, $offset, $length, $thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE,
						  $removeAlbum = false, $removeVideo = false, $removePhoto = false, $isOnlyPhotoVideoTableInfo=false, $storeThumbOrder=true)
	{
		csSYNOPhotoDB::GetDBInstance()->PrepareAlbumPhotos($albumName, $offset, $length);

		$thumbList = array();
		$list = $this->GetList($albumName, $removeAlbum, $removeVideo, $removePhoto);
		$listCount = array_count_values($list);
		$albumCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_ALBUM])) {
			$albumCount = $listCount[SYNOPHOTO_ITEM_TYPE_ALBUM];
		}

		$photoCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_PHOTO])) {
			$photoCount = $listCount[SYNOPHOTO_ITEM_TYPE_PHOTO];
		}

		if ($storeThumbOrder) {
			// TODO: remove this when we deprecate SYNOPHOTO_AJAX_HANDLER_ChangeSortMethod()
			$_SESSION[SYNOPHOTO_ADMIN_USER][$albumName]['thumb_order'] = array();
		}
		$seekOffset = 0;
		$pageAlbumCount = 0;
		foreach($list as $name => $itemType) {
            $blSeek = (0 > (int)$length) ? true : ($seekOffset < $offset + $length);
			if ($seekOffset >= $offset && $blSeek) {
				if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
					$thumbList[] = $this->GetAlbumThumb($name, $thumbSize);
					$pageAlbumCount++;
				} else if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
					$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$name}";
					$thumbList[] = $this->GetPhotoThumb($photoPath, false, false, $thumbSize, $isOnlyPhotoVideoTableInfo);
				} else {
					//$name will be path in video type condition
					$thumbList[] = $this->GetVideoThumb($name, false, $thumbSize, $isOnlyPhotoVideoTableInfo);
				}
			}
			if ($storeThumbOrder) {
				// TODO: remove this when we deprecate SYNOPHOTO_AJAX_HANDLER_ChangeSortMethod()
				if ($itemType != SYNOPHOTO_ITEM_TYPE_ALBUM) {
					$_SESSION[SYNOPHOTO_ADMIN_USER][$albumName]['thumb_order']['list'][] = basename($name);
				}
			}
			$seekOffset++;
		}

		if ($storeThumbOrder) {
			// TODO: remove this when we deprecate SYNOPHOTO_AJAX_HANDLER_ChangeSortMethod()
			$_SESSION[SYNOPHOTO_ADMIN_USER][$albumName]['thumb_order']['offset'] = $offset - $albumCount;
			if ($pageAlbumCount > 0) {
				$_SESSION[SYNOPHOTO_ADMIN_USER][$albumName]['thumb_order']['offset'] = 0;
			}
		}

		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = $albumCount;
		$result['videoCount'] = $result['itemCount'] - $result['subAlbumCount'] - $photoCount;
		$result['pageIndex'] = $this->GetPageIndex($offset/$length+1, $length, $result['itemCount']);
		return $result;
	}
	/*!
	 * Get thumb list all
	 *
	 * \param $albumName album name
	 * \return array with thumb list info
	 *	- items: array merged from GetDirThumbs() and GetPicThumbs()
	 *	- subAlbumCount: # of the subAlbums
	 *	- itemCount: # of the thumbs
	 */
	function GetThumbListAll($albumName, $photoName = NULL, $isForSlideShow = false, $isForSlideModule = false, $thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE, $removeFail = false, $storeThumbOrder=true)
	{
		$thumbList = array();
		$list = $this->GetList($albumName);
		$listCount = array_count_values($list);
		$albumCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_ALBUM])) {
			$albumCount = $listCount[SYNOPHOTO_ITEM_TYPE_ALBUM];
		}

		$photoCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_PHOTO])) {
			$photoCount = $listCount[SYNOPHOTO_ITEM_TYPE_PHOTO];
		}

		if ($storeThumbOrder) {
			// TODO: remove this when we deprecate SYNOPHOTO_AJAX_HANDLER_ChangeSortMethod()
			$_SESSION[SYNOPHOTO_ADMIN_USER][$albumName]['thumb_order'] = array();
			$_SESSION[SYNOPHOTO_ADMIN_USER][$albumName]['thumb_order']['offset'] = 0;
		}
		$key =0;
		$currentKey=0;
		foreach($list as $name => $itemType) {
			if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
				$thumbList[] = $this->GetAlbumThumb($name, $thumbSize);
			} else if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
				$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$name}";
				$item = $this->GetPhotoThumb($photoPath, $isForSlideShow, $isForSlideModule, $thumbSize);
				if ($removeFail && strstr($item['url'], 'photo_one.php') === false) {
					continue;
				}

				$thumbList[] = $item;
			} else if (!$isForSlideModule) {
				$item = $this->GetVideoThumb($name, $isForSlideShow, $thumbSize);
				if ($removeFail && strstr($item['url'], 'photo_one.php') === false) {
					continue;
				}
				$thumbList[] = $item;
			}
			if ($storeThumbOrder) {
				// TODO: remove this when we deprecate SYNOPHOTO_AJAX_HANDLER_ChangeSortMethod()
				if ($itemType != SYNOPHOTO_ITEM_TYPE_ALBUM) {
					$_SESSION[SYNOPHOTO_ADMIN_USER][$albumName]['thumb_order']['list'][] = basename($name);
				}
			}
			if ($photoName != NULL && $photoName == basename($name)) {
				$currentKey = $key;
			}
			$key++;
		}
		if ($currentKey > 0 && $albumCount > 0) {
			$currentKey = $currentKey - $albumCount;
		}
		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = $albumCount;
		$result['videoCount'] = $result['itemCount'] - $result['subAlbumCount'] - $photoCount;
		$result['currentKey'] = $currentKey;
		return $result;
	}
	/*!
	 * prepare thumb list all for slide_Show/photo_one page
	 *
	 * \param $albumName album name
	 * \return array with thumb list info
	 *	- items: array merged from GetDirThumbs() and GetPicThumbs()
	 *	- subAlbumCount: # of the subAlbums
	 *	- itemCount: # of the thumbs
	 */
	function prepareThumbListAll($dir, $name = NULL, $isForSlideShow)
	{
		if (NULL == $dir) {
			return false;
		}
		$removeFail = true;
		$thumbList = $this->GetThumbListAll($dir, $name, $isForSlideShow, false, SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE, $removeFail);
		$photoList = array_slice($thumbList['items'], $thumbList['subAlbumCount']);
		$current_key = $thumbList['currentKey'];

		$result	= "<script type=\"text/javascript\">\n";
		$result .= "var current_key = ".$thumbList['currentKey'].";\n";
		$result .= "g_data = ".json_encode($photoList).";\n";
		$result .= "</script>\n";
		return $result;
	}

	function prepareVirtualAlbumThumbList($type, $current_key, $labelId = -1)
	{
		switch($type) {
			case 0:
				$thumbList = $this->GetMostRecentThumbList('photo', false, true, 0, 0);
				break;
			case 1:
				$thumbList = $this->GetMostRecentThumbList('video', false, true, 0, 0);
				break;
			case 2:
				$thumbList = $this->GetMostRecentThumbList('photo', true, true, 0, 0);
				break;
			case 3:
				$thumbList = $this->GetMostRecentThumbList('video', true, true, 0, 0);
				break;
			case 4:
				$thumbList = $this->GetLabelAlbumThumbList(0, 0, 0, $labelId, true, true);
				break;
			case 5:
				$thumbList = $this->GetLabelAlbumThumbList(0, 0, 1, $labelId, true, true);
				break;
			case 6:
				$thumbList = $this->GetLabelAlbumThumbList(0, 0, 2, $labelId, true, true);
				break;
		}

		if (isSet($thumbList['current_key'])) {
			$current_key = $thumbList['current_key'];
		}

		$result	= "<script type=\"text/javascript\">\n";
		$result .= "g_data = ".json_encode($thumbList['items']).";\n";
		$result .= "var current_key = ".$current_key.";\n";
		$result .= "</script>\n";
		return $result;

	}

	function GetLabelAlbumRSSList($type, $labelId)
	{
		$thumbList = array();
		$category = $type - 4;//0~3 is the most recent album
		if (null !== $labelId) {
			$thumbList = $this->GetLabelAlbumThumbList(0, 0, $category, $labelId, true, true);
			return $thumbList;
		}

		$thumbList = $this->GetLabelAlbumCategoryList($category);
		return $thumbList;
	}

	function prepareThumbListForPreview($list)
	{
		if (empty($list)) {
			return '';
		}
		$dataList = array();
		foreach($list as $item){
			$data = array();
			if ($item['itemType'] == 0) {//album
				$data['title'] = $item['showTitle'];
				$key = 'album_item_'.bin2hex($item['name']);
			} else {
				$data['title'] = $item['title'];
				$data['resolution'] = $item['resolutionx'].' x '.$item['resolutiony'];
				if ($item['itemType'] == 2) {//video
					$data['duration'] = csSYNOPhotoMisc::formatTime($item['duration']);
					$data['time'] = $item['mdate'];
					$key = 'video_item_'.$item['id'];
				} else {
					$data['time'] = $item['timetaken'];
					$key = 'photo_item_'.$item['id'];
				}
			}
			$data['itemType'] = $item['itemType'];
			$data['desc'] = $item['desc'];
			$data['bigCover'] = $item['bigCover'];
			$dataList[$key] = $data;
		}
		$result	= "<script type=\"text/javascript\">\n";
		$result .= "g_data = ".json_encode($dataList).";\n";
		$result .= "</script>\n";
		return $result;
	}
	/*!
	 * Get GPS thumb list by offset and length
	 *
	 * \param $albumName album name
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with gps thumb info list
	 *	- items: array with thumb info that included GPS info, photos or videos.
	 *	- itemCount: # of the photos
	 *	- videoCount: # of the videos
	 */
	function GetGPSThumbList($albumName)
	{
		$thumbList = array();
		$list = $this->GetList($albumName);

		foreach($list as $name => $itemType) {
			if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
				$item = $this->GetPhotoThumb(SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$name}");
			} else {
				//$name will be path in video type condition
				$item = $this->GetVideoThumb($name);
			}
			$marginTop = $item['cover']['height'] < 120 ? (120 - $item['cover']['height']) / 2 : 0;
			$marginLeft = $item['cover']['width'] < 120 ? (120 - $item['cover']['width']) / 2 : 0;
			$item['src'] = $item['cover']['src'];
			$item['width'] = $item['cover']['width'];
			$item['height'] = $item['cover']['height'];
			$item['style'] = "margin: ${marginTop}px 0 0 ${marginLeft}px;";
			$thumbList[] = $item;
		}
		return $thumbList;
	}

	/*!
	 * Get thumb list from search result by offset and length
	 *
	 * \param $condition conditions for search
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with thumb list info
	 *	- token: the cache token returned by csSYNOPhotoDB::GetSearchToken()
	 *	- items: result thumb list
	 *	- subAlbumCount: # of the sub albums
	 *	- itemCount: # of total items
	 */
	function GetSearchThumbList($condition, $offset, $length, $isOnlyPhotoVideoTableInfo=false)
	{
		$searchResult = csSYNOPhotoDB::GetDBInstance()->GetSearchToken($condition);
		csSYNOPhotoDB::GetDBInstance()->PrepareSearchPhotos($searchResult['search_result_photo']['statement'], $searchResult['search_result_photo']['param'], $offset, $length);

		$thumbList = array();
		$list = $this->GetSearchList($condition);

		$listCount = array_count_values($list);
		$albumCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_ALBUM])) {
			$albumCount = $listCount[SYNOPHOTO_ITEM_TYPE_ALBUM];
		}

		$photoCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_PHOTO])) {
			$photoCount = $listCount[SYNOPHOTO_ITEM_TYPE_PHOTO];
		}

		if ($offset + $length > $albumCount + $photoCount) {
			// need to query video data
			$videoOffset = 0;
			if ($offset > ($albumCount + $photoCount)) {
				$videoOffset = $offset - ($albumCount + $photoCount);
			}
			csSYNOPhotoDB::GetDBInstance()->PrepareSearchVideos($searchResult['search_result_video']['statement'], $searchResult['search_result_video']['param'], $videoOffset, $length);
		}

		$seekOffset = 0;
		foreach($list as $name => $itemType) {
            $blSeek = (0 > (int)$length) ? true : ($seekOffset < $offset + $length);
			if ($seekOffset >= $offset && $blSeek) {
				if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
					$thumbList[] = $this->GetAlbumThumb($name);

				} else if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
					$thumbList[] = $this->GetPhotoThumb($name, false, false, SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE, $isOnlyPhotoVideoTableInfo);
				} else {
					$thumbList[] = $this->GetVideoThumb($name, false, SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE, $isOnlyPhotoVideoTableInfo);
				}
			}
			$seekOffset++;
		}

		$result = array();
		$result['token'] = $searchToken;
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = $albumCount;
		$result['videoCount'] = $result['itemCount'] - $result['subAlbumCount'] - $photoCount;
        if (0 < (int)length) {
            $result['pageIndex'] = $this->GetPageIndex($offset/$length+1, $length, $result['itemCount']);
        }
		return $result;
	}

	function GetUncategorizedThumbList($offset, $length, $thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE, $isOnlyPhotoVideoTableInfo=false)
	{
		$thumbList = array();
		$list = $this->GetUncategorizedList();
		$i = 0;
		$seekOffset = 0;
		foreach($list as $name => $itemType) {
            $blSeek = (0 > (int)$length) ? true : ($seekOffset < $offset + $length);
			if ($seekOffset >= $offset && $blSeek) {
				$item = array();
				if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
					$item = $this->GetPhotoThumb($name, false, false, $thumbSize, $isOnlyPhotoVideoTableInfo);
				} else {
					$item = $this->GetVideoThumb($name, false, $thumbSize, $isOnlyPhotoVideoTableInfo);
				}

				if ($removeFail && strstr($item['url'], 'photo_one.php') === false) {
					continue;
				}
				if (strstr($item['url'], 'photo_one.php') !== false) {
					$item['url'] .= "&current_key=$i";
					$i++;
				}
				$thumbList[] = $item;
			}
			$seekOffset++;
		}

		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = 0;
        if (0 < (int)$length) {
            $result['pageIndex'] = $this->GetPageIndex($offset/$length+1, $length, $result['itemCount']);
        }
		$videoCount = 0;

		if ('video' == $source) {
			$videoCount = $result['itemCount'];
		}
		$result['videoCount'] = $videoCount;

		return $result;
	}
	/*!
	 * Get thumb list from most recent items by offset and length
	 *
	 * \param $source most recent items' source type, 'photo' or 'video'
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list, $length=0 means all
	 * \return array with thumb list info
	 *	- items: result thumb list
	 *	- subAlbumCount: # of the sub albums
	 *	- itemCount: # of total items
	 */
	function GetMostRecentThumbList($source, $isRecentComment=false, $removeFail = false, $offset=0, $length=0)
	{
		//unset dbcacher, so that photo/ video data will skip dbcached and be queried from DB directly
		// (dbcacher won't have most recent photo/ video data)
		if ('photo' == $source) {
			$_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID] = array();

		} else if ('video' == $source) {
			$_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID] = array();
			if (!$isRecentComment && $removeFail && $length == 0) {
				$getNewCruuentKey = true;
			}

		}

		$isAllVideo = false;
		if (($count = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_video_num') ) == "all") {
			$isAllVideo = true;
		}

		$thumbList = array();
		$list = $this->GetMostRecentList($source, $isRecentComment);
		$i = 0;
		$seekoffset = 0;
		foreach($list as $name => $itemType) {
			if ($length == 0 || ($seekoffset >= $offset && $seekoffset < $offset + $length)) {
				$item = array();
				if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
					$item = $this->GetPhotoThumb($name);;
				} else {
					$item = $this->GetVideoThumb($name);
				}

				if ($removeFail && strstr($item['url'], 'photo_one.php') === false) {
					$failCount++;
					continue;
				}

				if ($getNewCruuentKey && strstr($_SERVER['REQUEST_URI'], $item['url'])) {
					$current_key = $seekoffset;
				}
				$url_current_key = $offset + $i;
				if (strstr($item['url'], 'photo_one.php') !== false) {
					$item['url'] .= "&current_key=$url_current_key";
					$i++;
				}

				$thumbList[] = $item;
			}
			$seekoffset++;
		}

		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = 0;
		$videoCount = 0;

		if ('video' == $source) {
			$videoCount = $result['itemCount'];
		}
		$result['videoCount'] = $videoCount;
		if ($isAllVideo && $length !== 0) {
			$result['pageIndex'] = $this->GetPageIndex($offset/$length+1, $length, $result['itemCount']);
		}

		if ($getNewCruuentKey){
			$result['current_key'] = $current_key;
		}

		return $result;
	}

	function GetMostRecentVideoThumbList($page = 0, $length)
	{
		$limit = 20;
		if (($count = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_video_num') )!= null) {
				$limit = $count;
		}
		if ($limit == 'all') {
			$offset = ($page - 1) * $length;
		} else {
			$offset = 0;
			$length = $limit;
		}
		$photoList = $this->GetMostRecentThumbList('video', false, false, $offset, $length);
		return $photoList;
	}
	/*!
	 * Get comments for specified photo by page number
	 *
	 * \param $albumName album name
	 * \param $photoName photo file name
	 * \param $offset # of comments to skip
	 * \param $length # of comments to list
	 * \return array with comment list info
	 *	- comments: array with comment info
	 *		- name: commentator name
	 *		- email: commentator email
	 *		- comment: comment
	 *		- date: comment date
	 *	- commentsMore: # of the rest comments
	 */
	function GetCommentList($albumName, $photoName, $offset, $length)
	{
		$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$photoName}";
		$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
		$comments = csSYNOPhotoDB::GetDBInstance()->GetPhotoComments($photoInfo['id'], $offset, $length);
		$result['comments'] = array();
		foreach ($comments as $item) {
			$result['comments'][] = array('name' => $item['name'], 'email' => $item['email'], 'comment' => $item['comment'],
										  'date' => csSYNOPhotoMisc::GetReducedDate($item['date'])
										 );
		}
		$result['commentsMore'] = csSYNOPhotoDB::GetDBInstance()->GetNumberOfComments($photoInfo['id']) - $offset - count($result['comments']);
		return $result;
	}
	/*!
	 * Get all comments for specified photo
	 *
	 * \param $photoPath photo path
	 * \return array with comment list info
	 *	- comments: array with comment info
	 *		- name: commentator name
	 *		- email: commentator email
	 *		- comment: comment
	 *		- date: comment date
	 */
	function GetAllPhotoComments($photoPath)
	{
		$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
		$comments = csSYNOPhotoDB::GetDBInstance()->GetPhotoComments($photoInfo['id']);
		$result = array();
		foreach ($comments as $item) {
			$emailAddr = '';
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				// only show e-mail addr when user is admin
				$emailAddr = $item['email'];
			}

			$result[] = array('name' => $item['name'], 'email' => $emailAddr, 'comment' => $item['comment'],
										  'date' => $item['date']
										 );
		}
		return $result;
	}

	/*!
	 * Get all comments for specified video
	 *
	 * \param $videoPath video path
	 * \return array with comment list info
	 *	- comments: array with comment info
	 *		- name: commentator name
	 *		- email: commentator email
	 *		- comment: comment
	 *		- date: comment date
	 */
	function GetAllVideoComments($videoPath)
	{
		$comments = csSYNOPhotoDB::GetDBInstance()->GetVideoComments($videoPath);
		$result = array();
		foreach ($comments as $item) {
			$emailAddr = '';
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				// only show e-mail addr when user is admin
				$emailAddr = $item['email'];
			}
			$result[] = array('name' => $item['name'], 'email' => $emailAddr, 'comment' => $item['comment'],
										  'date' => $item['date']
										 );
		}
		return $result;
	}
	/*!
	 * Check if the photo or video file is commentable
	 *
	 * \param $filePath photo or video file path
	 * \return true or false
	 */
	function isFileCommentable($filePath)
	{
		$sharePath = substr($filePath, strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1);

		$arr = explode('/', $sharePath);
		$level1ShareName = $arr[0];

		return isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['commentable_album'][$level1ShareName]);
	}
	/*!
	 * add new comment
	 *
	 * \param $filePath the path of the photo or video
	 * \param $itemType identify photo or video
	 * \param $name user name who adding the comment
	 * \param $email email address of whom adding the comment
	 * \param $comment the comment
	 * \return true for adding comment success
	 */
	function AddNewComment($filePath, $itemType, $name, $mail, $comment)
	{
		$result = false;
		if (SYNOPHOTO_ITEM_TYPE_PHOTO == $itemType) {
			$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($filePath);
			if (!empty($photoInfo)) {
				$result = csSYNOPhotoDB::GetDBInstance()->AddPhotoComment($photoInfo['id'], $name, $mail, $comment);
			}

		} else if (SYNOPHOTO_ITEM_TYPE_VIDEO == $itemType) {
			$videoInfo = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($filePath);
			if (!empty($videoInfo)) {
				$result = csSYNOPhotoDB::GetDBInstance()->AddVideoComment($videoInfo['path'], $name, $mail, $comment);
			}
		}

		return $result;
	}

	function SetSortTypeOrder($albumName)
	{
		$sortMethod = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumThumbSortType($albumName);
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['change_sort_method'][$albumName])) {
			csSYNOPhotoDB::GetDBInstance()->SetSessionSortMethod($_SESSION[SYNOPHOTO_ADMIN_USER]['change_sort_method'][$albumName]['type'], $_SESSION[SYNOPHOTO_ADMIN_USER]['change_sort_method'][$albumName]['order']);
		} else if ($sortMethod === '' || $sortMethod['type'] == '-1') {
			csSYNOPhotoDB::GetDBInstance()->SetSessionSortMethod(csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'thumb_sort_type'),
										csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'thumb_sort_order'));
		} else {
			csSYNOPhotoDB::GetDBInstance()->SetSessionSortMethod($sortMethod['type'], $sortMethod['order']);
		}
	}

	function GetPageIndex($currentPage, $num, $totalAlbum)
	{
		if ($totalAlbum <= 0) {
			return array();
		}
		$section_size = 5;
		$offset = floor($section_size/2);
		$total_page = ceil($totalAlbum/$num);
		$start = $currentPage - $offset;
		$end = $currentPage + $offset;
		$next_section = $currentPage + $section_size;
		$prev_section = $currentPage - $section_size;

		if ($start <= 0) {
			$start = 1;
			$end = min($section_size, $total_page);
		}
		if ($end > $total_page) {
			$end = $total_page;
			$start = max($total_page - $section_size + 1, 1);
		}
		$index_list = array();
		if ($next_section > $total_page) {
			$next_section = $total_page;
		}
		if ($prev_section < 1) {
			$prev_section = 1;
		}
		if ($start > 1) {
			$index = null;
			$index['text'] = '...';
			$index['index'] = $prev_section;
			$index_list[] = $index;
		}
		for($i = $start; $i <=$end; $i++) {
			$index = null;
			$index['text'] = $i;
			$index['index'] = $i;
			if ($i == $currentPage) {
				$index['class'] = 'current-page';
			}
			else{
				$index['class'] = 'normal-page';
			}
			$index_list[] = $index;
		}
		if ($end < $total_page) {
			$index = null;
			$index['text'] = '...';
			$index['index'] = $next_section;
			$index_list[] = $index;
		}
		return $index_list;
	}

	function GetPathLinkArray($albumName, $type = -1, $forUncategorizedAlbum = false, $label = null, $forSmartAlbum = false)
	{
		$albumToken = explode('/', $albumName);
		$linkArray = array();
		$link['url'] = 'index.php';
		$link['text'] = __(photo_str_home);
		$link['full_text'] = __(photo_str_home);
		$linkArray[] = $link;
		$currentPath = '';

		if ($type != -1) {//virtual album
			$link = array();
			$link['url'] = 'photo_thumb.php?virtual_album='.$type;
			$link['text'] = csSYNOPhotoMisc::getVirtualAlbumText($type);
			$link['full_text'] = $link['text'];
			$linkArray[] = $link;
			if (!empty($label)) {
				$id = ($label === -1) ? -1 : $label['id'];
				$name = ($label === -1) ? __('photo_str_non_confirm_album') : $label['display_name'];
				$link['url'] = 'photo_thumb.php?virtual_album='.$type.'&id='.$id;
				$link['text'] = $name;
				$link['full_text'] = $link['text'];
				$linkArray[] = $link;
			}
		} else if ($forUncategorizedAlbum) {//uncategorized album
			$link = array();
			$link['url'] = 'photo_thumb.php?dir=';
			$link['text'] = __(photo_str_non_grouped_items);
			$link['full_text'] =  $link['text'];
			$linkArray[] = $link;
		} else if ($forSmartAlbum) {//smart album
			$link = array();
			$link['url'] = 'photo_thumb.php?smart_album='.bin2hex($albumName);
			$link['text'] = htmlspecialchars($albumName);
			$link['full_text'] =  $link['text'];
			$linkArray[] = $link;
		} else {
			$i = 0;
			$count = count($albumToken);
			if ($count > 3) {
				$i = $count -3 -1;
				for($j=0; $j < $i; $j++) {
					$currentPath .= $albumToken[$j].'/';
				}
			}
			while ($i < $count){
				$token = $albumToken[$i];
				$name = htmlspecialchars($token);
				$currentPath .= $token;
				$albumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($currentPath);
				$name = $albumInfo['showTitle'];
				$link = array();
				$link['url'] = 'photo_thumb.php?dir='.bin2hex($currentPath);
				$link['full_text'] =  $name;
				$link['text'] =  ($i==$count-4)? '...' : $name;
				$currentPath .= '/';
				$linkArray[] = $link;
				$i++;
			}

		}
		$linkArray[count($linkArray)-1]['isLast'] = true;
		return $linkArray;
	}

	function getThumbSizeArray($thumbSize, $layoutType)
	{
		$countPerRow = floor(950/($thumbSize+22));
		$data['albumSize'] = $thumbSize + 22;
		$data['itemWidth'] = floor(950/$countPerRow);
		$data['itemHeight'] = ($layoutType == 1) ? $data['albumSize']+21 : $data['albumSize'];
		$data['albumLeft'] = $thumbSize + 8;
		$data['albumRightHeight'] = $thumbSize +8 -14;
		$data['photoSize'] = $thumbSize + 20;
		$data['viedoIconLeft'] = floor($thumbSize-60)/2;
		return $data;
	}
}
?>
