<?php

require_once dirname(__FILE__).'/../include/SYNOPhotoEA.php';

function FBLog($level, $msg) {
	$handle = fopen('/tmp/fbphoto.log', "a");
	if($handle) {
		fwrite($handle, date('y-m-d H:i:s'). " $level: ".$msg."\n");
		$st = fstat($handle);
		fclose($handle);
		if($st['size'] > 512000) {
			@unlink('/tmp/fbphoto.log');
		}
	}
}

function FBLogErr($msg)
{
	FBLog('Error', $msg);
}

function FBLogInfo($msg)
{
	FBLog('Info', $msg);
}

class FBPhotoUtils {
	var $fb;
	public function __construct($fb) {
		$this->fb = $fb;
		$fb->setFileUploadSupport(true);
	}
	public function createAlbum($name, $message) {
		$albumID = '';
		try {
			$resp = $this->fb->api('/me/albums', 'POST', array('name' => $name, 'message' => $message));
		}
		catch (FacebookApiException $e) {
			FBLogErr($e);
			return $albumID;
		}

		if(array_key_exists('id', $resp)) {
			$albumID = $resp['id'];
		}
		return $albumID;
	}
    public function getAlbums() {
		try {
			$resp = $this->fb->api("/me/albums");
		}
		catch (FacebookApiException $e) {
			FBLogErr($e);
			return NULL;
		}
		return $resp["data"];
	}
	public function getAlbumPhotos($albumID) {

		try {
			$resp = $this->fb->api("/$albumID/photos?limit=200&offset=0");
		}
		catch (FacebookApiException $e) {
			FBLogErr($e);
			return NULL;
		}
		return $resp["data"];
	}
	public function getAlbum($albumID) {

		try {
			$resp = $this->fb->api("/$albumID");
		}
		catch (FacebookApiException $e) {
			FBLogErr($e);
			return NULL;
		}
		return $resp;
	}

	function uploadPhoto($filePath, $albumID, $message, $useOrig) {

		$fb = $this->fb;
		$photoID = '';
		$uploadFile = $filePath;
		if(!$useOrig) {
			if (SYNOPhotoEA::checkFilePath($filePath, SYNOPhotoEA::FILE_THUMB_XL, $thumbPath)) {
				$uploadFile = $thumbPath;
			}
		}
		FBLogInfo("Upload file path: " . $uploadFile);
		$opts = array(
			'access_token'=> $fb->getAccessToken(),
			'message' => $message,
			'source' => '@'.$uploadFile
		);
		$url = empty($albumID) ? "/me/photos" : "/$albumID/photos";
		try {
			$resp = $fb->api($url, 'POST', $opts);
		}
		catch (FacebookApiException $e) {
			FBLogErr($e);
			return $photoID;
		}
		if(array_key_exists('id', $resp)) {
			$photoID = $resp['id'];
		}

		return $photoID;
	}
	public function deleteObject($id) {
		$fb = $this->fb;
		try {
			$resp = $fb->api("/$id", 'DELETE', array('access_token'=>$fb->getAccessToken()));
		}
		catch (FacebookApiException $e) {
			FBLogErr($e);
		}
	}
	public function deletePhoto($uid, $pid) {

        $params = array("method" => "facebook.photos.deletePhoto", "uid"=>$uid, "pid"=>$pid);
		$fb = $this->fb;
		try {
			$resp = $fb->api($params);
		}
		catch (FacebookApiException $e) {
			FBLogErr($e);
		}
		var_dump($resp);
	}

	public function getUser() {
		try {
			$resp = $this->fb->api('/me');
		}
		catch (FacebookApiException $e) {
			FBLogErr($e);
			return NULL;
		}
		FBLogInfo("User ID: " . $resp['id']);
		return $resp;
	}

}
?>
