<?php
require_once(dirname(__FILE__).'/../../include/syno_conf.php');
require_once(SYNOBLOG_INCLUDE_ARTICLE);

switch ($action)
{
	case 'search':
		echo SEARCH_doSearch(urldecode($_POST['key']));
		break;
}

function SEARCH_GetModuleContent()
{
	return null;
}

function SEARCH_doSearch($key_string)
{
	global $smarty;

	if($key_string == null || $key_string == "" || strpos($key_string, "\\")!==false ||
	    strpos($key_string, "\"")!==false || strpos($key_string, "'")!==false ||
	    strpos($key_string, "+")!==false) {
		return SYNOBLOG_ARTICLE_GetErrorContent(__(photo_str_search_key_error));
	}

	$sqlParam = array();
	$key_array = SEARCH_GetKeyArray($key_string);
	$condition = SEARCH_GetConditionString($key_array, $sqlParam);

	if($condition == null || $condition == "") {
		return SYNOBLOG_ARTICLE_GetErrorContent(__(photo_str_search_key_error));
	}

	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$query = "Select * from blog_article where draft = 0 and ".$condition." order by date desc;";
	} else if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
		$query = "Select * from blog_article where ".$condition." and draft = 0 and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN." order by date desc;";
	} else {
		$query = "Select * from blog_article where ".$condition." and draft = 0 and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_USER." and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN." order by date desc;";
	}

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	$rows = PHOTO_DB_FetchAll($db_result);

	if (count($rows) == 0) {
		return SYNOBLOG_ARTICLE_GetErrorContent(__(photo_str_search_no_entries), SYNOBLOG_IMAGES_RIGHT_ARROW);
	}

	$result['title'] = str_replace("{1}", $key_string, __(photo_str_list_search));
	$result['type'] = 'search';
	$article_list = array();
	foreach($rows as $row) {
		$article_list[] = SYNOBLOG_ARTICLE_PrepareArticleData($row);
	}
	$result['list'] = $article_list;
	$resulte_list[] = $result;
	$smarty->assign('STR_AUTHOR', __(blog_article_author));
	$smarty->assign('articleList', $resulte_list);

	return $smarty->Fetch('blog/article.tpl');
}

function SEARCH_GetKeyArray($string)
{
	$string = trim($string);

	if(substr_count($string, '"') > 1) {
		$count = 0;
		$temp_string = $string;
		$pos_2 = -1;
		while(strstr($temp_string, '"') != null) {
			if(($count % 2) == 0) {
				$pos_1 = strpos($temp_string, '"') + $pos_2 + 1;
				$temp_string = substr($string, $pos_1+1);
			} else {
				$pos_2 = strpos($temp_string, '"') + $pos_1 + 1;
				$temp_array[] = substr($string, $pos_1+1, $pos_2 - $pos_1 - 1);
				$temp_string = substr($string, $pos_2+1);
			}
			$count++;
		}
	}

	if($temp_array != null) {
		foreach ($temp_array as $tok) {
			$string = str_replace("\"".$tok."\"", " ", $string);
		}
	}

	$arr = explode(" ", $string);
	if($temp_array != null) {
		$arr = array_merge($arr, $temp_array);
	}

	$i = 0;
	foreach ($arr as $tok) {
		$tok = trim($tok, "\" ");
		$arr[$i] = PHOTO_DB_EscapForLike(strtolower($tok)); // For "like"
		$i++;
	}
	return $arr;
}

function SEARCH_GetConditionString($key_array, &$sqlParam)
{
	$i = 0;
	$escape = PHOTO_DB_GetEscape();
	$titleSqlParam = array();
	$absSqlParam = array();
	$conSqlParam = array();
	foreach ($key_array as $tok) {
		if($tok == null || $tok == "" || $tok == "\"") {
			continue;
		}
		if($i != 0) {
			$title = $title." or ";
			$abstract = $abstract." or ";
			$content = $content." or ";
		}
		$title = $title."lower(title) like ? $escape ";
		$titleSqlParam[] = '%'.$tok.'%';
		$abstract = $abstract."lower(abstract) like ? $escape ";
		$absSqlParam[] = '%'.$tok.'%';
		$content = $content."lower(content) like ? $escape ";
		$conSqlParam[] = '%'.$tok.'%';
		$i++;
	}
	if($i > 0) {
		$sqlParam = array_merge($titleSqlParam, $absSqlParam);
		$sqlParam = array_merge($sqlParam, $conSqlParam);
		return "(".$title." or ".$abstract." or ".$content.")";
	}
	return "";
}

?>
