<?php
require_once("include/syno_conf.php");
require_once("include/photo/rotate_pic.php");
require_once(SYNOPHOTO_INCLUDE_SEND_MAIL);
require_once 'include/SYNOPhotoEA.php';

$albumName = '';
if (isSet($_POST['album_name'])) {
	$albumName = @pack('H*', $_POST['album_name']);
}
if (isSet($_POST['albumName'])) {
	$albumName = $_POST['albumName'];
}
if (isSet($_POST['path'])) {
	$albumName = substr($_POST['path'], strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1, strrpos($_POST['path'] , '/') - strlen(SYNOPHOTO_SERVICE_REAL_DIR) - 1);
}
if (preg_match('/^(save_album_order|edit_album_info|set_cover|delete_comment|rotate_pic|rotate|edit_item_titleDesc|face_recog|get_face_recog_status|cancel_face_recog|set_gps|set_def_gps|batch_set_gps)$/', $_POST['action'])) {
	if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
		csSYNOPhotoMisc::CheckAdminTimeOut();
	}
}

switch ($_POST['action']) {
case 'get_album_photo_list'://blog module photo_slide
	echo SYNOPHOTO_AJAX_HANDLER_GetAlbumPhotoList($_POST['album_name']);
	break;
case 'get_more_photo_gps':
	echo SYNOPHOTO_AJAX_HANDLER_GetMorePhotoGps();
	break;
case 'save_album_order':
	echo SYNOPHOTO_AJAX_HANDLER_SaveAlbumOrder();
	break;
case 'check_album_password':
	echo SYNOPHOTO_AJAX_HANDLER_CheckAlbumPassword();
	break;
case 'get_sort_method':
	echo SYNOPHOTO_AJAX_HANDLER_GetSortMethod();
	break;
case 'edit_album_info':
	echo SYNOPHOTO_AJAX_HANDLER_EditAlbumInfo();
	break;
case 'edit_item_info':
	echo SYNOPHOTO_AJAX_HANDLER_EditItemInfo();
	break;
case 'edit_item_titleDesc':
	echo SYNOPHOTO_AJAX_HANDLER_EditItemTitleDesc();
	break;
case 'edit_main_page_info':
	echo SYNOPHOTO_AJAX_HANDLER_EditPhotoMainInfo();
	break;
case 'get_comment':
	echo SYNOPHOTO_AJAX_HANDLER_GetComment();
	break;
case 'add_comment':
	$userType = csSYNOPhotoMisc::GetUserType();
	if($userType == 0 && $_POST['magic_number'] != $_SESSION[SYNOPHOTO_ADMIN_USER]['post_key_photo']) {
		$result['success'] = 'wrong_key';
		$result['right'] = $_SESSION[SYNOPHOTO_ADMIN_USER]['post_key_photo'];
		echo json_encode($result);
	} else {
		echo SYNOPHOTO_AJAX_HANDLER_AddComment();
	}
	break;
case 'delete_comment':
	echo SYNOPHOTO_AJAX_HANDLER_DeleteComment();
	break;
case 'rotate_pic':
	echo SYNOPHOTO_ROTATE_PIC_DoRotation($_POST['angle'], $_POST['path']);
	break;
case 'rotate':
	echo SYNOPHOTO_AJAX_HANDLER_RotatePic();
	break;
case 'set_gps':
	$result['success'] = FALSE;
	$filePath = $_POST['path'];

	if (file_exists($filePath) && is_numeric($_POST['lat']) && is_numeric($_POST['lng'])) {
		$gps = SYNOPHOTO_GPS_UTIL_SetGPSLatLng($filePath, $_POST['lat'], $_POST['lng']);
		if (SYNOPHOTO_GPS_UTIL_GPSEqual($gps, $_POST)) {
			$result['success'] = TRUE;
		}
	}
	echo json_encode($result);
	break;
case 'set_def_gps':
	$result['success'] = FALSE;
	if (is_numeric($_POST['lat']) && is_numeric($_POST['lng'])) {
		$gps = SYNOPHOTO_GPS_UTIL_SetGPSDefLatLng($_POST['lat'], $_POST['lng']);
		if (SYNOPHOTO_GPS_UTIL_GPSEqual($gps, $_POST)) {
			$result['success'] = TRUE;
		}
	}
	echo json_encode($result);
	break;
case 'get_album_gps':
	echo SYNOPHOTO_AJAX_HANDLER_GetThumbsGPSViewData();
	break;
case 'get_lang':
	echo $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
	break;
case 'get_uploadable_sub_album':
	echo SYNOPHOTO_AJAX_HANDLER_GetUploadableSubAlbum();
	break;
case 'set_selected_list':
	echo SYNOPHOTO_AJAX_HANDLER_SetSelectedList();
	break;
case 'face_recog':
	echo SYNOPHOTO_AJAX_HANDLER_DoFaceRecognition();
	break;
case 'get_face_recog_status':
	echo SYNOPHOTO_AJAX_HANDLER_GetFaceRecogStatus();
	break;
case 'cancel_face_recog':
	echo SYNOPHOTO_AJAX_HANDLER_CancelFaceRecog();
	break;
case 'batch_set_gps':
	$result['success'] = SYNOPHOTO_GPS_UTIL_BatchSetGPSLatLng($_POST['photo_list'], $_POST['video_list'], $_POST['lat'], $_POST['lng']);
	echo json_encode($result);
	break;
}

function SYNOPHOTO_AJAX_HANDLER_GetAlbumPhotoList($album)
{
	if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']) ||
		!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'])) {
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	}
	if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName = $album)){
		$result['success'] = 'access_denied';
		return json_encode($result);
	}
	$thumbList = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbListAll($album, null, false, true);
	$photoList = array_slice($thumbList['items'], $thumbList['subAlbumCount']);
	$result['photo_list'] = $photoList;
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_SaveAlbumOrder()
{
	$result['success'] = false;
	if (!isSet($_POST['list']) || !isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['album_order'])) {
		return json_encode($result);
	}
	$albumArr = explode(',', $_POST['list']);
	$orderList = array();
	foreach($albumArr as $album){
		if (substr($album, 0, 1) == 'v') {
			continue;
		}
		$orderList[] = @pack('H*', $album);
	}

	$offset = $_SESSION[SYNOPHOTO_ADMIN_USER]['album_order']['offset'];
	array_splice($_SESSION[SYNOPHOTO_ADMIN_USER]['album_order']['list'], $offset, count($orderList), $orderList);

	csSYNOPhotoMisc::UpdateConfigDB("album", "order_list", json_encode($_SESSION[SYNOPHOTO_ADMIN_USER]['album_order']['list']), "photo_config");

	csSYNOPhotoMisc::UpdateConfigDB("album", "album_order_type", '1', "photo_config");
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_CheckAlbumPassword()
{
	$result['success'] = false;
	if (!isSet($_POST['album_name']) || !isSet($_POST['passwd'])) {
		return json_encode($result);
	}

	$albumName = @pack('H*', $_POST['album_name']);
	$password = $_POST['passwd'];
	$result['success'] = 'error';

	$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName] = md5($password);

	if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']) ||
		!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'])) {
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	}
	$isSecondLevel = strstr($albumName, '/');
	if (md5($password) == $_SESSION[SYNOPHOTO_ADMIN_USER][$isSecondLevel?'accessible_subdir':'accessible_album'][$albumName]['password']) {
		$result['success'] = TRUE;
	}

	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_GetSortMethod()
{
	$result['type'] = '0';
	switch ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type']) {
		case 'name':
			$type = '0';
			break;
		case 'timetaken':
			$type = '1';
			break;
		case 'create_time':
			$type = '2';
			break;
	}

	if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_by_preference']) {
		$type = '3';
	}

	$order = '0';
	if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] == 'desc') {
		$order = '1';
	}

	$defaul_type = csSYNOPhotoMisc::GetConfigDB("album", "thumb_sort_type", "photo_config");
	if($defaul_type == null || $defaul_type == "") {
		$defaul_type = "0";
	}


	$sortData = csSYNOPhotoAlbum::GetAlbumThumbSortType(@pack('H*', $_POST['album_name']));
	$result['hasSortPreference'] = (empty($sortData['list'])) ? false : true;
	if (!$result['hasSortPreference'] && '3' == $type) {
		$type = $defaul_type;
	}

	$result['type'] = $type;
	$result['order'] = $order;
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_EditAlbumInfo()
{
	$result['success'] = false;
	if (!isSet($_POST['album_name']) || !isSet($_POST['type']) || !isSet($_POST['content'])) {
		return json_encode($result);
	}
	$type = $_POST['type'];
	$albumName = @pack('H*', $_POST['album_name']);
	$albumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);
	$title = $albumInfo['title'];
	$desc = $albumInfo['desc'];
	if ($type == 0) {
		$title = trim($_POST['content']);
	} else {
		$desc = trim($_POST['content']);
	}
	$result['success'] = csSYNOPhotoAlbum::GetAlbumInstance()->EditAlbumProperty($albumName, $title, $desc);
	$result['data'] = htmlspecialchars(trim($_POST['content']), ENT_QUOTES);
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_EditItemInfo()
{
	$result['success'] = false;
	if (!isSet($_POST['path']) || !isSet($_POST['itemType']) || !isSet($_POST['title']) ||
		!isSet($_POST['desc']) || !isSet($_POST['type'])) {
		return json_encode($result);
	}
	$type = $_POST['type'];
	$title = $type == 0 ? trim($_POST['title']) : htmlspecialchars_decode($_POST['title'], ENT_QUOTES);
	$desc = $type == 1 ? trim($_POST['desc']) : htmlspecialchars_decode($_POST['desc'], ENT_QUOTES);

	$result['success'] = csSYNOPhotoThumb::GetThumbInstance()->EditItemProperty($_POST['path'], $_POST['itemType'], $title, $desc);
	$result['data'] = $type == 0 ? htmlspecialchars($title, ENT_QUOTES) : htmlspecialchars($desc, ENT_QUOTES);
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_EditItemTitleDesc()
{
	$result['success'] = false;
	$isDesc = 0;
	if (!isSet($_POST['id']) || !isSet($_POST['text'])) {
		return json_encode($result);
	}
	if (isSet($_POST['type']) && $_POST['type'] == 1) {
		$isDesc = 1;//desc
	}
	$tmp = explode('_', trim($_POST['id']));
	$type = $tmp[0];
	$id = $tmp[2];
	$text = trim($_POST['text']);

	if ($type == 'photo') {
		$query = "SELECT path, title, description FROM photo_image WHERE id = ?";
		$sqlParam = array($id);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		if (false !== ($row = $db_result->fetch())) {
			$realPath = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			if ($isDesc == 1) {
				csSYNOPhotoDB::GetDBInstance()->UpdatePhotoProperty($row['path'], $row['title'], $text, $realPath);
			} else {
				csSYNOPhotoDB::GetDBInstance()->UpdatePhotoProperty($row['path'], $text, $row['description'], $realPath);
			}
		}
		//flush photo dbcacher cache since data had been changed
		unset($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID]);
		$result['success'] = true;
	} else if ($type == 'video'){
		$query = "Select path from video where id=?";
		$sqlParam = array($id);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		if (false !== ($row = $db_result->fetch())) {
			$customTitleDesc = csSYNOPhotoDB::GetDBInstance()->GetVideoCustomizedTitleDescription($row['path']);
			if ($isDesc == 1) {
				csSYNOPhotoDB::GetDBInstance()->UpdateVideoProperty($row['path'], $customTitleDesc['title'], $text);
			} else {
				csSYNOPhotoDB::GetDBInstance()->UpdateVideoProperty($row['path'], $text, $customTitleDesc['description']);
			}
		}
		//flush video dbcacher cache since data had been changed
		unset($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID]);
		$result['success'] = true;
	} else {//album
		$albumName = @pack('H*', $id);
		$albumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);
		if ($isDesc == 1) {
			$result['success'] = csSYNOPhotoAlbum::GetAlbumInstance()->EditAlbumProperty($albumName, $albumInfo['title'], $text);
		} else {
			$result['success'] = csSYNOPhotoAlbum::GetAlbumInstance()->EditAlbumProperty($albumName, $text, $albumInfo['desc']);
		}
		if ($text == '') {
			$text = basename($albumName);
		}
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	}

	$result['data'] = htmlspecialchars($text, ENT_QUOTES);
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_EditPhotoMainInfo()
{
	$result['success'] = false;
	if (!isSet($_POST['type']) || !isSet($_POST['content'])) {
		return json_encode($result);
	}

	$module_key = $_POST['type'] == 0 ? 'main_page_title' : 'main_page_desc';
	$content = trim($_POST['content']);
	csSYNOPhotoMisc::UpdateConfigDB('main', $module_key, $content, 'photo_config');

	$result['success'] = true;
	$result['data'] = htmlspecialchars($content, ENT_QUOTES);
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_GetComment()
{
	global $smarty;
	$result['success'] = false;
	if (!isSet($_POST['type']) || ($_POST['type'] == 1 && !isSet($_POST['id'])) ||
		($_POST['type'] == 2 && !isSet($_POST['path']))) {
		return json_encode($result);
	}

	$type = $_POST['type'];
	$path = $_POST['path'];
	$id = $_POST['id'];

	$tpl = 'photo/comment.tpl';
	if (isSet($_POST['isForLightbox']) && $_POST['isForLightbox'] == 'true') {
		$tpl = 'photo/lightbox_comment.tpl';
		$result['label'] = ($_POST['type'] == 2) ? SYNOPHOTO_LABEL_UTIL_GetVideoLabels($path) : SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($id);
	}

	if ($_POST['type'] == 1) {
		$commentList = csSYNOPhotoDB::GetDBInstance()->GetPhotoComments($id);
	} else {
		$commentList = csSYNOPhotoDB::GetDBInstance()->GetVideoComments($path);
	}

	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$smarty->assign('STR_EMAIL', __(photo_str_comment_email));
		$smarty->assign('STR_DELETE', __(photo_str_deleteuser));
	}
	$smarty->assign('commentList', $commentList);

	$result['success'] = true;
	$result['data'] = $smarty->Fetch($tpl);
	$result['comment_num'] = count($commentList);
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_AddComment()
{
	$result['success'] = false;
	if (!isSet($_POST['type']) || !isSet($_POST['path'])) {
		return json_encode($result);
	}
	$path = $_POST['path'];

	csSYNOPhotoBrowse::GetBrowseInstance()->AddNewComment($_POST['path'], $_POST['type'], $_POST['name'], $_POST['mail'], $_POST['comment']);
	SYNOPHOTO_SEND_MAIL_SendCommentMailToAdmin();
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_DeleteComment()
{
	$result['success'] = false;
	if (!isSet($_POST['type']) || !isSet($_POST['id'])) {
		return json_encode($result);
	}
	csSYNOPhotoDB::GetDBInstance()->DeleteComment($_POST['type'], $_POST['id']);

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_GetThumbsGPSViewData()
{
	$result['success'] = false;
	if (!isSet($_POST['albumName'])) {
		return json_encode($result);
	}

	$gpsData = SYNOPHOTO_GPS_UTIL_GetGPSDefLatLng();
	if ($gpsData) {
		$result['gps_def'] = $gpsData;
	}

	$gpsItemList = csSYNOPhotoBrowse::GetBrowseInstance()->GetGPSThumbList($_POST['albumName']);
	$result['success'] = true;
	$result['list'] = $gpsItemList;

	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_GetUploadableSubAlbum()
{
	$result['success'] = false;
	if (!isSet($_POST['albumName'])) {
	   return json_encode($result);
	}
	$result['albums'] = array();
	$currPath = getcwd();
	$albumName = $_POST['albumName'];
	@chdir(SYNOPHOTO_SERVICE_REAL_DIR."/".$albumName);
	foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $dirName) {
		$dir = (empty($albumName))? $dirName : $albumName."/".$dirName;
	   if ($dirName == SYNOPHOTO_EADIR || $dirName == '.' || $dirName == '..' || $dirName == SYNOPHOTO_RECYCLE_DIR
		   || !csSYNOPhotoMisc::CheckAlbumUploadable($dir) || !csSYNOPhotoMisc::IsUtf8($dirName)) {
		   continue;
	   }
	   $item = array();
	   $item['name'] = $dirName;
	   $item['name_for_display'] = htmlspecialchars($dirName);
	   $item['id'] = $dirName;
	   $result['albums'][] = $item;
	}
	@chdir($currPath);
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_GetMorePhotoGps()
{
	$result['success'] = false;
	if (!isSet($_POST['type']) || !isSet($_POST['dir']) || !isSet($_POST['list'])) {
		return json_encode($result);
	}

	if (!csSYNOPhotoMisc::CheckAlbumAccessible($_POST['dir'])) {
		return json_encode($result);
	}
	$result['list'] = array();
	$list = json_decode($_POST['list']);
	foreach($list as $path){
		$gpsData = SYNOPHOTO_GPS_UTIL_GetGPSLatLng($path);
		$result['list'][] = $gpsData;
	}

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_RotatePic()
{
	$result['success'] = false;
	if (!isSet($_POST['id']) || !isSet($_POST['angle'])) {
		return json_encode($result);
	}

	$id = substr($_POST['id'], 11, strlen($_POST['id']));
	if (substr($_POST['id'], 0, 5) == 'photo') {
		$query = 'SELECT path FROM photo_image WHERE id=?';
	} else {
		return json_encode($result);
	}
	$sqlParam = array($id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		return SYNOPHOTO_ROTATE_PIC_DoRotation($_POST['angle'], $path);
	}
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_SetSelectedList()
{
	$result['success'] = false;
	if (!isSet($_POST['list'])) {
		return json_encode($result);
	}
	$_SESSION[SYNOPHOTO_ADMIN_USER]['select_list'] = $_POST['list'];
	$result['success'] = true;
	return json_encode($result);
}

function getPhotoPathById ($id)
{
	$id_arr = explode('_', $id);
	$type = $id_arr[0];
	$albumName = @pack('H*', $id_arr[1]);
	$fileName = @pack('H*', $id_arr[2]);
	return realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName . '/' . $fileName);
}

function SYNOPHOTO_AJAX_HANDLER_DoFaceRecognition()
{
	$result['success'] = false;
	if (!isSet($_POST['id'])) {
		return json_encode($result);
	}

	$path = getPhotoPathById($_POST['id']);

	if (!csSYNOPhotoMisc::IsPhotoFile($path) || !csSYNOPhotoMisc::IsPhotoFileWithThumb($path)) {
		$result['msg'] = __(photo_str_upload_file_format_unsupport);
		return json_encode($result);
	}

	if (SYNOPHOTO_ROTATE_PIC_ThumbLackCheck($path)) {
		$result['msg'] = __(photo_str_thumbing_wait_msg);
		return json_encode($result);
	}

	if (file_exists(SYNOPHOTO_DAEMON_QUEUE) || file_exists(SYNOPHOTO_DAEMON_QUEUE_TMP)) {
		$result['msg'] = __(photo_str_service_busy);
		return json_encode($result);
	}

	if ($_POST['delete_old']) {
		$row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('id', 'photo_image', 'path', $path);
		$photo_id = $row[0];
		$all_labels = SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($photo_id);
		for ($i = 0; $i < count($all_labels['person']); $i++) {
			SYNOPHOTO_LABEL_UTIL_DeleteItemLabel($all_labels['person'][$i]['id']);
			$result['delete'][] = $all_labels['person'][$i]['id'];
		}
	}

	$pidFile = "/tmp/facerecog.".$_POST['prog_id'];
	$fp = fopen($pidFile, 'w');
	fwrite($fp, "file=\"". $path ."\"\n");
	fclose($fp);

	$commend = SYNOPHOTO_FACE_RECOG_TOOL." -A ".$pidFile;
	@exec($commend);

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_GetFaceRecogStatus()
{
	$result['success'] = false;
	if (!isSet($_POST['prog_id'])) {
		return json_encode($result);
	}

	$result['success'] = 'doing_recog';
	if (!@file_exists("/tmp/facerecog.".$_POST['prog_id'])) {
		$result['success'] = 'finish';
	}
	return json_encode($result);
}

function SYNOPHOTO_AJAX_HANDLER_CancelFaceRecog()
{
	$result['success'] = false;
	if (!isSet($_POST['prog_id'])) {
		return json_encode($result);
	}
	$pidFile = "/tmp/facerecog.".$_POST['prog_id'];
	if (file_exists($pidFile)) {
		$commend = SYNOPHOTO_FACE_RECOG_TOOL." -K ".$pidFile;
		@exec($commend);
	}
	$result['success'] = true;
	return json_encode($result);
}

?>
